/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.IntArray;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.UnsignedInt;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;
import java.text.DecimalFormat;

public class Int
extends AbstractNumeric
implements ValueFormat {
    public static final int PRIORITY = 3;
    protected int value;

    public Int(int v) {
        this.value = v;
    }

    public Int(String s) {
        this.value = Integer.parseInt(this.toString());
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public String getFormattedString(int length) {
        return Int.getFormattedString(length, this.value, true);
    }

    @Override
    public byte[] getFormattedBuffer() {
        return Int.getFormattedBuffer(this.value);
    }

    public static String getFormattedString(int length, int value, boolean is_signed) {
        if (is_signed) {
            return new String(new DecimalFormat("+0000000000;-0000000000").format(value));
        }
        return new String(new DecimalFormat("+0000000000;-0000000000").format((long)value & 0xFFFFFFFFL));
    }

    public static byte[] getFormattedBuffer(int value) {
        byte[] buffer = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return buffer;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public final int getPriority() {
        return 3;
    }

    @Override
    public Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 3: {
                return this;
            }
            case 10: {
                IntArray intArray = new IntArray(1);
                intArray.assign(0, this.intValue());
                return intArray;
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Numeric vi = (Numeric)v.convertTo(9);
        this.value = vi.intValue();
    }

    @Override
    public Value unaryMinus() {
        return new Int(-this.value);
    }

    @Override
    public final Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long sum = this.longValue() + num.longValue();
        if (sum < Integer.MIN_VALUE || sum > 0xFFFFFFFFL) {
            return new Long(sum);
        }
        if (sum < 0x80000000L) {
            return new Int((int)sum);
        }
        return new UnsignedInt((int)sum);
    }

    @Override
    public Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long dif = this.longValue() - num.longValue();
        if (dif < Integer.MIN_VALUE || dif > 0xFFFFFFFFL) {
            return new Long(dif);
        }
        if (dif < 0x80000000L) {
            return new Int((int)dif);
        }
        return new UnsignedInt((int)dif);
    }

    @Override
    public Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long prod = this.longValue() * num.longValue();
        if (prod < Integer.MIN_VALUE || prod > 0xFFFFFFFFL) {
            return new Long(prod);
        }
        if (prod < 0x80000000L) {
            return new Int((int)prod);
        }
        return new UnsignedInt((int)prod);
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long div = this.longValue() / num.longValue();
        if (div < Integer.MIN_VALUE || div > 0xFFFFFFFFL) {
            return new Long(div);
        }
        if (div < 0x80000000L) {
            return new Int((int)div);
        }
        return new UnsignedInt((int)div);
    }

    @Override
    public Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long mod = this.longValue() % num.longValue();
        if (mod < Integer.MIN_VALUE || mod > 0xFFFFFFFFL) {
            return new Long(mod);
        }
        if (mod < 0x80000000L) {
            return new Int((int)mod);
        }
        return new UnsignedInt((int)mod);
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() >= x.getPriority()) {
            int v2 = ((Numeric)x).intValue();
            if (this.value == v2) {
                return 0;
            }
            if (this.value < v2) {
                return -1;
            }
            return 1;
        }
        return -((Comparison)((Object)x)).compareTo(this);
    }

    @Override
    public final boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public final short shortValue() {
        return (short)this.value;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    public final void assign(boolean value) {
        this.value = value ? 1 : 0;
    }

    @Override
    public final void assign(byte value) {
        this.value = value;
    }

    @Override
    public final void assign(short value) {
        this.value = value;
    }

    @Override
    public final void assign(int value) {
        this.value = value;
    }

    @Override
    public final void assign(long value) {
        this.value = (int)value;
    }

    @Override
    public final void assign(float value) {
        this.value = (int)value;
    }

    @Override
    public final void assign(double value) {
        this.value = (int)value;
    }

    public static void main(String[] args) {
        System.out.println((long)Integer.MIN_VALUE);
        Int i1 = new Int(2000000000);
        Int i2 = new Int(2000000000);
        System.out.println(i1.add(i2));
        System.out.println(new Int(1).convertTo(0));
    }
}

