/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractValue;
import fr.gael.drb.value.Arithmetic;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.DateTime;
import fr.gael.drb.value.DayTimeDuration;
import fr.gael.drb.value.Duration;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;

public class YearMonthDuration
extends AbstractValue
implements Arithmetic,
Comparison {
    static final int PRIORITY = 7;
    static final int MONTHS_PER_YEAR = 12;
    protected long yearMonth;

    public YearMonthDuration(long year_month) {
        this.yearMonth = year_month;
    }

    public long getYearMonth() {
        return this.yearMonth;
    }

    long getYears() {
        return Math.abs(this.yearMonth) / 12L;
    }

    int getMonths() {
        return (int)(Math.abs(this.yearMonth) % 12L);
    }

    public java.lang.String toString() {
        java.lang.String str = "P" + this.getYears() + "Y" + this.getMonths() + "M";
        if (this.yearMonth < 0L) {
            return "-" + str;
        }
        return str;
    }

    @Override
    public int getType() {
        return 18;
    }

    @Override
    public Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 18: {
                return this;
            }
            case 17: {
                return new DayTimeDuration((double)this.yearMonth * 2629800.0);
            }
            case 16: {
                return new Duration(this.yearMonth, 0.0);
            }
            case 7: {
                return new String(this.toString());
            }
        }
        return new Long(this.yearMonth).convertTo(type);
    }

    @Override
    public void assign(Value v) {
        YearMonthDuration vd = (YearMonthDuration)v.convertTo(18);
        this.yearMonth = vd.getYearMonth();
    }

    @Override
    public int getPriority() {
        return 7;
    }

    @Override
    public Value add(Value x) {
        YearMonthDuration vd = (YearMonthDuration)x.convertTo(18);
        return new YearMonthDuration(this.getYearMonth() + vd.getYearMonth());
    }

    @Override
    public Value unaryMinus() {
        return new YearMonthDuration(-this.getYearMonth());
    }

    @Override
    public Value sub(Value x) {
        YearMonthDuration vd = (YearMonthDuration)x.convertTo(18);
        return new YearMonthDuration(this.getYearMonth() - vd.getYearMonth());
    }

    @Override
    public Value multiply(Value x) {
        Numeric num = (Numeric)x.convertTo(9);
        return new YearMonthDuration((long)((double)this.getYearMonth() * num.doubleValue()));
    }

    @Override
    public Value divide(Value x) {
        Numeric num = (Numeric)x.convertTo(9);
        return new YearMonthDuration((long)((double)this.getYearMonth() / num.doubleValue()));
    }

    @Override
    public Value modulus(Value x) {
        Numeric num = (Numeric)x.convertTo(9);
        return new YearMonthDuration((long)((double)this.getYearMonth() % num.doubleValue()));
    }

    @Override
    public int compareTo(Value v) {
        YearMonthDuration vd = (YearMonthDuration)v.convertTo(18);
        double diff = this.getYearMonth() - vd.getYearMonth();
        if (diff < 0.0) {
            return -1;
        }
        if (diff > 0.0) {
            return 1;
        }
        return 0;
    }

    public static void main(java.lang.String[] args) {
        YearMonthDuration dur = new YearMonthDuration(java.lang.Long.parseLong(args[0]));
        System.out.println("Test :  convert a yearMonthDuration(" + args[0] + ")");
        System.out.println("toString : " + dur.convertTo(7));
        if (args.length > 1) {
            System.out.println("-- CMP --");
            YearMonthDuration dur2 = new YearMonthDuration(java.lang.Long.parseLong(args[1]));
            System.out.println("'" + dur + "' compareTo '" + dur2 + " = " + dur.compareTo(dur2));
        }
        java.lang.String[] dates = new java.lang.String[]{"01-JAN-2000 00:00:00.000000", "31-DEC-1999 04:00:00.004321", "01-JUL-1973 15:15:00.000937", "01-JAN-2002 10:30:50.876543"};
        System.out.println("-- SUM --");
        DateTime date_time1 = null;
        for (int iDate = 0; iDate < dates.length; ++iDate) {
            date_time1 = new DateTime(dates[iDate]);
            System.out.println("'" + date_time1 + "' + '" + dur + " = " + date_time1.add(dur).convertTo(8));
            System.out.println("'" + date_time1 + "' - '" + dur + " = " + date_time1.sub(dur).convertTo(8));
        }
    }
}

