/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.URLNode;
import fr.gael.drb.impl.xml.XmlFactory;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import fr.gael.drb.xsd.XsdAtomicType;
import fr.gael.drb.xsd.XsdComplexType;
import fr.gael.drb.xsd.XsdComponent;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdFactory;
import fr.gael.drb.xsd.XsdInvalid;
import fr.gael.drb.xsd.XsdNodeImpl;
import fr.gael.drb.xsd.XsdType;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.Logger;

public class XmlSchema
extends XsdComponent {
    private static Logger logger = Logger.getLogger(XmlSchema.class);
    static final java.lang.String TAG = "schema";
    static final java.lang.String TARGET_NAMESPACE_TAG = "targetNamespace";
    static final java.lang.String INCLUDE_TAG = "include";
    static final java.lang.String IMPORT_TAG = "import";
    static final java.lang.String SCHEMA_LOCATION_TAG = "schemaLocation";
    private XsdType[] globalTypes = null;
    private Set<XsdType>[] derivationTypes = null;
    private Hashtable<XsdType, Set<XsdType>> derivationMap = new Hashtable();
    private XsdElement[] rootElements = null;
    protected Namespace namespaces = null;
    static XmlSchema xs_schema = null;

    public XmlSchema(XsdElement[] root_elements, XsdType[] global_types, Namespace namespaces) {
        int i;
        if (root_elements == null) {
            root_elements = new XsdElement[]{};
        }
        this.rootElements = root_elements;
        if (global_types == null) {
            global_types = new XsdType[]{};
        }
        this.globalTypes = global_types;
        if (namespaces == null) {
            namespaces = new Namespace();
        }
        this.namespaces = namespaces;
        this.derivationTypes = new Set[this.globalTypes.length];
        this.derivationMap = new Hashtable();
        for (i = 0; i < this.globalTypes.length; ++i) {
            this.globalTypes[i].setSchema(this);
            this.derivationTypes[i] = new HashSet<XsdType>();
            this.derivationMap.put(this.globalTypes[i], this.derivationTypes[i]);
        }
        for (i = 0; i < this.globalTypes.length; ++i) {
            Set<XsdType> derivation_set = this.getDerivation(this.globalTypes[i].getBase());
            if (derivation_set == null) continue;
            derivation_set.add(this.globalTypes[i]);
        }
    }

    public final XsdElement getDefaultRootElement() {
        if (this.rootElements != null && this.rootElements.length > 0) {
            return this.rootElements[0];
        }
        return null;
    }

    public final XsdElement[] getRootElements() {
        return this.rootElements;
    }

    public final XsdElement getRootElement(java.lang.String qname) {
        java.lang.String local_name = Namespace.toLocal(qname);
        java.lang.String prefix_name = Namespace.toPrefix(qname);
        java.lang.String ns_name = this.namespaces.resolveNamespace(prefix_name);
        if (ns_name == null) {
            ns_name = prefix_name;
        }
        for (int i = 0; i < this.rootElements.length; ++i) {
            java.lang.String elt_name = this.rootElements[i].getName();
            java.lang.String elt_ns = this.rootElements[i].getTargetNamespace();
            if (elt_name == null || !elt_name.equals(local_name) || ns_name != null && !ns_name.equals(elt_name)) continue;
            return this.rootElements[i];
        }
        return null;
    }

    public final XsdType[] getGlobalTypes() {
        return this.globalTypes;
    }

    public XsdType getType(java.lang.String qname) {
        java.lang.String local_name = Namespace.toLocal(qname);
        java.lang.String prefix_name = Namespace.toPrefix(qname);
        java.lang.String ns_name = this.namespaces.resolveNamespace(prefix_name);
        if (ns_name == null) {
            ns_name = prefix_name;
        }
        for (int i = 0; i < this.globalTypes.length; ++i) {
            java.lang.String type_name = this.globalTypes[i].getName();
            java.lang.String type_ns = this.globalTypes[i].getTargetNamespace();
            if (type_name == null || !type_name.equals(local_name) || ns_name != null && !ns_name.equals(type_ns)) continue;
            return this.globalTypes[i];
        }
        return null;
    }

    protected final Set<XsdType> getDerivation(XsdType global_type) {
        if (global_type == null) {
            return new HashSet<XsdType>();
        }
        Set<XsdType> derivation_set = this.derivationMap.get(global_type);
        return derivation_set;
    }

    public static synchronized XmlSchema getDefaultSchema() {
        if (xs_schema == null) {
            XsdType[] base_type = new XsdType[]{new XsdAtomicType(-2)};
            base_type[0].setTargetNamespace("http://www.w3.org/2001/XMLSchema");
            XsdElement[] elements = new XsdElement[]{};
            Namespace namespaces = new Namespace();
            namespaces.bind("xsd", "http://www.w3.org/2001/XMLSchema");
            namespaces.bind("xs", "http://www.w3.org/2001/XMLSchema");
            XmlSchema base_schema = new XmlSchema(elements, base_type, namespaces);
            URL datatype_url = XmlSchema.class.getClassLoader().getResource("fr/gael/drb/xsd/datatypes.xsd");
            XmlFactory xml_factory = new XmlFactory();
            DrbNode context_node = DrbFactory.openURI(".");
            DrbNode schema_node = xml_factory.open(new URLNode(datatype_url));
            xs_schema = new XsdFactory().open(context_node, schema_node, base_schema);
        }
        return xs_schema;
    }

    @Override
    public DrbNode toNode() {
        int i;
        DrbDefaultMutableNode schema_node = new DrbDefaultMutableNode(TAG);
        schema_node.setNamespaceURI("http://www.w3.org/2001/XMLSchema");
        schema_node.setNamespaceBindings(this.namespaces);
        DrbDefaultAttributeList attributes = new DrbDefaultAttributeList();
        if (this.getTargetNamespace() != null) {
            attributes.add(new DrbDefaultAttribute(TARGET_NAMESPACE_TAG, (Value)new String(this.getTargetNamespace()), schema_node));
        }
        schema_node.setAttributes(attributes);
        if (this.rootElements != null) {
            for (i = 0; i < this.rootElements.length; ++i) {
                DrbNode elt_node = this.rootElements[i].toNode();
                if (elt_node == null) continue;
                schema_node.appendChild(elt_node);
            }
        }
        if (this.globalTypes != null) {
            for (i = 0; i < this.globalTypes.length; ++i) {
                DrbNode type_node = this.globalTypes[i].toNode();
                if (type_node == null) continue;
                schema_node.appendChild(type_node);
            }
        }
        return schema_node;
    }

    public static XsdInvalid validate(java.lang.String xml_filename, java.lang.String xsd_filename, boolean deep) {
        logger.debug("Try to validate: '" + xml_filename + "' with schema '" + xsd_filename + "'");
        XsdFactory xsdfactory = new XsdFactory();
        DrbNode node_schema = DrbFactory.open(xsd_filename);
        if (node_schema == null) {
            logger.error("Cannot open schema file: " + xsd_filename);
            return null;
        }
        XmlSchema xmlschema = xsdfactory.open(node_schema.getNamedChild(TAG, 1));
        if (xmlschema == null) {
            logger.error("Cannot load schema file: " + xsd_filename);
            return null;
        }
        DrbNode node_xml = DrbFactory.open(xml_filename);
        if (node_xml == null) {
            logger.error("Cannot open xml file: " + xml_filename);
            return null;
        }
        XsdElement xsd_root_element = xmlschema.getDefaultRootElement();
        XsdType xsd_type = xsd_root_element.getType();
        XsdNodeImpl xsd_node = (XsdNodeImpl)XsdNodeImpl.getInstance(node_xml.getFirstChild(), xsd_type);
        if (deep) {
            return xsd_node.isDeepValid();
        }
        return xsd_node.isValid();
    }

    public static void main(java.lang.String[] args) {
        XmlSchema xsd_schema;
        if (args.length == 0) {
            logger.error("Usage : XmlSchema <typename> [schema]");
            return;
        }
        XmlSchema schema = xsd_schema = XmlSchema.getDefaultSchema();
        if (args.length == 2) {
            DrbNode file_node = DrbFactory.open(args[1]);
            DrbNode schema_node = file_node.getFirstChild();
            XsdFactory xsdfactory = new XsdFactory();
            schema = xsdfactory.open(file_node.getParent(), schema_node);
        }
        for (int i = 0; i < 1; ++i) {
            XsdType type = schema.getType(args[i]);
            if (type == null) {
                type = xsd_schema.getType(args[i]);
            }
            if (type == null) {
                System.out.println("'" + args[i] + "' not found.");
                continue;
            }
            System.out.println("Name : " + type.getName());
            System.out.println("Target namespace : " + type.getTargetNamespace());
            java.lang.String prefix = null;
            if (xsd_schema.namespaces != null) {
                prefix = xsd_schema.namespaces.resolvePrefix(type.getTargetNamespace());
            }
            System.out.println("Prefix : " + prefix);
            DrbNodeList ext_nodes = type.getExternalNodes();
            DrbNode annot = null;
            if (ext_nodes != null) {
                annot = ext_nodes.getNamedItem("annotation", 1);
            }
            DrbNode doc = null;
            if (annot != null) {
                doc = annot.getNamedChild("documentation", 1);
            }
            java.lang.String doc_value = "";
            if (doc != null && doc.getValue() != null) {
                doc_value = doc.getValue().toString();
            }
            System.out.println("documentation : " + doc_value);
            if (type.getBase() != null) {
                if (type.getBase().getName() == null) {
                    System.out.println("Base : anonymous");
                }
                System.out.println("Base : " + type.getBase().getName());
            }
            System.out.println("Derivation : ");
            Object[] type_derivation = type.getDerivation().toArray();
            for (int ideriv = 0; ideriv < type_derivation.length; ++ideriv) {
                System.out.println(type_derivation[ideriv] + " ");
            }
            if (type.getStructure() != null) {
                XsdComplexType structure_type = type.getStructure();
                System.out.println("complexType : " + structure_type);
                XmlWriter.writeXML(structure_type.toNode(), System.out);
            }
            System.out.println("datatype : " + type.getDatatype());
            if (type.getDatatype() != null) {
                System.out.println("valueType : " + type.getDatatype().getTypeId());
                System.out.println("inclusive lower bound: " + type.getDatatype().getInclusiveLowerBound());
                System.out.println("inclusive upper bound: " + type.getDatatype().getInclusiveUpperBound());
            }
            System.out.println("\n\n");
        }
    }
}

