/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbNode;
import fr.gael.drb.xsd.XsdAppinfo;
import fr.gael.drb.xsd.XsdDocumentation;

public class XsdAnnotation {
    static final String TAG = "annotation";
    private XsdAppinfo[] appinfo;
    private XsdDocumentation[] documentation;

    public XsdAnnotation(XsdAppinfo[] appinfo, XsdDocumentation[] documentation) {
        if (appinfo == null) {
            appinfo = new XsdAppinfo[]{};
        }
        this.appinfo = appinfo;
        if (documentation == null) {
            documentation = new XsdDocumentation[]{};
        }
        this.documentation = documentation;
    }

    public XsdDocumentation[] getDocumentations() {
        return this.documentation;
    }

    public XsdAppinfo[] getAppinfos() {
        return this.appinfo;
    }

    DrbNode toNode() {
        int i;
        if (this.appinfo.length == 0 && this.documentation.length == 0) {
            return null;
        }
        DrbDefaultMutableNode annotNode = new DrbDefaultMutableNode(TAG);
        annotNode.setNamespaceURI("http://www.w3.org/2001/XMLSchema");
        for (i = 0; i < this.documentation.length; ++i) {
            DrbNode docNode = this.documentation[i].toNode();
            if (docNode == null) continue;
            annotNode.appendChild(docNode);
        }
        for (i = 0; i < this.appinfo.length; ++i) {
            DrbNode appNode = this.appinfo[i].toNode();
            if (appNode == null) continue;
            annotNode.appendChild(appNode);
        }
        return annotNode;
    }
}

