/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drbx.cortex;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.spi.DrbNodeSpi;
import fr.gael.drb.query.Query;
import fr.gael.drbx.cortex.DrbCortexItemClass;
import fr.gael.drbx.cortex.DrbCortexModel;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DrbCortexItemSignature {
    private static Logger logger = Logger.getLogger(DrbCortexItemSignature.class);
    private Collection<DrbItemTest> tests = new Vector<DrbItemTest>();
    private DrbCortexItemClass holdingClass = null;

    public DrbCortexItemSignature(DrbCortexItemClass holding_class) throws NullPointerException {
        this.setHoldingClass(holding_class);
        OntClass ont_class = holding_class.getOntClass();
        Vector<XQueryTest> slow_tests = new Vector<XQueryTest>();
        OntProperty signature_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "signature");
        OntProperty name_match_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "nameMatch");
        OntProperty name_test_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "nameTest");
        OntProperty xquery_test_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "xqueryTest");
        OntProperty ns_test_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "namespaceTest");
        OntProperty ns_match_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "namespaceMatch");
        OntProperty parent_class_test_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "parentClassTest");
        OntProperty parent_class_match_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "parentClassMatch");
        OntProperty parent_subclass_test_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "parentIsSubClassTest");
        OntProperty parent_subclass_match_property = ont_class.getOntModel().getOntProperty(DrbCortexModel.getUriPrefix() + "parentIsSubClassMatch");
        Statement signature_statement = ont_class.getProperty((Property)signature_property);
        if (signature_statement != null) {
            Resource signature = signature_statement.getResource();
            StmtIterator signature_tests = signature.listProperties();
            while (signature_tests.hasNext()) {
                Statement signature_test = signature_tests.nextStatement();
                if (signature_test.getPredicate().equals(name_match_property)) {
                    this.getTests().add(new NameMatch(signature_test.getString()));
                    continue;
                }
                if (signature_test.getPredicate().equals(name_test_property)) {
                    this.getTests().add(new NameTest(signature_test.getString()));
                    continue;
                }
                if (signature_test.getPredicate().equals(xquery_test_property)) {
                    slow_tests.add(new XQueryTest(signature_test.getString()));
                    continue;
                }
                if (signature_test.getPredicate().equals(ns_test_property)) {
                    this.getTests().add(new NamespaceTest(signature_test.getString()));
                    continue;
                }
                if (signature_test.getPredicate().equals(ns_match_property)) {
                    this.getTests().add(new NamespaceMatch(signature_test.getString()));
                    continue;
                }
                if (signature_test.getPredicate().equals(parent_class_test_property)) {
                    this.getTests().add(new ParentClassTest(signature_test.getString()));
                    continue;
                }
                if (signature_test.getPredicate().equals(parent_class_match_property)) {
                    this.getTests().add(new ParentClassMatch(signature_test.getString()));
                    continue;
                }
                if (signature_test.getPredicate().equals(parent_subclass_test_property)) {
                    this.getTests().add(new ParentIsSubClassTest(signature_test.getString()));
                    continue;
                }
                if (!signature_test.getPredicate().equals(parent_subclass_match_property)) continue;
                this.getTests().add(new ParentIsSubClassMatch(signature_test.getString()));
            }
            for (DrbItemTest drbItemTest : slow_tests) {
                this.getTests().add(drbItemTest);
            }
        }
    }

    public boolean matches(DrbItem item) {
        if (logger.isDebugEnabled()) {
            logger.debug("   Probing signature of class \"" + this.getHoldingClass().getLabel() + "\"...");
        }
        for (DrbItemTest test : this.tests) {
            if (!test.matches(item)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("      Item \"" + item.getName() + "\" does not match signature test: \"" + test + "\".");
                }
                return false;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("      Item \"" + item.getName() + "\" matches signature test: \"" + test + "\".");
        }
        logger.debug("   Item \"" + item.getName() + "\" matches signature of class \"" + this.getHoldingClass().getLabel() + "\".");
        return true;
    }

    private Collection<DrbItemTest> getTests() {
        return this.tests;
    }

    private DrbCortexItemClass getHoldingClass() {
        return this.holdingClass;
    }

    private void setHoldingClass(DrbCortexItemClass holdingClass) {
        this.holdingClass = holdingClass;
    }

    private class ParentIsSubClassTest
    implements DrbItemTest {
        private String parentClass = null;

        ParentIsSubClassTest(String parent_class) {
            this.parentClass = parent_class.trim();
        }

        public boolean matches(DrbItem item) {
            if (item == null || !(item instanceof DrbNode) || ((DrbNode)item).getParent() == null) {
                return false;
            }
            try {
                DrbCortexItemClass cla = DrbCortexModel.getDefaultModel().getClassOf((DrbItem)((DrbNode)item).getParent());
                String parent = cla.getOntClass().getNameSpace() + cla.getOntClass().getLocalName();
                logger.debug("Compare Class \"" + this.parentClass + "\" with \"" + parent + "\"");
                if (parent.equals(this.parentClass)) {
                    return true;
                }
                ExtendedIterator it = cla.getOntClass().listSuperClasses();
                while (it.hasNext()) {
                    OntClass c = (OntClass)it.next();
                    parent = c.getNameSpace() + c.getLocalName();
                    logger.debug("Compare Class \"" + this.parentClass + "\" with \"" + parent + "\"");
                    if (!parent.equals(this.parentClass)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }

    private class ParentIsSubClassMatch
    implements DrbItemTest {
        private String parentClass = null;

        ParentIsSubClassMatch(String parent_class) {
            this.parentClass = parent_class.trim();
        }

        public boolean matches(DrbItem item) {
            if (item == null || !(item instanceof DrbNode) || ((DrbNode)item).getParent() == null) {
                return false;
            }
            try {
                DrbCortexItemClass cla = DrbCortexModel.getDefaultModel().getClassOf((DrbItem)((DrbNode)item).getParent());
                String parent = cla.getOntClass().getNameSpace() + cla.getOntClass().getLocalName();
                logger.debug("Compare Class \"" + this.parentClass + "\" with \"" + parent + "\"");
                if (parent.matches(this.parentClass)) {
                    return true;
                }
                ExtendedIterator it = cla.getOntClass().listSuperClasses();
                while (it.hasNext()) {
                    OntClass c = (OntClass)it.next();
                    parent = c.getNameSpace() + c.getLocalName();
                    logger.debug("Compare Class \"" + this.parentClass + "\" with \"" + parent + "\"");
                    if (!parent.matches(this.parentClass)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }

    private class ParentClassTest
    implements DrbItemTest {
        private String parentClass = null;

        ParentClassTest(String parent_class) {
            this.parentClass = parent_class.trim();
        }

        public boolean matches(DrbItem item) {
            if (item == null || !(item instanceof DrbNode) || ((DrbNode)item).getParent() == null) {
                return false;
            }
            try {
                DrbCortexItemClass cla = DrbCortexModel.getDefaultModel().getClassOf((DrbItem)((DrbNode)item).getParent());
                String parent = cla.getOntClass().getNameSpace() + cla.getOntClass().getLocalName();
                logger.debug("Compare Class \"" + this.parentClass + "\" with \"" + parent + "\"");
                if (parent.equals(this.parentClass)) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }

    private class ParentClassMatch
    implements DrbItemTest {
        private String parentClass = null;

        ParentClassMatch(String parent_class) {
            this.parentClass = parent_class.trim();
        }

        public boolean matches(DrbItem item) {
            if (item == null || !(item instanceof DrbNode) || ((DrbNode)item).getParent() == null) {
                return false;
            }
            try {
                DrbCortexItemClass cla = DrbCortexModel.getDefaultModel().getClassOf((DrbItem)((DrbNode)item).getParent());
                String parent = cla.getOntClass().getNameSpace() + cla.getOntClass().getLocalName();
                logger.debug("Compare Class \"" + this.parentClass + "\" with \"" + parent + "\"");
                if (parent.matches(this.parentClass)) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }

    private class NamespaceMatch
    implements DrbItemTest {
        private String matchesUri = null;

        NamespaceMatch(String matches) {
            this.matchesUri = matches;
        }

        public boolean matches(DrbItem item) {
            return item.getNamespaceURI() != null && item.getNamespaceURI().matches(this.matchesUri);
        }

        public String toString() {
            return "NamespaceMatch(\"" + this.matchesUri + "\")";
        }
    }

    private class NamespaceTest
    implements DrbItemTest {
        private String nsUri = null;

        NamespaceTest(String _ns) {
            this.nsUri = _ns;
            if ("".equals(_ns)) {
                this.nsUri = null;
            }
        }

        public boolean matches(DrbItem item) {
            String namespace = item.getNamespaceURI();
            return namespace == this.nsUri || this.nsUri.equals(namespace);
        }

        public String toString() {
            return "NamespaceTest(\"" + this.nsUri + "\")";
        }
    }

    private class XQueryTest
    implements DrbItemTest {
        private String queryScript = null;
        private Query query = null;

        XQueryTest(String query_script) {
            this.queryScript = query_script;
            this.query = new Query(this.queryScript);
        }

        public boolean matches(DrbItem item) {
            DrbSequence result_sequence;
            if (logger.isDebugEnabled()) {
                logger.debug("      Probing " + this + " with item \"" + item.getName() + "\"");
            }
            if (item.getItemType() == 1) {
                item = new DrbNodeSpi((DrbNode)item, true);
                if (logger.isDebugEnabled()) {
                    logger.debug("      Item \"" + item.getName() + "\" potentially cloned to prevent alteration of the input node. New reference = \"" + item.getName() + "\"@" + Integer.toHexString(item.hashCode()));
                }
                if (item.getItemType() == 1) {
                    DrbCortexItemSignature.this.getHoldingClass().getModel().putClassInCache(((DrbNode)item).getPath(), DrbCortexItemSignature.this.getHoldingClass());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("      Item \"" + item.getName() + "\"@" + Integer.toHexString(item.hashCode()) + " queued to prevent cyclic testing.");
                }
            }
            try {
                result_sequence = this.query.evaluate(item);
            }
            catch (RuntimeException e) {
                logger.error("Error while running " + this.queryScript);
                throw e;
            }
            boolean result = Query.getEffectiveBooleanValue((DrbSequence)result_sequence);
            if (!result) {
                if (item.getItemType() == 1) {
                    DrbCortexItemSignature.this.getHoldingClass().getModel().removeClassFromCache(((DrbNode)item).getPath());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(" Item \"" + item.getName() + "\" dequeued.");
                }
            }
            return result;
        }

        public String toString() {
            String message = null;
            message = this.queryScript.trim().length() > 60 ? this.queryScript.trim().substring(0, 60) + "[...]" : this.queryScript.trim();
            return "XQueryTest(\"" + message + "\")";
        }
    }

    private class NameTest
    implements DrbItemTest {
        private String name = null;

        NameTest(String _name) {
            this.name = _name;
        }

        public boolean matches(DrbItem item) {
            return item.getName() != null && item.getName().equals(this.name);
        }

        public String toString() {
            return "NameTest(\"" + this.name + "\")";
        }
    }

    private class NameMatch
    implements DrbItemTest {
        private String regex = null;

        NameMatch(String _regex) {
            this.regex = _regex;
        }

        public boolean matches(DrbItem item) {
            return item.getName() != null && item.getName().matches(this.regex);
        }

        public String toString() {
            return "NameMatch(\"" + this.regex + "\")";
        }
    }

    public static interface DrbItemTest {
        public boolean matches(DrbItem var1);
    }
}

