/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.Reader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class LARQ {
    public static final String fIndex = "index";
    public static final String fLex = "lex";
    public static final String fLang = "lang";
    public static final String fDataType = "datatype";
    public static final String fURI = "uri";
    public static final String fBNodeID = "bnode";
    public static final Symbol indexKey = ARQConstants.allocSymbol("lucene");

    public static void setDefaultIndex(IndexLARQ index) {
        LARQ.setDefaultIndex(ARQ.getContext(), index);
    }

    public static void setDefaultIndex(Context context, IndexLARQ index) {
        context.set(indexKey, index);
    }

    public static IndexLARQ getDefaultIndex() {
        return LARQ.getDefaultIndex(ARQ.getContext());
    }

    public static IndexLARQ getDefaultIndex(Context context) {
        return (IndexLARQ)context.get(indexKey);
    }

    public static void removeDefaultIndex() {
        LARQ.removeDefaultIndex(ARQ.getContext());
    }

    public static void removeDefaultIndex(Context context) {
        context.unset(indexKey);
    }

    public static void index(Document doc, Node indexNode) {
        if (!indexNode.isLiteral()) {
            throw new ARQLuceneException("Not a literal: " + indexNode);
        }
        LARQ.index(doc, indexNode.getLiteralLexicalForm());
    }

    public static void index(Document doc, String indexContent) {
        Field indexField = new Field(fIndex, indexContent, Field.Store.NO, Field.Index.TOKENIZED);
        doc.add(indexField);
    }

    public static void index(Document doc, Reader indexContent) {
        Field indexField = new Field(fIndex, indexContent);
        doc.add(indexField);
    }

    public static void store(Document doc, Node node) {
        if (node.isLiteral()) {
            LARQ.storeLiteral(doc, (Node_Literal)node);
        } else if (node.isURI()) {
            LARQ.storeURI(doc, (Node_URI)node);
        } else if (node.isBlank()) {
            LARQ.storeBNode(doc, (Node_Blank)node);
        } else {
            throw new ARQLuceneException("Can't store: " + node);
        }
    }

    public static Node build(Document doc) {
        String lex = doc.get(fLex);
        if (lex != null) {
            return LARQ.buildLiteral(doc);
        }
        String uri = doc.get(fURI);
        if (uri != null) {
            return Node.createURI((String)uri);
        }
        String bnode2 = doc.get(fBNodeID);
        if (bnode2 != null) {
            return Node.createAnon((AnonId)new AnonId(bnode2));
        }
        throw new ARQLuceneException("Can't build: " + doc);
    }

    public static boolean isString(Literal literal) {
        RDFDatatype dtype = literal.getDatatype();
        if (dtype == null) {
            return true;
        }
        return dtype.equals(XSDDatatype.XSDstring);
    }

    private static void storeURI(Document doc, Node_URI node) {
        String x = node.getURI();
        Field f = new Field(fIndex, x, Field.Store.NO, Field.Index.TOKENIZED);
        doc.add(f);
        f = new Field(fURI, x, Field.Store.YES, Field.Index.NO);
        doc.add(f);
    }

    private static void storeBNode(Document doc, Node_Blank node) {
        String x = node.getBlankNodeLabel();
        Field f = new Field(fIndex, x, Field.Store.NO, Field.Index.TOKENIZED);
        doc.add(f);
        f = new Field(fBNodeID, x, Field.Store.YES, Field.Index.NO);
        doc.add(f);
    }

    private static void storeLiteral(Document doc, Node_Literal node) {
        String lex = node.getLiteralLexicalForm();
        String datatype = node.getLiteralDatatypeURI();
        String lang = node.getLiteralLanguage();
        Field f = new Field(fLex, lex, Field.Store.YES, Field.Index.NO);
        doc.add(f);
        if (lang != null) {
            f = new Field(fLang, lang, Field.Store.YES, Field.Index.NO);
            doc.add(f);
        }
        if (datatype != null) {
            f = new Field(fDataType, datatype, Field.Store.YES, Field.Index.NO);
            doc.add(f);
        }
    }

    private static Node buildLiteral(Document doc) {
        String lex = doc.get(fLex);
        if (lex == null) {
            return null;
        }
        String datatype = doc.get(fDataType);
        String lang = doc.get(fLang);
        return NodeFactory.createLiteralNode(lex, lang, datatype);
    }
}

