/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDistinguishedVars;
import com.hp.hpl.jena.sparql.engine.main.StageGenBasicPattern;
import com.hp.hpl.jena.sparql.engine.main.StageGenPropertyFunction;
import com.hp.hpl.jena.sparql.engine.main.StageGenerator;
import com.hp.hpl.jena.sparql.engine.main.StageList;
import com.hp.hpl.jena.sparql.util.Context;

public class StageBuilder {
    public static QueryIterator compile(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        if (pattern.isEmpty()) {
            return input;
        }
        boolean hideBNodeVars = execCxt.getContext().isTrue(ARQ.hideNonDistiguishedVariables);
        StageGenerator gen = StageBuilder.chooseStageGenerator(execCxt.getContext());
        StageList sList = gen.compile(pattern, execCxt);
        QueryIterator qIter = sList.build(input, execCxt);
        if (hideBNodeVars) {
            qIter = new QueryIterDistinguishedVars(qIter, execCxt);
        }
        return qIter;
    }

    public static void setGenerator(Context context, StageGenerator builder) {
        context.set(ARQ.stageGenerator, builder);
    }

    public static StageGenerator getGenerator(Context context) {
        if (context == null) {
            return null;
        }
        return (StageGenerator)context.get(ARQ.stageGenerator);
    }

    public static StageGenerator getGenerator() {
        StageGenerator gen = StageBuilder.getGenerator(ARQ.getContext());
        if (gen == null) {
            gen = StageBuilder.standardGenerator();
            StageBuilder.setGenerator(ARQ.getContext(), gen);
        }
        return gen;
    }

    public static StageGenerator standardGenerator() {
        return new StageGenPropertyFunction(new StageGenBasicPattern());
    }

    private static StageGenerator chooseStageGenerator(Context context) {
        StageGenerator gen = StageBuilder.getGenerator(context);
        if (gen == null) {
            gen = StageBuilder.getGenerator();
        }
        return gen;
    }
}

