/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.ExprNode;
import com.hp.hpl.jena.sparql.expr.ExprNotComparableException;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeFunctions;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueBoolean;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDate;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDateTime;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDecimal;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDouble;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueFloat;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueNode;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueString;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import com.hp.hpl.jena.sparql.util.RefBoolean;
import com.hp.hpl.jena.sparql.util.RomanNumeral;
import com.hp.hpl.jena.sparql.util.RomanNumeralDatatype;
import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.vocabulary.XSD;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;

public abstract class NodeValue
extends ExprNode {
    public static boolean VerboseWarnings = true;
    public static boolean VerboseExceptions = false;
    private static boolean VALUE_EXTENSIONS;
    private static boolean sameValueAsString;
    private static RefBoolean enableRomanNumerals;
    public static final BigInteger IntegerZERO;
    public static final BigDecimal DecimalZERO;
    public static final NodeValue TRUE;
    public static final NodeValue FALSE;
    private Node node = null;
    private static final int VSPACE_NUM = 10;
    private static final int VSPACE_DATETIME = 20;
    private static final int VSPACE_DATETIME_TZ = 20;
    private static final int VSPACE_DATETIME_NO_TZ = 25;
    private static final int VSPACE_DATE = 30;
    private static final int VSPACE_DATE_TZ = 30;
    private static final int VSPACE_DATE_NO_TZ = 35;
    private static final int VSPACE_STRING = 40;
    private static final int VSPACE_LANG = 50;
    private static final int VSPACE_BOOLEAN = 60;
    private static final int VSPACE_NODE = 70;
    private static final int VSPACE_UNKNOWN = 80;
    private static final int VSPACE_DIFFERENT = 90;

    protected NodeValue() {
    }

    protected NodeValue(Node n) {
        this.node = n;
    }

    public static NodeValue makeInteger(long i) {
        return new NodeValueInteger(i);
    }

    public static NodeValue makeInteger(BigInteger i) {
        return new NodeValueInteger(i);
    }

    public static NodeValue makeInteger(String lexicalForm) {
        return new NodeValueInteger(new BigInteger(lexicalForm));
    }

    public static NodeValue makeFloat(float f) {
        return new NodeValueFloat(f);
    }

    public static NodeValue makeDouble(double d) {
        return new NodeValueDouble(d);
    }

    public static NodeValue makeString(String s) {
        return new NodeValueString(s);
    }

    public static NodeValue makeDecimal(BigDecimal d) {
        return new NodeValueDecimal(d);
    }

    public static NodeValue makeDecimal(long i) {
        return new NodeValueDecimal(BigDecimal.valueOf(i));
    }

    public static NodeValue makeDecimal(double d) {
        return new NodeValueDecimal(new BigDecimal(d));
    }

    public static NodeValue makeDecimal(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdecimal);
    }

    public static NodeValue makeDateTime(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeDateTime(Calendar cal) {
        XSDDateTime xdt = new XSDDateTime(cal);
        return new NodeValueDateTime(xdt);
    }

    public static NodeValue makeDate(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdate);
    }

    public static NodeValue makeDate(Calendar cal) {
        XSDDateTime xdt = new XSDDateTime(cal);
        return new NodeValueDate(xdt);
    }

    public static NodeValue makeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue booleanReturn(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNode(Node n) {
        NodeValue nv = NodeValue.nodeToNodeValue(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, XSDDatatype dtype) {
        Node n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dtype);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return NodeValue.makeNode(lexicalForm, langTag, uri);
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, String datatype) {
        if (datatype != null && datatype.equals("")) {
            datatype = null;
        }
        if (langTag != null && datatype != null) {
            ALog.warn(NodeValue.class, "Both lang tag and datatype defined (lexcial form '" + lexicalForm + "')");
        }
        Node n = null;
        if (datatype != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
            n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dType);
        } else {
            n = Node.createLiteral((String)lexicalForm, (String)langTag, null);
        }
        return NodeValue.makeNode(n);
    }

    public static NodeValue makeNodeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNodeBoolean(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xboolean.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(long v) {
        NodeValue nv = NodeValue.makeNode(Long.toString(v), null, XSD.integer.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.integer.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(float f) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(f), null, XSD.xfloat.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(double v) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(v), null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDecimal(BigDecimal decimal) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(decimal), null, XSD.decimal.getURI());
        return nv;
    }

    public static NodeValue makeNodeDecimal(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.decimal.getURI());
        return nv;
    }

    public static NodeValue makeNodeString(String string) {
        NodeValue nv = NodeValue.makeNode(string, null, (String)null);
        return nv;
    }

    public static NodeValue makeNodeDateTime(Calendar date2) {
        String lex = Utils.calendarToXSDDateTimeString(date2);
        NodeValue nv = NodeValue.makeNode(lex, XSDDatatype.XSDdateTime);
        return nv;
    }

    public static NodeValue makeNodeDateTime(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
        return nv;
    }

    public static NodeValue makeNodeDate(Calendar date2) {
        String lex = Utils.calendarToXSDDateString(date2);
        NodeValue nv = NodeValue.makeNode(lex, XSDDatatype.XSDdate);
        return nv;
    }

    public static NodeValue makeNodeDate(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdate);
        return nv;
    }

    public NodeValue eval(Binding binding, FunctionEnv env) {
        return this;
    }

    public Expr copySubstitute(Binding binding, boolean foldConstants) {
        Node n = this.asNode();
        return NodeValue.makeNode(n);
    }

    public NodeValue evalNodeValue(Binding binding, ExecutionContext execCxt) {
        System.err.println("eval - convert back to NodeValue");
        return null;
    }

    public Node evalNode(Binding binding, ExecutionContext execCxt) {
        return this.asNode();
    }

    public boolean isConstant() {
        return true;
    }

    public NodeValue getConstant() {
        return this;
    }

    public static boolean sameAs(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            new ARQInternalErrorException("Attempt to sameValueAs on a null");
        }
        int compType = NodeValue.classifyValueOp(nv1, nv2);
        switch (compType) {
            case 10: {
                return XSDFuncOp.compareNumeric(nv1, nv2) == 0;
            }
            case 20: {
                int x = XSDFuncOp.compareDateTime(nv1, nv2);
                if (x == 2) {
                    throw new ExprNotComparableException("Indeterminate dateTime comparison");
                }
                return x == 0;
            }
            case 30: {
                int x = XSDFuncOp.compareDate(nv1, nv2);
                if (x == 2) {
                    throw new ExprNotComparableException("Indeterminate date comparison");
                }
                return x == 0;
            }
            case 40: {
                return XSDFuncOp.compareString(nv1, nv2) == 0;
            }
            case 60: {
                return XSDFuncOp.compareBoolean(nv1, nv2) == 0;
            }
            case 50: {
                Node node1 = nv1.getNode();
                Node node2 = nv2.getNode();
                return node1.getLiteralLexicalForm().equals(node2.getLiteralLexicalForm()) && node1.getLiteralLanguage().equalsIgnoreCase(node2.getLiteralLanguage());
            }
            case 70: {
                return NodeFunctions.sameTerm(nv1.getNode(), nv2.getNode());
            }
            case 80: {
                Node node1 = nv1.getNode();
                Node node2 = nv2.getNode();
                if (!VALUE_EXTENSIONS) {
                    return NodeFunctions.rdfTermEquals(node1, node2);
                }
                if (!node1.isLiteral() || !node2.isLiteral()) {
                    return false;
                }
                if (NodeFunctions.sameTerm(node1, node2)) {
                    return true;
                }
                if (!node1.getLiteralLanguage().equals("") || !node2.getLiteralLanguage().equals("")) {
                    return false;
                }
                NodeValue.raise(new ExprEvalException("Unknown equality test: " + nv1 + " and " + nv2));
                throw new ARQInternalErrorException("raise returned (sameValueAs)");
            }
            case 90: {
                if (!VALUE_EXTENSIONS && nv1.isLiteral() && nv2.isLiteral()) {
                    NodeValue.raise(new ExprEvalException("Incompatible: " + nv1 + " and " + nv2));
                }
                return false;
            }
        }
        throw new ARQInternalErrorException("sameValueAs failure" + nv1 + " and " + nv2);
    }

    public static boolean notSameAs(Node n1, Node n2) {
        return NodeValue.notSameAs(NodeValue.makeNode(n1), NodeValue.makeNode(n2));
    }

    public static boolean notSameAs(NodeValue nv1, NodeValue nv2) {
        return !NodeValue.sameAs(nv1, nv2);
    }

    public static int compareAlways(NodeValue nv1, NodeValue nv2) {
        try {
            int x = NodeValue.compare(nv1, nv2, true);
            if (x != 0) {
                return x;
            }
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
        nv1.forceToNode();
        nv2.forceToNode();
        return NodeUtils.compareRDFTerms(nv1.getNode(), nv2.getNode());
    }

    public static int compare(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            new ARQInternalErrorException("Attempt to compare on null");
        }
        int x = NodeValue.compare(nv1, nv2, false);
        return x;
    }

    private static int compare(NodeValue nv1, NodeValue nv2, boolean sortOrderingCompare) {
        if (nv1 == null && nv2 == null) {
            return 0;
        }
        if (nv1 == null) {
            return -1;
        }
        if (nv2 == null) {
            return 1;
        }
        int compType = NodeValue.classifyValueOp(nv1, nv2);
        switch (compType) {
            case 20: {
                int x = XSDFuncOp.compareDateTime(nv1, nv2);
                if (x != 2) {
                    return x;
                }
                compType = 90;
                break;
            }
            case 30: {
                int x = XSDFuncOp.compareDate(nv1, nv2);
                if (x != 2) {
                    return x;
                }
                compType = 90;
                break;
            }
        }
        switch (compType) {
            case 20: 
            case 30: {
                throw new ARQInternalErrorException("Still seeing date/dateTime compare type");
            }
            case 10: {
                return XSDFuncOp.compareNumeric(nv1, nv2);
            }
            case 40: {
                int cmp = XSDFuncOp.compareString(nv1, nv2);
                if (!sortOrderingCompare) {
                    return cmp;
                }
                if (cmp != 0) {
                    return cmp;
                }
                String dt1 = nv1.asNode().getLiteralDatatypeURI();
                String dt2 = nv2.asNode().getLiteralDatatypeURI();
                if (dt1 == null && dt2 != null) {
                    return -1;
                }
                if (dt2 == null && dt1 != null) {
                    return 1;
                }
                return 0;
            }
            case 60: {
                return XSDFuncOp.compareBoolean(nv1, nv2);
            }
            case 50: {
                Node node1 = nv1.asNode();
                Node node2 = nv2.asNode();
                int x = StringUtils.strCompareIgnoreCase(node1.getLiteralLanguage(), node2.getLiteralLanguage());
                if (x != 0) {
                    if (!sortOrderingCompare) {
                        NodeValue.raise(new ExprNotComparableException("Can't compare (different languages) " + nv1 + " and " + nv2));
                    }
                    return x;
                }
                x = StringUtils.strCompare(node1.getLiteralLexicalForm(), node2.getLiteralLexicalForm());
                if (x != 0) {
                    return x;
                }
                x = StringUtils.strCompare(node1.getLiteralLanguage(), node2.getLiteralLanguage());
                if (x == 0 && !NodeFunctions.sameTerm(node1, node2)) {
                    throw new ARQInternalErrorException("Look the same (lang tags) but no node equals");
                }
                return x;
            }
            case 70: {
                if (sortOrderingCompare) {
                    return NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
                }
                NodeValue.raise(new ExprNotComparableException("Can't compare (nodes) " + nv1 + " and " + nv2));
                throw new ARQInternalErrorException("NodeValue.raise returned");
            }
            case 80: {
                Node node1 = nv1.asNode();
                Node node2 = nv2.asNode();
                if (NodeFunctions.sameTerm(node1, node2)) {
                    return 0;
                }
                if (sortOrderingCompare) {
                    return NodeUtils.compareRDFTerms(node1, node2);
                }
                NodeValue.raise(new ExprNotComparableException("Can't compare " + nv1 + " and " + nv2));
                throw new ARQInternalErrorException("NodeValue.raise returned");
            }
            case 90: {
                if (sortOrderingCompare) {
                    return NodeUtils.compareRDFTerms(nv1.asNode(), nv2.asNode());
                }
                NodeValue.raise(new ExprNotComparableException("Can't compare (incompatible value spaces)" + nv1 + " and " + nv2));
                throw new ARQInternalErrorException("NodeValue.raise returned");
            }
        }
        throw new ARQInternalErrorException("Compare failure " + nv1 + " and " + nv2);
    }

    private static int classifyValueOp(NodeValue nv1, NodeValue nv2) {
        int c2;
        int c1 = NodeValue.classifyValueSpace(nv1);
        if (c1 == (c2 = NodeValue.classifyValueSpace(nv2))) {
            return c1;
        }
        if (c1 == 80 || c2 == 80) {
            return 80;
        }
        return 90;
    }

    private static int classifyValueSpace(NodeValue nv) {
        if (nv.isNumber()) {
            return 10;
        }
        if (nv.isDateTime()) {
            return 20;
        }
        if (VALUE_EXTENSIONS && nv.isDate()) {
            return 30;
        }
        if (nv.isString()) {
            return 40;
        }
        if (nv.isBoolean()) {
            return 60;
        }
        if (!nv.isLiteral()) {
            return 70;
        }
        if (VALUE_EXTENSIONS && nv.getNode() != null && nv.getNode().isLiteral() && !nv.getNode().getLiteralLanguage().equals("")) {
            return 50;
        }
        return 80;
    }

    public static Node toNode(NodeValue nv) {
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    public final Node asNode() {
        if (this.node == null) {
            this.node = this.makeNode();
        }
        return this.node;
    }

    protected abstract Node makeNode();

    public Node getNode() {
        return this.node;
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public boolean hasKnownValue() {
        return this.isBoolean() || this.isNumber() || this.isString() || this.isDateTime() || this.isDate();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isDecimal() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isDate() {
        return false;
    }

    public boolean isLiteral() {
        return this.getNode() == null || this.getNode().isLiteral();
    }

    public boolean getBoolean() {
        NodeValue.raise(new ExprEvalException("Not a boolean: " + this));
        return false;
    }

    public String getString() {
        NodeValue.raise(new ExprEvalException("Not a string: " + this));
        return null;
    }

    public BigInteger getInteger() {
        NodeValue.raise(new ExprEvalException("Not an integer: " + this));
        return null;
    }

    public BigDecimal getDecimal() {
        NodeValue.raise(new ExprEvalException("Not a decimal: " + this));
        return null;
    }

    public float getFloat() {
        NodeValue.raise(new ExprEvalException("Not a float: " + this));
        return Float.NaN;
    }

    public double getDouble() {
        NodeValue.raise(new ExprEvalException("Not a double: " + this));
        return Double.NaN;
    }

    public XSDDateTime getDateTime() {
        NodeValue.raise(new ExprEvalException("Not a dateTime: " + this));
        return null;
    }

    public XSDDateTime getDate() {
        NodeValue.raise(new ExprEvalException("Not a date: " + this));
        return null;
    }

    private static NodeValue nodeToNodeValue(Node node) {
        boolean isPlainLiteral;
        if (node.isVariable()) {
            ALog.warn(NodeValue.class, "Variable passed to NodeValue.nodeToNodeValue");
        }
        if (!node.isLiteral()) {
            return new NodeValueNode(node);
        }
        boolean hasLangTag = node.getLiteralLanguage() != null && !node.getLiteralLanguage().equals("");
        boolean bl = isPlainLiteral = node.getLiteralDatatypeURI() == null && !hasLangTag;
        if (isPlainLiteral) {
            return new NodeValueString(node.getLiteralLexicalForm(), node);
        }
        if (hasLangTag) {
            if (node.getLiteralDatatypeURI() != null && VerboseWarnings) {
                ALog.warn(NodeValue.class, "Lang tag and datatype (datatype ignored)");
            }
            return new NodeValueNode(node);
        }
        LiteralLabel lit = node.getLiteral();
        if (!lit.getDatatype().isValidLiteral(lit)) {
            if (VerboseWarnings) {
                String tmp = FmtUtils.stringForNode(node);
                ALog.warn(NodeValue.class, "Datatype format exception: " + tmp);
            }
            return new NodeValueNode(node);
        }
        NodeValue nv = NodeValue._setByValue(node);
        if (nv != null) {
            return nv;
        }
        return new NodeValueNode(node);
    }

    private static NodeValue _setByValue(Node node) {
        LiteralLabel lit = node.getLiteral();
        try {
            if (sameValueAsString && XSDDatatype.XSDstring.isValidLiteral(node.getLiteral())) {
                return new NodeValueString(lit.getLexicalForm(), node);
            }
            if (!node.getLiteralDatatype().equals(XSDDatatype.XSDdecimal) && XSDDatatype.XSDinteger.isValidLiteral(lit)) {
                long i = ((Number)lit.getValue()).longValue();
                return new NodeValueInteger(i, node);
            }
            if (XSDDatatype.XSDdecimal.isValidLiteral(lit)) {
                BigDecimal decimal = new BigDecimal(lit.getLexicalForm());
                return new NodeValueDecimal(decimal, node);
            }
            if (XSDDatatype.XSDfloat.isValidLiteral(lit)) {
                float f = ((Number)lit.getValue()).floatValue();
                return new NodeValueFloat(f, node);
            }
            if (XSDDatatype.XSDdouble.isValidLiteral(lit)) {
                double d = ((Number)lit.getValue()).doubleValue();
                return new NodeValueDouble(d, node);
            }
            if (XSDDatatype.XSDdateTime.isValidLiteral(lit)) {
                XSDDateTime dateTime = (XSDDateTime)lit.getValue();
                return new NodeValueDateTime(dateTime, node);
            }
            if (XSDDatatype.XSDdate.isValidLiteral(lit)) {
                XSDDateTime dateTime = (XSDDateTime)lit.getValue();
                return new NodeValueDate(dateTime, node);
            }
            if (XSDDatatype.XSDboolean.isValidLiteral(lit)) {
                boolean b = (Boolean)lit.getValue();
                return new NodeValueBoolean(b, node);
            }
            if (enableRomanNumerals.getValue() && lit.getDatatypeURI().equals(RomanNumeralDatatype.get().getURI())) {
                Object obj = RomanNumeralDatatype.get().parse(lit.getLexicalForm());
                if (obj instanceof Integer) {
                    return new NodeValueInteger(((Integer)obj).longValue());
                }
                if (obj instanceof RomanNumeral) {
                    return new NodeValueInteger(((RomanNumeral)obj).intValue());
                }
                throw new ARQInternalErrorException("DatatypeFormatException: Roman numeral is unknown class");
            }
        }
        catch (DatatypeFormatException ex) {
            throw new ARQInternalErrorException("DatatypeFormatException: " + lit, ex);
        }
        return null;
    }

    public static void raise(ExprException ex) {
        throw ex;
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    private void forceToNode() {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node == null) {
            NodeValue.raise(new ExprEvalException("Not a node: " + this));
        }
    }

    public final String asUnquotedString() {
        return this.asString();
    }

    public final String asQuotedString() {
        return this.asQuotedString(new SerializationContext());
    }

    public final String asQuotedString(SerializationContext context) {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node != null) {
            return FmtUtils.stringForNode(this.node, context);
        }
        return this.toString();
    }

    public String asString() {
        this.forceToNode();
        return NodeFunctions.str(this.node);
    }

    public int hashCode() {
        return this.asNode().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeValue)) {
            return false;
        }
        NodeValue nv = (NodeValue)other;
        return this.asNode().equals((Object)nv.asNode());
    }

    public abstract void visit(NodeValueVisitor var1);

    public String toString() {
        return this.asQuotedString();
    }

    static {
        sameValueAsString = VALUE_EXTENSIONS = ARQ.getContext().isTrueOrUndef(ARQ.extensionValueTypes);
        enableRomanNumerals = new RefBoolean(ARQ.enableRomanNumerals, false);
        IntegerZERO = new BigInteger("0");
        DecimalZERO = new BigDecimal("0");
        TRUE = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
        FALSE = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
    }
}

