/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeStruct {
    public boolean xsdDateTime;
    public String neg = null;
    public String year = null;
    public String month = null;
    public String day = null;
    public String hour = null;
    public String minute = null;
    public String second = null;
    public String timezone = null;
    public static final String regexDate = "(-?)(\\d{4})-(\\d{2})-(\\d{2})";
    public static final String regexTime = "(\\d{2}):(\\d{2}):(\\d{2}(?:\\.\\d+)?)";
    public static final String regexTZ = "(Z|(?:(?:\\+|-)\\d{2}:\\d{2}))?";
    public static final String regexXSDDateTime = "(-?)(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2}(?:\\.\\d+)?)(Z|(?:(?:\\+|-)\\d{2}:\\d{2}))?";
    public static final String regexXSDDate = "(-?)(\\d{4})-(\\d{2})-(\\d{2})(Z|(?:(?:\\+|-)\\d{2}:\\d{2}))?";
    public static final Pattern patternDateTime = Pattern.compile("(-?)(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2}(?:\\.\\d+)?)(Z|(?:(?:\\+|-)\\d{2}:\\d{2}))?");
    public static final Pattern patternDate = Pattern.compile("(-?)(\\d{4})-(\\d{2})-(\\d{2})(Z|(?:(?:\\+|-)\\d{2}:\\d{2}))?");

    private DateTimeStruct() {
    }

    public String toString() {
        String ySep = "-";
        String tSep = ":";
        String x = this.year + ySep + this.month + ySep + this.day;
        if (this.xsdDateTime) {
            x = x + "T" + this.hour + tSep + this.minute + tSep + this.second;
        }
        if (this.neg != null) {
            x = this.neg + x;
        }
        if (this.timezone != null) {
            x = x + this.timezone;
        }
        return x;
    }

    public static DateTimeStruct parseDate(String str2) {
        Matcher m = patternDate.matcher(str2);
        if (!m.matches()) {
            throw new DateTimeParseException();
        }
        DateTimeStruct dt = new DateTimeStruct();
        dt.xsdDateTime = false;
        dt.neg = DateTimeStruct.matchStrOrNull(str2, m, 1);
        dt.year = DateTimeStruct.matchStr(str2, m, 2);
        dt.month = DateTimeStruct.matchStr(str2, m, 3);
        dt.day = DateTimeStruct.matchStr(str2, m, 4);
        dt.timezone = DateTimeStruct.matchStrOrNull(str2, m, 5);
        dt.hour = "00";
        dt.minute = "00";
        dt.second = "00";
        return dt;
    }

    public static DateTimeStruct parseDateTime(String str2) {
        Matcher m = patternDateTime.matcher(str2);
        if (!m.matches()) {
            throw new DateTimeParseException();
        }
        DateTimeStruct dt = new DateTimeStruct();
        dt.xsdDateTime = true;
        dt.neg = DateTimeStruct.matchStrOrNull(str2, m, 1);
        dt.year = DateTimeStruct.matchStr(str2, m, 2);
        dt.month = DateTimeStruct.matchStr(str2, m, 3);
        dt.day = DateTimeStruct.matchStr(str2, m, 4);
        dt.hour = DateTimeStruct.matchStr(str2, m, 5);
        dt.minute = DateTimeStruct.matchStr(str2, m, 6);
        dt.second = DateTimeStruct.matchStr(str2, m, 7);
        dt.timezone = DateTimeStruct.matchStrOrNull(str2, m, 8);
        return dt;
    }

    private static String matchStr(String str2, Matcher m, int i) {
        if (m.start(i) == -1) {
            return "";
        }
        return str2.substring(m.start(i), m.end(i));
    }

    private static String matchStrOrNull(String str2, Matcher m, int i) {
        if (m.start(i) == -1) {
            return null;
        }
        String s = str2.substring(m.start(i), m.end(i));
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    public static class DateTimeParseException
    extends RuntimeException {
    }
}

