/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.util.NotUniqueException;
import com.hp.hpl.jena.sparql.util.PlainGraphMem;
import com.hp.hpl.jena.sparql.util.PropertyRequiredException;
import com.hp.hpl.jena.sparql.util.RefBoolean;
import com.hp.hpl.jena.sparql.util.TypeNotUniqueException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphUtils {
    private static RefBoolean usePlainGraph = new RefBoolean(ARQ.strictGraph);

    public static Model makeDefaultModel() {
        return ModelFactory.createModelForGraph((Graph)GraphUtils.makeDefaultGraph());
    }

    public static Model makePlainModel() {
        return ModelFactory.createModelForGraph((Graph)GraphUtils.makePlainGraph());
    }

    public static Model makeJenaDefaultModel() {
        return ModelFactory.createDefaultModel();
    }

    public static Graph makeDefaultGraph() {
        return usePlainGraph.getValue() ? GraphUtils.makePlainGraph() : GraphUtils.makeJenaDefaultGraph();
    }

    public static Graph makeJenaDefaultGraph() {
        return Factory.createDefaultGraph();
    }

    public static Graph makePlainGraph() {
        return new PlainGraphMem();
    }

    public static List multiValueString(Resource r, Property p) {
        List nodes = GraphUtils.multiValue(r, p);
        ArrayList<String> values = new ArrayList<String>();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            RDFNode n = (RDFNode)iter.next();
            if (!n.isLiteral()) continue;
            values.add(((Literal)n).getString());
        }
        return values;
    }

    public static List multiValue(Resource r, Property p) {
        ArrayList<RDFNode> values = new ArrayList<RDFNode>();
        StmtIterator sIter = r.listProperties(p);
        while (sIter.hasNext()) {
            Statement s = sIter.nextStatement();
            values.add(s.getObject());
        }
        return values;
    }

    public static List multiValueURI(Resource r, Property p) {
        List nodes = GraphUtils.multiValue(r, p);
        ArrayList<String> values = new ArrayList<String>();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            RDFNode n = (RDFNode)iter.next();
            if (!n.isURIResource()) continue;
            values.add(((Resource)n).getURI());
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exactlyOneProperty(Resource r, Property p) {
        StmtIterator sIter = r.listProperties(p);
        try {
            if (!sIter.hasNext()) {
                throw new PropertyRequiredException(r, p);
            }
            sIter.next();
            if (sIter.hasNext()) {
                throw new NotUniqueException(r, p);
            }
        }
        finally {
            sIter.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean atmostOneProperty(Resource r, Property p) {
        StmtIterator sIter = r.listProperties(p);
        try {
            if (!sIter.hasNext()) {
                boolean bl = true;
                return bl;
            }
            sIter.next();
            if (sIter.hasNext()) {
                throw new NotUniqueException(r, p);
            }
        }
        finally {
            sIter.close();
        }
        return true;
    }

    public static String getStringValue(Resource r, Property p) {
        if (!GraphUtils.atmostOneProperty(r, p)) {
            throw new NotUniqueException(r, p);
        }
        Statement s = r.getProperty(p);
        if (s == null) {
            return null;
        }
        return s.getString();
    }

    public static String getAsStringValue(Resource r, Property p) {
        if (!GraphUtils.atmostOneProperty(r, p)) {
            throw new NotUniqueException(r, p);
        }
        Statement s = r.getProperty(p);
        if (s == null) {
            return null;
        }
        if (s.getObject().isResource()) {
            return s.getResource().getURI();
        }
        return s.getString();
    }

    public static Resource getResourceValue(Resource r, Property p) {
        if (!GraphUtils.atmostOneProperty(r, p)) {
            throw new NotUniqueException(r, p);
        }
        Statement s = r.getProperty(p);
        if (s == null) {
            return null;
        }
        return s.getResource();
    }

    public static Resource getResourceByType(Model model, Resource type) {
        StmtIterator sIter = model.listStatements(null, RDF.type, (RDFNode)type);
        if (!sIter.hasNext()) {
            return null;
        }
        Resource r = sIter.nextStatement().getSubject();
        if (sIter.hasNext()) {
            throw new TypeNotUniqueException(r);
        }
        return r;
    }

    public static String fmtURI(Resource r) {
        return r.getModel().shortForm(r.getURI());
    }
}

