<!-- *********************************************************************** -->
<!-- NAME schema.xsl                                                         -->
<!--                                                                         -->
<!-- *********************************************************************** -->
<!-- SYNOPSIS                                                                -->
<!-- To be use with an xsd file and xalan of Apache project                  -->
<!-- *********************************************************************** -->
<!-- DESCRIPTION                                                             -->
<!-- *********************************************************************** -->
<!-- COPYRIGHTS                                                              -->
<!-- Copyrights 2004 by GAEL Consultant - All rights reserved.               -->
<!-- GAEL Consultant proprietary - Delivered under license agreement.        -->
<!-- Copying and disclosure prohibited without express written permission    -->
<!-- from GAEL Consultant.                                                   -->
<!-- *********************************************************************** -->
<!-- ADMINISTRATION                                                          -->
<!-- Didier FRANCOIS  | 29.06.04 | v01.00 | Creation of the SW component     -->
<!-- *********************************************************************** -->

<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
     xmlns:xsd="http://www.w3.org/2001/03/XMLSchema"
     xmlns:sdf="http://www.gael.fr/drb/impl/sdf-20020222">

   <xsl:output method="xml" indent="yes"/>

   <xsl:param name="PKGDIR"/>


<!-- *********************************************************************** -->
<!-- template: annotation                                                    -->
<!-- *********************************************************************** -->
   <xsl:template match="*:annotation">
      <xsd:annotation>
        <xsl:apply-templates/>
        <xsd:appinfo>
           <xsl:for-each select="../sdf:block">
              <xsl:copy>
                 <xsl:apply-templates/>
              </xsl:copy>
           </xsl:for-each>
        </xsd:appinfo>
      </xsd:annotation>
   </xsl:template>

   <xsl:template match="sdf:block"/>

   
   <xsl:template match="*:schema/text()"/>
   <xsl:template match="*:block/text()"/>
   <xsl:template match="*:annotation/text()"/>
   <xsl:template match="*:element/text()"/>
   <xsl:template match="*:sequence/text()"/>
   <xsl:template match="*:complexType/text()"/>

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
