# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### StepFunctionsTPSTokenBucket <a name="StepFunctionsTPSTokenBucket" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.Initializer"></a>

```typescript
import { StepFunctionsTPSTokenBucket } from 'schadem-cdk-construct-sfn-token-bucket'

new StepFunctionsTPSTokenBucket(parent: Construct, id: string, props: StepFunctionsTPSTokenBucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.Initializer.parameter.parent">parent</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps">StepFunctionsTPSTokenBucketProps</a></code> | *No description.* |

---

##### `parent`<sup>Required</sup> <a name="parent" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.Initializer.parameter.parent"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps">StepFunctionsTPSTokenBucketProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.next">next</a></code> | Continue normal execution with the given state. |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.prefixStates">prefixStates</a></code> | Prefix the IDs of all states in this state machine fragment. |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.toSingleState">toSingleState</a></code> | Wrap all states in this state machine fragment up into a single state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `next` <a name="next" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.prefixStates"></a>

```typescript
public prefixStates(prefix?: string): StateMachineFragment
```

Prefix the IDs of all states in this state machine fragment.

Use this to avoid multiple copies of the state machine all having the
same state IDs.

###### `prefix`<sup>Optional</sup> <a name="prefix" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.prefixStates.parameter.prefix"></a>

- *Type:* string

The prefix to add.

Will use construct ID by default.

---

##### `toSingleState` <a name="toSingleState" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.toSingleState"></a>

```typescript
public toSingleState(options?: SingleStateOptions): Parallel
```

Wrap all states in this state machine fragment up into a single state.

This can be used to add retry or error handling onto this state
machine fragment.

Be aware that this changes the result of the inner state machine
to be an array with the result of the state machine in it. Adjust
your paths accordingly. For example, change 'outputPath' to
'$[0]'.

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.toSingleState.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.SingleStateOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.isConstruct"></a>

```typescript
import { StepFunctionsTPSTokenBucket } from 'schadem-cdk-construct-sfn-token-bucket'

StepFunctionsTPSTokenBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | The states to chain onto if this fragment is used. |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | The start state of this state machine fragment. |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

The states to chain onto if this fragment is used.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

The start state of this state machine fragment.

---


## Structs <a name="Structs" id="Structs"></a>

### StepFunctionsTPSTokenBucketProps <a name="StepFunctionsTPSTokenBucketProps" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps"></a>

#### Initializer <a name="Initializer" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps.Initializer"></a>

```typescript
import { StepFunctionsTPSTokenBucketProps } from 'schadem-cdk-construct-sfn-token-bucket'

const stepFunctionsTPSTokenBucketProps: StepFunctionsTPSTokenBucketProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps.property.tokenLimit">tokenLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps.property.sqsQueue">sqsQueue</a></code> | <code>aws-cdk-lib.aws_sqs.IQueue</code> | queue to use for the task token requests - allows for distribution of tokens across different workflows. |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps.property.tokenBucketDDBTableID">tokenBucketDDBTableID</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps.property.tokenBucketDDBTableName">tokenBucketDDBTableName</a></code> | <code>string</code> | *No description.* |

---

##### `tokenLimit`<sup>Required</sup> <a name="tokenLimit" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps.property.tokenLimit"></a>

```typescript
public readonly tokenLimit: number;
```

- *Type:* number

---

##### `sqsQueue`<sup>Optional</sup> <a name="sqsQueue" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps.property.sqsQueue"></a>

```typescript
public readonly sqsQueue: IQueue;
```

- *Type:* aws-cdk-lib.aws_sqs.IQueue

queue to use for the task token requests - allows for distribution of tokens across different workflows.

Queue and DDB table should obviously be the same if spreading

---

##### `tokenBucketDDBTableID`<sup>Optional</sup> <a name="tokenBucketDDBTableID" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps.property.tokenBucketDDBTableID"></a>

```typescript
public readonly tokenBucketDDBTableID: string;
```

- *Type:* string

---

##### `tokenBucketDDBTableName`<sup>Optional</sup> <a name="tokenBucketDDBTableName" id="schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucketProps.property.tokenBucketDDBTableName"></a>

```typescript
public readonly tokenBucketDDBTableName: string;
```

- *Type:* string

---



