"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsTPSTokenBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sqs = require("aws-cdk-lib/aws-sqs");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
class StepFunctionsTPSTokenBucket extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var dynamoDBTableName;
        var dynamoDBTableID;
        var sqsQueue;
        if (!props.tokenBucketDDBTableID || !props.tokenBucketDDBTableName) {
            const dynamoDBTableClass = new dynamodb.Table(this, 'TextractConcurrencyTable', {
                partitionKey: {
                    name: 'tpsTokenBucketDefault',
                    type: dynamodb.AttributeType.NUMBER,
                },
                billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            });
            dynamoDBTableName = dynamoDBTableClass.tableName;
            dynamoDBTableID = 'tpsTokenBucketDefault';
        }
        else {
            dynamoDBTableName = props.tokenBucketDDBTableName;
            dynamoDBTableID = props.tokenBucketDDBTableID;
        }
        if (!props.sqsQueue || !props.sqsQueue) {
            // should avoid using a different SQS queue for the same token bucket
            sqsQueue = new sqs.Queue(this, 'TokenBucketQueue');
        }
        else {
            sqsQueue = props.sqsQueue;
        }
        const tpsTokenBucketFunction = new lambda.DockerImageFunction(this, 'TokenBucketFunction', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/tokenbucket/')),
            memorySize: 128,
            timeout: aws_cdk_lib_1.Duration.minutes(5),
            environment: {
                TOKEN_LIMIT: props.tokenLimit.toString(),
                DDB_TOKEN_ID: dynamoDBTableID,
                DDB_TOKEN_TABLE: dynamoDBTableName,
            },
        });
        tpsTokenBucketFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['dynamodb:*'], resources: ['*'] }));
        tpsTokenBucketFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['states:*'], resources: ['*'] }));
        const tpsTokenBucketFunctionInvoke = new tasks.LambdaInvoke(this, 'TPSTokenBucketFunction', {
            lambdaFunction: tpsTokenBucketFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(900),
            outputPath: '$.Payload',
        });
        tpsTokenBucketFunctionInvoke.addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(1),
            maxAttempts: 6,
            backoffRate: 2,
            errors: [sfn.Errors.ALL],
        });
        const sqsTokenBucketTask = new tasks.SqsSendMessage(this, 'SqsTokenBucketTask', {
            queue: sqsQueue,
            messageBody: sfn.TaskInput.fromObject({ field1: 'somedata', TaskToken: sfn.JsonPath.taskToken }),
            integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
        });
        // const workflow_chain = sfn.Chain.start(sqsTokenBucketTask);
        // // detectText.next(releaseLockClass);
        // // textractAsyncLambdaInvoke.next(releaseLockClass);
        // const stateMachine = new sfn.StateMachine(this, 'StateMachine', {
        //   definition: workflow_chain,
        //   timeout: Duration.hours(4),
        // });
        this.endStates = [sqsTokenBucketTask];
        this.startState = sqsTokenBucketTask;
    }
}
exports.StepFunctionsTPSTokenBucket = StepFunctionsTPSTokenBucket;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsTPSTokenBucket[_a] = { fqn: "schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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