# coding: utf-8
# Copyright 2023 OpenSPG Authors
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
# in compliance with the License. You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under the License
# is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
# or implied.


"""
    knext

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from knext.common.rest.configuration import Configuration


class EdgeRecord(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "record_type": "str",
        "edge_type": "EdgeTypeName",
        "src_id": "str",
        "dst_id": "str",
        "properties": "list[LpgPropertyRecord]",
    }

    attribute_map = {
        "record_type": "recordType",
        "edge_type": "edgeType",
        "src_id": "srcId",
        "dst_id": "dstId",
        "properties": "properties",
    }

    def __init__(
        self,
        record_type=None,
        edge_type=None,
        src_id=None,
        dst_id=None,
        properties=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """EdgeRecord - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._record_type = None
        self._edge_type = None
        self._src_id = None
        self._dst_id = None
        self._properties = None
        self.discriminator = None

        if record_type is not None:
            self.record_type = record_type
        if edge_type is not None:
            self.edge_type = edge_type
        if src_id is not None:
            self.src_id = src_id
        if dst_id is not None:
            self.dst_id = dst_id
        if properties is not None:
            self.properties = properties

    @property
    def record_type(self):
        """Gets the record_type of this EdgeRecord.  # noqa: E501


        :return: The record_type of this EdgeRecord.  # noqa: E501
        :rtype: str
        """
        return self._record_type

    @record_type.setter
    def record_type(self, record_type):
        """Sets the record_type of this EdgeRecord.


        :param record_type: The record_type of this EdgeRecord.  # noqa: E501
        :type: str
        """

        self._record_type = record_type

    @property
    def edge_type(self):
        """Gets the edge_type of this EdgeRecord.  # noqa: E501


        :return: The edge_type of this EdgeRecord.  # noqa: E501
        :rtype: EdgeTypeName
        """
        return self._edge_type

    @edge_type.setter
    def edge_type(self, edge_type):
        """Sets the edge_type of this EdgeRecord.


        :param edge_type: The edge_type of this EdgeRecord.  # noqa: E501
        :type: EdgeTypeName
        """

        self._edge_type = edge_type

    @property
    def src_id(self):
        """Gets the src_id of this EdgeRecord.  # noqa: E501


        :return: The src_id of this EdgeRecord.  # noqa: E501
        :rtype: str
        """
        return self._src_id

    @src_id.setter
    def src_id(self, src_id):
        """Sets the src_id of this EdgeRecord.


        :param src_id: The src_id of this EdgeRecord.  # noqa: E501
        :type: str
        """

        self._src_id = src_id

    @property
    def dst_id(self):
        """Gets the dst_id of this EdgeRecord.  # noqa: E501


        :return: The dst_id of this EdgeRecord.  # noqa: E501
        :rtype: str
        """
        return self._dst_id

    @dst_id.setter
    def dst_id(self, dst_id):
        """Sets the dst_id of this EdgeRecord.


        :param dst_id: The dst_id of this EdgeRecord.  # noqa: E501
        :type: str
        """

        self._dst_id = dst_id

    @property
    def properties(self):
        """Gets the properties of this EdgeRecord.  # noqa: E501


        :return: The properties of this EdgeRecord.  # noqa: E501
        :rtype: list[LpgPropertyRecord]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this EdgeRecord.


        :param properties: The properties of this EdgeRecord.  # noqa: E501
        :type: list[LpgPropertyRecord]
        """

        self._properties = properties

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EdgeRecord):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EdgeRecord):
            return True

        return self.to_dict() != other.to_dict()
