# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper


class Category(object):

    """Implementation of the 'Category' model.

    A user can create a category and use the same during service creation
    request.

    Attributes:
        id (string): Auto-generated unique Id eg:
            58296746-57ee-44f8-8107-399b61d53967.
        category_name (string): Any string value which is described as a
            category name.
        category_description (string): Brief description about the category
            being created.
        is_verizon_certified (bool): Boolean value which implies if the
            category is verizon certified or not by default it is false.
        created_date (datetime): System captured creation date and time when
            tag is created.
        last_modified_date (datetime): System captured date and time when the
            tag was last modified.
        created_by (string): User information who created the tag.
        updated_by (string): Last user information who made changes to tag.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "category_name": 'categoryName',
        "id": 'id',
        "category_description": 'categoryDescription',
        "is_verizon_certified": 'isVerizonCertified',
        "created_date": 'createdDate',
        "last_modified_date": 'lastModifiedDate',
        "created_by": 'createdBy',
        "updated_by": 'updatedBy'
    }

    _optionals = [
        'id',
        'category_description',
        'is_verizon_certified',
        'created_date',
        'last_modified_date',
        'created_by',
        'updated_by',
    ]

    def __init__(self,
                 category_name=None,
                 id=APIHelper.SKIP,
                 category_description=APIHelper.SKIP,
                 is_verizon_certified=False,
                 created_date=APIHelper.SKIP,
                 last_modified_date=APIHelper.SKIP,
                 created_by=APIHelper.SKIP,
                 updated_by=APIHelper.SKIP):
        """Constructor for the Category class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        self.category_name = category_name 
        if category_description is not APIHelper.SKIP:
            self.category_description = category_description 
        self.is_verizon_certified = is_verizon_certified 
        if created_date is not APIHelper.SKIP:
            self.created_date = APIHelper.RFC3339DateTime(created_date) if created_date else None 
        if last_modified_date is not APIHelper.SKIP:
            self.last_modified_date = APIHelper.RFC3339DateTime(last_modified_date) if last_modified_date else None 
        if created_by is not APIHelper.SKIP:
            self.created_by = created_by 
        if updated_by is not APIHelper.SKIP:
            self.updated_by = updated_by 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        category_name = dictionary.get("categoryName") if dictionary.get("categoryName") else None
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        category_description = dictionary.get("categoryDescription") if dictionary.get("categoryDescription") else APIHelper.SKIP
        is_verizon_certified = dictionary.get("isVerizonCertified") if dictionary.get("isVerizonCertified") else False
        created_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdDate")).datetime if dictionary.get("createdDate") else APIHelper.SKIP
        last_modified_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("lastModifiedDate")).datetime if dictionary.get("lastModifiedDate") else APIHelper.SKIP
        created_by = dictionary.get("createdBy") if dictionary.get("createdBy") else APIHelper.SKIP
        updated_by = dictionary.get("updatedBy") if dictionary.get("updatedBy") else APIHelper.SKIP
        # Return an object of this model
        return cls(category_name,
                   id,
                   category_description,
                   is_verizon_certified,
                   created_date,
                   last_modified_date,
                   created_by,
                   updated_by)
