# Generated by Django 3.1.3 on 2021-01-16 18:27

from django.db import migrations, models
import django.db.models.deletion
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.documents.blocks
import wagtail.images.blocks


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0059_apply_collection_ordering'),
    ]

    operations = [
        migrations.CreateModel(
            name='OpeningHours',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('weekday', models.IntegerField(choices=[(0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')])),
                ('from_hour', models.TimeField(blank=True, null=True)),
                ('to_hour', models.TimeField(blank=True, null=True)),
            ],
            options={
                'ordering': ('weekday', 'from_hour'),
                'unique_together': {('weekday', 'from_hour', 'to_hour')},
            },
        ),
        migrations.CreateModel(
            name='CompanyInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('company_settings', wagtail.core.fields.StreamField([('company_settings', wagtail.core.blocks.StructBlock([('company_svg_logo', wagtail.documents.blocks.DocumentChooserBlock(required=False)), ('company_jpg_logo', wagtail.images.blocks.ImageChooserBlock(required=False)), ('company_name', wagtail.core.blocks.CharBlock(help_text='Company name', required=False)), ('company_description', wagtail.core.blocks.CharBlock(help_text='Company Description', required=False)), ('cuisine', wagtail.core.blocks.CharBlock(help_text='Cuisine (eg.türkisches,französische)', required=False)), ('reservations', wagtail.core.blocks.BooleanBlock(help_text='Reservations', required=False)), ('currencies_accepted', wagtail.core.blocks.CharBlock(help_text='Currencies Accepted (eg.EUR,USD)', required=False)), ('payment_accepted', wagtail.core.blocks.CharBlock(help_text='Payment Accepted (eg.Cash, Visa, Master Card)', required=False)), ('price_range', wagtail.core.blocks.CharBlock(help_text='Price Range (eg.€2 - €15)', required=False))]))], blank=True, null=True)),
                ('company_sales', wagtail.core.fields.StreamField([('company_sales', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(help_text='Title For channel (eg.Lieferando)', required=False)), ('slug', wagtail.core.blocks.CharBlock(help_text='Slug For channel (eg.lieferando)', required=False)), ('url', wagtail.core.blocks.URLBlock(help_text='Sale Channel URL', required=False))]))], blank=True, null=True)),
                ('company_contact', wagtail.core.fields.StreamField([('company_contact', wagtail.core.blocks.StructBlock([('phone', wagtail.core.blocks.CharBlock(help_text='Company phone number (eg.+49-000-000-0000)', required=False)), ('phone_short', wagtail.core.blocks.CharBlock(help_text='Company short phone number (eg.000-0000)', required=False)), ('phone_call', wagtail.core.blocks.CharBlock(help_text='Company short phone number (eg.0000000)', required=False)), ('fax', wagtail.core.blocks.CharBlock(help_text='Company fax number', required=False)), ('email', wagtail.core.blocks.CharBlock(help_text='Company email address', required=False))]))], blank=True, null=True)),
                ('company_address', wagtail.core.fields.StreamField([('company_address', wagtail.core.blocks.StructBlock([('country_code', wagtail.core.blocks.CharBlock(help_text='Country Code (eg.DE)', required=False)), ('city', wagtail.core.blocks.CharBlock(help_text='City', required=False)), ('region', wagtail.core.blocks.CharBlock(help_text='Region', required=False)), ('post_code', wagtail.core.blocks.CharBlock(help_text='Post Code', required=False)), ('street', wagtail.core.blocks.CharBlock(help_text='Street / Number', required=False))]))], blank=True, null=True)),
                ('company_google_map', wagtail.core.fields.StreamField([('company_google_map', wagtail.core.blocks.StructBlock([('latitude', wagtail.core.blocks.CharBlock(help_text='Address Latitude', required=False)), ('longitude', wagtail.core.blocks.CharBlock(help_text='Address Longitude', required=False))]))], blank=True, null=True)),
                ('company_social_media', wagtail.core.fields.StreamField([('company_social_media', wagtail.core.blocks.StructBlock([('tripadvisor', wagtail.core.blocks.URLBlock(help_text='Tripadvisor Url', required=False)), ('lieferando', wagtail.core.blocks.URLBlock(help_text='Lieferando Url', required=False)), ('facebook', wagtail.core.blocks.URLBlock(help_text='Facebook Url', required=False)), ('instagram', wagtail.core.blocks.URLBlock(help_text='Instagram Url', required=False)), ('youtube', wagtail.core.blocks.URLBlock(help_text='Youtube Url', required=False)), ('twitter', wagtail.core.blocks.URLBlock(help_text='Twitter Url', required=False))]))], blank=True, null=True)),
                ('company_promote', wagtail.core.fields.StreamField([('company_promote', wagtail.core.blocks.StructBlock([('promote', wagtail.core.blocks.RawHTMLBlock(help_text='Promote Text', required=False))]))], blank=True, null=True)),
                ('company_photos', wagtail.core.fields.StreamField([('company_photos', wagtail.core.blocks.StructBlock([('company_photos', wagtail.images.blocks.ImageChooserBlock(required=False))]))], blank=True, null=True)),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
