# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoSnmpFeatureTemplateResult',
    'AwaitableGetCiscoSnmpFeatureTemplateResult',
    'get_cisco_snmp_feature_template',
    'get_cisco_snmp_feature_template_output',
]

@pulumi.output_type
class GetCiscoSnmpFeatureTemplateResult:
    """
    A collection of values returned by getCiscoSnmpFeatureTemplate.
    """
    def __init__(__self__, communities=None, contact=None, contact_variable=None, description=None, device_types=None, groups=None, id=None, location=None, location_variable=None, name=None, shutdown=None, shutdown_variable=None, template_type=None, trap_targets=None, users=None, version=None, views=None):
        if communities and not isinstance(communities, list):
            raise TypeError("Expected argument 'communities' to be a list")
        pulumi.set(__self__, "communities", communities)
        if contact and not isinstance(contact, str):
            raise TypeError("Expected argument 'contact' to be a str")
        pulumi.set(__self__, "contact", contact)
        if contact_variable and not isinstance(contact_variable, str):
            raise TypeError("Expected argument 'contact_variable' to be a str")
        pulumi.set(__self__, "contact_variable", contact_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if location_variable and not isinstance(location_variable, str):
            raise TypeError("Expected argument 'location_variable' to be a str")
        pulumi.set(__self__, "location_variable", location_variable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if shutdown and not isinstance(shutdown, bool):
            raise TypeError("Expected argument 'shutdown' to be a bool")
        pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable and not isinstance(shutdown_variable, str):
            raise TypeError("Expected argument 'shutdown_variable' to be a str")
        pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if trap_targets and not isinstance(trap_targets, list):
            raise TypeError("Expected argument 'trap_targets' to be a list")
        pulumi.set(__self__, "trap_targets", trap_targets)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)
        if views and not isinstance(views, list):
            raise TypeError("Expected argument 'views' to be a list")
        pulumi.set(__self__, "views", views)

    @property
    @pulumi.getter
    def communities(self) -> Sequence['outputs.GetCiscoSnmpFeatureTemplateCommunityResult']:
        """
        Configure SNMP community
        """
        return pulumi.get(self, "communities")

    @property
    @pulumi.getter
    def contact(self) -> str:
        """
        Set the contact for this managed node
        """
        return pulumi.get(self, "contact")

    @property
    @pulumi.getter(name="contactVariable")
    def contact_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "contact_variable")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetCiscoSnmpFeatureTemplateGroupResult']:
        """
        Configure an SNMP group
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Set the physical location of this managed node
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationVariable")
    def location_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "location_variable")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def shutdown(self) -> bool:
        """
        Enable or disable SNMP
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="trapTargets")
    def trap_targets(self) -> Sequence['outputs.GetCiscoSnmpFeatureTemplateTrapTargetResult']:
        """
        Configure SNMP server to receive SNMP traps
        """
        return pulumi.get(self, "trap_targets")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetCiscoSnmpFeatureTemplateUserResult']:
        """
        Configure an SNMP user
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def views(self) -> Sequence['outputs.GetCiscoSnmpFeatureTemplateViewResult']:
        """
        Configure a view record
        """
        return pulumi.get(self, "views")


class AwaitableGetCiscoSnmpFeatureTemplateResult(GetCiscoSnmpFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoSnmpFeatureTemplateResult(
            communities=self.communities,
            contact=self.contact,
            contact_variable=self.contact_variable,
            description=self.description,
            device_types=self.device_types,
            groups=self.groups,
            id=self.id,
            location=self.location,
            location_variable=self.location_variable,
            name=self.name,
            shutdown=self.shutdown,
            shutdown_variable=self.shutdown_variable,
            template_type=self.template_type,
            trap_targets=self.trap_targets,
            users=self.users,
            version=self.version,
            views=self.views)


def get_cisco_snmp_feature_template(id: Optional[str] = None,
                                    name: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoSnmpFeatureTemplateResult:
    """
    This data source can read the Cisco SNMP feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_snmp_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoSnmpFeatureTemplate:getCiscoSnmpFeatureTemplate', __args__, opts=opts, typ=GetCiscoSnmpFeatureTemplateResult).value

    return AwaitableGetCiscoSnmpFeatureTemplateResult(
        communities=pulumi.get(__ret__, 'communities'),
        contact=pulumi.get(__ret__, 'contact'),
        contact_variable=pulumi.get(__ret__, 'contact_variable'),
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        location_variable=pulumi.get(__ret__, 'location_variable'),
        name=pulumi.get(__ret__, 'name'),
        shutdown=pulumi.get(__ret__, 'shutdown'),
        shutdown_variable=pulumi.get(__ret__, 'shutdown_variable'),
        template_type=pulumi.get(__ret__, 'template_type'),
        trap_targets=pulumi.get(__ret__, 'trap_targets'),
        users=pulumi.get(__ret__, 'users'),
        version=pulumi.get(__ret__, 'version'),
        views=pulumi.get(__ret__, 'views'))
def get_cisco_snmp_feature_template_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                           name: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCiscoSnmpFeatureTemplateResult]:
    """
    This data source can read the Cisco SNMP feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_snmp_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getCiscoSnmpFeatureTemplate:getCiscoSnmpFeatureTemplate', __args__, opts=opts, typ=GetCiscoSnmpFeatureTemplateResult)
    return __ret__.apply(lambda __response__: GetCiscoSnmpFeatureTemplateResult(
        communities=pulumi.get(__response__, 'communities'),
        contact=pulumi.get(__response__, 'contact'),
        contact_variable=pulumi.get(__response__, 'contact_variable'),
        description=pulumi.get(__response__, 'description'),
        device_types=pulumi.get(__response__, 'device_types'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        location_variable=pulumi.get(__response__, 'location_variable'),
        name=pulumi.get(__response__, 'name'),
        shutdown=pulumi.get(__response__, 'shutdown'),
        shutdown_variable=pulumi.get(__response__, 'shutdown_variable'),
        template_type=pulumi.get(__response__, 'template_type'),
        trap_targets=pulumi.get(__response__, 'trap_targets'),
        users=pulumi.get(__response__, 'users'),
        version=pulumi.get(__response__, 'version'),
        views=pulumi.get(__response__, 'views')))
