"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToElasticachememcached = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("../../core");
const constructs_1 = require("constructs");
const core_1 = require("../../core");
const defaultEnvironmentVariableName = "CACHE_ENDPOINT";
/**
 * @summary The LambdaToElasticachememcached class.
 */
class LambdaToElasticachememcached extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToElasticachememcached class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToElasticachememcachedProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        if ((props.existingCache || props.existingLambdaObj) && (!props.existingVpc)) {
            throw Error('If providing an existing Cache or Lambda Function, you must also supply the associated existingVpc');
        }
        if (props.cacheProps &&
            props.cacheProps.engine &&
            props.cacheProps.engine !== "memcached") {
            throw Error("This construct can only launch memcached clusters");
        }
        if (props.cacheProps && props.existingCache) {
            throw Error("Cannot specify existingCache and cacheProps");
        }
        const cachePort = (0, core_1.getCachePort)(props.cacheProps, props.existingCache);
        this.vpc = defaults.buildVpc(scope, {
            defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
            existingVpc: props.existingVpc,
            userVpcProps: props.vpcProps,
        });
        const lambdaToCacheSecurityGroup = (0, core_1.CreateSelfReferencingSecurityGroup)(this, id, this.vpc, cachePort);
        this.cache = (0, core_1.obtainMemcachedCluster)(this, id, {
            cacheSecurityGroupId: lambdaToCacheSecurityGroup.securityGroupId,
            cacheProps: props.cacheProps,
            existingCache: props.existingCache,
            vpc: this.vpc,
            cachePort,
        });
        // Add the self-referencing security group to the Lambda function props
        const lambdaFunctionProps = defaults.consolidateProps({}, props.lambdaFunctionProps, { securityGroups: [lambdaToCacheSecurityGroup] }, true);
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps,
            vpc: this.vpc,
        });
        AddLambdaEnvironmentVariable(this.lambdaFunction, `${this.cache.attrConfigurationEndpointAddress}:${this.cache.attrConfigurationEndpointPort}`, defaultEnvironmentVariableName, props.cacheEndpointEnvironmentVariableName);
    }
}
exports.LambdaToElasticachememcached = LambdaToElasticachememcached;
_a = JSII_RTTI_SYMBOL_1;
LambdaToElasticachememcached[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-elasticachememcached.LambdaToElasticachememcached", version: "2.97.0" };
function AddLambdaEnvironmentVariable(targetFunction, value, defaultName, clientName) {
    const variableName = clientName || defaultName;
    targetFunction.addEnvironment(variableName, value);
}
//# sourceMappingURL=data:application/json;base64,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