"""initial_database_schema

Revision ID: c4c46d14ca6a
Revises: None
Create Date: 2023-03-06 09:14:50.901521

"""
import alembic
import sqlalchemy as sa  # type: ignore

# revision identifiers, used by Alembic.
revision = 'c4c46d14ca6a'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    alembic.op.create_table('blockchains',
                            sa.Column('id', sa.Integer(), nullable=False),
                            sa.Column('name', sa.Text(), nullable=False),
                            sa.PrimaryKeyConstraint('id'))
    alembic.op.create_table('transfer_status',
                            sa.Column('id', sa.Integer(), nullable=False),
                            sa.Column('name', sa.Text(), nullable=False),
                            sa.PrimaryKeyConstraint('id'))
    alembic.op.create_table(
        'forwarder_contracts', sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('blockchain_id', sa.Integer(), nullable=False),
        sa.Column('address', sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ['blockchain_id'],
            ['blockchains.id'],
        ), sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('blockchain_id', 'address'))
    alembic.op.create_table(
        'hub_contracts', sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('blockchain_id', sa.Integer(), nullable=False),
        sa.Column('address', sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ['blockchain_id'],
            ['blockchains.id'],
        ), sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('blockchain_id', 'address'))
    alembic.op.create_table(
        'token_contracts', sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('blockchain_id', sa.Integer(), nullable=False),
        sa.Column('address', sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ['blockchain_id'],
            ['blockchains.id'],
        ), sa.PrimaryKeyConstraint('id'))
    alembic.op.create_index('ux_token_contracts_blockchain_id_address',
                            'token_contracts', ['blockchain_id', 'address'],
                            unique=True)
    alembic.op.create_table(
        'bids', sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('hub_contract_id', sa.Integer(), nullable=False),
        sa.Column('on_chain_bid_id', sa.BigInteger(), nullable=False),
        sa.Column('destination_blockchain_id', sa.Integer(), nullable=False),
        sa.Column('execution_time', sa.Integer(), nullable=False),
        sa.Column('fee', sa.Numeric(precision=78, scale=0), nullable=False),
        sa.Column('registered', sa.DateTime(), nullable=False),
        sa.Column('unregistered', sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ['destination_blockchain_id'],
            ['blockchains.id'],
        ), sa.ForeignKeyConstraint(
            ['hub_contract_id'],
            ['hub_contracts.id'],
        ), sa.PrimaryKeyConstraint('id'))
    alembic.op.create_index('ux_bids_hub_contract_id_on_chain_bid_id', 'bids',
                            ['hub_contract_id', 'on_chain_bid_id'],
                            unique=True)
    alembic.op.create_table(
        'transfers', sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('source_blockchain_id', sa.Integer(), nullable=False),
        sa.Column('destination_blockchain_id', sa.Integer(), nullable=False),
        sa.Column('sender_address', sa.Text(), nullable=False),
        sa.Column('recipient_address', sa.Text(), nullable=False),
        sa.Column('source_token_contract_id', sa.Integer(), nullable=False),
        sa.Column('destination_token_contract_id', sa.Integer(),
                  nullable=False),
        sa.Column('amount', sa.Numeric(precision=78, scale=0), nullable=False),
        sa.Column('bid_id', sa.Integer(), nullable=False),
        sa.Column('sender_nonce', sa.Numeric(precision=78, scale=0),
                  nullable=True),
        sa.Column('signature', sa.Text(), nullable=False),
        sa.Column('hub_contract_id', sa.Integer(), nullable=False),
        sa.Column('forwarder_contract_id', sa.Integer(), nullable=False),
        sa.Column('task_id', sa.Text(), nullable=True),
        sa.Column('on_chain_transfer_id', sa.Numeric(precision=78, scale=0),
                  nullable=True),
        sa.Column('transaction_id', sa.Text(), nullable=True),
        sa.Column('nonce', sa.BigInteger(), nullable=True),
        sa.Column('status_id', sa.Integer(), nullable=False),
        sa.Column('created', sa.DateTime(), nullable=False),
        sa.Column('updated', sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ['bid_id'],
            ['bids.id'],
        ),
        sa.ForeignKeyConstraint(
            ['destination_blockchain_id'],
            ['blockchains.id'],
        ),
        sa.ForeignKeyConstraint(
            ['destination_token_contract_id'],
            ['token_contracts.id'],
        ),
        sa.ForeignKeyConstraint(
            ['forwarder_contract_id'],
            ['forwarder_contracts.id'],
        ), sa.ForeignKeyConstraint(
            ['hub_contract_id'],
            ['hub_contracts.id'],
        ),
        sa.ForeignKeyConstraint(
            ['source_blockchain_id'],
            ['blockchains.id'],
        ),
        sa.ForeignKeyConstraint(
            ['source_token_contract_id'],
            ['token_contracts.id'],
        ), sa.ForeignKeyConstraint(
            ['status_id'],
            ['transfer_status.id'],
        ), sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('forwarder_contract_id', 'sender_address',
                            'sender_nonce', name='unique_sender_nonce'),
        sa.UniqueConstraint('hub_contract_id', 'on_chain_transfer_id'),
        sa.UniqueConstraint('source_blockchain_id', 'transaction_id'),
        sa.UniqueConstraint('task_id'))
    alembic.op.create_index(
        'ux_transfers_source_blockchain_id_nonce_status_id', 'transfers',
        ['source_blockchain_id',
         sa.text('nonce DESC'), 'status_id'], unique=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    alembic.op.drop_index('ux_transfers_source_blockchain_id_nonce_status_id',
                          table_name='transfers')
    alembic.op.drop_table('transfers')
    alembic.op.drop_index('ux_bids_hub_contract_id_on_chain_bid_id',
                          table_name='bids')
    alembic.op.drop_table('bids')
    alembic.op.drop_index('ux_token_contracts_blockchain_id_address',
                          table_name='token_contracts')
    alembic.op.drop_table('token_contracts')
    alembic.op.drop_table('hub_contracts')
    alembic.op.drop_table('forwarder_contracts')
    alembic.op.drop_table('transfer_status')
    alembic.op.drop_table('blockchains')
    # ### end Alembic commands ###
