import unittest
from crime_classifier import CrimeClassifier
 
class TestClassifier(unittest.TestCase):
        
    def test_sum(self):
        classifier = CrimeClassifier()
        test_sentences_positive = ["na mujer de 39 años murió en las últimas horas en un hospital de Santa Fe luego de agonizar desde el 11 de marzo, cuando su hijo la roció con nafta y la prendió fuego, en la localidad de Bella Italia, lindante con Rafaela, informaron hoy fuentes policiales. Los voceros identificaron a la víctima como Romina Esther Leiva (39), en tanto el acusado del ataque es su hijo Miguel Ángel Beresvilj (25), quien está detenido a la espera del juicio. Leiva murió mientras era asistida en la sala de terapia intensiva del hospital José María Cullen de la capital santafesina, luego de sufrir graves quemaduras en el 80 por ciento de su cuerpo que le afectaron el rostro, tórax, brazos y la pierna izquierda. La mujer resultó quemada en el marco de un violento episodio en su casa, situada en calle Córdoba al 100, de Bella Italia, localidad ubicada unos 95 kilómetros al oeste de la ciudad de Santa Fe. Luego del ataque, Beresvilj escapó en su motocicleta y horas después fue atrapado por la policía en la localidad de Frontera, en el límite con la provincia de Córdoba. En el domicilio donde ocurrió la agresión la Policía de Investigaciones secuestró dos bidones de cinco litros con restos de nafta. La versión del muchacho ante la Justicia es que su intención era quemar el automóvil de la pareja de su madre, con quien mantenía una mala relación, y que su madre se interpuso y resultó quemada por accidente. La fiscal de la Unidad de Violencia de Género, Familiar y Sexual del Ministerio Público de la Acusación (MPA), Ángela Capitanio, imputó a Beresvilj por el delito de ?homicidio agravado por el vínculo y por mediar violencia de género, en grado de tentativa, aunque ahora cambiará de figura penal ante la muerte de la mujer. El acusado se encuentra detenido con prisión preventiva sin plazos por orden del juez Osvaldo Carlos. Voceros judiciales indicaron que en la audiencia donde se fijó la prisión preventiva, el acusado dijo que jamás tuvo la intención de lastimar a su madre y que solo quería arruinarle el auto a (Roberto) Mansilla, el esposo de Leiva. Romina Leiva tenía, además de Beresvilj, cuatro hijos, dos mellizos de 13 años y otros dos de 9, producto de una relación anterior.",
        "Gregory McMichael, de 64 años, y su hijo Travis, de 34, han sido detenidos y acusados este jueves por el asesinato a Ahmaud Arbery, un afroamericano de 25 años, quien murió abatido a tiros por los dos hombres blancos mientras corría por las calles de Satilla Shores, en Georgia. Arbery iba desarmado y, como se puede escuchar en un brutal vídeo difundido este martes, recibió tres disparos hasta derrumbarse en el suelo a plena luz del día. A más de dos meses del suceso, ocurrido el 23 de febrero, nadie había sido detenido, pero las imágenes publicadas esta semana aumentaron la indignación en la comunidad, quienes presionaron, con la ayuda de políticos y celebridades, para que se hiciera justicia cuanto antes. El exoficial de policía en el condado de Glynn, Gregory McMichael, vio pasar por delante de su casa a Arbery corriendo, una actividad deportiva que solía hacer según los vecinos. Pensó que se trataba de un ladrón que había estado circulando por su barrio y llamó a su hijo Travis para ir en su búsqueda. El padre cogió una pistola .357 Magnum, el hijo agarró una escopeta, y ambos se subieron a una camioneta para ir tras el sospechoso. Según documentos policiales citados por The New York Times, McMichael declaró haberle pedido a Arbery que se detuviera para hablar, pero este no les hizo caso. Cuando lo volvieron a interceptar, Travis se bajó del coche con su arma y el fallecido lo “atacó violentamente”. En el vídeo, grabado por una persona no identificada, los hombres comenzaron un forcejeo para hacerse con la escopeta. Durante esa disputa se escuchan dos disparos. Luego un tercero. Arbery intenta salir corriendo, pero se desvanece. Murió antes de que la policía llegara al sitio. La Oficina de Investigación de Georgia anunció esta noche las detenciones, un día después de que comenzara su propia investigación ha pedido de un fiscal externo. La agencia informó en un comunicado de prensa que los McMichael habían sido encarcelados por cargos de asesinato y asalto agravado. El fiscal del Circuito Judicial del Atlántico de Georgia, Tom Durden, había anunciado este martes que traspasaría el caso a un gran jurado del condado de Glynn, en el mismo Estado, para que ellos decidieran si presentar cargos penales. Debido a la pandemia del coronavirus, la Corte Suprema de Georgia ha prohibido que los grandes jurados se reúnan hasta el 12 de junio, por lo que la decisión implicaba que padre e hijo quedaran libres hasta entonces. En un comunicado, S. Lee Merritt, la abogada de la familia de Arbery, afirmó que el vídeo revela que los hombres que persiguieron al joven cometieron un delito. “Esto es asesinato. La serie de eventos capturados en el vídeo confirma lo que indicaba toda la evidencia antes de que se publicara”. El caso recibió atención nacional con la difusión del vídeo y muchos políticos y famosos, entre ellos el presunto candidato presidencial demócrata, Joe Biden, y la animadora Ellen DeGeneres alzaron la voz para que las autoridades del Estado actuaran a la brevedad. También empujó a una multitud de manifestantes a la calle donde Arbery fue asesinado. “Vi a mi hijo venir al mundo”, afirmó a los periodistas su madre, Wanda Cooper Jones, y agregó, “verlo salir del mundo es algo que jamás voy a querer ver”. El gobernador republicano Brian Kemp apoyó este martes la investigación en su cuenta de Twitter: “Los georgianos merecen respuestas. La policía estatal está lista para garantizar que se haga justicia”. Por su parte, Biden escribió: “El video es claro: Ahmaud Arbery fue asesinado a sangre fría”, y pidió que se hiciera justicia ya por este “asesinato”. El fiscal Durden es el tercero en llevar el caso. La primera fiscal se recusó porque había trabajado con McMichael. El segundo, George E. Barnhill, también se apartó por un posible conflicto de interés. Antes de hacerse a un lado, informó a la policía de que consideraba que no había una causa suficiente para arrestar al padre e hijo, ya que habían actuado legalmente bajo el concepto de “arresto ciudadano”, contemplado en la legislación estatal, y cumpliendo los estatutos de defensa personal, de acuerdo con documentos obtenidos por The New York Times. “A McMichael se le permitió usar la fuerza letal para protegerse”, reza el escrito. La ley de Georgia dicta que una “persona privada puede arrestar a un delincuente si el delito se comete en su presencia o dentro de su conocimiento inmediato. Si el delito es un delito grave y el delincuente escapa o intenta escapar, una persona privada puede arrestarlo por motivos razonables y probables de sospecha”. La carta del fiscal Barnhill, dirigida a la policía, también apuntaba que Arbery tenía un pasado criminal. Los registros judiciales citados por The New York Times indican que fue declarado culpable de robo en tiendas y de violar la libertad condicional en 2018.",
        "Los hechos ocurrieron minutos antes de las 13:00 horas de este domingo. A esa hora una compañera de piso de los implicados que había presenciado la agresión, telefoneó a la guardia urbana para alertar de la misma. Una patrulla acudió al lugar indicado y se entrevistó tanto con la denunciante como con el supuesto agresor y su víctima. Tras escuchar sus declaraciones y comprobar que la mujer presentaba varias marcas de lesiones, los agentes detuvieron al hombre, según ha informado la Policía Local. En Santurtzi, un hombre de 37 años ha sido detenido este lunes acusado de agredir a su expareja en un domicilio de esta localidad vizcaína, donde ambos conviven temporalmente durante el confinamiento por el COVID-19 para compartir el cuidado de sus hijos, según ha informado el Departamento vasco de Seguridad. Sobre las 03:00 horas de este lunes, la Ertzaintza ha recibido la llamada de una menor de edad que alertaba de que su padrastro había golpeado a su madre en una vivienda del barrio de Mamariga. Varios recursos policiales se han trasladado al lugar y han contactado con la víctima. La mujer, que se encontraba en un estado de gran nerviosismo, ha denunciado a los agentes que su expareja, con la que convive estos días de confinamiento para compartir el cuidado de sus hijos, le había tirado del pelo y agarrado del cuello. Según ha relatado la víctima, la agresión se había producido tras una discusión por el alto volumen de la televisión y la conversación a gritos que su expareja mantenía por teléfono. La mujer ha podido refugiarse en la habitación de sus hijos y uno de ellos ha realizado la llamada de socorro. Los ertzainas han procedido a la identificación y posterior arresto del presunto agresor acusado de un delito de violencia de género. Una vez trasladado a dependencias policiales, ha quedado en libertad con la obligación de comparecer ante la autoridad judicial en las próximas horas."]
        
        test_sentences_negative = ["IMPORTANTE: El restaurante cierra los días de partido o eventos.  El confort y la elegancia son uno de los dúos más apreciados por los sibaritas de todo el mundo. Pero Chamartín ha sabido convertirlo en un muy distinguido trío, puesto que suma la gastronomía asiática a esta lujosa ecuación.  Y es que Zen Market es mucho más que un restaurante, puesto que su calidad raya la perfección. No es casualidad que Ignacio García de Vinuesa y su equipo de profesionales le hayan dado forma a este rincón que también es deportista: se encuentra en una zona exclusiva del estadio Santiago Bernabéu.  Si pensabas que habías probado un pato lacado auténtico, desde eltenedor.es te pedimos que reserves una mesa y disfrutes de un auténtico pato lacado en caviar o quizás un bogavante salteado con sal y pimienta Sechuan. Si ya los probaste, reserva en cualquier caso y para cualquier ocasión. Zen Market es toda una experiencia. ¡No te lo puedes perder!",
        "España ha amanecido este martes con una buena noticia: La Organización Mundial de la Salud (OMS) ha comentado que nuestro país puede estar llegando al pico de incidencia de casos del nuevo coronavirus Covid-19. Sin embargo, no ha sido la única. Entre las tinieblas y la incertidumbre que ha pintado el Covid-19 esta primavera de 2020, cada jornada se conocen informaciones que animan a mantener la esperanza. Un paciente de coronavirus Un paciente de coronavirus 1. El Hospital Gregorio Marañón da el alta de la UCI a su paciente más joven, de 20 años. El Hospital Gregorio Marañón ha dado el alta de la UCI a su paciente de coronavirus más joven, un chico de 20 años que ha pasado a la planta de hospitalización, donde continuará con su recuperación del Covid-19. Según informaron fuentes del centro hospitalario, el Gregorio Marañón ha dado hoy más de 80 altas a pacientes que ya han regresado a su domicilio. El hospital madrileño es uno de los cinco españoles que participan en un ensayo clínico con «sarilumab» para pacientes hospitalizados con Covid-19 en estado grave o crítico con enfermos europeos. El Hospital Vall d'Hebron de Barcelona ha sido el primer centro activado en España y el Gregorio Marañón de Madrid el que ha incluido los primeros pacientes. También participan el Hospital La Paz y el Ramón y Cajal, ambos de Madrid y el Clinic de Barcelona. 2. El emotivo gesto de dos agentes de la Policía Nacional con una anciana por su cumpleaño. La crisis del coronavirus ha desatado un gran estado de alarma y nerviosismo entre la población. En estos tiempos difíciles, la solidaridad se abre paso y sale a la luz el lado más humano de la sociedad. Una muestra de ello es el emotivo gesto que se vivió la semana pasada en un municipio de Aragón. Un equipo de la Policía Nacional estaba realizando una patrulla peatonal por el centro de Jaca (Huesca), y Toñi, una anciana de un edificio cercano, al verlos, salió a aplaudirles. No fue la única. Varios vecinos, que también se asomaron a sus balcones, comentaron a los agentes que aquel día era el cumpleaños de la mujer. Decididos a hacer de aquella una jornada especial para ella, los dos miembros del cuerpo se acercaron a la comisaría para hacerse con una caja de dulces y regresaron al barrio de Toñi. Una vez allí, y sin pensárselo dos veces, Manuel Aldaz, jefe de la Policía Nacional en Jaca, se encaramó a su coche y entregó el presente a la anciana. Amancio Ortega ha hecho grandes esfuerzos para lugar contra el coronavirus Amancio Ortega ha hecho grandes esfuerzos para lugar contra el coronavirus 3. La Fundación Amancio Ortega compra material contra la pandemia de coronavirus por 63 millones de euros. Según ha informado la entidad a través de un comunicado, «las gestiones de compra continúan en marcha con el objetivo de seguir incrementando el volumen de material adquirido». Entre este material destaca, principalmente, la adquisición de 1.450 respiradores para las unidades de cuidados intensivos, tres millones de mascarillas filtrantes para el uso de personal sanitario, un millón de kits de detección del virus y otros equipamientos para centros sanitarios, como 450 camas hospitalarias.",
        "Recuerdo que antes decía, que en mí vivían sentimientos de agonía y tristeza, sentimientos que revivían con cada recuerdo que tenía, mi mente, un lugar abrumado, confundido, desolado y que pensaba que en ningún otro momento eso cambiaría, estaba tan lastimado no sólo por las personas, sino por la vida en general… De un momento a otro llega una pequeña casualidad, aquella que le daría un rumbo diferente a mi vida, que haría despertar aquel yo que se había ocultado por mucho tiempo, aquellos sentimientos que habían desaparecido, aquella pequeña casualidad, cobró mucha importancia, ya no sólo era una casualidad, era la razón de que yo no brincara al fondo de ese hoyo el cual me atraía cada vez más para hundirme dentro de el, era por quién en las mañanas ya no pensaba que todo era repetitivo, sino que todas las mañanas eran días nuevos, para poder vivir, poder disfrutar y sobre todo poder amar",
        "Agricultores afectados por el incendio de junio en la Ribera d'Ebre, Garrigues y Segrià consideran insuficiente el plan de choque anunciado este jueves por la 'consellera' de Agricultura, Teresa Jordà, que propuso ayudas directas por la limpieza de los bosques quemados y créditos blandos por los propietarios de fincas afectadas por el fuego, que arrasó más de 5.000 hectáreas. El presidente de Asaja y portavoz de agricultores afectados por el incendio de Ribera de Ebro, Pere Roqué, dice que los campesinos están desilusionados con la propuesta puesto que necesitan una primera ayuda directa para las explotaciones antes de plantearse un crédito blando. También Unió de Pagesos se ha sumado a la protesta y añaden que las ayudas no tienen en cuenta la pérdida de rentas que supondrán a medio plazo para los afectados, algunos de los cuales se plantean poder continuar con la actividad agrícola o ganadera. Los agricultores anuncian una nueva manifestación por domingo a las 18h en Flix y reclaman una reunión urgente con Jordà la semana que viene. Lamentan que se los emplace en septiembre y le recuerdan que los campesinos afectados no se van de vacaciones. La 'consellera' de Agricultura, Teresa Jordà, anunció una ayuda directa para limpiar los bosques de la madera quemada este agosto y una línea de créditos de 5 millones de euros, cuyos intereses irán a cargo del departamento. También anunció una inversión de 3,5 millones de euros para extender el riego de apoyo a toda la zona afectada por el incendio. Sobre las ayudas a fondo perdido, Jordà se emplazó a seguir hablando en septiembre, dependiendo también de los próximos presupuestos, a pesar de que se comprometió a estudiar caso por caso todas las demandas y necesidades. Los agricultores y ganaderos afectados por el incendio de la Ribera d'Ebre no  tienen bastante y reclaman ayudas directas para recuperar sus explotaciones. La medida del crédito puede ser interesante, siempre y cuando primero haya una ayuda directa para salir adelante, para aquellas explotaciones que los hagan falta más dinero además de la ayuda directa, explica Roqué."
        ]
        for text in test_sentences_positive:
            print(text)
            sentiment_result = classifier.crime_subject_probability(text)
            print(sentiment_result)
            print("--------")
            self.assertGreater(sentiment_result, 0.5, "Result should be possitive")
        
        for text in test_sentences_negative:
            print(text)
            sentiment_result = classifier.crime_subject_probability(text)
            print(sentiment_result)
            print("--------")
            self.assertLess(sentiment_result, 0.5, "Result should be negative")



if __name__ == '__main__':
    unittest.main()