# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoOspfFeatureTemplateArgs', 'CiscoOspfFeatureTemplate']

@pulumi.input_type
class CiscoOspfFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 areas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateAreaArgs']]]] = None,
                 auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate: Optional[pulumi.Input[bool]] = None,
                 default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 distance_external: Optional[pulumi.Input[int]] = None,
                 distance_external_variable: Optional[pulumi.Input[str]] = None,
                 distance_inter_area: Optional[pulumi.Input[int]] = None,
                 distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 distance_intra_area: Optional[pulumi.Input[int]] = None,
                 distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redistributes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRedistributeArgs']]]] = None,
                 route_policies: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRoutePolicyArgs']]]] = None,
                 router_id: Optional[pulumi.Input[str]] = None,
                 router_id_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CiscoOspfFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateAreaArgs']]] areas: Configure OSPF area
        :param pulumi.Input[int] auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] default_information_originate_metric_variable: Variable name
        :param pulumi.Input[int] distance_external: Set distance for external routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_external_variable: Variable name
        :param pulumi.Input[int] distance_inter_area: Set distance for inter-area routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_inter_area_variable: Variable name
        :param pulumi.Input[int] distance_intra_area: Set distance for intra-area routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_intra_area_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs']]] max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRedistributeArgs']]] redistributes: Redistribute routes
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRoutePolicyArgs']]] route_policies: Set route policy to apply
        :param pulumi.Input[str] router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] router_id_variable: Variable name
        :param pulumi.Input[int] timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        :param pulumi.Input[str] timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        :param pulumi.Input[str] timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        :param pulumi.Input[str] timers_spf_max_hold_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if areas is not None:
            pulumi.set(__self__, "areas", areas)
        if auto_cost_reference_bandwidth is not None:
            pulumi.set(__self__, "auto_cost_reference_bandwidth", auto_cost_reference_bandwidth)
        if auto_cost_reference_bandwidth_variable is not None:
            pulumi.set(__self__, "auto_cost_reference_bandwidth_variable", auto_cost_reference_bandwidth_variable)
        if compatible_rfc1583 is not None:
            pulumi.set(__self__, "compatible_rfc1583", compatible_rfc1583)
        if compatible_rfc1583_variable is not None:
            pulumi.set(__self__, "compatible_rfc1583_variable", compatible_rfc1583_variable)
        if default_information_originate is not None:
            pulumi.set(__self__, "default_information_originate", default_information_originate)
        if default_information_originate_always is not None:
            pulumi.set(__self__, "default_information_originate_always", default_information_originate_always)
        if default_information_originate_always_variable is not None:
            pulumi.set(__self__, "default_information_originate_always_variable", default_information_originate_always_variable)
        if default_information_originate_metric is not None:
            pulumi.set(__self__, "default_information_originate_metric", default_information_originate_metric)
        if default_information_originate_metric_type is not None:
            pulumi.set(__self__, "default_information_originate_metric_type", default_information_originate_metric_type)
        if default_information_originate_metric_type_variable is not None:
            pulumi.set(__self__, "default_information_originate_metric_type_variable", default_information_originate_metric_type_variable)
        if default_information_originate_metric_variable is not None:
            pulumi.set(__self__, "default_information_originate_metric_variable", default_information_originate_metric_variable)
        if distance_external is not None:
            pulumi.set(__self__, "distance_external", distance_external)
        if distance_external_variable is not None:
            pulumi.set(__self__, "distance_external_variable", distance_external_variable)
        if distance_inter_area is not None:
            pulumi.set(__self__, "distance_inter_area", distance_inter_area)
        if distance_inter_area_variable is not None:
            pulumi.set(__self__, "distance_inter_area_variable", distance_inter_area_variable)
        if distance_intra_area is not None:
            pulumi.set(__self__, "distance_intra_area", distance_intra_area)
        if distance_intra_area_variable is not None:
            pulumi.set(__self__, "distance_intra_area_variable", distance_intra_area_variable)
        if max_metric_router_lsas is not None:
            pulumi.set(__self__, "max_metric_router_lsas", max_metric_router_lsas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redistributes is not None:
            pulumi.set(__self__, "redistributes", redistributes)
        if route_policies is not None:
            pulumi.set(__self__, "route_policies", route_policies)
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if router_id_variable is not None:
            pulumi.set(__self__, "router_id_variable", router_id_variable)
        if timers_spf_delay is not None:
            pulumi.set(__self__, "timers_spf_delay", timers_spf_delay)
        if timers_spf_delay_variable is not None:
            pulumi.set(__self__, "timers_spf_delay_variable", timers_spf_delay_variable)
        if timers_spf_initial_hold is not None:
            pulumi.set(__self__, "timers_spf_initial_hold", timers_spf_initial_hold)
        if timers_spf_initial_hold_variable is not None:
            pulumi.set(__self__, "timers_spf_initial_hold_variable", timers_spf_initial_hold_variable)
        if timers_spf_max_hold is not None:
            pulumi.set(__self__, "timers_spf_max_hold", timers_spf_max_hold)
        if timers_spf_max_hold_variable is not None:
            pulumi.set(__self__, "timers_spf_max_hold_variable", timers_spf_max_hold_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def areas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateAreaArgs']]]]:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "areas")

    @areas.setter
    def areas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateAreaArgs']]]]):
        pulumi.set(self, "areas", value)

    @property
    @pulumi.getter(name="autoCostReferenceBandwidth")
    def auto_cost_reference_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        """
        return pulumi.get(self, "auto_cost_reference_bandwidth")

    @auto_cost_reference_bandwidth.setter
    def auto_cost_reference_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_cost_reference_bandwidth", value)

    @property
    @pulumi.getter(name="autoCostReferenceBandwidthVariable")
    def auto_cost_reference_bandwidth_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "auto_cost_reference_bandwidth_variable")

    @auto_cost_reference_bandwidth_variable.setter
    def auto_cost_reference_bandwidth_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_cost_reference_bandwidth_variable", value)

    @property
    @pulumi.getter(name="compatibleRfc1583")
    def compatible_rfc1583(self) -> Optional[pulumi.Input[bool]]:
        """
        Calculate summary route cost based on RFC 1583 - Default value: `true`
        """
        return pulumi.get(self, "compatible_rfc1583")

    @compatible_rfc1583.setter
    def compatible_rfc1583(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compatible_rfc1583", value)

    @property
    @pulumi.getter(name="compatibleRfc1583Variable")
    def compatible_rfc1583_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "compatible_rfc1583_variable")

    @compatible_rfc1583_variable.setter
    def compatible_rfc1583_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compatible_rfc1583_variable", value)

    @property
    @pulumi.getter(name="defaultInformationOriginate")
    def default_information_originate(self) -> Optional[pulumi.Input[bool]]:
        """
        Distribute default external route into OSPF - Default value: `false`
        """
        return pulumi.get(self, "default_information_originate")

    @default_information_originate.setter
    def default_information_originate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_information_originate", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateAlways")
    def default_information_originate_always(self) -> Optional[pulumi.Input[bool]]:
        """
        Always advertise default route - Default value: `false`
        """
        return pulumi.get(self, "default_information_originate_always")

    @default_information_originate_always.setter
    def default_information_originate_always(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_information_originate_always", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateAlwaysVariable")
    def default_information_originate_always_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_always_variable")

    @default_information_originate_always_variable.setter
    def default_information_originate_always_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_information_originate_always_variable", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateMetric")
    def default_information_originate_metric(self) -> Optional[pulumi.Input[int]]:
        """
        Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        """
        return pulumi.get(self, "default_information_originate_metric")

    @default_information_originate_metric.setter
    def default_information_originate_metric(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_information_originate_metric", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricType")
    def default_information_originate_metric_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set default route type - Choices: `type1`, `type2`
        """
        return pulumi.get(self, "default_information_originate_metric_type")

    @default_information_originate_metric_type.setter
    def default_information_originate_metric_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_information_originate_metric_type", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricTypeVariable")
    def default_information_originate_metric_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_type_variable")

    @default_information_originate_metric_type_variable.setter
    def default_information_originate_metric_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_information_originate_metric_type_variable", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricVariable")
    def default_information_originate_metric_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_variable")

    @default_information_originate_metric_variable.setter
    def default_information_originate_metric_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_information_originate_metric_variable", value)

    @property
    @pulumi.getter(name="distanceExternal")
    def distance_external(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for external routes - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "distance_external")

    @distance_external.setter
    def distance_external(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "distance_external", value)

    @property
    @pulumi.getter(name="distanceExternalVariable")
    def distance_external_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_external_variable")

    @distance_external_variable.setter
    def distance_external_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distance_external_variable", value)

    @property
    @pulumi.getter(name="distanceInterArea")
    def distance_inter_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for inter-area routes - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "distance_inter_area")

    @distance_inter_area.setter
    def distance_inter_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "distance_inter_area", value)

    @property
    @pulumi.getter(name="distanceInterAreaVariable")
    def distance_inter_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_inter_area_variable")

    @distance_inter_area_variable.setter
    def distance_inter_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distance_inter_area_variable", value)

    @property
    @pulumi.getter(name="distanceIntraArea")
    def distance_intra_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for intra-area routes - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "distance_intra_area")

    @distance_intra_area.setter
    def distance_intra_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "distance_intra_area", value)

    @property
    @pulumi.getter(name="distanceIntraAreaVariable")
    def distance_intra_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_intra_area_variable")

    @distance_intra_area_variable.setter
    def distance_intra_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distance_intra_area_variable", value)

    @property
    @pulumi.getter(name="maxMetricRouterLsas")
    def max_metric_router_lsas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs']]]]:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "max_metric_router_lsas")

    @max_metric_router_lsas.setter
    def max_metric_router_lsas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs']]]]):
        pulumi.set(self, "max_metric_router_lsas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def redistributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRedistributeArgs']]]]:
        """
        Redistribute routes
        """
        return pulumi.get(self, "redistributes")

    @redistributes.setter
    def redistributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRedistributeArgs']]]]):
        pulumi.set(self, "redistributes", value)

    @property
    @pulumi.getter(name="routePolicies")
    def route_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRoutePolicyArgs']]]]:
        """
        Set route policy to apply
        """
        return pulumi.get(self, "route_policies")

    @route_policies.setter
    def route_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRoutePolicyArgs']]]]):
        pulumi.set(self, "route_policies", value)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router_id", value)

    @property
    @pulumi.getter(name="routerIdVariable")
    def router_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "router_id_variable")

    @router_id_variable.setter
    def router_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router_id_variable", value)

    @property
    @pulumi.getter(name="timersSpfDelay")
    def timers_spf_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        """
        return pulumi.get(self, "timers_spf_delay")

    @timers_spf_delay.setter
    def timers_spf_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timers_spf_delay", value)

    @property
    @pulumi.getter(name="timersSpfDelayVariable")
    def timers_spf_delay_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_delay_variable")

    @timers_spf_delay_variable.setter
    def timers_spf_delay_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timers_spf_delay_variable", value)

    @property
    @pulumi.getter(name="timersSpfInitialHold")
    def timers_spf_initial_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        """
        return pulumi.get(self, "timers_spf_initial_hold")

    @timers_spf_initial_hold.setter
    def timers_spf_initial_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timers_spf_initial_hold", value)

    @property
    @pulumi.getter(name="timersSpfInitialHoldVariable")
    def timers_spf_initial_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_initial_hold_variable")

    @timers_spf_initial_hold_variable.setter
    def timers_spf_initial_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timers_spf_initial_hold_variable", value)

    @property
    @pulumi.getter(name="timersSpfMaxHold")
    def timers_spf_max_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        """
        return pulumi.get(self, "timers_spf_max_hold")

    @timers_spf_max_hold.setter
    def timers_spf_max_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timers_spf_max_hold", value)

    @property
    @pulumi.getter(name="timersSpfMaxHoldVariable")
    def timers_spf_max_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_max_hold_variable")

    @timers_spf_max_hold_variable.setter
    def timers_spf_max_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timers_spf_max_hold_variable", value)


@pulumi.input_type
class _CiscoOspfFeatureTemplateState:
    def __init__(__self__, *,
                 areas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateAreaArgs']]]] = None,
                 auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate: Optional[pulumi.Input[bool]] = None,
                 default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 distance_external: Optional[pulumi.Input[int]] = None,
                 distance_external_variable: Optional[pulumi.Input[str]] = None,
                 distance_inter_area: Optional[pulumi.Input[int]] = None,
                 distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 distance_intra_area: Optional[pulumi.Input[int]] = None,
                 distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redistributes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRedistributeArgs']]]] = None,
                 route_policies: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRoutePolicyArgs']]]] = None,
                 router_id: Optional[pulumi.Input[str]] = None,
                 router_id_variable: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CiscoOspfFeatureTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateAreaArgs']]] areas: Configure OSPF area
        :param pulumi.Input[int] auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] default_information_originate_metric_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[int] distance_external: Set distance for external routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_external_variable: Variable name
        :param pulumi.Input[int] distance_inter_area: Set distance for inter-area routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_inter_area_variable: Variable name
        :param pulumi.Input[int] distance_intra_area: Set distance for intra-area routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_intra_area_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs']]] max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRedistributeArgs']]] redistributes: Redistribute routes
        :param pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRoutePolicyArgs']]] route_policies: Set route policy to apply
        :param pulumi.Input[str] router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] router_id_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        :param pulumi.Input[str] timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        :param pulumi.Input[str] timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        :param pulumi.Input[str] timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        if areas is not None:
            pulumi.set(__self__, "areas", areas)
        if auto_cost_reference_bandwidth is not None:
            pulumi.set(__self__, "auto_cost_reference_bandwidth", auto_cost_reference_bandwidth)
        if auto_cost_reference_bandwidth_variable is not None:
            pulumi.set(__self__, "auto_cost_reference_bandwidth_variable", auto_cost_reference_bandwidth_variable)
        if compatible_rfc1583 is not None:
            pulumi.set(__self__, "compatible_rfc1583", compatible_rfc1583)
        if compatible_rfc1583_variable is not None:
            pulumi.set(__self__, "compatible_rfc1583_variable", compatible_rfc1583_variable)
        if default_information_originate is not None:
            pulumi.set(__self__, "default_information_originate", default_information_originate)
        if default_information_originate_always is not None:
            pulumi.set(__self__, "default_information_originate_always", default_information_originate_always)
        if default_information_originate_always_variable is not None:
            pulumi.set(__self__, "default_information_originate_always_variable", default_information_originate_always_variable)
        if default_information_originate_metric is not None:
            pulumi.set(__self__, "default_information_originate_metric", default_information_originate_metric)
        if default_information_originate_metric_type is not None:
            pulumi.set(__self__, "default_information_originate_metric_type", default_information_originate_metric_type)
        if default_information_originate_metric_type_variable is not None:
            pulumi.set(__self__, "default_information_originate_metric_type_variable", default_information_originate_metric_type_variable)
        if default_information_originate_metric_variable is not None:
            pulumi.set(__self__, "default_information_originate_metric_variable", default_information_originate_metric_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if distance_external is not None:
            pulumi.set(__self__, "distance_external", distance_external)
        if distance_external_variable is not None:
            pulumi.set(__self__, "distance_external_variable", distance_external_variable)
        if distance_inter_area is not None:
            pulumi.set(__self__, "distance_inter_area", distance_inter_area)
        if distance_inter_area_variable is not None:
            pulumi.set(__self__, "distance_inter_area_variable", distance_inter_area_variable)
        if distance_intra_area is not None:
            pulumi.set(__self__, "distance_intra_area", distance_intra_area)
        if distance_intra_area_variable is not None:
            pulumi.set(__self__, "distance_intra_area_variable", distance_intra_area_variable)
        if max_metric_router_lsas is not None:
            pulumi.set(__self__, "max_metric_router_lsas", max_metric_router_lsas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redistributes is not None:
            pulumi.set(__self__, "redistributes", redistributes)
        if route_policies is not None:
            pulumi.set(__self__, "route_policies", route_policies)
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if router_id_variable is not None:
            pulumi.set(__self__, "router_id_variable", router_id_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if timers_spf_delay is not None:
            pulumi.set(__self__, "timers_spf_delay", timers_spf_delay)
        if timers_spf_delay_variable is not None:
            pulumi.set(__self__, "timers_spf_delay_variable", timers_spf_delay_variable)
        if timers_spf_initial_hold is not None:
            pulumi.set(__self__, "timers_spf_initial_hold", timers_spf_initial_hold)
        if timers_spf_initial_hold_variable is not None:
            pulumi.set(__self__, "timers_spf_initial_hold_variable", timers_spf_initial_hold_variable)
        if timers_spf_max_hold is not None:
            pulumi.set(__self__, "timers_spf_max_hold", timers_spf_max_hold)
        if timers_spf_max_hold_variable is not None:
            pulumi.set(__self__, "timers_spf_max_hold_variable", timers_spf_max_hold_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def areas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateAreaArgs']]]]:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "areas")

    @areas.setter
    def areas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateAreaArgs']]]]):
        pulumi.set(self, "areas", value)

    @property
    @pulumi.getter(name="autoCostReferenceBandwidth")
    def auto_cost_reference_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        """
        return pulumi.get(self, "auto_cost_reference_bandwidth")

    @auto_cost_reference_bandwidth.setter
    def auto_cost_reference_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_cost_reference_bandwidth", value)

    @property
    @pulumi.getter(name="autoCostReferenceBandwidthVariable")
    def auto_cost_reference_bandwidth_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "auto_cost_reference_bandwidth_variable")

    @auto_cost_reference_bandwidth_variable.setter
    def auto_cost_reference_bandwidth_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_cost_reference_bandwidth_variable", value)

    @property
    @pulumi.getter(name="compatibleRfc1583")
    def compatible_rfc1583(self) -> Optional[pulumi.Input[bool]]:
        """
        Calculate summary route cost based on RFC 1583 - Default value: `true`
        """
        return pulumi.get(self, "compatible_rfc1583")

    @compatible_rfc1583.setter
    def compatible_rfc1583(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compatible_rfc1583", value)

    @property
    @pulumi.getter(name="compatibleRfc1583Variable")
    def compatible_rfc1583_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "compatible_rfc1583_variable")

    @compatible_rfc1583_variable.setter
    def compatible_rfc1583_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compatible_rfc1583_variable", value)

    @property
    @pulumi.getter(name="defaultInformationOriginate")
    def default_information_originate(self) -> Optional[pulumi.Input[bool]]:
        """
        Distribute default external route into OSPF - Default value: `false`
        """
        return pulumi.get(self, "default_information_originate")

    @default_information_originate.setter
    def default_information_originate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_information_originate", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateAlways")
    def default_information_originate_always(self) -> Optional[pulumi.Input[bool]]:
        """
        Always advertise default route - Default value: `false`
        """
        return pulumi.get(self, "default_information_originate_always")

    @default_information_originate_always.setter
    def default_information_originate_always(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_information_originate_always", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateAlwaysVariable")
    def default_information_originate_always_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_always_variable")

    @default_information_originate_always_variable.setter
    def default_information_originate_always_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_information_originate_always_variable", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateMetric")
    def default_information_originate_metric(self) -> Optional[pulumi.Input[int]]:
        """
        Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        """
        return pulumi.get(self, "default_information_originate_metric")

    @default_information_originate_metric.setter
    def default_information_originate_metric(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_information_originate_metric", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricType")
    def default_information_originate_metric_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set default route type - Choices: `type1`, `type2`
        """
        return pulumi.get(self, "default_information_originate_metric_type")

    @default_information_originate_metric_type.setter
    def default_information_originate_metric_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_information_originate_metric_type", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricTypeVariable")
    def default_information_originate_metric_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_type_variable")

    @default_information_originate_metric_type_variable.setter
    def default_information_originate_metric_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_information_originate_metric_type_variable", value)

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricVariable")
    def default_information_originate_metric_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_variable")

    @default_information_originate_metric_variable.setter
    def default_information_originate_metric_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_information_originate_metric_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="distanceExternal")
    def distance_external(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for external routes - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "distance_external")

    @distance_external.setter
    def distance_external(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "distance_external", value)

    @property
    @pulumi.getter(name="distanceExternalVariable")
    def distance_external_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_external_variable")

    @distance_external_variable.setter
    def distance_external_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distance_external_variable", value)

    @property
    @pulumi.getter(name="distanceInterArea")
    def distance_inter_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for inter-area routes - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "distance_inter_area")

    @distance_inter_area.setter
    def distance_inter_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "distance_inter_area", value)

    @property
    @pulumi.getter(name="distanceInterAreaVariable")
    def distance_inter_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_inter_area_variable")

    @distance_inter_area_variable.setter
    def distance_inter_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distance_inter_area_variable", value)

    @property
    @pulumi.getter(name="distanceIntraArea")
    def distance_intra_area(self) -> Optional[pulumi.Input[int]]:
        """
        Set distance for intra-area routes - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "distance_intra_area")

    @distance_intra_area.setter
    def distance_intra_area(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "distance_intra_area", value)

    @property
    @pulumi.getter(name="distanceIntraAreaVariable")
    def distance_intra_area_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_intra_area_variable")

    @distance_intra_area_variable.setter
    def distance_intra_area_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distance_intra_area_variable", value)

    @property
    @pulumi.getter(name="maxMetricRouterLsas")
    def max_metric_router_lsas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs']]]]:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "max_metric_router_lsas")

    @max_metric_router_lsas.setter
    def max_metric_router_lsas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs']]]]):
        pulumi.set(self, "max_metric_router_lsas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def redistributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRedistributeArgs']]]]:
        """
        Redistribute routes
        """
        return pulumi.get(self, "redistributes")

    @redistributes.setter
    def redistributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRedistributeArgs']]]]):
        pulumi.set(self, "redistributes", value)

    @property
    @pulumi.getter(name="routePolicies")
    def route_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRoutePolicyArgs']]]]:
        """
        Set route policy to apply
        """
        return pulumi.get(self, "route_policies")

    @route_policies.setter
    def route_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoOspfFeatureTemplateRoutePolicyArgs']]]]):
        pulumi.set(self, "route_policies", value)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router_id", value)

    @property
    @pulumi.getter(name="routerIdVariable")
    def router_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "router_id_variable")

    @router_id_variable.setter
    def router_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router_id_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="timersSpfDelay")
    def timers_spf_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        """
        return pulumi.get(self, "timers_spf_delay")

    @timers_spf_delay.setter
    def timers_spf_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timers_spf_delay", value)

    @property
    @pulumi.getter(name="timersSpfDelayVariable")
    def timers_spf_delay_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_delay_variable")

    @timers_spf_delay_variable.setter
    def timers_spf_delay_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timers_spf_delay_variable", value)

    @property
    @pulumi.getter(name="timersSpfInitialHold")
    def timers_spf_initial_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        """
        return pulumi.get(self, "timers_spf_initial_hold")

    @timers_spf_initial_hold.setter
    def timers_spf_initial_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timers_spf_initial_hold", value)

    @property
    @pulumi.getter(name="timersSpfInitialHoldVariable")
    def timers_spf_initial_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_initial_hold_variable")

    @timers_spf_initial_hold_variable.setter
    def timers_spf_initial_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timers_spf_initial_hold_variable", value)

    @property
    @pulumi.getter(name="timersSpfMaxHold")
    def timers_spf_max_hold(self) -> Optional[pulumi.Input[int]]:
        """
        Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        """
        return pulumi.get(self, "timers_spf_max_hold")

    @timers_spf_max_hold.setter
    def timers_spf_max_hold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timers_spf_max_hold", value)

    @property
    @pulumi.getter(name="timersSpfMaxHoldVariable")
    def timers_spf_max_hold_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_max_hold_variable")

    @timers_spf_max_hold_variable.setter
    def timers_spf_max_hold_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timers_spf_max_hold_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CiscoOspfFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateAreaArgs', 'CiscoOspfFeatureTemplateAreaArgsDict']]]]] = None,
                 auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate: Optional[pulumi.Input[bool]] = None,
                 default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 distance_external: Optional[pulumi.Input[int]] = None,
                 distance_external_variable: Optional[pulumi.Input[str]] = None,
                 distance_inter_area: Optional[pulumi.Input[int]] = None,
                 distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 distance_intra_area: Optional[pulumi.Input[int]] = None,
                 distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs', 'CiscoOspfFeatureTemplateMaxMetricRouterLsaArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRedistributeArgs', 'CiscoOspfFeatureTemplateRedistributeArgsDict']]]]] = None,
                 route_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRoutePolicyArgs', 'CiscoOspfFeatureTemplateRoutePolicyArgsDict']]]]] = None,
                 router_id: Optional[pulumi.Input[str]] = None,
                 router_id_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco OSPF feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoOspfFeatureTemplate:CiscoOspfFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateAreaArgs', 'CiscoOspfFeatureTemplateAreaArgsDict']]]] areas: Configure OSPF area
        :param pulumi.Input[int] auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] default_information_originate_metric_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[int] distance_external: Set distance for external routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_external_variable: Variable name
        :param pulumi.Input[int] distance_inter_area: Set distance for inter-area routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_inter_area_variable: Variable name
        :param pulumi.Input[int] distance_intra_area: Set distance for intra-area routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_intra_area_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs', 'CiscoOspfFeatureTemplateMaxMetricRouterLsaArgsDict']]]] max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRedistributeArgs', 'CiscoOspfFeatureTemplateRedistributeArgsDict']]]] redistributes: Redistribute routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRoutePolicyArgs', 'CiscoOspfFeatureTemplateRoutePolicyArgsDict']]]] route_policies: Set route policy to apply
        :param pulumi.Input[str] router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] router_id_variable: Variable name
        :param pulumi.Input[int] timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        :param pulumi.Input[str] timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        :param pulumi.Input[str] timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        :param pulumi.Input[str] timers_spf_max_hold_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoOspfFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco OSPF feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoOspfFeatureTemplate:CiscoOspfFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoOspfFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoOspfFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateAreaArgs', 'CiscoOspfFeatureTemplateAreaArgsDict']]]]] = None,
                 auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
                 auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
                 compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
                 compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate: Optional[pulumi.Input[bool]] = None,
                 default_information_originate_always: Optional[pulumi.Input[bool]] = None,
                 default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric: Optional[pulumi.Input[int]] = None,
                 default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
                 default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 distance_external: Optional[pulumi.Input[int]] = None,
                 distance_external_variable: Optional[pulumi.Input[str]] = None,
                 distance_inter_area: Optional[pulumi.Input[int]] = None,
                 distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
                 distance_intra_area: Optional[pulumi.Input[int]] = None,
                 distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
                 max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs', 'CiscoOspfFeatureTemplateMaxMetricRouterLsaArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRedistributeArgs', 'CiscoOspfFeatureTemplateRedistributeArgsDict']]]]] = None,
                 route_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRoutePolicyArgs', 'CiscoOspfFeatureTemplateRoutePolicyArgsDict']]]]] = None,
                 router_id: Optional[pulumi.Input[str]] = None,
                 router_id_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_delay: Optional[pulumi.Input[int]] = None,
                 timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
                 timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
                 timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
                 timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoOspfFeatureTemplateArgs.__new__(CiscoOspfFeatureTemplateArgs)

            __props__.__dict__["areas"] = areas
            __props__.__dict__["auto_cost_reference_bandwidth"] = auto_cost_reference_bandwidth
            __props__.__dict__["auto_cost_reference_bandwidth_variable"] = auto_cost_reference_bandwidth_variable
            __props__.__dict__["compatible_rfc1583"] = compatible_rfc1583
            __props__.__dict__["compatible_rfc1583_variable"] = compatible_rfc1583_variable
            __props__.__dict__["default_information_originate"] = default_information_originate
            __props__.__dict__["default_information_originate_always"] = default_information_originate_always
            __props__.__dict__["default_information_originate_always_variable"] = default_information_originate_always_variable
            __props__.__dict__["default_information_originate_metric"] = default_information_originate_metric
            __props__.__dict__["default_information_originate_metric_type"] = default_information_originate_metric_type
            __props__.__dict__["default_information_originate_metric_type_variable"] = default_information_originate_metric_type_variable
            __props__.__dict__["default_information_originate_metric_variable"] = default_information_originate_metric_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["distance_external"] = distance_external
            __props__.__dict__["distance_external_variable"] = distance_external_variable
            __props__.__dict__["distance_inter_area"] = distance_inter_area
            __props__.__dict__["distance_inter_area_variable"] = distance_inter_area_variable
            __props__.__dict__["distance_intra_area"] = distance_intra_area
            __props__.__dict__["distance_intra_area_variable"] = distance_intra_area_variable
            __props__.__dict__["max_metric_router_lsas"] = max_metric_router_lsas
            __props__.__dict__["name"] = name
            __props__.__dict__["redistributes"] = redistributes
            __props__.__dict__["route_policies"] = route_policies
            __props__.__dict__["router_id"] = router_id
            __props__.__dict__["router_id_variable"] = router_id_variable
            __props__.__dict__["timers_spf_delay"] = timers_spf_delay
            __props__.__dict__["timers_spf_delay_variable"] = timers_spf_delay_variable
            __props__.__dict__["timers_spf_initial_hold"] = timers_spf_initial_hold
            __props__.__dict__["timers_spf_initial_hold_variable"] = timers_spf_initial_hold_variable
            __props__.__dict__["timers_spf_max_hold"] = timers_spf_max_hold
            __props__.__dict__["timers_spf_max_hold_variable"] = timers_spf_max_hold_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoOspfFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoOspfFeatureTemplate:CiscoOspfFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateAreaArgs', 'CiscoOspfFeatureTemplateAreaArgsDict']]]]] = None,
            auto_cost_reference_bandwidth: Optional[pulumi.Input[int]] = None,
            auto_cost_reference_bandwidth_variable: Optional[pulumi.Input[str]] = None,
            compatible_rfc1583: Optional[pulumi.Input[bool]] = None,
            compatible_rfc1583_variable: Optional[pulumi.Input[str]] = None,
            default_information_originate: Optional[pulumi.Input[bool]] = None,
            default_information_originate_always: Optional[pulumi.Input[bool]] = None,
            default_information_originate_always_variable: Optional[pulumi.Input[str]] = None,
            default_information_originate_metric: Optional[pulumi.Input[int]] = None,
            default_information_originate_metric_type: Optional[pulumi.Input[str]] = None,
            default_information_originate_metric_type_variable: Optional[pulumi.Input[str]] = None,
            default_information_originate_metric_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            distance_external: Optional[pulumi.Input[int]] = None,
            distance_external_variable: Optional[pulumi.Input[str]] = None,
            distance_inter_area: Optional[pulumi.Input[int]] = None,
            distance_inter_area_variable: Optional[pulumi.Input[str]] = None,
            distance_intra_area: Optional[pulumi.Input[int]] = None,
            distance_intra_area_variable: Optional[pulumi.Input[str]] = None,
            max_metric_router_lsas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs', 'CiscoOspfFeatureTemplateMaxMetricRouterLsaArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            redistributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRedistributeArgs', 'CiscoOspfFeatureTemplateRedistributeArgsDict']]]]] = None,
            route_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRoutePolicyArgs', 'CiscoOspfFeatureTemplateRoutePolicyArgsDict']]]]] = None,
            router_id: Optional[pulumi.Input[str]] = None,
            router_id_variable: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            timers_spf_delay: Optional[pulumi.Input[int]] = None,
            timers_spf_delay_variable: Optional[pulumi.Input[str]] = None,
            timers_spf_initial_hold: Optional[pulumi.Input[int]] = None,
            timers_spf_initial_hold_variable: Optional[pulumi.Input[str]] = None,
            timers_spf_max_hold: Optional[pulumi.Input[int]] = None,
            timers_spf_max_hold_variable: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CiscoOspfFeatureTemplate':
        """
        Get an existing CiscoOspfFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateAreaArgs', 'CiscoOspfFeatureTemplateAreaArgsDict']]]] areas: Configure OSPF area
        :param pulumi.Input[int] auto_cost_reference_bandwidth: Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        :param pulumi.Input[str] auto_cost_reference_bandwidth_variable: Variable name
        :param pulumi.Input[bool] compatible_rfc1583: Calculate summary route cost based on RFC 1583 - Default value: `true`
        :param pulumi.Input[str] compatible_rfc1583_variable: Variable name
        :param pulumi.Input[bool] default_information_originate: Distribute default external route into OSPF - Default value: `false`
        :param pulumi.Input[bool] default_information_originate_always: Always advertise default route - Default value: `false`
        :param pulumi.Input[str] default_information_originate_always_variable: Variable name
        :param pulumi.Input[int] default_information_originate_metric: Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        :param pulumi.Input[str] default_information_originate_metric_type: Set default route type - Choices: `type1`, `type2`
        :param pulumi.Input[str] default_information_originate_metric_type_variable: Variable name
        :param pulumi.Input[str] default_information_originate_metric_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[int] distance_external: Set distance for external routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_external_variable: Variable name
        :param pulumi.Input[int] distance_inter_area: Set distance for inter-area routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_inter_area_variable: Variable name
        :param pulumi.Input[int] distance_intra_area: Set distance for intra-area routes - Range: `1`-`255` - Default value: `110`
        :param pulumi.Input[str] distance_intra_area_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateMaxMetricRouterLsaArgs', 'CiscoOspfFeatureTemplateMaxMetricRouterLsaArgsDict']]]] max_metric_router_lsas: Advertise own router LSA with infinite distance
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRedistributeArgs', 'CiscoOspfFeatureTemplateRedistributeArgsDict']]]] redistributes: Redistribute routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoOspfFeatureTemplateRoutePolicyArgs', 'CiscoOspfFeatureTemplateRoutePolicyArgsDict']]]] route_policies: Set route policy to apply
        :param pulumi.Input[str] router_id: Set OSPF router ID to override system IP address
        :param pulumi.Input[str] router_id_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] timers_spf_delay: Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        :param pulumi.Input[str] timers_spf_delay_variable: Variable name
        :param pulumi.Input[int] timers_spf_initial_hold: Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        :param pulumi.Input[str] timers_spf_initial_hold_variable: Variable name
        :param pulumi.Input[int] timers_spf_max_hold: Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        :param pulumi.Input[str] timers_spf_max_hold_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoOspfFeatureTemplateState.__new__(_CiscoOspfFeatureTemplateState)

        __props__.__dict__["areas"] = areas
        __props__.__dict__["auto_cost_reference_bandwidth"] = auto_cost_reference_bandwidth
        __props__.__dict__["auto_cost_reference_bandwidth_variable"] = auto_cost_reference_bandwidth_variable
        __props__.__dict__["compatible_rfc1583"] = compatible_rfc1583
        __props__.__dict__["compatible_rfc1583_variable"] = compatible_rfc1583_variable
        __props__.__dict__["default_information_originate"] = default_information_originate
        __props__.__dict__["default_information_originate_always"] = default_information_originate_always
        __props__.__dict__["default_information_originate_always_variable"] = default_information_originate_always_variable
        __props__.__dict__["default_information_originate_metric"] = default_information_originate_metric
        __props__.__dict__["default_information_originate_metric_type"] = default_information_originate_metric_type
        __props__.__dict__["default_information_originate_metric_type_variable"] = default_information_originate_metric_type_variable
        __props__.__dict__["default_information_originate_metric_variable"] = default_information_originate_metric_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["distance_external"] = distance_external
        __props__.__dict__["distance_external_variable"] = distance_external_variable
        __props__.__dict__["distance_inter_area"] = distance_inter_area
        __props__.__dict__["distance_inter_area_variable"] = distance_inter_area_variable
        __props__.__dict__["distance_intra_area"] = distance_intra_area
        __props__.__dict__["distance_intra_area_variable"] = distance_intra_area_variable
        __props__.__dict__["max_metric_router_lsas"] = max_metric_router_lsas
        __props__.__dict__["name"] = name
        __props__.__dict__["redistributes"] = redistributes
        __props__.__dict__["route_policies"] = route_policies
        __props__.__dict__["router_id"] = router_id
        __props__.__dict__["router_id_variable"] = router_id_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["timers_spf_delay"] = timers_spf_delay
        __props__.__dict__["timers_spf_delay_variable"] = timers_spf_delay_variable
        __props__.__dict__["timers_spf_initial_hold"] = timers_spf_initial_hold
        __props__.__dict__["timers_spf_initial_hold_variable"] = timers_spf_initial_hold_variable
        __props__.__dict__["timers_spf_max_hold"] = timers_spf_max_hold
        __props__.__dict__["timers_spf_max_hold_variable"] = timers_spf_max_hold_variable
        __props__.__dict__["version"] = version
        return CiscoOspfFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def areas(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfFeatureTemplateArea']]]:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "areas")

    @property
    @pulumi.getter(name="autoCostReferenceBandwidth")
    def auto_cost_reference_bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        Set reference bandwidth method to assign OSPF cost - Range: `1`-`4294967` - Default value: `100`
        """
        return pulumi.get(self, "auto_cost_reference_bandwidth")

    @property
    @pulumi.getter(name="autoCostReferenceBandwidthVariable")
    def auto_cost_reference_bandwidth_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "auto_cost_reference_bandwidth_variable")

    @property
    @pulumi.getter(name="compatibleRfc1583")
    def compatible_rfc1583(self) -> pulumi.Output[Optional[bool]]:
        """
        Calculate summary route cost based on RFC 1583 - Default value: `true`
        """
        return pulumi.get(self, "compatible_rfc1583")

    @property
    @pulumi.getter(name="compatibleRfc1583Variable")
    def compatible_rfc1583_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "compatible_rfc1583_variable")

    @property
    @pulumi.getter(name="defaultInformationOriginate")
    def default_information_originate(self) -> pulumi.Output[Optional[bool]]:
        """
        Distribute default external route into OSPF - Default value: `false`
        """
        return pulumi.get(self, "default_information_originate")

    @property
    @pulumi.getter(name="defaultInformationOriginateAlways")
    def default_information_originate_always(self) -> pulumi.Output[Optional[bool]]:
        """
        Always advertise default route - Default value: `false`
        """
        return pulumi.get(self, "default_information_originate_always")

    @property
    @pulumi.getter(name="defaultInformationOriginateAlwaysVariable")
    def default_information_originate_always_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_always_variable")

    @property
    @pulumi.getter(name="defaultInformationOriginateMetric")
    def default_information_originate_metric(self) -> pulumi.Output[Optional[int]]:
        """
        Set metric used to generate default route <0..16777214> - Range: `0`-`16777214`
        """
        return pulumi.get(self, "default_information_originate_metric")

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricType")
    def default_information_originate_metric_type(self) -> pulumi.Output[Optional[str]]:
        """
        Set default route type - Choices: `type1`, `type2`
        """
        return pulumi.get(self, "default_information_originate_metric_type")

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricTypeVariable")
    def default_information_originate_metric_type_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_type_variable")

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricVariable")
    def default_information_originate_metric_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="distanceExternal")
    def distance_external(self) -> pulumi.Output[Optional[int]]:
        """
        Set distance for external routes - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "distance_external")

    @property
    @pulumi.getter(name="distanceExternalVariable")
    def distance_external_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_external_variable")

    @property
    @pulumi.getter(name="distanceInterArea")
    def distance_inter_area(self) -> pulumi.Output[Optional[int]]:
        """
        Set distance for inter-area routes - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "distance_inter_area")

    @property
    @pulumi.getter(name="distanceInterAreaVariable")
    def distance_inter_area_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_inter_area_variable")

    @property
    @pulumi.getter(name="distanceIntraArea")
    def distance_intra_area(self) -> pulumi.Output[Optional[int]]:
        """
        Set distance for intra-area routes - Range: `1`-`255` - Default value: `110`
        """
        return pulumi.get(self, "distance_intra_area")

    @property
    @pulumi.getter(name="distanceIntraAreaVariable")
    def distance_intra_area_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_intra_area_variable")

    @property
    @pulumi.getter(name="maxMetricRouterLsas")
    def max_metric_router_lsas(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfFeatureTemplateMaxMetricRouterLsa']]]:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "max_metric_router_lsas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def redistributes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfFeatureTemplateRedistribute']]]:
        """
        Redistribute routes
        """
        return pulumi.get(self, "redistributes")

    @property
    @pulumi.getter(name="routePolicies")
    def route_policies(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoOspfFeatureTemplateRoutePolicy']]]:
        """
        Set route policy to apply
        """
        return pulumi.get(self, "route_policies")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Output[Optional[str]]:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter(name="routerIdVariable")
    def router_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "router_id_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="timersSpfDelay")
    def timers_spf_delay(self) -> pulumi.Output[Optional[int]]:
        """
        Set delay from first change received until performing SPF calculation - Range: `1`-`600000` - Default value: `200`
        """
        return pulumi.get(self, "timers_spf_delay")

    @property
    @pulumi.getter(name="timersSpfDelayVariable")
    def timers_spf_delay_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_delay_variable")

    @property
    @pulumi.getter(name="timersSpfInitialHold")
    def timers_spf_initial_hold(self) -> pulumi.Output[Optional[int]]:
        """
        Set initial hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `1000`
        """
        return pulumi.get(self, "timers_spf_initial_hold")

    @property
    @pulumi.getter(name="timersSpfInitialHoldVariable")
    def timers_spf_initial_hold_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_initial_hold_variable")

    @property
    @pulumi.getter(name="timersSpfMaxHold")
    def timers_spf_max_hold(self) -> pulumi.Output[Optional[int]]:
        """
        Set maximum hold time between consecutive SPF calculations - Range: `1`-`600000` - Default value: `10000`
        """
        return pulumi.get(self, "timers_spf_max_hold")

    @property
    @pulumi.getter(name="timersSpfMaxHoldVariable")
    def timers_spf_max_hold_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timers_spf_max_hold_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

