# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['GpsFeatureTemplateArgs', 'GpsFeatureTemplate']

@pulumi.input_type
class GpsFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 destination_address: Optional[pulumi.Input[str]] = None,
                 destination_address_variable: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 destination_port_variable: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 enable_variable: Optional[pulumi.Input[str]] = None,
                 gps_mode: Optional[pulumi.Input[str]] = None,
                 gps_mode_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nmea: Optional[pulumi.Input[bool]] = None,
                 nmea_variable: Optional[pulumi.Input[str]] = None,
                 source_address: Optional[pulumi.Input[str]] = None,
                 source_address_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GpsFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] destination_address: Destination address
        :param pulumi.Input[str] destination_address_variable: Variable name
        :param pulumi.Input[int] destination_port: Destination port - Range: `1`-`65535`
        :param pulumi.Input[str] destination_port_variable: Variable name
        :param pulumi.Input[bool] enable: Enable/disable GPS - Default value: `false`
        :param pulumi.Input[str] enable_variable: Variable name
        :param pulumi.Input[str] gps_mode: Select GPS mode - Choices: `ms-based`, `standalone` - Default value: `ms-based`
        :param pulumi.Input[str] gps_mode_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] nmea: Enable/disable NMEA data - Default value: `false`
        :param pulumi.Input[str] nmea_variable: Variable name
        :param pulumi.Input[str] source_address: Source address
        :param pulumi.Input[str] source_address_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if destination_address is not None:
            pulumi.set(__self__, "destination_address", destination_address)
        if destination_address_variable is not None:
            pulumi.set(__self__, "destination_address_variable", destination_address_variable)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if destination_port_variable is not None:
            pulumi.set(__self__, "destination_port_variable", destination_port_variable)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enable_variable is not None:
            pulumi.set(__self__, "enable_variable", enable_variable)
        if gps_mode is not None:
            pulumi.set(__self__, "gps_mode", gps_mode)
        if gps_mode_variable is not None:
            pulumi.set(__self__, "gps_mode_variable", gps_mode_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nmea is not None:
            pulumi.set(__self__, "nmea", nmea)
        if nmea_variable is not None:
            pulumi.set(__self__, "nmea_variable", nmea_variable)
        if source_address is not None:
            pulumi.set(__self__, "source_address", source_address)
        if source_address_variable is not None:
            pulumi.set(__self__, "source_address_variable", source_address_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> Optional[pulumi.Input[str]]:
        """
        Destination address
        """
        return pulumi.get(self, "destination_address")

    @destination_address.setter
    def destination_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_address", value)

    @property
    @pulumi.getter(name="destinationAddressVariable")
    def destination_address_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "destination_address_variable")

    @destination_address_variable.setter
    def destination_address_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_address_variable", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        Destination port - Range: `1`-`65535`
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter(name="destinationPortVariable")
    def destination_port_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "destination_port_variable")

    @destination_port_variable.setter
    def destination_port_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port_variable", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable GPS - Default value: `false`
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="enableVariable")
    def enable_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_variable")

    @enable_variable.setter
    def enable_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_variable", value)

    @property
    @pulumi.getter(name="gpsMode")
    def gps_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Select GPS mode - Choices: `ms-based`, `standalone` - Default value: `ms-based`
        """
        return pulumi.get(self, "gps_mode")

    @gps_mode.setter
    def gps_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gps_mode", value)

    @property
    @pulumi.getter(name="gpsModeVariable")
    def gps_mode_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "gps_mode_variable")

    @gps_mode_variable.setter
    def gps_mode_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gps_mode_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nmea(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable NMEA data - Default value: `false`
        """
        return pulumi.get(self, "nmea")

    @nmea.setter
    def nmea(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nmea", value)

    @property
    @pulumi.getter(name="nmeaVariable")
    def nmea_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "nmea_variable")

    @nmea_variable.setter
    def nmea_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nmea_variable", value)

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> Optional[pulumi.Input[str]]:
        """
        Source address
        """
        return pulumi.get(self, "source_address")

    @source_address.setter
    def source_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address", value)

    @property
    @pulumi.getter(name="sourceAddressVariable")
    def source_address_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "source_address_variable")

    @source_address_variable.setter
    def source_address_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address_variable", value)


@pulumi.input_type
class _GpsFeatureTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_address: Optional[pulumi.Input[str]] = None,
                 destination_address_variable: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 destination_port_variable: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 enable_variable: Optional[pulumi.Input[str]] = None,
                 gps_mode: Optional[pulumi.Input[str]] = None,
                 gps_mode_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nmea: Optional[pulumi.Input[bool]] = None,
                 nmea_variable: Optional[pulumi.Input[str]] = None,
                 source_address: Optional[pulumi.Input[str]] = None,
                 source_address_variable: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering GpsFeatureTemplate resources.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[str] destination_address: Destination address
        :param pulumi.Input[str] destination_address_variable: Variable name
        :param pulumi.Input[int] destination_port: Destination port - Range: `1`-`65535`
        :param pulumi.Input[str] destination_port_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] enable: Enable/disable GPS - Default value: `false`
        :param pulumi.Input[str] enable_variable: Variable name
        :param pulumi.Input[str] gps_mode: Select GPS mode - Choices: `ms-based`, `standalone` - Default value: `ms-based`
        :param pulumi.Input[str] gps_mode_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] nmea: Enable/disable NMEA data - Default value: `false`
        :param pulumi.Input[str] nmea_variable: Variable name
        :param pulumi.Input[str] source_address: Source address
        :param pulumi.Input[str] source_address_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address is not None:
            pulumi.set(__self__, "destination_address", destination_address)
        if destination_address_variable is not None:
            pulumi.set(__self__, "destination_address_variable", destination_address_variable)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if destination_port_variable is not None:
            pulumi.set(__self__, "destination_port_variable", destination_port_variable)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enable_variable is not None:
            pulumi.set(__self__, "enable_variable", enable_variable)
        if gps_mode is not None:
            pulumi.set(__self__, "gps_mode", gps_mode)
        if gps_mode_variable is not None:
            pulumi.set(__self__, "gps_mode_variable", gps_mode_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nmea is not None:
            pulumi.set(__self__, "nmea", nmea)
        if nmea_variable is not None:
            pulumi.set(__self__, "nmea_variable", nmea_variable)
        if source_address is not None:
            pulumi.set(__self__, "source_address", source_address)
        if source_address_variable is not None:
            pulumi.set(__self__, "source_address_variable", source_address_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> Optional[pulumi.Input[str]]:
        """
        Destination address
        """
        return pulumi.get(self, "destination_address")

    @destination_address.setter
    def destination_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_address", value)

    @property
    @pulumi.getter(name="destinationAddressVariable")
    def destination_address_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "destination_address_variable")

    @destination_address_variable.setter
    def destination_address_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_address_variable", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        Destination port - Range: `1`-`65535`
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter(name="destinationPortVariable")
    def destination_port_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "destination_port_variable")

    @destination_port_variable.setter
    def destination_port_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port_variable", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable GPS - Default value: `false`
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="enableVariable")
    def enable_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_variable")

    @enable_variable.setter
    def enable_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_variable", value)

    @property
    @pulumi.getter(name="gpsMode")
    def gps_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Select GPS mode - Choices: `ms-based`, `standalone` - Default value: `ms-based`
        """
        return pulumi.get(self, "gps_mode")

    @gps_mode.setter
    def gps_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gps_mode", value)

    @property
    @pulumi.getter(name="gpsModeVariable")
    def gps_mode_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "gps_mode_variable")

    @gps_mode_variable.setter
    def gps_mode_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gps_mode_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nmea(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable NMEA data - Default value: `false`
        """
        return pulumi.get(self, "nmea")

    @nmea.setter
    def nmea(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nmea", value)

    @property
    @pulumi.getter(name="nmeaVariable")
    def nmea_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "nmea_variable")

    @nmea_variable.setter
    def nmea_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nmea_variable", value)

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> Optional[pulumi.Input[str]]:
        """
        Source address
        """
        return pulumi.get(self, "source_address")

    @source_address.setter
    def source_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address", value)

    @property
    @pulumi.getter(name="sourceAddressVariable")
    def source_address_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "source_address_variable")

    @source_address_variable.setter
    def source_address_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class GpsFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_address: Optional[pulumi.Input[str]] = None,
                 destination_address_variable: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 destination_port_variable: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 enable_variable: Optional[pulumi.Input[str]] = None,
                 gps_mode: Optional[pulumi.Input[str]] = None,
                 gps_mode_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nmea: Optional[pulumi.Input[bool]] = None,
                 nmea_variable: Optional[pulumi.Input[str]] = None,
                 source_address: Optional[pulumi.Input[str]] = None,
                 source_address_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a gps feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.GpsFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            enable=True,
            gps_mode="ms-based",
            nmea=True,
            source_address="1.2.3.4",
            destination_address="2.3.4.5",
            destination_port=1234)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/gpsFeatureTemplate:GpsFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[str] destination_address: Destination address
        :param pulumi.Input[str] destination_address_variable: Variable name
        :param pulumi.Input[int] destination_port: Destination port - Range: `1`-`65535`
        :param pulumi.Input[str] destination_port_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] enable: Enable/disable GPS - Default value: `false`
        :param pulumi.Input[str] enable_variable: Variable name
        :param pulumi.Input[str] gps_mode: Select GPS mode - Choices: `ms-based`, `standalone` - Default value: `ms-based`
        :param pulumi.Input[str] gps_mode_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] nmea: Enable/disable NMEA data - Default value: `false`
        :param pulumi.Input[str] nmea_variable: Variable name
        :param pulumi.Input[str] source_address: Source address
        :param pulumi.Input[str] source_address_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GpsFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a gps feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.GpsFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            enable=True,
            gps_mode="ms-based",
            nmea=True,
            source_address="1.2.3.4",
            destination_address="2.3.4.5",
            destination_port=1234)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/gpsFeatureTemplate:GpsFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param GpsFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GpsFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_address: Optional[pulumi.Input[str]] = None,
                 destination_address_variable: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 destination_port_variable: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 enable_variable: Optional[pulumi.Input[str]] = None,
                 gps_mode: Optional[pulumi.Input[str]] = None,
                 gps_mode_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nmea: Optional[pulumi.Input[bool]] = None,
                 nmea_variable: Optional[pulumi.Input[str]] = None,
                 source_address: Optional[pulumi.Input[str]] = None,
                 source_address_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GpsFeatureTemplateArgs.__new__(GpsFeatureTemplateArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_address"] = destination_address
            __props__.__dict__["destination_address_variable"] = destination_address_variable
            __props__.__dict__["destination_port"] = destination_port
            __props__.__dict__["destination_port_variable"] = destination_port_variable
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["enable"] = enable
            __props__.__dict__["enable_variable"] = enable_variable
            __props__.__dict__["gps_mode"] = gps_mode
            __props__.__dict__["gps_mode_variable"] = gps_mode_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["nmea"] = nmea
            __props__.__dict__["nmea_variable"] = nmea_variable
            __props__.__dict__["source_address"] = source_address
            __props__.__dict__["source_address_variable"] = source_address_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(GpsFeatureTemplate, __self__).__init__(
            'sdwan:index/gpsFeatureTemplate:GpsFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            destination_address: Optional[pulumi.Input[str]] = None,
            destination_address_variable: Optional[pulumi.Input[str]] = None,
            destination_port: Optional[pulumi.Input[int]] = None,
            destination_port_variable: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            enable_variable: Optional[pulumi.Input[str]] = None,
            gps_mode: Optional[pulumi.Input[str]] = None,
            gps_mode_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nmea: Optional[pulumi.Input[bool]] = None,
            nmea_variable: Optional[pulumi.Input[str]] = None,
            source_address: Optional[pulumi.Input[str]] = None,
            source_address_variable: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'GpsFeatureTemplate':
        """
        Get an existing GpsFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[str] destination_address: Destination address
        :param pulumi.Input[str] destination_address_variable: Variable name
        :param pulumi.Input[int] destination_port: Destination port - Range: `1`-`65535`
        :param pulumi.Input[str] destination_port_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] enable: Enable/disable GPS - Default value: `false`
        :param pulumi.Input[str] enable_variable: Variable name
        :param pulumi.Input[str] gps_mode: Select GPS mode - Choices: `ms-based`, `standalone` - Default value: `ms-based`
        :param pulumi.Input[str] gps_mode_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] nmea: Enable/disable NMEA data - Default value: `false`
        :param pulumi.Input[str] nmea_variable: Variable name
        :param pulumi.Input[str] source_address: Source address
        :param pulumi.Input[str] source_address_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GpsFeatureTemplateState.__new__(_GpsFeatureTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination_address"] = destination_address
        __props__.__dict__["destination_address_variable"] = destination_address_variable
        __props__.__dict__["destination_port"] = destination_port
        __props__.__dict__["destination_port_variable"] = destination_port_variable
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["enable"] = enable
        __props__.__dict__["enable_variable"] = enable_variable
        __props__.__dict__["gps_mode"] = gps_mode
        __props__.__dict__["gps_mode_variable"] = gps_mode_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["nmea"] = nmea
        __props__.__dict__["nmea_variable"] = nmea_variable
        __props__.__dict__["source_address"] = source_address
        __props__.__dict__["source_address_variable"] = source_address_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return GpsFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> pulumi.Output[Optional[str]]:
        """
        Destination address
        """
        return pulumi.get(self, "destination_address")

    @property
    @pulumi.getter(name="destinationAddressVariable")
    def destination_address_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "destination_address_variable")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> pulumi.Output[Optional[int]]:
        """
        Destination port - Range: `1`-`65535`
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="destinationPortVariable")
    def destination_port_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "destination_port_variable")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable/disable GPS - Default value: `false`
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="enableVariable")
    def enable_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_variable")

    @property
    @pulumi.getter(name="gpsMode")
    def gps_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Select GPS mode - Choices: `ms-based`, `standalone` - Default value: `ms-based`
        """
        return pulumi.get(self, "gps_mode")

    @property
    @pulumi.getter(name="gpsModeVariable")
    def gps_mode_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "gps_mode_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nmea(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable/disable NMEA data - Default value: `false`
        """
        return pulumi.get(self, "nmea")

    @property
    @pulumi.getter(name="nmeaVariable")
    def nmea_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "nmea_variable")

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> pulumi.Output[Optional[str]]:
        """
        Source address
        """
        return pulumi.get(self, "source_address")

    @property
    @pulumi.getter(name="sourceAddressVariable")
    def source_address_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "source_address_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

