# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyObjectIpv6PrefixListArgs', 'PolicyObjectIpv6PrefixList']

@pulumi.input_type
class PolicyObjectIpv6PrefixListArgs:
    def __init__(__self__, *,
                 entries: pulumi.Input[Sequence[pulumi.Input['PolicyObjectIpv6PrefixListEntryArgs']]],
                 feature_profile_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PolicyObjectIpv6PrefixList resource.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyObjectIpv6PrefixListEntryArgs']]] entries: IPv6 Prefix List
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] description: The description of the Policy_object
        :param pulumi.Input[str] name: The name of the Policy_object
        """
        pulumi.set(__self__, "entries", entries)
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Input[Sequence[pulumi.Input['PolicyObjectIpv6PrefixListEntryArgs']]]:
        """
        IPv6 Prefix List
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: pulumi.Input[Sequence[pulumi.Input['PolicyObjectIpv6PrefixListEntryArgs']]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Policy_object
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Policy_object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PolicyObjectIpv6PrefixListState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyObjectIpv6PrefixListEntryArgs']]]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering PolicyObjectIpv6PrefixList resources.
        :param pulumi.Input[str] description: The description of the Policy_object
        :param pulumi.Input[Sequence[pulumi.Input['PolicyObjectIpv6PrefixListEntryArgs']]] entries: IPv6 Prefix List
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the Policy_object
        :param pulumi.Input[int] version: The version of the Policy_object
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Policy_object
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyObjectIpv6PrefixListEntryArgs']]]]:
        """
        IPv6 Prefix List
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyObjectIpv6PrefixListEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Policy_object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the Policy_object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class PolicyObjectIpv6PrefixList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyObjectIpv6PrefixListEntryArgs', 'PolicyObjectIpv6PrefixListEntryArgsDict']]]]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Policy Object IPv6 Prefix List Policy_object.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/policyObjectIpv6PrefixList:PolicyObjectIpv6PrefixList example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Policy_object
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyObjectIpv6PrefixListEntryArgs', 'PolicyObjectIpv6PrefixListEntryArgsDict']]]] entries: IPv6 Prefix List
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the Policy_object
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyObjectIpv6PrefixListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Policy Object IPv6 Prefix List Policy_object.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/policyObjectIpv6PrefixList:PolicyObjectIpv6PrefixList example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param PolicyObjectIpv6PrefixListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyObjectIpv6PrefixListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyObjectIpv6PrefixListEntryArgs', 'PolicyObjectIpv6PrefixListEntryArgsDict']]]]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyObjectIpv6PrefixListArgs.__new__(PolicyObjectIpv6PrefixListArgs)

            __props__.__dict__["description"] = description
            if entries is None and not opts.urn:
                raise TypeError("Missing required property 'entries'")
            __props__.__dict__["entries"] = entries
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["version"] = None
        super(PolicyObjectIpv6PrefixList, __self__).__init__(
            'sdwan:index/policyObjectIpv6PrefixList:PolicyObjectIpv6PrefixList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyObjectIpv6PrefixListEntryArgs', 'PolicyObjectIpv6PrefixListEntryArgsDict']]]]] = None,
            feature_profile_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'PolicyObjectIpv6PrefixList':
        """
        Get an existing PolicyObjectIpv6PrefixList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Policy_object
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyObjectIpv6PrefixListEntryArgs', 'PolicyObjectIpv6PrefixListEntryArgsDict']]]] entries: IPv6 Prefix List
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the Policy_object
        :param pulumi.Input[int] version: The version of the Policy_object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyObjectIpv6PrefixListState.__new__(_PolicyObjectIpv6PrefixListState)

        __props__.__dict__["description"] = description
        __props__.__dict__["entries"] = entries
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["version"] = version
        return PolicyObjectIpv6PrefixList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Policy_object
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Sequence['outputs.PolicyObjectIpv6PrefixListEntry']]:
        """
        IPv6 Prefix List
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Policy_object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the Policy_object
        """
        return pulumi.get(self, "version")

