# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoSystemFeatureTemplateArgs', 'CiscoSystemFeatureTemplate']

@pulumi.input_type
class CiscoSystemFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 admin_tech_on_failure: Optional[pulumi.Input[bool]] = None,
                 admin_tech_on_failure_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_number: Optional[pulumi.Input[int]] = None,
                 affinity_group_number_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_preference_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 console_baud_rate: Optional[pulumi.Input[str]] = None,
                 console_baud_rate_variable: Optional[pulumi.Input[str]] = None,
                 control_session_pps: Optional[pulumi.Input[int]] = None,
                 control_session_pps_variable: Optional[pulumi.Input[str]] = None,
                 controller_group_list_variable: Optional[pulumi.Input[str]] = None,
                 controller_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_groups_variable: Optional[pulumi.Input[str]] = None,
                 enable_mrf_migration: Optional[pulumi.Input[str]] = None,
                 geo_fencing: Optional[pulumi.Input[bool]] = None,
                 geo_fencing_range: Optional[pulumi.Input[int]] = None,
                 geo_fencing_range_variable: Optional[pulumi.Input[str]] = None,
                 geo_fencing_sms: Optional[pulumi.Input[bool]] = None,
                 geo_fencing_sms_phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs']]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hostname_variable: Optional[pulumi.Input[str]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 idle_timeout_variable: Optional[pulumi.Input[str]] = None,
                 latitude: Optional[pulumi.Input[float]] = None,
                 latitude_variable: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_variable: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[float]] = None,
                 longitude_variable: Optional[pulumi.Input[str]] = None,
                 max_omp_sessions: Optional[pulumi.Input[int]] = None,
                 max_omp_sessions_variable: Optional[pulumi.Input[str]] = None,
                 migration_bgp_community: Optional[pulumi.Input[int]] = None,
                 multi_tenant: Optional[pulumi.Input[bool]] = None,
                 multi_tenant_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_trackers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateObjectTrackerArgs']]]] = None,
                 on_demand_tunnel: Optional[pulumi.Input[bool]] = None,
                 on_demand_tunnel_idle_timeout: Optional[pulumi.Input[int]] = None,
                 on_demand_tunnel_idle_timeout_variable: Optional[pulumi.Input[str]] = None,
                 on_demand_tunnel_variable: Optional[pulumi.Input[str]] = None,
                 overlay_id: Optional[pulumi.Input[int]] = None,
                 overlay_id_variable: Optional[pulumi.Input[str]] = None,
                 port_hopping: Optional[pulumi.Input[bool]] = None,
                 port_hopping_variable: Optional[pulumi.Input[str]] = None,
                 port_offset: Optional[pulumi.Input[int]] = None,
                 port_offset_variable: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[int]] = None,
                 region_id_variable: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 role_variable: Optional[pulumi.Input[str]] = None,
                 secondary_region_id: Optional[pulumi.Input[int]] = None,
                 secondary_region_id_variable: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 site_id_variable: Optional[pulumi.Input[str]] = None,
                 system_description: Optional[pulumi.Input[str]] = None,
                 system_description_variable: Optional[pulumi.Input[str]] = None,
                 system_ip: Optional[pulumi.Input[str]] = None,
                 system_ip_variable: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 timezone_variable: Optional[pulumi.Input[str]] = None,
                 track_default_gateway: Optional[pulumi.Input[bool]] = None,
                 track_default_gateway_variable: Optional[pulumi.Input[str]] = None,
                 track_interface_tag: Optional[pulumi.Input[int]] = None,
                 track_interface_tag_variable: Optional[pulumi.Input[str]] = None,
                 track_transport: Optional[pulumi.Input[bool]] = None,
                 track_transport_variable: Optional[pulumi.Input[str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateTrackerArgs']]]] = None,
                 transport_gateway: Optional[pulumi.Input[bool]] = None,
                 transport_gateway_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CiscoSystemFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[bool] admin_tech_on_failure: Collect admin-tech before reboot due to daemon failure - Default value: `true`
        :param pulumi.Input[str] admin_tech_on_failure_variable: Variable name
        :param pulumi.Input[int] affinity_group_number: Set the affinity group number for router - Range: `1`-`255`
        :param pulumi.Input[str] affinity_group_number_variable: Variable name
        :param pulumi.Input[str] affinity_group_preference_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] affinity_group_preferences: Set the affinity group preference
        :param pulumi.Input[str] console_baud_rate: Set the console baud rate - Choices: `1200`, `2400`, `4800`, `9600`, `19200`, `38400`, `57600`, `115200` - Default
               value: `9600`
        :param pulumi.Input[str] console_baud_rate_variable: Variable name
        :param pulumi.Input[int] control_session_pps: Set the policer rate for control sessions - Range: `1`-`65535` - Default value: `300`
        :param pulumi.Input[str] control_session_pps_variable: Variable name
        :param pulumi.Input[str] controller_group_list_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] controller_group_lists: Configure a list of comma-separated device groups
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_groups: Device groups (Use comma(,) for multiple groups)
        :param pulumi.Input[str] device_groups_variable: Variable name
        :param pulumi.Input[str] enable_mrf_migration: Enable migration mode to Multi-Region Fabric - Choices: `enabled`, `enabled-from-bgp-core`
        :param pulumi.Input[bool] geo_fencing: Enable Geo fencing - Default value: `false`
        :param pulumi.Input[int] geo_fencing_range: Set the device’s geo fencing range - Range: `100`-`10000` - Default value: `100`
        :param pulumi.Input[str] geo_fencing_range_variable: Variable name
        :param pulumi.Input[bool] geo_fencing_sms: Enable Geo fencing - Default value: `false`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs']]] geo_fencing_sms_phone_numbers: Set device’s geo fencing SMS phone number
        :param pulumi.Input[str] hostname: Set the hostname
        :param pulumi.Input[str] hostname_variable: Variable name
        :param pulumi.Input[int] idle_timeout: Idle CLI timeout in minutes - Range: `0`-`300`
        :param pulumi.Input[str] idle_timeout_variable: Variable name
        :param pulumi.Input[float] latitude: Set the device’s physical latitude - Range: `-90`-`90`
        :param pulumi.Input[str] latitude_variable: Variable name
        :param pulumi.Input[str] location: Set the location of the device
        :param pulumi.Input[str] location_variable: Variable name
        :param pulumi.Input[float] longitude: Set the device’s physical longitude - Range: `-180`-`180`
        :param pulumi.Input[str] longitude_variable: Variable name
        :param pulumi.Input[int] max_omp_sessions: Set the maximum number of OMP sessions <1..100> the device can have - Range: `1`-`100`
        :param pulumi.Input[str] max_omp_sessions_variable: Variable name
        :param pulumi.Input[int] migration_bgp_community: Set BGP community during migration from BGP-core based network - Range: `1`-`4294967295`
        :param pulumi.Input[bool] multi_tenant: Device is multi-tenant - Default value: `false`
        :param pulumi.Input[str] multi_tenant_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateObjectTrackerArgs']]] object_trackers: Object Track configuration
        :param pulumi.Input[bool] on_demand_tunnel: Enable or disable On-demand Tunnel - Default value: `false`
        :param pulumi.Input[int] on_demand_tunnel_idle_timeout: Idle CLI timeout in minutes - Range: `0`-`300`
        :param pulumi.Input[str] on_demand_tunnel_idle_timeout_variable: Variable name
        :param pulumi.Input[str] on_demand_tunnel_variable: Variable name
        :param pulumi.Input[int] overlay_id: Set the Overlay ID - Range: `1`-`4294967295` - Default value: `1`
        :param pulumi.Input[str] overlay_id_variable: Variable name
        :param pulumi.Input[bool] port_hopping: Enable port hopping - Default value: `true`
        :param pulumi.Input[str] port_hopping_variable: Variable name
        :param pulumi.Input[int] port_offset: Set the TLOC port offset when multiple devices are behind a NAT - Range: `0`-`19` - Default value: `0`
        :param pulumi.Input[str] port_offset_variable: Variable name
        :param pulumi.Input[int] region_id: Set region ID - Range: `1`-`63`
        :param pulumi.Input[str] region_id_variable: Variable name
        :param pulumi.Input[str] role: Set the role for router - Choices: `edge-router`, `border-router`
        :param pulumi.Input[str] role_variable: Variable name
        :param pulumi.Input[int] secondary_region_id: Set secondary region ID - Range: `1`-`63`
        :param pulumi.Input[str] secondary_region_id_variable: Variable name
        :param pulumi.Input[int] site_id: Set the site identifier - Range: `1`-`4294967295`
        :param pulumi.Input[str] site_id_variable: Variable name
        :param pulumi.Input[str] system_description: Set a text description of the device
        :param pulumi.Input[str] system_description_variable: Variable name
        :param pulumi.Input[str] system_ip: Set the system IP address
        :param pulumi.Input[str] system_ip_variable: Variable name
        :param pulumi.Input[str] timezone: Set the timezone - Choices: `Europe/Andorra`, `Asia/Dubai`, `Asia/Kabul`, `America/Antigua`, `America/Anguilla`,
               `Europe/Tirane`, `Asia/Yerevan`, `Africa/Luanda`, `Antarctica/McMurdo`, `Antarctica/Rothera`, `Antarctica/Palmer`,
               `Antarctica/Mawson`, `Antarctica/Davis`, `Antarctica/Casey`, `Antarctica/Vostok`, `Antarctica/DumontDUrville`,
               `Antarctica/Syowa`, `America/Argentina/Buenos_Aires`, `America/Argentina/Cordoba`, `America/Argentina/Salta`,
               `America/Argentina/Jujuy`, `America/Argentina/Tucuman`, `America/Argentina/Catamarca`, `America/Argentina/La_Rioja`,
               `America/Argentina/San_Juan`, `America/Argentina/Mendoza`, `America/Argentina/San_Luis`,
               `America/Argentina/Rio_Gallegos`, `America/Argentina/Ushuaia`, `Pacific/Pago_Pago`, `Europe/Vienna`,
               `Australia/Lord_Howe`, `Antarctica/Macquarie`, `Australia/Hobart`, `Australia/Currie`, `Australia/Melbourne`,
               `Australia/Sydney`, `Australia/Broken_Hill`, `Australia/Brisbane`, `Australia/Lindeman`, `Australia/Adelaide`,
               `Australia/Darwin`, `Australia/Perth`, `Australia/Eucla`, `America/Aruba`, `Europe/Mariehamn`, `Asia/Baku`,
               `Europe/Sarajevo`, `America/Barbados`, `Asia/Dhaka`, `Europe/Brussels`, `Africa/Ouagadougou`, `Europe/Sofia`,
               `Asia/Bahrain`, `Africa/Bujumbura`, `Africa/Porto-Novo`, `America/St_Barthelemy`, `Atlantic/Bermuda`, `Asia/Brunei`,
               `America/La_Paz`, `America/Kralendijk`, `America/Noronha`, `America/Belem`, `America/Fortaleza`, `America/Recife`,
               `America/Araguaina`, `America/Maceio`, `America/Bahia`, `America/Sao_Paulo`, `America/Campo_Grande`, `America/Cuiaba`,
               `America/Santarem`, `America/Porto_Velho`, `America/Boa_Vista`, `America/Manaus`, `America/Eirunepe`,
               `America/Rio_Branco`, `America/Nassau`, `Asia/Thimphu`, `Africa/Gaborone`, `Europe/Minsk`, `America/Belize`,
               `America/St_Johns`, `America/Halifax`, `America/Glace_Bay`, `America/Moncton`, `America/Goose_Bay`,
               `America/Blanc-Sablon`, `America/Toronto`, `America/Nipigon`, `America/Thunder_Bay`, `America/Iqaluit`,
               `America/Pangnirtung`, `America/Resolute`, `America/Atikokan`, `America/Rankin_Inlet`, `America/Winnipeg`,
               `America/Rainy_River`, `America/Regina`, `America/Swift_Current`, `America/Edmonton`, `America/Cambridge_Bay`,
               `America/Yellowknife`, `America/Inuvik`, `America/Creston`, `America/Dawson_Creek`, `America/Vancouver`,
               `America/Whitehorse`, `America/Dawson`, `Indian/Cocos`, `Africa/Kinshasa`, `Africa/Lubumbashi`, `Africa/Bangui`,
               `Africa/Brazzaville`, `Europe/Zurich`, `Africa/Abidjan`, `Pacific/Rarotonga`, `America/Santiago`, `Pacific/Easter`,
               `Africa/Douala`, `Asia/Shanghai`, `Asia/Harbin`, `Asia/Chongqing`, `Asia/Urumqi`, `Asia/Kashgar`, `America/Bogota`,
               `America/Costa_Rica`, `America/Havana`, `Atlantic/Cape_Verde`, `America/Curacao`, `Indian/Christmas`, `Asia/Nicosia`,
               `Europe/Prague`, `Europe/Berlin`, `Europe/Busingen`, `Africa/Djibouti`, `Europe/Copenhagen`, `America/Dominica`,
               `America/Santo_Domingo`, `Africa/Algiers`, `America/Guayaquil`, `Pacific/Galapagos`, `Europe/Tallinn`, `Africa/Cairo`,
               `Africa/El_Aaiun`, `Africa/Asmara`, `Europe/Madrid`, `Africa/Ceuta`, `Atlantic/Canary`, `Africa/Addis_Ababa`,
               `Europe/Helsinki`, `Pacific/Fiji`, `Atlantic/Stanley`, `Pacific/Chuuk`, `Pacific/Pohnpei`, `Pacific/Kosrae`,
               `Atlantic/Faroe`, `Europe/Paris`, `Africa/Libreville`, `Europe/London`, `America/Grenada`, `Asia/Tbilisi`,
               `America/Cayenne`, `Europe/Guernsey`, `Africa/Accra`, `Europe/Gibraltar`, `America/Godthab`, `America/Danmarkshavn`,
               `America/Scoresbysund`, `America/Thule`, `Africa/Banjul`, `Africa/Conakry`, `America/Guadeloupe`, `Africa/Malabo`,
               `Europe/Athens`, `Atlantic/South_Georgia`, `America/Guatemala`, `Pacific/Guam`, `Africa/Bissau`, `America/Guyana`,
               `Asia/Hong_Kong`, `America/Tegucigalpa`, `Europe/Zagreb`, `America/Port-au-Prince`, `Europe/Budapest`, `Asia/Jakarta`,
               `Asia/Pontianak`, `Asia/Makassar`, `Asia/Jayapura`, `Europe/Dublin`, `Asia/Jerusalem`, `Europe/Isle_of_Man`,
               `Asia/Kolkata`, `Indian/Chagos`, `Asia/Baghdad`, `Asia/Tehran`, `Atlantic/Reykjavik`, `Europe/Rome`, `Europe/Jersey`,
               `America/Jamaica`, `Asia/Amman`, `Asia/Tokyo`, `Africa/Nairobi`, `Asia/Bishkek`, `Asia/Phnom_Penh`, `Pacific/Tarawa`,
               `Pacific/Enderbury`, `Pacific/Kiritimati`, `Indian/Comoro`, `America/St_Kitts`, `Asia/Pyongyang`, `Asia/Seoul`,
               `Asia/Kuwait`, `America/Cayman`, `Asia/Almaty`, `Asia/Qyzylorda`, `Asia/Aqtobe`, `Asia/Aqtau`, `Asia/Oral`,
               `Asia/Vientiane`, `Asia/Beirut`, `America/St_Lucia`, `Europe/Vaduz`, `Asia/Colombo`, `Africa/Monrovia`, `Africa/Maseru`,
               `Europe/Vilnius`, `Europe/Luxembourg`, `Europe/Riga`, `Africa/Tripoli`, `Africa/Casablanca`, `Europe/Monaco`,
               `Europe/Chisinau`, `Europe/Podgorica`, `America/Marigot`, `Indian/Antananarivo`, `Pacific/Majuro`, `Pacific/Kwajalein`,
               `Europe/Skopje`, `Africa/Bamako`, `Asia/Rangoon`, `Asia/Ulaanbaatar`, `Asia/Hovd`, `Asia/Choibalsan`, `Asia/Macau`,
               `Pacific/Saipan`, `America/Martinique`, `Africa/Nouakchott`, `America/Montserrat`, `Europe/Malta`, `Indian/Mauritius`,
               `Indian/Maldives`, `Africa/Blantyre`, `America/Mexico_City`, `America/Cancun`, `America/Merida`, `America/Monterrey`,
               `America/Matamoros`, `America/Mazatlan`, `America/Chihuahua`, `America/Ojinaga`, `America/Hermosillo`,
               `America/Tijuana`, `America/Santa_Isabel`, `America/Bahia_Banderas`, `Asia/Kuala_Lumpur`, `Asia/Kuching`,
               `Africa/Maputo`, `Africa/Windhoek`, `Pacific/Noumea`, `Africa/Niamey`, `Pacific/Norfolk`, `Africa/Lagos`,
               `America/Managua`, `Europe/Amsterdam`, `Europe/Oslo`, `Asia/Kathmandu`, `Pacific/Nauru`, `Pacific/Niue`,
               `Pacific/Auckland`, `Pacific/Chatham`, `Asia/Muscat`, `America/Panama`, `America/Lima`, `Pacific/Tahiti`,
               `Pacific/Marquesas`, `Pacific/Gambier`, `Pacific/Port_Moresby`, `Asia/Manila`, `Asia/Karachi`, `Europe/Warsaw`,
               `America/Miquelon`, `Pacific/Pitcairn`, `America/Puerto_Rico`, `Asia/Gaza`, `Asia/Hebron`, `Europe/Lisbon`,
               `Atlantic/Madeira`, `Atlantic/Azores`, `Pacific/Palau`, `America/Asuncion`, `Asia/Qatar`, `Indian/Reunion`,
               `Europe/Bucharest`, `Europe/Belgrade`, `Europe/Kaliningrad`, `Europe/Moscow`, `Europe/Volgograd`, `Europe/Samara`,
               `Asia/Yekaterinburg`, `Asia/Omsk`, `Asia/Novosibirsk`, `Asia/Novokuznetsk`, `Asia/Krasnoyarsk`, `Asia/Irkutsk`,
               `Asia/Yakutsk`, `Asia/Khandyga`, `Asia/Vladivostok`, `Asia/Sakhalin`, `Asia/Ust-Nera`, `Asia/Magadan`, `Asia/Kamchatka`,
               `Asia/Anadyr`, `Africa/Kigali`, `Asia/Riyadh`, `Pacific/Guadalcanal`, `Indian/Mahe`, `Africa/Khartoum`,
               `Europe/Stockholm`, `Asia/Singapore`, `Atlantic/St_Helena`, `Europe/Ljubljana`, `Arctic/Longyearbyen`,
               `Europe/Bratislava`, `Africa/Freetown`, `Europe/San_Marino`, `Africa/Dakar`, `Africa/Mogadishu`, `America/Paramaribo`,
               `Africa/Juba`, `Africa/Sao_Tome`, `America/El_Salvador`, `America/Lower_Princes`, `Asia/Damascus`, `Africa/Mbabane`,
               `America/Grand_Turk`, `Africa/Ndjamena`, `Indian/Kerguelen`, `Africa/Lome`, `Asia/Bangkok`, `Asia/Dushanbe`,
               `Pacific/Fakaofo`, `Asia/Dili`, `Asia/Ashgabat`, `Africa/Tunis`, `Pacific/Tongatapu`, `Europe/Istanbul`,
               `America/Port_of_Spain`, `Pacific/Funafuti`, `Asia/Taipei`, `Africa/Dar_es_Salaam`, `Europe/Kiev`, `Europe/Uzhgorod`,
               `Europe/Zaporozhye`, `Europe/Simferopol`, `Africa/Kampala`, `Pacific/Johnston`, `Pacific/Midway`, `Pacific/Wake`,
               `America/New_York`, `America/Detroit`, `America/Kentucky/Louisville`, `America/Kentucky/Monticello`,
               `America/Indiana/Indianapolis`, `America/Indiana/Vincennes`, `America/Indiana/Winamac`, `America/Indiana/Marengo`,
               `America/Indiana/Petersburg`, `America/Indiana/Vevay`, `America/Chicago`, `America/Indiana/Tell_City`,
               `America/Indiana/Knox`, `America/Menominee`, `America/North_Dakota/Center`, `America/North_Dakota/New_Salem`,
               `America/North_Dakota/Beulah`, `America/Denver`, `America/Boise`, `America/Phoenix`, `America/Los_Angeles`,
               `America/Anchorage`, `America/Juneau`, `America/Sitka`, `America/Yakutat`, `America/Nome`, `America/Adak`,
               `America/Metlakatla`, `Pacific/Honolulu`, `America/Montevideo`, `Asia/Samarkand`, `Asia/Tashkent`, `Europe/Vatican`,
               `America/St_Vincent`, `America/Caracas`, `America/Tortola`, `America/St_Thomas`, `Asia/Ho_Chi_Minh`, `Pacific/Efate`,
               `Pacific/Wallis`, `Pacific/Apia`, `Asia/Aden`, `Indian/Mayotte`, `Africa/Johannesburg`, `Africa/Lusaka`,
               `Africa/Harare`, `UTC` - Default value: `UTC`
        :param pulumi.Input[str] timezone_variable: Variable name
        :param pulumi.Input[bool] track_default_gateway: Enable or disable default gateway tracking - Default value: `true`
        :param pulumi.Input[str] track_default_gateway_variable: Variable name
        :param pulumi.Input[int] track_interface_tag: OMP Tag attached to routes based on interface tracking - Range: `1`-`4294967295`
        :param pulumi.Input[str] track_interface_tag_variable: Variable name
        :param pulumi.Input[bool] track_transport: Configure tracking of transport - Default value: `true`
        :param pulumi.Input[str] track_transport_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateTrackerArgs']]] trackers: Tracker configuration
        :param pulumi.Input[bool] transport_gateway: Enable transport gateway - Default value: `false`
        :param pulumi.Input[str] transport_gateway_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if admin_tech_on_failure is not None:
            pulumi.set(__self__, "admin_tech_on_failure", admin_tech_on_failure)
        if admin_tech_on_failure_variable is not None:
            pulumi.set(__self__, "admin_tech_on_failure_variable", admin_tech_on_failure_variable)
        if affinity_group_number is not None:
            pulumi.set(__self__, "affinity_group_number", affinity_group_number)
        if affinity_group_number_variable is not None:
            pulumi.set(__self__, "affinity_group_number_variable", affinity_group_number_variable)
        if affinity_group_preference_variable is not None:
            pulumi.set(__self__, "affinity_group_preference_variable", affinity_group_preference_variable)
        if affinity_group_preferences is not None:
            pulumi.set(__self__, "affinity_group_preferences", affinity_group_preferences)
        if console_baud_rate is not None:
            pulumi.set(__self__, "console_baud_rate", console_baud_rate)
        if console_baud_rate_variable is not None:
            pulumi.set(__self__, "console_baud_rate_variable", console_baud_rate_variable)
        if control_session_pps is not None:
            pulumi.set(__self__, "control_session_pps", control_session_pps)
        if control_session_pps_variable is not None:
            pulumi.set(__self__, "control_session_pps_variable", control_session_pps_variable)
        if controller_group_list_variable is not None:
            pulumi.set(__self__, "controller_group_list_variable", controller_group_list_variable)
        if controller_group_lists is not None:
            pulumi.set(__self__, "controller_group_lists", controller_group_lists)
        if device_groups is not None:
            pulumi.set(__self__, "device_groups", device_groups)
        if device_groups_variable is not None:
            pulumi.set(__self__, "device_groups_variable", device_groups_variable)
        if enable_mrf_migration is not None:
            pulumi.set(__self__, "enable_mrf_migration", enable_mrf_migration)
        if geo_fencing is not None:
            pulumi.set(__self__, "geo_fencing", geo_fencing)
        if geo_fencing_range is not None:
            pulumi.set(__self__, "geo_fencing_range", geo_fencing_range)
        if geo_fencing_range_variable is not None:
            pulumi.set(__self__, "geo_fencing_range_variable", geo_fencing_range_variable)
        if geo_fencing_sms is not None:
            pulumi.set(__self__, "geo_fencing_sms", geo_fencing_sms)
        if geo_fencing_sms_phone_numbers is not None:
            pulumi.set(__self__, "geo_fencing_sms_phone_numbers", geo_fencing_sms_phone_numbers)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hostname_variable is not None:
            pulumi.set(__self__, "hostname_variable", hostname_variable)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if idle_timeout_variable is not None:
            pulumi.set(__self__, "idle_timeout_variable", idle_timeout_variable)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if latitude_variable is not None:
            pulumi.set(__self__, "latitude_variable", latitude_variable)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_variable is not None:
            pulumi.set(__self__, "location_variable", location_variable)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if longitude_variable is not None:
            pulumi.set(__self__, "longitude_variable", longitude_variable)
        if max_omp_sessions is not None:
            pulumi.set(__self__, "max_omp_sessions", max_omp_sessions)
        if max_omp_sessions_variable is not None:
            pulumi.set(__self__, "max_omp_sessions_variable", max_omp_sessions_variable)
        if migration_bgp_community is not None:
            pulumi.set(__self__, "migration_bgp_community", migration_bgp_community)
        if multi_tenant is not None:
            pulumi.set(__self__, "multi_tenant", multi_tenant)
        if multi_tenant_variable is not None:
            pulumi.set(__self__, "multi_tenant_variable", multi_tenant_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_trackers is not None:
            pulumi.set(__self__, "object_trackers", object_trackers)
        if on_demand_tunnel is not None:
            pulumi.set(__self__, "on_demand_tunnel", on_demand_tunnel)
        if on_demand_tunnel_idle_timeout is not None:
            pulumi.set(__self__, "on_demand_tunnel_idle_timeout", on_demand_tunnel_idle_timeout)
        if on_demand_tunnel_idle_timeout_variable is not None:
            pulumi.set(__self__, "on_demand_tunnel_idle_timeout_variable", on_demand_tunnel_idle_timeout_variable)
        if on_demand_tunnel_variable is not None:
            pulumi.set(__self__, "on_demand_tunnel_variable", on_demand_tunnel_variable)
        if overlay_id is not None:
            pulumi.set(__self__, "overlay_id", overlay_id)
        if overlay_id_variable is not None:
            pulumi.set(__self__, "overlay_id_variable", overlay_id_variable)
        if port_hopping is not None:
            pulumi.set(__self__, "port_hopping", port_hopping)
        if port_hopping_variable is not None:
            pulumi.set(__self__, "port_hopping_variable", port_hopping_variable)
        if port_offset is not None:
            pulumi.set(__self__, "port_offset", port_offset)
        if port_offset_variable is not None:
            pulumi.set(__self__, "port_offset_variable", port_offset_variable)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if region_id_variable is not None:
            pulumi.set(__self__, "region_id_variable", region_id_variable)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if role_variable is not None:
            pulumi.set(__self__, "role_variable", role_variable)
        if secondary_region_id is not None:
            pulumi.set(__self__, "secondary_region_id", secondary_region_id)
        if secondary_region_id_variable is not None:
            pulumi.set(__self__, "secondary_region_id_variable", secondary_region_id_variable)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_id_variable is not None:
            pulumi.set(__self__, "site_id_variable", site_id_variable)
        if system_description is not None:
            pulumi.set(__self__, "system_description", system_description)
        if system_description_variable is not None:
            pulumi.set(__self__, "system_description_variable", system_description_variable)
        if system_ip is not None:
            pulumi.set(__self__, "system_ip", system_ip)
        if system_ip_variable is not None:
            pulumi.set(__self__, "system_ip_variable", system_ip_variable)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if timezone_variable is not None:
            pulumi.set(__self__, "timezone_variable", timezone_variable)
        if track_default_gateway is not None:
            pulumi.set(__self__, "track_default_gateway", track_default_gateway)
        if track_default_gateway_variable is not None:
            pulumi.set(__self__, "track_default_gateway_variable", track_default_gateway_variable)
        if track_interface_tag is not None:
            pulumi.set(__self__, "track_interface_tag", track_interface_tag)
        if track_interface_tag_variable is not None:
            pulumi.set(__self__, "track_interface_tag_variable", track_interface_tag_variable)
        if track_transport is not None:
            pulumi.set(__self__, "track_transport", track_transport)
        if track_transport_variable is not None:
            pulumi.set(__self__, "track_transport_variable", track_transport_variable)
        if trackers is not None:
            pulumi.set(__self__, "trackers", trackers)
        if transport_gateway is not None:
            pulumi.set(__self__, "transport_gateway", transport_gateway)
        if transport_gateway_variable is not None:
            pulumi.set(__self__, "transport_gateway_variable", transport_gateway_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="adminTechOnFailure")
    def admin_tech_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Collect admin-tech before reboot due to daemon failure - Default value: `true`
        """
        return pulumi.get(self, "admin_tech_on_failure")

    @admin_tech_on_failure.setter
    def admin_tech_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_tech_on_failure", value)

    @property
    @pulumi.getter(name="adminTechOnFailureVariable")
    def admin_tech_on_failure_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "admin_tech_on_failure_variable")

    @admin_tech_on_failure_variable.setter
    def admin_tech_on_failure_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_tech_on_failure_variable", value)

    @property
    @pulumi.getter(name="affinityGroupNumber")
    def affinity_group_number(self) -> Optional[pulumi.Input[int]]:
        """
        Set the affinity group number for router - Range: `1`-`255`
        """
        return pulumi.get(self, "affinity_group_number")

    @affinity_group_number.setter
    def affinity_group_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "affinity_group_number", value)

    @property
    @pulumi.getter(name="affinityGroupNumberVariable")
    def affinity_group_number_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "affinity_group_number_variable")

    @affinity_group_number_variable.setter
    def affinity_group_number_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "affinity_group_number_variable", value)

    @property
    @pulumi.getter(name="affinityGroupPreferenceVariable")
    def affinity_group_preference_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "affinity_group_preference_variable")

    @affinity_group_preference_variable.setter
    def affinity_group_preference_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "affinity_group_preference_variable", value)

    @property
    @pulumi.getter(name="affinityGroupPreferences")
    def affinity_group_preferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Set the affinity group preference
        """
        return pulumi.get(self, "affinity_group_preferences")

    @affinity_group_preferences.setter
    def affinity_group_preferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "affinity_group_preferences", value)

    @property
    @pulumi.getter(name="consoleBaudRate")
    def console_baud_rate(self) -> Optional[pulumi.Input[str]]:
        """
        Set the console baud rate - Choices: `1200`, `2400`, `4800`, `9600`, `19200`, `38400`, `57600`, `115200` - Default
        value: `9600`
        """
        return pulumi.get(self, "console_baud_rate")

    @console_baud_rate.setter
    def console_baud_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "console_baud_rate", value)

    @property
    @pulumi.getter(name="consoleBaudRateVariable")
    def console_baud_rate_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "console_baud_rate_variable")

    @console_baud_rate_variable.setter
    def console_baud_rate_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "console_baud_rate_variable", value)

    @property
    @pulumi.getter(name="controlSessionPps")
    def control_session_pps(self) -> Optional[pulumi.Input[int]]:
        """
        Set the policer rate for control sessions - Range: `1`-`65535` - Default value: `300`
        """
        return pulumi.get(self, "control_session_pps")

    @control_session_pps.setter
    def control_session_pps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "control_session_pps", value)

    @property
    @pulumi.getter(name="controlSessionPpsVariable")
    def control_session_pps_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "control_session_pps_variable")

    @control_session_pps_variable.setter
    def control_session_pps_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_session_pps_variable", value)

    @property
    @pulumi.getter(name="controllerGroupListVariable")
    def controller_group_list_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_group_list_variable")

    @controller_group_list_variable.setter
    def controller_group_list_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_group_list_variable", value)

    @property
    @pulumi.getter(name="controllerGroupLists")
    def controller_group_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Configure a list of comma-separated device groups
        """
        return pulumi.get(self, "controller_group_lists")

    @controller_group_lists.setter
    def controller_group_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "controller_group_lists", value)

    @property
    @pulumi.getter(name="deviceGroups")
    def device_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Device groups (Use comma(,) for multiple groups)
        """
        return pulumi.get(self, "device_groups")

    @device_groups.setter
    def device_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_groups", value)

    @property
    @pulumi.getter(name="deviceGroupsVariable")
    def device_groups_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "device_groups_variable")

    @device_groups_variable.setter
    def device_groups_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_groups_variable", value)

    @property
    @pulumi.getter(name="enableMrfMigration")
    def enable_mrf_migration(self) -> Optional[pulumi.Input[str]]:
        """
        Enable migration mode to Multi-Region Fabric - Choices: `enabled`, `enabled-from-bgp-core`
        """
        return pulumi.get(self, "enable_mrf_migration")

    @enable_mrf_migration.setter
    def enable_mrf_migration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_mrf_migration", value)

    @property
    @pulumi.getter(name="geoFencing")
    def geo_fencing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Geo fencing - Default value: `false`
        """
        return pulumi.get(self, "geo_fencing")

    @geo_fencing.setter
    def geo_fencing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "geo_fencing", value)

    @property
    @pulumi.getter(name="geoFencingRange")
    def geo_fencing_range(self) -> Optional[pulumi.Input[int]]:
        """
        Set the device’s geo fencing range - Range: `100`-`10000` - Default value: `100`
        """
        return pulumi.get(self, "geo_fencing_range")

    @geo_fencing_range.setter
    def geo_fencing_range(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "geo_fencing_range", value)

    @property
    @pulumi.getter(name="geoFencingRangeVariable")
    def geo_fencing_range_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "geo_fencing_range_variable")

    @geo_fencing_range_variable.setter
    def geo_fencing_range_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "geo_fencing_range_variable", value)

    @property
    @pulumi.getter(name="geoFencingSms")
    def geo_fencing_sms(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Geo fencing - Default value: `false`
        """
        return pulumi.get(self, "geo_fencing_sms")

    @geo_fencing_sms.setter
    def geo_fencing_sms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "geo_fencing_sms", value)

    @property
    @pulumi.getter(name="geoFencingSmsPhoneNumbers")
    def geo_fencing_sms_phone_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs']]]]:
        """
        Set device’s geo fencing SMS phone number
        """
        return pulumi.get(self, "geo_fencing_sms_phone_numbers")

    @geo_fencing_sms_phone_numbers.setter
    def geo_fencing_sms_phone_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs']]]]):
        pulumi.set(self, "geo_fencing_sms_phone_numbers", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Set the hostname
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="hostnameVariable")
    def hostname_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hostname_variable")

    @hostname_variable.setter
    def hostname_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname_variable", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Idle CLI timeout in minutes - Range: `0`-`300`
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="idleTimeoutVariable")
    def idle_timeout_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "idle_timeout_variable")

    @idle_timeout_variable.setter
    def idle_timeout_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_timeout_variable", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[float]]:
        """
        Set the device’s physical latitude - Range: `-90`-`90`
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter(name="latitudeVariable")
    def latitude_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "latitude_variable")

    @latitude_variable.setter
    def latitude_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latitude_variable", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Set the location of the device
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationVariable")
    def location_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "location_variable")

    @location_variable.setter
    def location_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_variable", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[float]]:
        """
        Set the device’s physical longitude - Range: `-180`-`180`
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "longitude", value)

    @property
    @pulumi.getter(name="longitudeVariable")
    def longitude_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "longitude_variable")

    @longitude_variable.setter
    def longitude_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "longitude_variable", value)

    @property
    @pulumi.getter(name="maxOmpSessions")
    def max_omp_sessions(self) -> Optional[pulumi.Input[int]]:
        """
        Set the maximum number of OMP sessions <1..100> the device can have - Range: `1`-`100`
        """
        return pulumi.get(self, "max_omp_sessions")

    @max_omp_sessions.setter
    def max_omp_sessions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_omp_sessions", value)

    @property
    @pulumi.getter(name="maxOmpSessionsVariable")
    def max_omp_sessions_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "max_omp_sessions_variable")

    @max_omp_sessions_variable.setter
    def max_omp_sessions_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_omp_sessions_variable", value)

    @property
    @pulumi.getter(name="migrationBgpCommunity")
    def migration_bgp_community(self) -> Optional[pulumi.Input[int]]:
        """
        Set BGP community during migration from BGP-core based network - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "migration_bgp_community")

    @migration_bgp_community.setter
    def migration_bgp_community(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "migration_bgp_community", value)

    @property
    @pulumi.getter(name="multiTenant")
    def multi_tenant(self) -> Optional[pulumi.Input[bool]]:
        """
        Device is multi-tenant - Default value: `false`
        """
        return pulumi.get(self, "multi_tenant")

    @multi_tenant.setter
    def multi_tenant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_tenant", value)

    @property
    @pulumi.getter(name="multiTenantVariable")
    def multi_tenant_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multi_tenant_variable")

    @multi_tenant_variable.setter
    def multi_tenant_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_tenant_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectTrackers")
    def object_trackers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateObjectTrackerArgs']]]]:
        """
        Object Track configuration
        """
        return pulumi.get(self, "object_trackers")

    @object_trackers.setter
    def object_trackers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateObjectTrackerArgs']]]]):
        pulumi.set(self, "object_trackers", value)

    @property
    @pulumi.getter(name="onDemandTunnel")
    def on_demand_tunnel(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable On-demand Tunnel - Default value: `false`
        """
        return pulumi.get(self, "on_demand_tunnel")

    @on_demand_tunnel.setter
    def on_demand_tunnel(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_demand_tunnel", value)

    @property
    @pulumi.getter(name="onDemandTunnelIdleTimeout")
    def on_demand_tunnel_idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Idle CLI timeout in minutes - Range: `0`-`300`
        """
        return pulumi.get(self, "on_demand_tunnel_idle_timeout")

    @on_demand_tunnel_idle_timeout.setter
    def on_demand_tunnel_idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_demand_tunnel_idle_timeout", value)

    @property
    @pulumi.getter(name="onDemandTunnelIdleTimeoutVariable")
    def on_demand_tunnel_idle_timeout_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "on_demand_tunnel_idle_timeout_variable")

    @on_demand_tunnel_idle_timeout_variable.setter
    def on_demand_tunnel_idle_timeout_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_demand_tunnel_idle_timeout_variable", value)

    @property
    @pulumi.getter(name="onDemandTunnelVariable")
    def on_demand_tunnel_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "on_demand_tunnel_variable")

    @on_demand_tunnel_variable.setter
    def on_demand_tunnel_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_demand_tunnel_variable", value)

    @property
    @pulumi.getter(name="overlayId")
    def overlay_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set the Overlay ID - Range: `1`-`4294967295` - Default value: `1`
        """
        return pulumi.get(self, "overlay_id")

    @overlay_id.setter
    def overlay_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "overlay_id", value)

    @property
    @pulumi.getter(name="overlayIdVariable")
    def overlay_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "overlay_id_variable")

    @overlay_id_variable.setter
    def overlay_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overlay_id_variable", value)

    @property
    @pulumi.getter(name="portHopping")
    def port_hopping(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable port hopping - Default value: `true`
        """
        return pulumi.get(self, "port_hopping")

    @port_hopping.setter
    def port_hopping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "port_hopping", value)

    @property
    @pulumi.getter(name="portHoppingVariable")
    def port_hopping_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "port_hopping_variable")

    @port_hopping_variable.setter
    def port_hopping_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_hopping_variable", value)

    @property
    @pulumi.getter(name="portOffset")
    def port_offset(self) -> Optional[pulumi.Input[int]]:
        """
        Set the TLOC port offset when multiple devices are behind a NAT - Range: `0`-`19` - Default value: `0`
        """
        return pulumi.get(self, "port_offset")

    @port_offset.setter
    def port_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_offset", value)

    @property
    @pulumi.getter(name="portOffsetVariable")
    def port_offset_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "port_offset_variable")

    @port_offset_variable.setter
    def port_offset_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_offset_variable", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set region ID - Range: `1`-`63`
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter(name="regionIdVariable")
    def region_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "region_id_variable")

    @region_id_variable.setter
    def region_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id_variable", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Set the role for router - Choices: `edge-router`, `border-router`
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="roleVariable")
    def role_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "role_variable")

    @role_variable.setter
    def role_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_variable", value)

    @property
    @pulumi.getter(name="secondaryRegionId")
    def secondary_region_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set secondary region ID - Range: `1`-`63`
        """
        return pulumi.get(self, "secondary_region_id")

    @secondary_region_id.setter
    def secondary_region_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "secondary_region_id", value)

    @property
    @pulumi.getter(name="secondaryRegionIdVariable")
    def secondary_region_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_region_id_variable")

    @secondary_region_id_variable.setter
    def secondary_region_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_region_id_variable", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set the site identifier - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="siteIdVariable")
    def site_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "site_id_variable")

    @site_id_variable.setter
    def site_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_id_variable", value)

    @property
    @pulumi.getter(name="systemDescription")
    def system_description(self) -> Optional[pulumi.Input[str]]:
        """
        Set a text description of the device
        """
        return pulumi.get(self, "system_description")

    @system_description.setter
    def system_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_description", value)

    @property
    @pulumi.getter(name="systemDescriptionVariable")
    def system_description_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "system_description_variable")

    @system_description_variable.setter
    def system_description_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_description_variable", value)

    @property
    @pulumi.getter(name="systemIp")
    def system_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Set the system IP address
        """
        return pulumi.get(self, "system_ip")

    @system_ip.setter
    def system_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_ip", value)

    @property
    @pulumi.getter(name="systemIpVariable")
    def system_ip_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "system_ip_variable")

    @system_ip_variable.setter
    def system_ip_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_ip_variable", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Set the timezone - Choices: `Europe/Andorra`, `Asia/Dubai`, `Asia/Kabul`, `America/Antigua`, `America/Anguilla`,
        `Europe/Tirane`, `Asia/Yerevan`, `Africa/Luanda`, `Antarctica/McMurdo`, `Antarctica/Rothera`, `Antarctica/Palmer`,
        `Antarctica/Mawson`, `Antarctica/Davis`, `Antarctica/Casey`, `Antarctica/Vostok`, `Antarctica/DumontDUrville`,
        `Antarctica/Syowa`, `America/Argentina/Buenos_Aires`, `America/Argentina/Cordoba`, `America/Argentina/Salta`,
        `America/Argentina/Jujuy`, `America/Argentina/Tucuman`, `America/Argentina/Catamarca`, `America/Argentina/La_Rioja`,
        `America/Argentina/San_Juan`, `America/Argentina/Mendoza`, `America/Argentina/San_Luis`,
        `America/Argentina/Rio_Gallegos`, `America/Argentina/Ushuaia`, `Pacific/Pago_Pago`, `Europe/Vienna`,
        `Australia/Lord_Howe`, `Antarctica/Macquarie`, `Australia/Hobart`, `Australia/Currie`, `Australia/Melbourne`,
        `Australia/Sydney`, `Australia/Broken_Hill`, `Australia/Brisbane`, `Australia/Lindeman`, `Australia/Adelaide`,
        `Australia/Darwin`, `Australia/Perth`, `Australia/Eucla`, `America/Aruba`, `Europe/Mariehamn`, `Asia/Baku`,
        `Europe/Sarajevo`, `America/Barbados`, `Asia/Dhaka`, `Europe/Brussels`, `Africa/Ouagadougou`, `Europe/Sofia`,
        `Asia/Bahrain`, `Africa/Bujumbura`, `Africa/Porto-Novo`, `America/St_Barthelemy`, `Atlantic/Bermuda`, `Asia/Brunei`,
        `America/La_Paz`, `America/Kralendijk`, `America/Noronha`, `America/Belem`, `America/Fortaleza`, `America/Recife`,
        `America/Araguaina`, `America/Maceio`, `America/Bahia`, `America/Sao_Paulo`, `America/Campo_Grande`, `America/Cuiaba`,
        `America/Santarem`, `America/Porto_Velho`, `America/Boa_Vista`, `America/Manaus`, `America/Eirunepe`,
        `America/Rio_Branco`, `America/Nassau`, `Asia/Thimphu`, `Africa/Gaborone`, `Europe/Minsk`, `America/Belize`,
        `America/St_Johns`, `America/Halifax`, `America/Glace_Bay`, `America/Moncton`, `America/Goose_Bay`,
        `America/Blanc-Sablon`, `America/Toronto`, `America/Nipigon`, `America/Thunder_Bay`, `America/Iqaluit`,
        `America/Pangnirtung`, `America/Resolute`, `America/Atikokan`, `America/Rankin_Inlet`, `America/Winnipeg`,
        `America/Rainy_River`, `America/Regina`, `America/Swift_Current`, `America/Edmonton`, `America/Cambridge_Bay`,
        `America/Yellowknife`, `America/Inuvik`, `America/Creston`, `America/Dawson_Creek`, `America/Vancouver`,
        `America/Whitehorse`, `America/Dawson`, `Indian/Cocos`, `Africa/Kinshasa`, `Africa/Lubumbashi`, `Africa/Bangui`,
        `Africa/Brazzaville`, `Europe/Zurich`, `Africa/Abidjan`, `Pacific/Rarotonga`, `America/Santiago`, `Pacific/Easter`,
        `Africa/Douala`, `Asia/Shanghai`, `Asia/Harbin`, `Asia/Chongqing`, `Asia/Urumqi`, `Asia/Kashgar`, `America/Bogota`,
        `America/Costa_Rica`, `America/Havana`, `Atlantic/Cape_Verde`, `America/Curacao`, `Indian/Christmas`, `Asia/Nicosia`,
        `Europe/Prague`, `Europe/Berlin`, `Europe/Busingen`, `Africa/Djibouti`, `Europe/Copenhagen`, `America/Dominica`,
        `America/Santo_Domingo`, `Africa/Algiers`, `America/Guayaquil`, `Pacific/Galapagos`, `Europe/Tallinn`, `Africa/Cairo`,
        `Africa/El_Aaiun`, `Africa/Asmara`, `Europe/Madrid`, `Africa/Ceuta`, `Atlantic/Canary`, `Africa/Addis_Ababa`,
        `Europe/Helsinki`, `Pacific/Fiji`, `Atlantic/Stanley`, `Pacific/Chuuk`, `Pacific/Pohnpei`, `Pacific/Kosrae`,
        `Atlantic/Faroe`, `Europe/Paris`, `Africa/Libreville`, `Europe/London`, `America/Grenada`, `Asia/Tbilisi`,
        `America/Cayenne`, `Europe/Guernsey`, `Africa/Accra`, `Europe/Gibraltar`, `America/Godthab`, `America/Danmarkshavn`,
        `America/Scoresbysund`, `America/Thule`, `Africa/Banjul`, `Africa/Conakry`, `America/Guadeloupe`, `Africa/Malabo`,
        `Europe/Athens`, `Atlantic/South_Georgia`, `America/Guatemala`, `Pacific/Guam`, `Africa/Bissau`, `America/Guyana`,
        `Asia/Hong_Kong`, `America/Tegucigalpa`, `Europe/Zagreb`, `America/Port-au-Prince`, `Europe/Budapest`, `Asia/Jakarta`,
        `Asia/Pontianak`, `Asia/Makassar`, `Asia/Jayapura`, `Europe/Dublin`, `Asia/Jerusalem`, `Europe/Isle_of_Man`,
        `Asia/Kolkata`, `Indian/Chagos`, `Asia/Baghdad`, `Asia/Tehran`, `Atlantic/Reykjavik`, `Europe/Rome`, `Europe/Jersey`,
        `America/Jamaica`, `Asia/Amman`, `Asia/Tokyo`, `Africa/Nairobi`, `Asia/Bishkek`, `Asia/Phnom_Penh`, `Pacific/Tarawa`,
        `Pacific/Enderbury`, `Pacific/Kiritimati`, `Indian/Comoro`, `America/St_Kitts`, `Asia/Pyongyang`, `Asia/Seoul`,
        `Asia/Kuwait`, `America/Cayman`, `Asia/Almaty`, `Asia/Qyzylorda`, `Asia/Aqtobe`, `Asia/Aqtau`, `Asia/Oral`,
        `Asia/Vientiane`, `Asia/Beirut`, `America/St_Lucia`, `Europe/Vaduz`, `Asia/Colombo`, `Africa/Monrovia`, `Africa/Maseru`,
        `Europe/Vilnius`, `Europe/Luxembourg`, `Europe/Riga`, `Africa/Tripoli`, `Africa/Casablanca`, `Europe/Monaco`,
        `Europe/Chisinau`, `Europe/Podgorica`, `America/Marigot`, `Indian/Antananarivo`, `Pacific/Majuro`, `Pacific/Kwajalein`,
        `Europe/Skopje`, `Africa/Bamako`, `Asia/Rangoon`, `Asia/Ulaanbaatar`, `Asia/Hovd`, `Asia/Choibalsan`, `Asia/Macau`,
        `Pacific/Saipan`, `America/Martinique`, `Africa/Nouakchott`, `America/Montserrat`, `Europe/Malta`, `Indian/Mauritius`,
        `Indian/Maldives`, `Africa/Blantyre`, `America/Mexico_City`, `America/Cancun`, `America/Merida`, `America/Monterrey`,
        `America/Matamoros`, `America/Mazatlan`, `America/Chihuahua`, `America/Ojinaga`, `America/Hermosillo`,
        `America/Tijuana`, `America/Santa_Isabel`, `America/Bahia_Banderas`, `Asia/Kuala_Lumpur`, `Asia/Kuching`,
        `Africa/Maputo`, `Africa/Windhoek`, `Pacific/Noumea`, `Africa/Niamey`, `Pacific/Norfolk`, `Africa/Lagos`,
        `America/Managua`, `Europe/Amsterdam`, `Europe/Oslo`, `Asia/Kathmandu`, `Pacific/Nauru`, `Pacific/Niue`,
        `Pacific/Auckland`, `Pacific/Chatham`, `Asia/Muscat`, `America/Panama`, `America/Lima`, `Pacific/Tahiti`,
        `Pacific/Marquesas`, `Pacific/Gambier`, `Pacific/Port_Moresby`, `Asia/Manila`, `Asia/Karachi`, `Europe/Warsaw`,
        `America/Miquelon`, `Pacific/Pitcairn`, `America/Puerto_Rico`, `Asia/Gaza`, `Asia/Hebron`, `Europe/Lisbon`,
        `Atlantic/Madeira`, `Atlantic/Azores`, `Pacific/Palau`, `America/Asuncion`, `Asia/Qatar`, `Indian/Reunion`,
        `Europe/Bucharest`, `Europe/Belgrade`, `Europe/Kaliningrad`, `Europe/Moscow`, `Europe/Volgograd`, `Europe/Samara`,
        `Asia/Yekaterinburg`, `Asia/Omsk`, `Asia/Novosibirsk`, `Asia/Novokuznetsk`, `Asia/Krasnoyarsk`, `Asia/Irkutsk`,
        `Asia/Yakutsk`, `Asia/Khandyga`, `Asia/Vladivostok`, `Asia/Sakhalin`, `Asia/Ust-Nera`, `Asia/Magadan`, `Asia/Kamchatka`,
        `Asia/Anadyr`, `Africa/Kigali`, `Asia/Riyadh`, `Pacific/Guadalcanal`, `Indian/Mahe`, `Africa/Khartoum`,
        `Europe/Stockholm`, `Asia/Singapore`, `Atlantic/St_Helena`, `Europe/Ljubljana`, `Arctic/Longyearbyen`,
        `Europe/Bratislava`, `Africa/Freetown`, `Europe/San_Marino`, `Africa/Dakar`, `Africa/Mogadishu`, `America/Paramaribo`,
        `Africa/Juba`, `Africa/Sao_Tome`, `America/El_Salvador`, `America/Lower_Princes`, `Asia/Damascus`, `Africa/Mbabane`,
        `America/Grand_Turk`, `Africa/Ndjamena`, `Indian/Kerguelen`, `Africa/Lome`, `Asia/Bangkok`, `Asia/Dushanbe`,
        `Pacific/Fakaofo`, `Asia/Dili`, `Asia/Ashgabat`, `Africa/Tunis`, `Pacific/Tongatapu`, `Europe/Istanbul`,
        `America/Port_of_Spain`, `Pacific/Funafuti`, `Asia/Taipei`, `Africa/Dar_es_Salaam`, `Europe/Kiev`, `Europe/Uzhgorod`,
        `Europe/Zaporozhye`, `Europe/Simferopol`, `Africa/Kampala`, `Pacific/Johnston`, `Pacific/Midway`, `Pacific/Wake`,
        `America/New_York`, `America/Detroit`, `America/Kentucky/Louisville`, `America/Kentucky/Monticello`,
        `America/Indiana/Indianapolis`, `America/Indiana/Vincennes`, `America/Indiana/Winamac`, `America/Indiana/Marengo`,
        `America/Indiana/Petersburg`, `America/Indiana/Vevay`, `America/Chicago`, `America/Indiana/Tell_City`,
        `America/Indiana/Knox`, `America/Menominee`, `America/North_Dakota/Center`, `America/North_Dakota/New_Salem`,
        `America/North_Dakota/Beulah`, `America/Denver`, `America/Boise`, `America/Phoenix`, `America/Los_Angeles`,
        `America/Anchorage`, `America/Juneau`, `America/Sitka`, `America/Yakutat`, `America/Nome`, `America/Adak`,
        `America/Metlakatla`, `Pacific/Honolulu`, `America/Montevideo`, `Asia/Samarkand`, `Asia/Tashkent`, `Europe/Vatican`,
        `America/St_Vincent`, `America/Caracas`, `America/Tortola`, `America/St_Thomas`, `Asia/Ho_Chi_Minh`, `Pacific/Efate`,
        `Pacific/Wallis`, `Pacific/Apia`, `Asia/Aden`, `Indian/Mayotte`, `Africa/Johannesburg`, `Africa/Lusaka`,
        `Africa/Harare`, `UTC` - Default value: `UTC`
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="timezoneVariable")
    def timezone_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timezone_variable")

    @timezone_variable.setter
    def timezone_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone_variable", value)

    @property
    @pulumi.getter(name="trackDefaultGateway")
    def track_default_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable default gateway tracking - Default value: `true`
        """
        return pulumi.get(self, "track_default_gateway")

    @track_default_gateway.setter
    def track_default_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "track_default_gateway", value)

    @property
    @pulumi.getter(name="trackDefaultGatewayVariable")
    def track_default_gateway_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "track_default_gateway_variable")

    @track_default_gateway_variable.setter
    def track_default_gateway_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "track_default_gateway_variable", value)

    @property
    @pulumi.getter(name="trackInterfaceTag")
    def track_interface_tag(self) -> Optional[pulumi.Input[int]]:
        """
        OMP Tag attached to routes based on interface tracking - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "track_interface_tag")

    @track_interface_tag.setter
    def track_interface_tag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "track_interface_tag", value)

    @property
    @pulumi.getter(name="trackInterfaceTagVariable")
    def track_interface_tag_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "track_interface_tag_variable")

    @track_interface_tag_variable.setter
    def track_interface_tag_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "track_interface_tag_variable", value)

    @property
    @pulumi.getter(name="trackTransport")
    def track_transport(self) -> Optional[pulumi.Input[bool]]:
        """
        Configure tracking of transport - Default value: `true`
        """
        return pulumi.get(self, "track_transport")

    @track_transport.setter
    def track_transport(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "track_transport", value)

    @property
    @pulumi.getter(name="trackTransportVariable")
    def track_transport_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "track_transport_variable")

    @track_transport_variable.setter
    def track_transport_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "track_transport_variable", value)

    @property
    @pulumi.getter
    def trackers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateTrackerArgs']]]]:
        """
        Tracker configuration
        """
        return pulumi.get(self, "trackers")

    @trackers.setter
    def trackers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateTrackerArgs']]]]):
        pulumi.set(self, "trackers", value)

    @property
    @pulumi.getter(name="transportGateway")
    def transport_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable transport gateway - Default value: `false`
        """
        return pulumi.get(self, "transport_gateway")

    @transport_gateway.setter
    def transport_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "transport_gateway", value)

    @property
    @pulumi.getter(name="transportGatewayVariable")
    def transport_gateway_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "transport_gateway_variable")

    @transport_gateway_variable.setter
    def transport_gateway_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transport_gateway_variable", value)


@pulumi.input_type
class _CiscoSystemFeatureTemplateState:
    def __init__(__self__, *,
                 admin_tech_on_failure: Optional[pulumi.Input[bool]] = None,
                 admin_tech_on_failure_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_number: Optional[pulumi.Input[int]] = None,
                 affinity_group_number_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_preference_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 console_baud_rate: Optional[pulumi.Input[str]] = None,
                 console_baud_rate_variable: Optional[pulumi.Input[str]] = None,
                 control_session_pps: Optional[pulumi.Input[int]] = None,
                 control_session_pps_variable: Optional[pulumi.Input[str]] = None,
                 controller_group_list_variable: Optional[pulumi.Input[str]] = None,
                 controller_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_groups_variable: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_mrf_migration: Optional[pulumi.Input[str]] = None,
                 geo_fencing: Optional[pulumi.Input[bool]] = None,
                 geo_fencing_range: Optional[pulumi.Input[int]] = None,
                 geo_fencing_range_variable: Optional[pulumi.Input[str]] = None,
                 geo_fencing_sms: Optional[pulumi.Input[bool]] = None,
                 geo_fencing_sms_phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs']]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hostname_variable: Optional[pulumi.Input[str]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 idle_timeout_variable: Optional[pulumi.Input[str]] = None,
                 latitude: Optional[pulumi.Input[float]] = None,
                 latitude_variable: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_variable: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[float]] = None,
                 longitude_variable: Optional[pulumi.Input[str]] = None,
                 max_omp_sessions: Optional[pulumi.Input[int]] = None,
                 max_omp_sessions_variable: Optional[pulumi.Input[str]] = None,
                 migration_bgp_community: Optional[pulumi.Input[int]] = None,
                 multi_tenant: Optional[pulumi.Input[bool]] = None,
                 multi_tenant_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_trackers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateObjectTrackerArgs']]]] = None,
                 on_demand_tunnel: Optional[pulumi.Input[bool]] = None,
                 on_demand_tunnel_idle_timeout: Optional[pulumi.Input[int]] = None,
                 on_demand_tunnel_idle_timeout_variable: Optional[pulumi.Input[str]] = None,
                 on_demand_tunnel_variable: Optional[pulumi.Input[str]] = None,
                 overlay_id: Optional[pulumi.Input[int]] = None,
                 overlay_id_variable: Optional[pulumi.Input[str]] = None,
                 port_hopping: Optional[pulumi.Input[bool]] = None,
                 port_hopping_variable: Optional[pulumi.Input[str]] = None,
                 port_offset: Optional[pulumi.Input[int]] = None,
                 port_offset_variable: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[int]] = None,
                 region_id_variable: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 role_variable: Optional[pulumi.Input[str]] = None,
                 secondary_region_id: Optional[pulumi.Input[int]] = None,
                 secondary_region_id_variable: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 site_id_variable: Optional[pulumi.Input[str]] = None,
                 system_description: Optional[pulumi.Input[str]] = None,
                 system_description_variable: Optional[pulumi.Input[str]] = None,
                 system_ip: Optional[pulumi.Input[str]] = None,
                 system_ip_variable: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 timezone_variable: Optional[pulumi.Input[str]] = None,
                 track_default_gateway: Optional[pulumi.Input[bool]] = None,
                 track_default_gateway_variable: Optional[pulumi.Input[str]] = None,
                 track_interface_tag: Optional[pulumi.Input[int]] = None,
                 track_interface_tag_variable: Optional[pulumi.Input[str]] = None,
                 track_transport: Optional[pulumi.Input[bool]] = None,
                 track_transport_variable: Optional[pulumi.Input[str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateTrackerArgs']]]] = None,
                 transport_gateway: Optional[pulumi.Input[bool]] = None,
                 transport_gateway_variable: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CiscoSystemFeatureTemplate resources.
        :param pulumi.Input[bool] admin_tech_on_failure: Collect admin-tech before reboot due to daemon failure - Default value: `true`
        :param pulumi.Input[str] admin_tech_on_failure_variable: Variable name
        :param pulumi.Input[int] affinity_group_number: Set the affinity group number for router - Range: `1`-`255`
        :param pulumi.Input[str] affinity_group_number_variable: Variable name
        :param pulumi.Input[str] affinity_group_preference_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] affinity_group_preferences: Set the affinity group preference
        :param pulumi.Input[str] console_baud_rate: Set the console baud rate - Choices: `1200`, `2400`, `4800`, `9600`, `19200`, `38400`, `57600`, `115200` - Default
               value: `9600`
        :param pulumi.Input[str] console_baud_rate_variable: Variable name
        :param pulumi.Input[int] control_session_pps: Set the policer rate for control sessions - Range: `1`-`65535` - Default value: `300`
        :param pulumi.Input[str] control_session_pps_variable: Variable name
        :param pulumi.Input[str] controller_group_list_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] controller_group_lists: Configure a list of comma-separated device groups
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_groups: Device groups (Use comma(,) for multiple groups)
        :param pulumi.Input[str] device_groups_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] enable_mrf_migration: Enable migration mode to Multi-Region Fabric - Choices: `enabled`, `enabled-from-bgp-core`
        :param pulumi.Input[bool] geo_fencing: Enable Geo fencing - Default value: `false`
        :param pulumi.Input[int] geo_fencing_range: Set the device’s geo fencing range - Range: `100`-`10000` - Default value: `100`
        :param pulumi.Input[str] geo_fencing_range_variable: Variable name
        :param pulumi.Input[bool] geo_fencing_sms: Enable Geo fencing - Default value: `false`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs']]] geo_fencing_sms_phone_numbers: Set device’s geo fencing SMS phone number
        :param pulumi.Input[str] hostname: Set the hostname
        :param pulumi.Input[str] hostname_variable: Variable name
        :param pulumi.Input[int] idle_timeout: Idle CLI timeout in minutes - Range: `0`-`300`
        :param pulumi.Input[str] idle_timeout_variable: Variable name
        :param pulumi.Input[float] latitude: Set the device’s physical latitude - Range: `-90`-`90`
        :param pulumi.Input[str] latitude_variable: Variable name
        :param pulumi.Input[str] location: Set the location of the device
        :param pulumi.Input[str] location_variable: Variable name
        :param pulumi.Input[float] longitude: Set the device’s physical longitude - Range: `-180`-`180`
        :param pulumi.Input[str] longitude_variable: Variable name
        :param pulumi.Input[int] max_omp_sessions: Set the maximum number of OMP sessions <1..100> the device can have - Range: `1`-`100`
        :param pulumi.Input[str] max_omp_sessions_variable: Variable name
        :param pulumi.Input[int] migration_bgp_community: Set BGP community during migration from BGP-core based network - Range: `1`-`4294967295`
        :param pulumi.Input[bool] multi_tenant: Device is multi-tenant - Default value: `false`
        :param pulumi.Input[str] multi_tenant_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateObjectTrackerArgs']]] object_trackers: Object Track configuration
        :param pulumi.Input[bool] on_demand_tunnel: Enable or disable On-demand Tunnel - Default value: `false`
        :param pulumi.Input[int] on_demand_tunnel_idle_timeout: Idle CLI timeout in minutes - Range: `0`-`300`
        :param pulumi.Input[str] on_demand_tunnel_idle_timeout_variable: Variable name
        :param pulumi.Input[str] on_demand_tunnel_variable: Variable name
        :param pulumi.Input[int] overlay_id: Set the Overlay ID - Range: `1`-`4294967295` - Default value: `1`
        :param pulumi.Input[str] overlay_id_variable: Variable name
        :param pulumi.Input[bool] port_hopping: Enable port hopping - Default value: `true`
        :param pulumi.Input[str] port_hopping_variable: Variable name
        :param pulumi.Input[int] port_offset: Set the TLOC port offset when multiple devices are behind a NAT - Range: `0`-`19` - Default value: `0`
        :param pulumi.Input[str] port_offset_variable: Variable name
        :param pulumi.Input[int] region_id: Set region ID - Range: `1`-`63`
        :param pulumi.Input[str] region_id_variable: Variable name
        :param pulumi.Input[str] role: Set the role for router - Choices: `edge-router`, `border-router`
        :param pulumi.Input[str] role_variable: Variable name
        :param pulumi.Input[int] secondary_region_id: Set secondary region ID - Range: `1`-`63`
        :param pulumi.Input[str] secondary_region_id_variable: Variable name
        :param pulumi.Input[int] site_id: Set the site identifier - Range: `1`-`4294967295`
        :param pulumi.Input[str] site_id_variable: Variable name
        :param pulumi.Input[str] system_description: Set a text description of the device
        :param pulumi.Input[str] system_description_variable: Variable name
        :param pulumi.Input[str] system_ip: Set the system IP address
        :param pulumi.Input[str] system_ip_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[str] timezone: Set the timezone - Choices: `Europe/Andorra`, `Asia/Dubai`, `Asia/Kabul`, `America/Antigua`, `America/Anguilla`,
               `Europe/Tirane`, `Asia/Yerevan`, `Africa/Luanda`, `Antarctica/McMurdo`, `Antarctica/Rothera`, `Antarctica/Palmer`,
               `Antarctica/Mawson`, `Antarctica/Davis`, `Antarctica/Casey`, `Antarctica/Vostok`, `Antarctica/DumontDUrville`,
               `Antarctica/Syowa`, `America/Argentina/Buenos_Aires`, `America/Argentina/Cordoba`, `America/Argentina/Salta`,
               `America/Argentina/Jujuy`, `America/Argentina/Tucuman`, `America/Argentina/Catamarca`, `America/Argentina/La_Rioja`,
               `America/Argentina/San_Juan`, `America/Argentina/Mendoza`, `America/Argentina/San_Luis`,
               `America/Argentina/Rio_Gallegos`, `America/Argentina/Ushuaia`, `Pacific/Pago_Pago`, `Europe/Vienna`,
               `Australia/Lord_Howe`, `Antarctica/Macquarie`, `Australia/Hobart`, `Australia/Currie`, `Australia/Melbourne`,
               `Australia/Sydney`, `Australia/Broken_Hill`, `Australia/Brisbane`, `Australia/Lindeman`, `Australia/Adelaide`,
               `Australia/Darwin`, `Australia/Perth`, `Australia/Eucla`, `America/Aruba`, `Europe/Mariehamn`, `Asia/Baku`,
               `Europe/Sarajevo`, `America/Barbados`, `Asia/Dhaka`, `Europe/Brussels`, `Africa/Ouagadougou`, `Europe/Sofia`,
               `Asia/Bahrain`, `Africa/Bujumbura`, `Africa/Porto-Novo`, `America/St_Barthelemy`, `Atlantic/Bermuda`, `Asia/Brunei`,
               `America/La_Paz`, `America/Kralendijk`, `America/Noronha`, `America/Belem`, `America/Fortaleza`, `America/Recife`,
               `America/Araguaina`, `America/Maceio`, `America/Bahia`, `America/Sao_Paulo`, `America/Campo_Grande`, `America/Cuiaba`,
               `America/Santarem`, `America/Porto_Velho`, `America/Boa_Vista`, `America/Manaus`, `America/Eirunepe`,
               `America/Rio_Branco`, `America/Nassau`, `Asia/Thimphu`, `Africa/Gaborone`, `Europe/Minsk`, `America/Belize`,
               `America/St_Johns`, `America/Halifax`, `America/Glace_Bay`, `America/Moncton`, `America/Goose_Bay`,
               `America/Blanc-Sablon`, `America/Toronto`, `America/Nipigon`, `America/Thunder_Bay`, `America/Iqaluit`,
               `America/Pangnirtung`, `America/Resolute`, `America/Atikokan`, `America/Rankin_Inlet`, `America/Winnipeg`,
               `America/Rainy_River`, `America/Regina`, `America/Swift_Current`, `America/Edmonton`, `America/Cambridge_Bay`,
               `America/Yellowknife`, `America/Inuvik`, `America/Creston`, `America/Dawson_Creek`, `America/Vancouver`,
               `America/Whitehorse`, `America/Dawson`, `Indian/Cocos`, `Africa/Kinshasa`, `Africa/Lubumbashi`, `Africa/Bangui`,
               `Africa/Brazzaville`, `Europe/Zurich`, `Africa/Abidjan`, `Pacific/Rarotonga`, `America/Santiago`, `Pacific/Easter`,
               `Africa/Douala`, `Asia/Shanghai`, `Asia/Harbin`, `Asia/Chongqing`, `Asia/Urumqi`, `Asia/Kashgar`, `America/Bogota`,
               `America/Costa_Rica`, `America/Havana`, `Atlantic/Cape_Verde`, `America/Curacao`, `Indian/Christmas`, `Asia/Nicosia`,
               `Europe/Prague`, `Europe/Berlin`, `Europe/Busingen`, `Africa/Djibouti`, `Europe/Copenhagen`, `America/Dominica`,
               `America/Santo_Domingo`, `Africa/Algiers`, `America/Guayaquil`, `Pacific/Galapagos`, `Europe/Tallinn`, `Africa/Cairo`,
               `Africa/El_Aaiun`, `Africa/Asmara`, `Europe/Madrid`, `Africa/Ceuta`, `Atlantic/Canary`, `Africa/Addis_Ababa`,
               `Europe/Helsinki`, `Pacific/Fiji`, `Atlantic/Stanley`, `Pacific/Chuuk`, `Pacific/Pohnpei`, `Pacific/Kosrae`,
               `Atlantic/Faroe`, `Europe/Paris`, `Africa/Libreville`, `Europe/London`, `America/Grenada`, `Asia/Tbilisi`,
               `America/Cayenne`, `Europe/Guernsey`, `Africa/Accra`, `Europe/Gibraltar`, `America/Godthab`, `America/Danmarkshavn`,
               `America/Scoresbysund`, `America/Thule`, `Africa/Banjul`, `Africa/Conakry`, `America/Guadeloupe`, `Africa/Malabo`,
               `Europe/Athens`, `Atlantic/South_Georgia`, `America/Guatemala`, `Pacific/Guam`, `Africa/Bissau`, `America/Guyana`,
               `Asia/Hong_Kong`, `America/Tegucigalpa`, `Europe/Zagreb`, `America/Port-au-Prince`, `Europe/Budapest`, `Asia/Jakarta`,
               `Asia/Pontianak`, `Asia/Makassar`, `Asia/Jayapura`, `Europe/Dublin`, `Asia/Jerusalem`, `Europe/Isle_of_Man`,
               `Asia/Kolkata`, `Indian/Chagos`, `Asia/Baghdad`, `Asia/Tehran`, `Atlantic/Reykjavik`, `Europe/Rome`, `Europe/Jersey`,
               `America/Jamaica`, `Asia/Amman`, `Asia/Tokyo`, `Africa/Nairobi`, `Asia/Bishkek`, `Asia/Phnom_Penh`, `Pacific/Tarawa`,
               `Pacific/Enderbury`, `Pacific/Kiritimati`, `Indian/Comoro`, `America/St_Kitts`, `Asia/Pyongyang`, `Asia/Seoul`,
               `Asia/Kuwait`, `America/Cayman`, `Asia/Almaty`, `Asia/Qyzylorda`, `Asia/Aqtobe`, `Asia/Aqtau`, `Asia/Oral`,
               `Asia/Vientiane`, `Asia/Beirut`, `America/St_Lucia`, `Europe/Vaduz`, `Asia/Colombo`, `Africa/Monrovia`, `Africa/Maseru`,
               `Europe/Vilnius`, `Europe/Luxembourg`, `Europe/Riga`, `Africa/Tripoli`, `Africa/Casablanca`, `Europe/Monaco`,
               `Europe/Chisinau`, `Europe/Podgorica`, `America/Marigot`, `Indian/Antananarivo`, `Pacific/Majuro`, `Pacific/Kwajalein`,
               `Europe/Skopje`, `Africa/Bamako`, `Asia/Rangoon`, `Asia/Ulaanbaatar`, `Asia/Hovd`, `Asia/Choibalsan`, `Asia/Macau`,
               `Pacific/Saipan`, `America/Martinique`, `Africa/Nouakchott`, `America/Montserrat`, `Europe/Malta`, `Indian/Mauritius`,
               `Indian/Maldives`, `Africa/Blantyre`, `America/Mexico_City`, `America/Cancun`, `America/Merida`, `America/Monterrey`,
               `America/Matamoros`, `America/Mazatlan`, `America/Chihuahua`, `America/Ojinaga`, `America/Hermosillo`,
               `America/Tijuana`, `America/Santa_Isabel`, `America/Bahia_Banderas`, `Asia/Kuala_Lumpur`, `Asia/Kuching`,
               `Africa/Maputo`, `Africa/Windhoek`, `Pacific/Noumea`, `Africa/Niamey`, `Pacific/Norfolk`, `Africa/Lagos`,
               `America/Managua`, `Europe/Amsterdam`, `Europe/Oslo`, `Asia/Kathmandu`, `Pacific/Nauru`, `Pacific/Niue`,
               `Pacific/Auckland`, `Pacific/Chatham`, `Asia/Muscat`, `America/Panama`, `America/Lima`, `Pacific/Tahiti`,
               `Pacific/Marquesas`, `Pacific/Gambier`, `Pacific/Port_Moresby`, `Asia/Manila`, `Asia/Karachi`, `Europe/Warsaw`,
               `America/Miquelon`, `Pacific/Pitcairn`, `America/Puerto_Rico`, `Asia/Gaza`, `Asia/Hebron`, `Europe/Lisbon`,
               `Atlantic/Madeira`, `Atlantic/Azores`, `Pacific/Palau`, `America/Asuncion`, `Asia/Qatar`, `Indian/Reunion`,
               `Europe/Bucharest`, `Europe/Belgrade`, `Europe/Kaliningrad`, `Europe/Moscow`, `Europe/Volgograd`, `Europe/Samara`,
               `Asia/Yekaterinburg`, `Asia/Omsk`, `Asia/Novosibirsk`, `Asia/Novokuznetsk`, `Asia/Krasnoyarsk`, `Asia/Irkutsk`,
               `Asia/Yakutsk`, `Asia/Khandyga`, `Asia/Vladivostok`, `Asia/Sakhalin`, `Asia/Ust-Nera`, `Asia/Magadan`, `Asia/Kamchatka`,
               `Asia/Anadyr`, `Africa/Kigali`, `Asia/Riyadh`, `Pacific/Guadalcanal`, `Indian/Mahe`, `Africa/Khartoum`,
               `Europe/Stockholm`, `Asia/Singapore`, `Atlantic/St_Helena`, `Europe/Ljubljana`, `Arctic/Longyearbyen`,
               `Europe/Bratislava`, `Africa/Freetown`, `Europe/San_Marino`, `Africa/Dakar`, `Africa/Mogadishu`, `America/Paramaribo`,
               `Africa/Juba`, `Africa/Sao_Tome`, `America/El_Salvador`, `America/Lower_Princes`, `Asia/Damascus`, `Africa/Mbabane`,
               `America/Grand_Turk`, `Africa/Ndjamena`, `Indian/Kerguelen`, `Africa/Lome`, `Asia/Bangkok`, `Asia/Dushanbe`,
               `Pacific/Fakaofo`, `Asia/Dili`, `Asia/Ashgabat`, `Africa/Tunis`, `Pacific/Tongatapu`, `Europe/Istanbul`,
               `America/Port_of_Spain`, `Pacific/Funafuti`, `Asia/Taipei`, `Africa/Dar_es_Salaam`, `Europe/Kiev`, `Europe/Uzhgorod`,
               `Europe/Zaporozhye`, `Europe/Simferopol`, `Africa/Kampala`, `Pacific/Johnston`, `Pacific/Midway`, `Pacific/Wake`,
               `America/New_York`, `America/Detroit`, `America/Kentucky/Louisville`, `America/Kentucky/Monticello`,
               `America/Indiana/Indianapolis`, `America/Indiana/Vincennes`, `America/Indiana/Winamac`, `America/Indiana/Marengo`,
               `America/Indiana/Petersburg`, `America/Indiana/Vevay`, `America/Chicago`, `America/Indiana/Tell_City`,
               `America/Indiana/Knox`, `America/Menominee`, `America/North_Dakota/Center`, `America/North_Dakota/New_Salem`,
               `America/North_Dakota/Beulah`, `America/Denver`, `America/Boise`, `America/Phoenix`, `America/Los_Angeles`,
               `America/Anchorage`, `America/Juneau`, `America/Sitka`, `America/Yakutat`, `America/Nome`, `America/Adak`,
               `America/Metlakatla`, `Pacific/Honolulu`, `America/Montevideo`, `Asia/Samarkand`, `Asia/Tashkent`, `Europe/Vatican`,
               `America/St_Vincent`, `America/Caracas`, `America/Tortola`, `America/St_Thomas`, `Asia/Ho_Chi_Minh`, `Pacific/Efate`,
               `Pacific/Wallis`, `Pacific/Apia`, `Asia/Aden`, `Indian/Mayotte`, `Africa/Johannesburg`, `Africa/Lusaka`,
               `Africa/Harare`, `UTC` - Default value: `UTC`
        :param pulumi.Input[str] timezone_variable: Variable name
        :param pulumi.Input[bool] track_default_gateway: Enable or disable default gateway tracking - Default value: `true`
        :param pulumi.Input[str] track_default_gateway_variable: Variable name
        :param pulumi.Input[int] track_interface_tag: OMP Tag attached to routes based on interface tracking - Range: `1`-`4294967295`
        :param pulumi.Input[str] track_interface_tag_variable: Variable name
        :param pulumi.Input[bool] track_transport: Configure tracking of transport - Default value: `true`
        :param pulumi.Input[str] track_transport_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateTrackerArgs']]] trackers: Tracker configuration
        :param pulumi.Input[bool] transport_gateway: Enable transport gateway - Default value: `false`
        :param pulumi.Input[str] transport_gateway_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        if admin_tech_on_failure is not None:
            pulumi.set(__self__, "admin_tech_on_failure", admin_tech_on_failure)
        if admin_tech_on_failure_variable is not None:
            pulumi.set(__self__, "admin_tech_on_failure_variable", admin_tech_on_failure_variable)
        if affinity_group_number is not None:
            pulumi.set(__self__, "affinity_group_number", affinity_group_number)
        if affinity_group_number_variable is not None:
            pulumi.set(__self__, "affinity_group_number_variable", affinity_group_number_variable)
        if affinity_group_preference_variable is not None:
            pulumi.set(__self__, "affinity_group_preference_variable", affinity_group_preference_variable)
        if affinity_group_preferences is not None:
            pulumi.set(__self__, "affinity_group_preferences", affinity_group_preferences)
        if console_baud_rate is not None:
            pulumi.set(__self__, "console_baud_rate", console_baud_rate)
        if console_baud_rate_variable is not None:
            pulumi.set(__self__, "console_baud_rate_variable", console_baud_rate_variable)
        if control_session_pps is not None:
            pulumi.set(__self__, "control_session_pps", control_session_pps)
        if control_session_pps_variable is not None:
            pulumi.set(__self__, "control_session_pps_variable", control_session_pps_variable)
        if controller_group_list_variable is not None:
            pulumi.set(__self__, "controller_group_list_variable", controller_group_list_variable)
        if controller_group_lists is not None:
            pulumi.set(__self__, "controller_group_lists", controller_group_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_groups is not None:
            pulumi.set(__self__, "device_groups", device_groups)
        if device_groups_variable is not None:
            pulumi.set(__self__, "device_groups_variable", device_groups_variable)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if enable_mrf_migration is not None:
            pulumi.set(__self__, "enable_mrf_migration", enable_mrf_migration)
        if geo_fencing is not None:
            pulumi.set(__self__, "geo_fencing", geo_fencing)
        if geo_fencing_range is not None:
            pulumi.set(__self__, "geo_fencing_range", geo_fencing_range)
        if geo_fencing_range_variable is not None:
            pulumi.set(__self__, "geo_fencing_range_variable", geo_fencing_range_variable)
        if geo_fencing_sms is not None:
            pulumi.set(__self__, "geo_fencing_sms", geo_fencing_sms)
        if geo_fencing_sms_phone_numbers is not None:
            pulumi.set(__self__, "geo_fencing_sms_phone_numbers", geo_fencing_sms_phone_numbers)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hostname_variable is not None:
            pulumi.set(__self__, "hostname_variable", hostname_variable)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if idle_timeout_variable is not None:
            pulumi.set(__self__, "idle_timeout_variable", idle_timeout_variable)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if latitude_variable is not None:
            pulumi.set(__self__, "latitude_variable", latitude_variable)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_variable is not None:
            pulumi.set(__self__, "location_variable", location_variable)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if longitude_variable is not None:
            pulumi.set(__self__, "longitude_variable", longitude_variable)
        if max_omp_sessions is not None:
            pulumi.set(__self__, "max_omp_sessions", max_omp_sessions)
        if max_omp_sessions_variable is not None:
            pulumi.set(__self__, "max_omp_sessions_variable", max_omp_sessions_variable)
        if migration_bgp_community is not None:
            pulumi.set(__self__, "migration_bgp_community", migration_bgp_community)
        if multi_tenant is not None:
            pulumi.set(__self__, "multi_tenant", multi_tenant)
        if multi_tenant_variable is not None:
            pulumi.set(__self__, "multi_tenant_variable", multi_tenant_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_trackers is not None:
            pulumi.set(__self__, "object_trackers", object_trackers)
        if on_demand_tunnel is not None:
            pulumi.set(__self__, "on_demand_tunnel", on_demand_tunnel)
        if on_demand_tunnel_idle_timeout is not None:
            pulumi.set(__self__, "on_demand_tunnel_idle_timeout", on_demand_tunnel_idle_timeout)
        if on_demand_tunnel_idle_timeout_variable is not None:
            pulumi.set(__self__, "on_demand_tunnel_idle_timeout_variable", on_demand_tunnel_idle_timeout_variable)
        if on_demand_tunnel_variable is not None:
            pulumi.set(__self__, "on_demand_tunnel_variable", on_demand_tunnel_variable)
        if overlay_id is not None:
            pulumi.set(__self__, "overlay_id", overlay_id)
        if overlay_id_variable is not None:
            pulumi.set(__self__, "overlay_id_variable", overlay_id_variable)
        if port_hopping is not None:
            pulumi.set(__self__, "port_hopping", port_hopping)
        if port_hopping_variable is not None:
            pulumi.set(__self__, "port_hopping_variable", port_hopping_variable)
        if port_offset is not None:
            pulumi.set(__self__, "port_offset", port_offset)
        if port_offset_variable is not None:
            pulumi.set(__self__, "port_offset_variable", port_offset_variable)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if region_id_variable is not None:
            pulumi.set(__self__, "region_id_variable", region_id_variable)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if role_variable is not None:
            pulumi.set(__self__, "role_variable", role_variable)
        if secondary_region_id is not None:
            pulumi.set(__self__, "secondary_region_id", secondary_region_id)
        if secondary_region_id_variable is not None:
            pulumi.set(__self__, "secondary_region_id_variable", secondary_region_id_variable)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_id_variable is not None:
            pulumi.set(__self__, "site_id_variable", site_id_variable)
        if system_description is not None:
            pulumi.set(__self__, "system_description", system_description)
        if system_description_variable is not None:
            pulumi.set(__self__, "system_description_variable", system_description_variable)
        if system_ip is not None:
            pulumi.set(__self__, "system_ip", system_ip)
        if system_ip_variable is not None:
            pulumi.set(__self__, "system_ip_variable", system_ip_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if timezone_variable is not None:
            pulumi.set(__self__, "timezone_variable", timezone_variable)
        if track_default_gateway is not None:
            pulumi.set(__self__, "track_default_gateway", track_default_gateway)
        if track_default_gateway_variable is not None:
            pulumi.set(__self__, "track_default_gateway_variable", track_default_gateway_variable)
        if track_interface_tag is not None:
            pulumi.set(__self__, "track_interface_tag", track_interface_tag)
        if track_interface_tag_variable is not None:
            pulumi.set(__self__, "track_interface_tag_variable", track_interface_tag_variable)
        if track_transport is not None:
            pulumi.set(__self__, "track_transport", track_transport)
        if track_transport_variable is not None:
            pulumi.set(__self__, "track_transport_variable", track_transport_variable)
        if trackers is not None:
            pulumi.set(__self__, "trackers", trackers)
        if transport_gateway is not None:
            pulumi.set(__self__, "transport_gateway", transport_gateway)
        if transport_gateway_variable is not None:
            pulumi.set(__self__, "transport_gateway_variable", transport_gateway_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="adminTechOnFailure")
    def admin_tech_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Collect admin-tech before reboot due to daemon failure - Default value: `true`
        """
        return pulumi.get(self, "admin_tech_on_failure")

    @admin_tech_on_failure.setter
    def admin_tech_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_tech_on_failure", value)

    @property
    @pulumi.getter(name="adminTechOnFailureVariable")
    def admin_tech_on_failure_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "admin_tech_on_failure_variable")

    @admin_tech_on_failure_variable.setter
    def admin_tech_on_failure_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_tech_on_failure_variable", value)

    @property
    @pulumi.getter(name="affinityGroupNumber")
    def affinity_group_number(self) -> Optional[pulumi.Input[int]]:
        """
        Set the affinity group number for router - Range: `1`-`255`
        """
        return pulumi.get(self, "affinity_group_number")

    @affinity_group_number.setter
    def affinity_group_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "affinity_group_number", value)

    @property
    @pulumi.getter(name="affinityGroupNumberVariable")
    def affinity_group_number_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "affinity_group_number_variable")

    @affinity_group_number_variable.setter
    def affinity_group_number_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "affinity_group_number_variable", value)

    @property
    @pulumi.getter(name="affinityGroupPreferenceVariable")
    def affinity_group_preference_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "affinity_group_preference_variable")

    @affinity_group_preference_variable.setter
    def affinity_group_preference_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "affinity_group_preference_variable", value)

    @property
    @pulumi.getter(name="affinityGroupPreferences")
    def affinity_group_preferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Set the affinity group preference
        """
        return pulumi.get(self, "affinity_group_preferences")

    @affinity_group_preferences.setter
    def affinity_group_preferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "affinity_group_preferences", value)

    @property
    @pulumi.getter(name="consoleBaudRate")
    def console_baud_rate(self) -> Optional[pulumi.Input[str]]:
        """
        Set the console baud rate - Choices: `1200`, `2400`, `4800`, `9600`, `19200`, `38400`, `57600`, `115200` - Default
        value: `9600`
        """
        return pulumi.get(self, "console_baud_rate")

    @console_baud_rate.setter
    def console_baud_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "console_baud_rate", value)

    @property
    @pulumi.getter(name="consoleBaudRateVariable")
    def console_baud_rate_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "console_baud_rate_variable")

    @console_baud_rate_variable.setter
    def console_baud_rate_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "console_baud_rate_variable", value)

    @property
    @pulumi.getter(name="controlSessionPps")
    def control_session_pps(self) -> Optional[pulumi.Input[int]]:
        """
        Set the policer rate for control sessions - Range: `1`-`65535` - Default value: `300`
        """
        return pulumi.get(self, "control_session_pps")

    @control_session_pps.setter
    def control_session_pps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "control_session_pps", value)

    @property
    @pulumi.getter(name="controlSessionPpsVariable")
    def control_session_pps_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "control_session_pps_variable")

    @control_session_pps_variable.setter
    def control_session_pps_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_session_pps_variable", value)

    @property
    @pulumi.getter(name="controllerGroupListVariable")
    def controller_group_list_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_group_list_variable")

    @controller_group_list_variable.setter
    def controller_group_list_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller_group_list_variable", value)

    @property
    @pulumi.getter(name="controllerGroupLists")
    def controller_group_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Configure a list of comma-separated device groups
        """
        return pulumi.get(self, "controller_group_lists")

    @controller_group_lists.setter
    def controller_group_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "controller_group_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceGroups")
    def device_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Device groups (Use comma(,) for multiple groups)
        """
        return pulumi.get(self, "device_groups")

    @device_groups.setter
    def device_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_groups", value)

    @property
    @pulumi.getter(name="deviceGroupsVariable")
    def device_groups_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "device_groups_variable")

    @device_groups_variable.setter
    def device_groups_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_groups_variable", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="enableMrfMigration")
    def enable_mrf_migration(self) -> Optional[pulumi.Input[str]]:
        """
        Enable migration mode to Multi-Region Fabric - Choices: `enabled`, `enabled-from-bgp-core`
        """
        return pulumi.get(self, "enable_mrf_migration")

    @enable_mrf_migration.setter
    def enable_mrf_migration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_mrf_migration", value)

    @property
    @pulumi.getter(name="geoFencing")
    def geo_fencing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Geo fencing - Default value: `false`
        """
        return pulumi.get(self, "geo_fencing")

    @geo_fencing.setter
    def geo_fencing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "geo_fencing", value)

    @property
    @pulumi.getter(name="geoFencingRange")
    def geo_fencing_range(self) -> Optional[pulumi.Input[int]]:
        """
        Set the device’s geo fencing range - Range: `100`-`10000` - Default value: `100`
        """
        return pulumi.get(self, "geo_fencing_range")

    @geo_fencing_range.setter
    def geo_fencing_range(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "geo_fencing_range", value)

    @property
    @pulumi.getter(name="geoFencingRangeVariable")
    def geo_fencing_range_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "geo_fencing_range_variable")

    @geo_fencing_range_variable.setter
    def geo_fencing_range_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "geo_fencing_range_variable", value)

    @property
    @pulumi.getter(name="geoFencingSms")
    def geo_fencing_sms(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Geo fencing - Default value: `false`
        """
        return pulumi.get(self, "geo_fencing_sms")

    @geo_fencing_sms.setter
    def geo_fencing_sms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "geo_fencing_sms", value)

    @property
    @pulumi.getter(name="geoFencingSmsPhoneNumbers")
    def geo_fencing_sms_phone_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs']]]]:
        """
        Set device’s geo fencing SMS phone number
        """
        return pulumi.get(self, "geo_fencing_sms_phone_numbers")

    @geo_fencing_sms_phone_numbers.setter
    def geo_fencing_sms_phone_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs']]]]):
        pulumi.set(self, "geo_fencing_sms_phone_numbers", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Set the hostname
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="hostnameVariable")
    def hostname_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hostname_variable")

    @hostname_variable.setter
    def hostname_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname_variable", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Idle CLI timeout in minutes - Range: `0`-`300`
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="idleTimeoutVariable")
    def idle_timeout_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "idle_timeout_variable")

    @idle_timeout_variable.setter
    def idle_timeout_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_timeout_variable", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[float]]:
        """
        Set the device’s physical latitude - Range: `-90`-`90`
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter(name="latitudeVariable")
    def latitude_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "latitude_variable")

    @latitude_variable.setter
    def latitude_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latitude_variable", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Set the location of the device
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationVariable")
    def location_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "location_variable")

    @location_variable.setter
    def location_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_variable", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[float]]:
        """
        Set the device’s physical longitude - Range: `-180`-`180`
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "longitude", value)

    @property
    @pulumi.getter(name="longitudeVariable")
    def longitude_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "longitude_variable")

    @longitude_variable.setter
    def longitude_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "longitude_variable", value)

    @property
    @pulumi.getter(name="maxOmpSessions")
    def max_omp_sessions(self) -> Optional[pulumi.Input[int]]:
        """
        Set the maximum number of OMP sessions <1..100> the device can have - Range: `1`-`100`
        """
        return pulumi.get(self, "max_omp_sessions")

    @max_omp_sessions.setter
    def max_omp_sessions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_omp_sessions", value)

    @property
    @pulumi.getter(name="maxOmpSessionsVariable")
    def max_omp_sessions_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "max_omp_sessions_variable")

    @max_omp_sessions_variable.setter
    def max_omp_sessions_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_omp_sessions_variable", value)

    @property
    @pulumi.getter(name="migrationBgpCommunity")
    def migration_bgp_community(self) -> Optional[pulumi.Input[int]]:
        """
        Set BGP community during migration from BGP-core based network - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "migration_bgp_community")

    @migration_bgp_community.setter
    def migration_bgp_community(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "migration_bgp_community", value)

    @property
    @pulumi.getter(name="multiTenant")
    def multi_tenant(self) -> Optional[pulumi.Input[bool]]:
        """
        Device is multi-tenant - Default value: `false`
        """
        return pulumi.get(self, "multi_tenant")

    @multi_tenant.setter
    def multi_tenant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_tenant", value)

    @property
    @pulumi.getter(name="multiTenantVariable")
    def multi_tenant_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multi_tenant_variable")

    @multi_tenant_variable.setter
    def multi_tenant_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_tenant_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectTrackers")
    def object_trackers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateObjectTrackerArgs']]]]:
        """
        Object Track configuration
        """
        return pulumi.get(self, "object_trackers")

    @object_trackers.setter
    def object_trackers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateObjectTrackerArgs']]]]):
        pulumi.set(self, "object_trackers", value)

    @property
    @pulumi.getter(name="onDemandTunnel")
    def on_demand_tunnel(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable On-demand Tunnel - Default value: `false`
        """
        return pulumi.get(self, "on_demand_tunnel")

    @on_demand_tunnel.setter
    def on_demand_tunnel(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_demand_tunnel", value)

    @property
    @pulumi.getter(name="onDemandTunnelIdleTimeout")
    def on_demand_tunnel_idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Idle CLI timeout in minutes - Range: `0`-`300`
        """
        return pulumi.get(self, "on_demand_tunnel_idle_timeout")

    @on_demand_tunnel_idle_timeout.setter
    def on_demand_tunnel_idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_demand_tunnel_idle_timeout", value)

    @property
    @pulumi.getter(name="onDemandTunnelIdleTimeoutVariable")
    def on_demand_tunnel_idle_timeout_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "on_demand_tunnel_idle_timeout_variable")

    @on_demand_tunnel_idle_timeout_variable.setter
    def on_demand_tunnel_idle_timeout_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_demand_tunnel_idle_timeout_variable", value)

    @property
    @pulumi.getter(name="onDemandTunnelVariable")
    def on_demand_tunnel_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "on_demand_tunnel_variable")

    @on_demand_tunnel_variable.setter
    def on_demand_tunnel_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_demand_tunnel_variable", value)

    @property
    @pulumi.getter(name="overlayId")
    def overlay_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set the Overlay ID - Range: `1`-`4294967295` - Default value: `1`
        """
        return pulumi.get(self, "overlay_id")

    @overlay_id.setter
    def overlay_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "overlay_id", value)

    @property
    @pulumi.getter(name="overlayIdVariable")
    def overlay_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "overlay_id_variable")

    @overlay_id_variable.setter
    def overlay_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overlay_id_variable", value)

    @property
    @pulumi.getter(name="portHopping")
    def port_hopping(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable port hopping - Default value: `true`
        """
        return pulumi.get(self, "port_hopping")

    @port_hopping.setter
    def port_hopping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "port_hopping", value)

    @property
    @pulumi.getter(name="portHoppingVariable")
    def port_hopping_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "port_hopping_variable")

    @port_hopping_variable.setter
    def port_hopping_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_hopping_variable", value)

    @property
    @pulumi.getter(name="portOffset")
    def port_offset(self) -> Optional[pulumi.Input[int]]:
        """
        Set the TLOC port offset when multiple devices are behind a NAT - Range: `0`-`19` - Default value: `0`
        """
        return pulumi.get(self, "port_offset")

    @port_offset.setter
    def port_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_offset", value)

    @property
    @pulumi.getter(name="portOffsetVariable")
    def port_offset_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "port_offset_variable")

    @port_offset_variable.setter
    def port_offset_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_offset_variable", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set region ID - Range: `1`-`63`
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter(name="regionIdVariable")
    def region_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "region_id_variable")

    @region_id_variable.setter
    def region_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id_variable", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Set the role for router - Choices: `edge-router`, `border-router`
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="roleVariable")
    def role_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "role_variable")

    @role_variable.setter
    def role_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_variable", value)

    @property
    @pulumi.getter(name="secondaryRegionId")
    def secondary_region_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set secondary region ID - Range: `1`-`63`
        """
        return pulumi.get(self, "secondary_region_id")

    @secondary_region_id.setter
    def secondary_region_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "secondary_region_id", value)

    @property
    @pulumi.getter(name="secondaryRegionIdVariable")
    def secondary_region_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_region_id_variable")

    @secondary_region_id_variable.setter
    def secondary_region_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_region_id_variable", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set the site identifier - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="siteIdVariable")
    def site_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "site_id_variable")

    @site_id_variable.setter
    def site_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_id_variable", value)

    @property
    @pulumi.getter(name="systemDescription")
    def system_description(self) -> Optional[pulumi.Input[str]]:
        """
        Set a text description of the device
        """
        return pulumi.get(self, "system_description")

    @system_description.setter
    def system_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_description", value)

    @property
    @pulumi.getter(name="systemDescriptionVariable")
    def system_description_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "system_description_variable")

    @system_description_variable.setter
    def system_description_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_description_variable", value)

    @property
    @pulumi.getter(name="systemIp")
    def system_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Set the system IP address
        """
        return pulumi.get(self, "system_ip")

    @system_ip.setter
    def system_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_ip", value)

    @property
    @pulumi.getter(name="systemIpVariable")
    def system_ip_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "system_ip_variable")

    @system_ip_variable.setter
    def system_ip_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_ip_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Set the timezone - Choices: `Europe/Andorra`, `Asia/Dubai`, `Asia/Kabul`, `America/Antigua`, `America/Anguilla`,
        `Europe/Tirane`, `Asia/Yerevan`, `Africa/Luanda`, `Antarctica/McMurdo`, `Antarctica/Rothera`, `Antarctica/Palmer`,
        `Antarctica/Mawson`, `Antarctica/Davis`, `Antarctica/Casey`, `Antarctica/Vostok`, `Antarctica/DumontDUrville`,
        `Antarctica/Syowa`, `America/Argentina/Buenos_Aires`, `America/Argentina/Cordoba`, `America/Argentina/Salta`,
        `America/Argentina/Jujuy`, `America/Argentina/Tucuman`, `America/Argentina/Catamarca`, `America/Argentina/La_Rioja`,
        `America/Argentina/San_Juan`, `America/Argentina/Mendoza`, `America/Argentina/San_Luis`,
        `America/Argentina/Rio_Gallegos`, `America/Argentina/Ushuaia`, `Pacific/Pago_Pago`, `Europe/Vienna`,
        `Australia/Lord_Howe`, `Antarctica/Macquarie`, `Australia/Hobart`, `Australia/Currie`, `Australia/Melbourne`,
        `Australia/Sydney`, `Australia/Broken_Hill`, `Australia/Brisbane`, `Australia/Lindeman`, `Australia/Adelaide`,
        `Australia/Darwin`, `Australia/Perth`, `Australia/Eucla`, `America/Aruba`, `Europe/Mariehamn`, `Asia/Baku`,
        `Europe/Sarajevo`, `America/Barbados`, `Asia/Dhaka`, `Europe/Brussels`, `Africa/Ouagadougou`, `Europe/Sofia`,
        `Asia/Bahrain`, `Africa/Bujumbura`, `Africa/Porto-Novo`, `America/St_Barthelemy`, `Atlantic/Bermuda`, `Asia/Brunei`,
        `America/La_Paz`, `America/Kralendijk`, `America/Noronha`, `America/Belem`, `America/Fortaleza`, `America/Recife`,
        `America/Araguaina`, `America/Maceio`, `America/Bahia`, `America/Sao_Paulo`, `America/Campo_Grande`, `America/Cuiaba`,
        `America/Santarem`, `America/Porto_Velho`, `America/Boa_Vista`, `America/Manaus`, `America/Eirunepe`,
        `America/Rio_Branco`, `America/Nassau`, `Asia/Thimphu`, `Africa/Gaborone`, `Europe/Minsk`, `America/Belize`,
        `America/St_Johns`, `America/Halifax`, `America/Glace_Bay`, `America/Moncton`, `America/Goose_Bay`,
        `America/Blanc-Sablon`, `America/Toronto`, `America/Nipigon`, `America/Thunder_Bay`, `America/Iqaluit`,
        `America/Pangnirtung`, `America/Resolute`, `America/Atikokan`, `America/Rankin_Inlet`, `America/Winnipeg`,
        `America/Rainy_River`, `America/Regina`, `America/Swift_Current`, `America/Edmonton`, `America/Cambridge_Bay`,
        `America/Yellowknife`, `America/Inuvik`, `America/Creston`, `America/Dawson_Creek`, `America/Vancouver`,
        `America/Whitehorse`, `America/Dawson`, `Indian/Cocos`, `Africa/Kinshasa`, `Africa/Lubumbashi`, `Africa/Bangui`,
        `Africa/Brazzaville`, `Europe/Zurich`, `Africa/Abidjan`, `Pacific/Rarotonga`, `America/Santiago`, `Pacific/Easter`,
        `Africa/Douala`, `Asia/Shanghai`, `Asia/Harbin`, `Asia/Chongqing`, `Asia/Urumqi`, `Asia/Kashgar`, `America/Bogota`,
        `America/Costa_Rica`, `America/Havana`, `Atlantic/Cape_Verde`, `America/Curacao`, `Indian/Christmas`, `Asia/Nicosia`,
        `Europe/Prague`, `Europe/Berlin`, `Europe/Busingen`, `Africa/Djibouti`, `Europe/Copenhagen`, `America/Dominica`,
        `America/Santo_Domingo`, `Africa/Algiers`, `America/Guayaquil`, `Pacific/Galapagos`, `Europe/Tallinn`, `Africa/Cairo`,
        `Africa/El_Aaiun`, `Africa/Asmara`, `Europe/Madrid`, `Africa/Ceuta`, `Atlantic/Canary`, `Africa/Addis_Ababa`,
        `Europe/Helsinki`, `Pacific/Fiji`, `Atlantic/Stanley`, `Pacific/Chuuk`, `Pacific/Pohnpei`, `Pacific/Kosrae`,
        `Atlantic/Faroe`, `Europe/Paris`, `Africa/Libreville`, `Europe/London`, `America/Grenada`, `Asia/Tbilisi`,
        `America/Cayenne`, `Europe/Guernsey`, `Africa/Accra`, `Europe/Gibraltar`, `America/Godthab`, `America/Danmarkshavn`,
        `America/Scoresbysund`, `America/Thule`, `Africa/Banjul`, `Africa/Conakry`, `America/Guadeloupe`, `Africa/Malabo`,
        `Europe/Athens`, `Atlantic/South_Georgia`, `America/Guatemala`, `Pacific/Guam`, `Africa/Bissau`, `America/Guyana`,
        `Asia/Hong_Kong`, `America/Tegucigalpa`, `Europe/Zagreb`, `America/Port-au-Prince`, `Europe/Budapest`, `Asia/Jakarta`,
        `Asia/Pontianak`, `Asia/Makassar`, `Asia/Jayapura`, `Europe/Dublin`, `Asia/Jerusalem`, `Europe/Isle_of_Man`,
        `Asia/Kolkata`, `Indian/Chagos`, `Asia/Baghdad`, `Asia/Tehran`, `Atlantic/Reykjavik`, `Europe/Rome`, `Europe/Jersey`,
        `America/Jamaica`, `Asia/Amman`, `Asia/Tokyo`, `Africa/Nairobi`, `Asia/Bishkek`, `Asia/Phnom_Penh`, `Pacific/Tarawa`,
        `Pacific/Enderbury`, `Pacific/Kiritimati`, `Indian/Comoro`, `America/St_Kitts`, `Asia/Pyongyang`, `Asia/Seoul`,
        `Asia/Kuwait`, `America/Cayman`, `Asia/Almaty`, `Asia/Qyzylorda`, `Asia/Aqtobe`, `Asia/Aqtau`, `Asia/Oral`,
        `Asia/Vientiane`, `Asia/Beirut`, `America/St_Lucia`, `Europe/Vaduz`, `Asia/Colombo`, `Africa/Monrovia`, `Africa/Maseru`,
        `Europe/Vilnius`, `Europe/Luxembourg`, `Europe/Riga`, `Africa/Tripoli`, `Africa/Casablanca`, `Europe/Monaco`,
        `Europe/Chisinau`, `Europe/Podgorica`, `America/Marigot`, `Indian/Antananarivo`, `Pacific/Majuro`, `Pacific/Kwajalein`,
        `Europe/Skopje`, `Africa/Bamako`, `Asia/Rangoon`, `Asia/Ulaanbaatar`, `Asia/Hovd`, `Asia/Choibalsan`, `Asia/Macau`,
        `Pacific/Saipan`, `America/Martinique`, `Africa/Nouakchott`, `America/Montserrat`, `Europe/Malta`, `Indian/Mauritius`,
        `Indian/Maldives`, `Africa/Blantyre`, `America/Mexico_City`, `America/Cancun`, `America/Merida`, `America/Monterrey`,
        `America/Matamoros`, `America/Mazatlan`, `America/Chihuahua`, `America/Ojinaga`, `America/Hermosillo`,
        `America/Tijuana`, `America/Santa_Isabel`, `America/Bahia_Banderas`, `Asia/Kuala_Lumpur`, `Asia/Kuching`,
        `Africa/Maputo`, `Africa/Windhoek`, `Pacific/Noumea`, `Africa/Niamey`, `Pacific/Norfolk`, `Africa/Lagos`,
        `America/Managua`, `Europe/Amsterdam`, `Europe/Oslo`, `Asia/Kathmandu`, `Pacific/Nauru`, `Pacific/Niue`,
        `Pacific/Auckland`, `Pacific/Chatham`, `Asia/Muscat`, `America/Panama`, `America/Lima`, `Pacific/Tahiti`,
        `Pacific/Marquesas`, `Pacific/Gambier`, `Pacific/Port_Moresby`, `Asia/Manila`, `Asia/Karachi`, `Europe/Warsaw`,
        `America/Miquelon`, `Pacific/Pitcairn`, `America/Puerto_Rico`, `Asia/Gaza`, `Asia/Hebron`, `Europe/Lisbon`,
        `Atlantic/Madeira`, `Atlantic/Azores`, `Pacific/Palau`, `America/Asuncion`, `Asia/Qatar`, `Indian/Reunion`,
        `Europe/Bucharest`, `Europe/Belgrade`, `Europe/Kaliningrad`, `Europe/Moscow`, `Europe/Volgograd`, `Europe/Samara`,
        `Asia/Yekaterinburg`, `Asia/Omsk`, `Asia/Novosibirsk`, `Asia/Novokuznetsk`, `Asia/Krasnoyarsk`, `Asia/Irkutsk`,
        `Asia/Yakutsk`, `Asia/Khandyga`, `Asia/Vladivostok`, `Asia/Sakhalin`, `Asia/Ust-Nera`, `Asia/Magadan`, `Asia/Kamchatka`,
        `Asia/Anadyr`, `Africa/Kigali`, `Asia/Riyadh`, `Pacific/Guadalcanal`, `Indian/Mahe`, `Africa/Khartoum`,
        `Europe/Stockholm`, `Asia/Singapore`, `Atlantic/St_Helena`, `Europe/Ljubljana`, `Arctic/Longyearbyen`,
        `Europe/Bratislava`, `Africa/Freetown`, `Europe/San_Marino`, `Africa/Dakar`, `Africa/Mogadishu`, `America/Paramaribo`,
        `Africa/Juba`, `Africa/Sao_Tome`, `America/El_Salvador`, `America/Lower_Princes`, `Asia/Damascus`, `Africa/Mbabane`,
        `America/Grand_Turk`, `Africa/Ndjamena`, `Indian/Kerguelen`, `Africa/Lome`, `Asia/Bangkok`, `Asia/Dushanbe`,
        `Pacific/Fakaofo`, `Asia/Dili`, `Asia/Ashgabat`, `Africa/Tunis`, `Pacific/Tongatapu`, `Europe/Istanbul`,
        `America/Port_of_Spain`, `Pacific/Funafuti`, `Asia/Taipei`, `Africa/Dar_es_Salaam`, `Europe/Kiev`, `Europe/Uzhgorod`,
        `Europe/Zaporozhye`, `Europe/Simferopol`, `Africa/Kampala`, `Pacific/Johnston`, `Pacific/Midway`, `Pacific/Wake`,
        `America/New_York`, `America/Detroit`, `America/Kentucky/Louisville`, `America/Kentucky/Monticello`,
        `America/Indiana/Indianapolis`, `America/Indiana/Vincennes`, `America/Indiana/Winamac`, `America/Indiana/Marengo`,
        `America/Indiana/Petersburg`, `America/Indiana/Vevay`, `America/Chicago`, `America/Indiana/Tell_City`,
        `America/Indiana/Knox`, `America/Menominee`, `America/North_Dakota/Center`, `America/North_Dakota/New_Salem`,
        `America/North_Dakota/Beulah`, `America/Denver`, `America/Boise`, `America/Phoenix`, `America/Los_Angeles`,
        `America/Anchorage`, `America/Juneau`, `America/Sitka`, `America/Yakutat`, `America/Nome`, `America/Adak`,
        `America/Metlakatla`, `Pacific/Honolulu`, `America/Montevideo`, `Asia/Samarkand`, `Asia/Tashkent`, `Europe/Vatican`,
        `America/St_Vincent`, `America/Caracas`, `America/Tortola`, `America/St_Thomas`, `Asia/Ho_Chi_Minh`, `Pacific/Efate`,
        `Pacific/Wallis`, `Pacific/Apia`, `Asia/Aden`, `Indian/Mayotte`, `Africa/Johannesburg`, `Africa/Lusaka`,
        `Africa/Harare`, `UTC` - Default value: `UTC`
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="timezoneVariable")
    def timezone_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timezone_variable")

    @timezone_variable.setter
    def timezone_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone_variable", value)

    @property
    @pulumi.getter(name="trackDefaultGateway")
    def track_default_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable default gateway tracking - Default value: `true`
        """
        return pulumi.get(self, "track_default_gateway")

    @track_default_gateway.setter
    def track_default_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "track_default_gateway", value)

    @property
    @pulumi.getter(name="trackDefaultGatewayVariable")
    def track_default_gateway_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "track_default_gateway_variable")

    @track_default_gateway_variable.setter
    def track_default_gateway_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "track_default_gateway_variable", value)

    @property
    @pulumi.getter(name="trackInterfaceTag")
    def track_interface_tag(self) -> Optional[pulumi.Input[int]]:
        """
        OMP Tag attached to routes based on interface tracking - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "track_interface_tag")

    @track_interface_tag.setter
    def track_interface_tag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "track_interface_tag", value)

    @property
    @pulumi.getter(name="trackInterfaceTagVariable")
    def track_interface_tag_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "track_interface_tag_variable")

    @track_interface_tag_variable.setter
    def track_interface_tag_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "track_interface_tag_variable", value)

    @property
    @pulumi.getter(name="trackTransport")
    def track_transport(self) -> Optional[pulumi.Input[bool]]:
        """
        Configure tracking of transport - Default value: `true`
        """
        return pulumi.get(self, "track_transport")

    @track_transport.setter
    def track_transport(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "track_transport", value)

    @property
    @pulumi.getter(name="trackTransportVariable")
    def track_transport_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "track_transport_variable")

    @track_transport_variable.setter
    def track_transport_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "track_transport_variable", value)

    @property
    @pulumi.getter
    def trackers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateTrackerArgs']]]]:
        """
        Tracker configuration
        """
        return pulumi.get(self, "trackers")

    @trackers.setter
    def trackers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSystemFeatureTemplateTrackerArgs']]]]):
        pulumi.set(self, "trackers", value)

    @property
    @pulumi.getter(name="transportGateway")
    def transport_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable transport gateway - Default value: `false`
        """
        return pulumi.get(self, "transport_gateway")

    @transport_gateway.setter
    def transport_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "transport_gateway", value)

    @property
    @pulumi.getter(name="transportGatewayVariable")
    def transport_gateway_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "transport_gateway_variable")

    @transport_gateway_variable.setter
    def transport_gateway_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transport_gateway_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CiscoSystemFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_tech_on_failure: Optional[pulumi.Input[bool]] = None,
                 admin_tech_on_failure_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_number: Optional[pulumi.Input[int]] = None,
                 affinity_group_number_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_preference_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 console_baud_rate: Optional[pulumi.Input[str]] = None,
                 console_baud_rate_variable: Optional[pulumi.Input[str]] = None,
                 control_session_pps: Optional[pulumi.Input[int]] = None,
                 control_session_pps_variable: Optional[pulumi.Input[str]] = None,
                 controller_group_list_variable: Optional[pulumi.Input[str]] = None,
                 controller_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_groups_variable: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_mrf_migration: Optional[pulumi.Input[str]] = None,
                 geo_fencing: Optional[pulumi.Input[bool]] = None,
                 geo_fencing_range: Optional[pulumi.Input[int]] = None,
                 geo_fencing_range_variable: Optional[pulumi.Input[str]] = None,
                 geo_fencing_sms: Optional[pulumi.Input[bool]] = None,
                 geo_fencing_sms_phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs', 'CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hostname_variable: Optional[pulumi.Input[str]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 idle_timeout_variable: Optional[pulumi.Input[str]] = None,
                 latitude: Optional[pulumi.Input[float]] = None,
                 latitude_variable: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_variable: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[float]] = None,
                 longitude_variable: Optional[pulumi.Input[str]] = None,
                 max_omp_sessions: Optional[pulumi.Input[int]] = None,
                 max_omp_sessions_variable: Optional[pulumi.Input[str]] = None,
                 migration_bgp_community: Optional[pulumi.Input[int]] = None,
                 multi_tenant: Optional[pulumi.Input[bool]] = None,
                 multi_tenant_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_trackers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateObjectTrackerArgs', 'CiscoSystemFeatureTemplateObjectTrackerArgsDict']]]]] = None,
                 on_demand_tunnel: Optional[pulumi.Input[bool]] = None,
                 on_demand_tunnel_idle_timeout: Optional[pulumi.Input[int]] = None,
                 on_demand_tunnel_idle_timeout_variable: Optional[pulumi.Input[str]] = None,
                 on_demand_tunnel_variable: Optional[pulumi.Input[str]] = None,
                 overlay_id: Optional[pulumi.Input[int]] = None,
                 overlay_id_variable: Optional[pulumi.Input[str]] = None,
                 port_hopping: Optional[pulumi.Input[bool]] = None,
                 port_hopping_variable: Optional[pulumi.Input[str]] = None,
                 port_offset: Optional[pulumi.Input[int]] = None,
                 port_offset_variable: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[int]] = None,
                 region_id_variable: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 role_variable: Optional[pulumi.Input[str]] = None,
                 secondary_region_id: Optional[pulumi.Input[int]] = None,
                 secondary_region_id_variable: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 site_id_variable: Optional[pulumi.Input[str]] = None,
                 system_description: Optional[pulumi.Input[str]] = None,
                 system_description_variable: Optional[pulumi.Input[str]] = None,
                 system_ip: Optional[pulumi.Input[str]] = None,
                 system_ip_variable: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 timezone_variable: Optional[pulumi.Input[str]] = None,
                 track_default_gateway: Optional[pulumi.Input[bool]] = None,
                 track_default_gateway_variable: Optional[pulumi.Input[str]] = None,
                 track_interface_tag: Optional[pulumi.Input[int]] = None,
                 track_interface_tag_variable: Optional[pulumi.Input[str]] = None,
                 track_transport: Optional[pulumi.Input[bool]] = None,
                 track_transport_variable: Optional[pulumi.Input[str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateTrackerArgs', 'CiscoSystemFeatureTemplateTrackerArgsDict']]]]] = None,
                 transport_gateway: Optional[pulumi.Input[bool]] = None,
                 transport_gateway_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco System feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoSystemFeatureTemplate:CiscoSystemFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_tech_on_failure: Collect admin-tech before reboot due to daemon failure - Default value: `true`
        :param pulumi.Input[str] admin_tech_on_failure_variable: Variable name
        :param pulumi.Input[int] affinity_group_number: Set the affinity group number for router - Range: `1`-`255`
        :param pulumi.Input[str] affinity_group_number_variable: Variable name
        :param pulumi.Input[str] affinity_group_preference_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] affinity_group_preferences: Set the affinity group preference
        :param pulumi.Input[str] console_baud_rate: Set the console baud rate - Choices: `1200`, `2400`, `4800`, `9600`, `19200`, `38400`, `57600`, `115200` - Default
               value: `9600`
        :param pulumi.Input[str] console_baud_rate_variable: Variable name
        :param pulumi.Input[int] control_session_pps: Set the policer rate for control sessions - Range: `1`-`65535` - Default value: `300`
        :param pulumi.Input[str] control_session_pps_variable: Variable name
        :param pulumi.Input[str] controller_group_list_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] controller_group_lists: Configure a list of comma-separated device groups
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_groups: Device groups (Use comma(,) for multiple groups)
        :param pulumi.Input[str] device_groups_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] enable_mrf_migration: Enable migration mode to Multi-Region Fabric - Choices: `enabled`, `enabled-from-bgp-core`
        :param pulumi.Input[bool] geo_fencing: Enable Geo fencing - Default value: `false`
        :param pulumi.Input[int] geo_fencing_range: Set the device’s geo fencing range - Range: `100`-`10000` - Default value: `100`
        :param pulumi.Input[str] geo_fencing_range_variable: Variable name
        :param pulumi.Input[bool] geo_fencing_sms: Enable Geo fencing - Default value: `false`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs', 'CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgsDict']]]] geo_fencing_sms_phone_numbers: Set device’s geo fencing SMS phone number
        :param pulumi.Input[str] hostname: Set the hostname
        :param pulumi.Input[str] hostname_variable: Variable name
        :param pulumi.Input[int] idle_timeout: Idle CLI timeout in minutes - Range: `0`-`300`
        :param pulumi.Input[str] idle_timeout_variable: Variable name
        :param pulumi.Input[float] latitude: Set the device’s physical latitude - Range: `-90`-`90`
        :param pulumi.Input[str] latitude_variable: Variable name
        :param pulumi.Input[str] location: Set the location of the device
        :param pulumi.Input[str] location_variable: Variable name
        :param pulumi.Input[float] longitude: Set the device’s physical longitude - Range: `-180`-`180`
        :param pulumi.Input[str] longitude_variable: Variable name
        :param pulumi.Input[int] max_omp_sessions: Set the maximum number of OMP sessions <1..100> the device can have - Range: `1`-`100`
        :param pulumi.Input[str] max_omp_sessions_variable: Variable name
        :param pulumi.Input[int] migration_bgp_community: Set BGP community during migration from BGP-core based network - Range: `1`-`4294967295`
        :param pulumi.Input[bool] multi_tenant: Device is multi-tenant - Default value: `false`
        :param pulumi.Input[str] multi_tenant_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateObjectTrackerArgs', 'CiscoSystemFeatureTemplateObjectTrackerArgsDict']]]] object_trackers: Object Track configuration
        :param pulumi.Input[bool] on_demand_tunnel: Enable or disable On-demand Tunnel - Default value: `false`
        :param pulumi.Input[int] on_demand_tunnel_idle_timeout: Idle CLI timeout in minutes - Range: `0`-`300`
        :param pulumi.Input[str] on_demand_tunnel_idle_timeout_variable: Variable name
        :param pulumi.Input[str] on_demand_tunnel_variable: Variable name
        :param pulumi.Input[int] overlay_id: Set the Overlay ID - Range: `1`-`4294967295` - Default value: `1`
        :param pulumi.Input[str] overlay_id_variable: Variable name
        :param pulumi.Input[bool] port_hopping: Enable port hopping - Default value: `true`
        :param pulumi.Input[str] port_hopping_variable: Variable name
        :param pulumi.Input[int] port_offset: Set the TLOC port offset when multiple devices are behind a NAT - Range: `0`-`19` - Default value: `0`
        :param pulumi.Input[str] port_offset_variable: Variable name
        :param pulumi.Input[int] region_id: Set region ID - Range: `1`-`63`
        :param pulumi.Input[str] region_id_variable: Variable name
        :param pulumi.Input[str] role: Set the role for router - Choices: `edge-router`, `border-router`
        :param pulumi.Input[str] role_variable: Variable name
        :param pulumi.Input[int] secondary_region_id: Set secondary region ID - Range: `1`-`63`
        :param pulumi.Input[str] secondary_region_id_variable: Variable name
        :param pulumi.Input[int] site_id: Set the site identifier - Range: `1`-`4294967295`
        :param pulumi.Input[str] site_id_variable: Variable name
        :param pulumi.Input[str] system_description: Set a text description of the device
        :param pulumi.Input[str] system_description_variable: Variable name
        :param pulumi.Input[str] system_ip: Set the system IP address
        :param pulumi.Input[str] system_ip_variable: Variable name
        :param pulumi.Input[str] timezone: Set the timezone - Choices: `Europe/Andorra`, `Asia/Dubai`, `Asia/Kabul`, `America/Antigua`, `America/Anguilla`,
               `Europe/Tirane`, `Asia/Yerevan`, `Africa/Luanda`, `Antarctica/McMurdo`, `Antarctica/Rothera`, `Antarctica/Palmer`,
               `Antarctica/Mawson`, `Antarctica/Davis`, `Antarctica/Casey`, `Antarctica/Vostok`, `Antarctica/DumontDUrville`,
               `Antarctica/Syowa`, `America/Argentina/Buenos_Aires`, `America/Argentina/Cordoba`, `America/Argentina/Salta`,
               `America/Argentina/Jujuy`, `America/Argentina/Tucuman`, `America/Argentina/Catamarca`, `America/Argentina/La_Rioja`,
               `America/Argentina/San_Juan`, `America/Argentina/Mendoza`, `America/Argentina/San_Luis`,
               `America/Argentina/Rio_Gallegos`, `America/Argentina/Ushuaia`, `Pacific/Pago_Pago`, `Europe/Vienna`,
               `Australia/Lord_Howe`, `Antarctica/Macquarie`, `Australia/Hobart`, `Australia/Currie`, `Australia/Melbourne`,
               `Australia/Sydney`, `Australia/Broken_Hill`, `Australia/Brisbane`, `Australia/Lindeman`, `Australia/Adelaide`,
               `Australia/Darwin`, `Australia/Perth`, `Australia/Eucla`, `America/Aruba`, `Europe/Mariehamn`, `Asia/Baku`,
               `Europe/Sarajevo`, `America/Barbados`, `Asia/Dhaka`, `Europe/Brussels`, `Africa/Ouagadougou`, `Europe/Sofia`,
               `Asia/Bahrain`, `Africa/Bujumbura`, `Africa/Porto-Novo`, `America/St_Barthelemy`, `Atlantic/Bermuda`, `Asia/Brunei`,
               `America/La_Paz`, `America/Kralendijk`, `America/Noronha`, `America/Belem`, `America/Fortaleza`, `America/Recife`,
               `America/Araguaina`, `America/Maceio`, `America/Bahia`, `America/Sao_Paulo`, `America/Campo_Grande`, `America/Cuiaba`,
               `America/Santarem`, `America/Porto_Velho`, `America/Boa_Vista`, `America/Manaus`, `America/Eirunepe`,
               `America/Rio_Branco`, `America/Nassau`, `Asia/Thimphu`, `Africa/Gaborone`, `Europe/Minsk`, `America/Belize`,
               `America/St_Johns`, `America/Halifax`, `America/Glace_Bay`, `America/Moncton`, `America/Goose_Bay`,
               `America/Blanc-Sablon`, `America/Toronto`, `America/Nipigon`, `America/Thunder_Bay`, `America/Iqaluit`,
               `America/Pangnirtung`, `America/Resolute`, `America/Atikokan`, `America/Rankin_Inlet`, `America/Winnipeg`,
               `America/Rainy_River`, `America/Regina`, `America/Swift_Current`, `America/Edmonton`, `America/Cambridge_Bay`,
               `America/Yellowknife`, `America/Inuvik`, `America/Creston`, `America/Dawson_Creek`, `America/Vancouver`,
               `America/Whitehorse`, `America/Dawson`, `Indian/Cocos`, `Africa/Kinshasa`, `Africa/Lubumbashi`, `Africa/Bangui`,
               `Africa/Brazzaville`, `Europe/Zurich`, `Africa/Abidjan`, `Pacific/Rarotonga`, `America/Santiago`, `Pacific/Easter`,
               `Africa/Douala`, `Asia/Shanghai`, `Asia/Harbin`, `Asia/Chongqing`, `Asia/Urumqi`, `Asia/Kashgar`, `America/Bogota`,
               `America/Costa_Rica`, `America/Havana`, `Atlantic/Cape_Verde`, `America/Curacao`, `Indian/Christmas`, `Asia/Nicosia`,
               `Europe/Prague`, `Europe/Berlin`, `Europe/Busingen`, `Africa/Djibouti`, `Europe/Copenhagen`, `America/Dominica`,
               `America/Santo_Domingo`, `Africa/Algiers`, `America/Guayaquil`, `Pacific/Galapagos`, `Europe/Tallinn`, `Africa/Cairo`,
               `Africa/El_Aaiun`, `Africa/Asmara`, `Europe/Madrid`, `Africa/Ceuta`, `Atlantic/Canary`, `Africa/Addis_Ababa`,
               `Europe/Helsinki`, `Pacific/Fiji`, `Atlantic/Stanley`, `Pacific/Chuuk`, `Pacific/Pohnpei`, `Pacific/Kosrae`,
               `Atlantic/Faroe`, `Europe/Paris`, `Africa/Libreville`, `Europe/London`, `America/Grenada`, `Asia/Tbilisi`,
               `America/Cayenne`, `Europe/Guernsey`, `Africa/Accra`, `Europe/Gibraltar`, `America/Godthab`, `America/Danmarkshavn`,
               `America/Scoresbysund`, `America/Thule`, `Africa/Banjul`, `Africa/Conakry`, `America/Guadeloupe`, `Africa/Malabo`,
               `Europe/Athens`, `Atlantic/South_Georgia`, `America/Guatemala`, `Pacific/Guam`, `Africa/Bissau`, `America/Guyana`,
               `Asia/Hong_Kong`, `America/Tegucigalpa`, `Europe/Zagreb`, `America/Port-au-Prince`, `Europe/Budapest`, `Asia/Jakarta`,
               `Asia/Pontianak`, `Asia/Makassar`, `Asia/Jayapura`, `Europe/Dublin`, `Asia/Jerusalem`, `Europe/Isle_of_Man`,
               `Asia/Kolkata`, `Indian/Chagos`, `Asia/Baghdad`, `Asia/Tehran`, `Atlantic/Reykjavik`, `Europe/Rome`, `Europe/Jersey`,
               `America/Jamaica`, `Asia/Amman`, `Asia/Tokyo`, `Africa/Nairobi`, `Asia/Bishkek`, `Asia/Phnom_Penh`, `Pacific/Tarawa`,
               `Pacific/Enderbury`, `Pacific/Kiritimati`, `Indian/Comoro`, `America/St_Kitts`, `Asia/Pyongyang`, `Asia/Seoul`,
               `Asia/Kuwait`, `America/Cayman`, `Asia/Almaty`, `Asia/Qyzylorda`, `Asia/Aqtobe`, `Asia/Aqtau`, `Asia/Oral`,
               `Asia/Vientiane`, `Asia/Beirut`, `America/St_Lucia`, `Europe/Vaduz`, `Asia/Colombo`, `Africa/Monrovia`, `Africa/Maseru`,
               `Europe/Vilnius`, `Europe/Luxembourg`, `Europe/Riga`, `Africa/Tripoli`, `Africa/Casablanca`, `Europe/Monaco`,
               `Europe/Chisinau`, `Europe/Podgorica`, `America/Marigot`, `Indian/Antananarivo`, `Pacific/Majuro`, `Pacific/Kwajalein`,
               `Europe/Skopje`, `Africa/Bamako`, `Asia/Rangoon`, `Asia/Ulaanbaatar`, `Asia/Hovd`, `Asia/Choibalsan`, `Asia/Macau`,
               `Pacific/Saipan`, `America/Martinique`, `Africa/Nouakchott`, `America/Montserrat`, `Europe/Malta`, `Indian/Mauritius`,
               `Indian/Maldives`, `Africa/Blantyre`, `America/Mexico_City`, `America/Cancun`, `America/Merida`, `America/Monterrey`,
               `America/Matamoros`, `America/Mazatlan`, `America/Chihuahua`, `America/Ojinaga`, `America/Hermosillo`,
               `America/Tijuana`, `America/Santa_Isabel`, `America/Bahia_Banderas`, `Asia/Kuala_Lumpur`, `Asia/Kuching`,
               `Africa/Maputo`, `Africa/Windhoek`, `Pacific/Noumea`, `Africa/Niamey`, `Pacific/Norfolk`, `Africa/Lagos`,
               `America/Managua`, `Europe/Amsterdam`, `Europe/Oslo`, `Asia/Kathmandu`, `Pacific/Nauru`, `Pacific/Niue`,
               `Pacific/Auckland`, `Pacific/Chatham`, `Asia/Muscat`, `America/Panama`, `America/Lima`, `Pacific/Tahiti`,
               `Pacific/Marquesas`, `Pacific/Gambier`, `Pacific/Port_Moresby`, `Asia/Manila`, `Asia/Karachi`, `Europe/Warsaw`,
               `America/Miquelon`, `Pacific/Pitcairn`, `America/Puerto_Rico`, `Asia/Gaza`, `Asia/Hebron`, `Europe/Lisbon`,
               `Atlantic/Madeira`, `Atlantic/Azores`, `Pacific/Palau`, `America/Asuncion`, `Asia/Qatar`, `Indian/Reunion`,
               `Europe/Bucharest`, `Europe/Belgrade`, `Europe/Kaliningrad`, `Europe/Moscow`, `Europe/Volgograd`, `Europe/Samara`,
               `Asia/Yekaterinburg`, `Asia/Omsk`, `Asia/Novosibirsk`, `Asia/Novokuznetsk`, `Asia/Krasnoyarsk`, `Asia/Irkutsk`,
               `Asia/Yakutsk`, `Asia/Khandyga`, `Asia/Vladivostok`, `Asia/Sakhalin`, `Asia/Ust-Nera`, `Asia/Magadan`, `Asia/Kamchatka`,
               `Asia/Anadyr`, `Africa/Kigali`, `Asia/Riyadh`, `Pacific/Guadalcanal`, `Indian/Mahe`, `Africa/Khartoum`,
               `Europe/Stockholm`, `Asia/Singapore`, `Atlantic/St_Helena`, `Europe/Ljubljana`, `Arctic/Longyearbyen`,
               `Europe/Bratislava`, `Africa/Freetown`, `Europe/San_Marino`, `Africa/Dakar`, `Africa/Mogadishu`, `America/Paramaribo`,
               `Africa/Juba`, `Africa/Sao_Tome`, `America/El_Salvador`, `America/Lower_Princes`, `Asia/Damascus`, `Africa/Mbabane`,
               `America/Grand_Turk`, `Africa/Ndjamena`, `Indian/Kerguelen`, `Africa/Lome`, `Asia/Bangkok`, `Asia/Dushanbe`,
               `Pacific/Fakaofo`, `Asia/Dili`, `Asia/Ashgabat`, `Africa/Tunis`, `Pacific/Tongatapu`, `Europe/Istanbul`,
               `America/Port_of_Spain`, `Pacific/Funafuti`, `Asia/Taipei`, `Africa/Dar_es_Salaam`, `Europe/Kiev`, `Europe/Uzhgorod`,
               `Europe/Zaporozhye`, `Europe/Simferopol`, `Africa/Kampala`, `Pacific/Johnston`, `Pacific/Midway`, `Pacific/Wake`,
               `America/New_York`, `America/Detroit`, `America/Kentucky/Louisville`, `America/Kentucky/Monticello`,
               `America/Indiana/Indianapolis`, `America/Indiana/Vincennes`, `America/Indiana/Winamac`, `America/Indiana/Marengo`,
               `America/Indiana/Petersburg`, `America/Indiana/Vevay`, `America/Chicago`, `America/Indiana/Tell_City`,
               `America/Indiana/Knox`, `America/Menominee`, `America/North_Dakota/Center`, `America/North_Dakota/New_Salem`,
               `America/North_Dakota/Beulah`, `America/Denver`, `America/Boise`, `America/Phoenix`, `America/Los_Angeles`,
               `America/Anchorage`, `America/Juneau`, `America/Sitka`, `America/Yakutat`, `America/Nome`, `America/Adak`,
               `America/Metlakatla`, `Pacific/Honolulu`, `America/Montevideo`, `Asia/Samarkand`, `Asia/Tashkent`, `Europe/Vatican`,
               `America/St_Vincent`, `America/Caracas`, `America/Tortola`, `America/St_Thomas`, `Asia/Ho_Chi_Minh`, `Pacific/Efate`,
               `Pacific/Wallis`, `Pacific/Apia`, `Asia/Aden`, `Indian/Mayotte`, `Africa/Johannesburg`, `Africa/Lusaka`,
               `Africa/Harare`, `UTC` - Default value: `UTC`
        :param pulumi.Input[str] timezone_variable: Variable name
        :param pulumi.Input[bool] track_default_gateway: Enable or disable default gateway tracking - Default value: `true`
        :param pulumi.Input[str] track_default_gateway_variable: Variable name
        :param pulumi.Input[int] track_interface_tag: OMP Tag attached to routes based on interface tracking - Range: `1`-`4294967295`
        :param pulumi.Input[str] track_interface_tag_variable: Variable name
        :param pulumi.Input[bool] track_transport: Configure tracking of transport - Default value: `true`
        :param pulumi.Input[str] track_transport_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateTrackerArgs', 'CiscoSystemFeatureTemplateTrackerArgsDict']]]] trackers: Tracker configuration
        :param pulumi.Input[bool] transport_gateway: Enable transport gateway - Default value: `false`
        :param pulumi.Input[str] transport_gateway_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoSystemFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco System feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoSystemFeatureTemplate:CiscoSystemFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoSystemFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoSystemFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_tech_on_failure: Optional[pulumi.Input[bool]] = None,
                 admin_tech_on_failure_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_number: Optional[pulumi.Input[int]] = None,
                 affinity_group_number_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_preference_variable: Optional[pulumi.Input[str]] = None,
                 affinity_group_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 console_baud_rate: Optional[pulumi.Input[str]] = None,
                 console_baud_rate_variable: Optional[pulumi.Input[str]] = None,
                 control_session_pps: Optional[pulumi.Input[int]] = None,
                 control_session_pps_variable: Optional[pulumi.Input[str]] = None,
                 controller_group_list_variable: Optional[pulumi.Input[str]] = None,
                 controller_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_groups_variable: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_mrf_migration: Optional[pulumi.Input[str]] = None,
                 geo_fencing: Optional[pulumi.Input[bool]] = None,
                 geo_fencing_range: Optional[pulumi.Input[int]] = None,
                 geo_fencing_range_variable: Optional[pulumi.Input[str]] = None,
                 geo_fencing_sms: Optional[pulumi.Input[bool]] = None,
                 geo_fencing_sms_phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs', 'CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hostname_variable: Optional[pulumi.Input[str]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 idle_timeout_variable: Optional[pulumi.Input[str]] = None,
                 latitude: Optional[pulumi.Input[float]] = None,
                 latitude_variable: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_variable: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[float]] = None,
                 longitude_variable: Optional[pulumi.Input[str]] = None,
                 max_omp_sessions: Optional[pulumi.Input[int]] = None,
                 max_omp_sessions_variable: Optional[pulumi.Input[str]] = None,
                 migration_bgp_community: Optional[pulumi.Input[int]] = None,
                 multi_tenant: Optional[pulumi.Input[bool]] = None,
                 multi_tenant_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_trackers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateObjectTrackerArgs', 'CiscoSystemFeatureTemplateObjectTrackerArgsDict']]]]] = None,
                 on_demand_tunnel: Optional[pulumi.Input[bool]] = None,
                 on_demand_tunnel_idle_timeout: Optional[pulumi.Input[int]] = None,
                 on_demand_tunnel_idle_timeout_variable: Optional[pulumi.Input[str]] = None,
                 on_demand_tunnel_variable: Optional[pulumi.Input[str]] = None,
                 overlay_id: Optional[pulumi.Input[int]] = None,
                 overlay_id_variable: Optional[pulumi.Input[str]] = None,
                 port_hopping: Optional[pulumi.Input[bool]] = None,
                 port_hopping_variable: Optional[pulumi.Input[str]] = None,
                 port_offset: Optional[pulumi.Input[int]] = None,
                 port_offset_variable: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[int]] = None,
                 region_id_variable: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 role_variable: Optional[pulumi.Input[str]] = None,
                 secondary_region_id: Optional[pulumi.Input[int]] = None,
                 secondary_region_id_variable: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[int]] = None,
                 site_id_variable: Optional[pulumi.Input[str]] = None,
                 system_description: Optional[pulumi.Input[str]] = None,
                 system_description_variable: Optional[pulumi.Input[str]] = None,
                 system_ip: Optional[pulumi.Input[str]] = None,
                 system_ip_variable: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 timezone_variable: Optional[pulumi.Input[str]] = None,
                 track_default_gateway: Optional[pulumi.Input[bool]] = None,
                 track_default_gateway_variable: Optional[pulumi.Input[str]] = None,
                 track_interface_tag: Optional[pulumi.Input[int]] = None,
                 track_interface_tag_variable: Optional[pulumi.Input[str]] = None,
                 track_transport: Optional[pulumi.Input[bool]] = None,
                 track_transport_variable: Optional[pulumi.Input[str]] = None,
                 trackers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateTrackerArgs', 'CiscoSystemFeatureTemplateTrackerArgsDict']]]]] = None,
                 transport_gateway: Optional[pulumi.Input[bool]] = None,
                 transport_gateway_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoSystemFeatureTemplateArgs.__new__(CiscoSystemFeatureTemplateArgs)

            __props__.__dict__["admin_tech_on_failure"] = admin_tech_on_failure
            __props__.__dict__["admin_tech_on_failure_variable"] = admin_tech_on_failure_variable
            __props__.__dict__["affinity_group_number"] = affinity_group_number
            __props__.__dict__["affinity_group_number_variable"] = affinity_group_number_variable
            __props__.__dict__["affinity_group_preference_variable"] = affinity_group_preference_variable
            __props__.__dict__["affinity_group_preferences"] = affinity_group_preferences
            __props__.__dict__["console_baud_rate"] = console_baud_rate
            __props__.__dict__["console_baud_rate_variable"] = console_baud_rate_variable
            __props__.__dict__["control_session_pps"] = control_session_pps
            __props__.__dict__["control_session_pps_variable"] = control_session_pps_variable
            __props__.__dict__["controller_group_list_variable"] = controller_group_list_variable
            __props__.__dict__["controller_group_lists"] = controller_group_lists
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["device_groups"] = device_groups
            __props__.__dict__["device_groups_variable"] = device_groups_variable
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["enable_mrf_migration"] = enable_mrf_migration
            __props__.__dict__["geo_fencing"] = geo_fencing
            __props__.__dict__["geo_fencing_range"] = geo_fencing_range
            __props__.__dict__["geo_fencing_range_variable"] = geo_fencing_range_variable
            __props__.__dict__["geo_fencing_sms"] = geo_fencing_sms
            __props__.__dict__["geo_fencing_sms_phone_numbers"] = geo_fencing_sms_phone_numbers
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["hostname_variable"] = hostname_variable
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["idle_timeout_variable"] = idle_timeout_variable
            __props__.__dict__["latitude"] = latitude
            __props__.__dict__["latitude_variable"] = latitude_variable
            __props__.__dict__["location"] = location
            __props__.__dict__["location_variable"] = location_variable
            __props__.__dict__["longitude"] = longitude
            __props__.__dict__["longitude_variable"] = longitude_variable
            __props__.__dict__["max_omp_sessions"] = max_omp_sessions
            __props__.__dict__["max_omp_sessions_variable"] = max_omp_sessions_variable
            __props__.__dict__["migration_bgp_community"] = migration_bgp_community
            __props__.__dict__["multi_tenant"] = multi_tenant
            __props__.__dict__["multi_tenant_variable"] = multi_tenant_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["object_trackers"] = object_trackers
            __props__.__dict__["on_demand_tunnel"] = on_demand_tunnel
            __props__.__dict__["on_demand_tunnel_idle_timeout"] = on_demand_tunnel_idle_timeout
            __props__.__dict__["on_demand_tunnel_idle_timeout_variable"] = on_demand_tunnel_idle_timeout_variable
            __props__.__dict__["on_demand_tunnel_variable"] = on_demand_tunnel_variable
            __props__.__dict__["overlay_id"] = overlay_id
            __props__.__dict__["overlay_id_variable"] = overlay_id_variable
            __props__.__dict__["port_hopping"] = port_hopping
            __props__.__dict__["port_hopping_variable"] = port_hopping_variable
            __props__.__dict__["port_offset"] = port_offset
            __props__.__dict__["port_offset_variable"] = port_offset_variable
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["region_id_variable"] = region_id_variable
            __props__.__dict__["role"] = role
            __props__.__dict__["role_variable"] = role_variable
            __props__.__dict__["secondary_region_id"] = secondary_region_id
            __props__.__dict__["secondary_region_id_variable"] = secondary_region_id_variable
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_id_variable"] = site_id_variable
            __props__.__dict__["system_description"] = system_description
            __props__.__dict__["system_description_variable"] = system_description_variable
            __props__.__dict__["system_ip"] = system_ip
            __props__.__dict__["system_ip_variable"] = system_ip_variable
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["timezone_variable"] = timezone_variable
            __props__.__dict__["track_default_gateway"] = track_default_gateway
            __props__.__dict__["track_default_gateway_variable"] = track_default_gateway_variable
            __props__.__dict__["track_interface_tag"] = track_interface_tag
            __props__.__dict__["track_interface_tag_variable"] = track_interface_tag_variable
            __props__.__dict__["track_transport"] = track_transport
            __props__.__dict__["track_transport_variable"] = track_transport_variable
            __props__.__dict__["trackers"] = trackers
            __props__.__dict__["transport_gateway"] = transport_gateway
            __props__.__dict__["transport_gateway_variable"] = transport_gateway_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoSystemFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoSystemFeatureTemplate:CiscoSystemFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_tech_on_failure: Optional[pulumi.Input[bool]] = None,
            admin_tech_on_failure_variable: Optional[pulumi.Input[str]] = None,
            affinity_group_number: Optional[pulumi.Input[int]] = None,
            affinity_group_number_variable: Optional[pulumi.Input[str]] = None,
            affinity_group_preference_variable: Optional[pulumi.Input[str]] = None,
            affinity_group_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            console_baud_rate: Optional[pulumi.Input[str]] = None,
            console_baud_rate_variable: Optional[pulumi.Input[str]] = None,
            control_session_pps: Optional[pulumi.Input[int]] = None,
            control_session_pps_variable: Optional[pulumi.Input[str]] = None,
            controller_group_list_variable: Optional[pulumi.Input[str]] = None,
            controller_group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            device_groups_variable: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_mrf_migration: Optional[pulumi.Input[str]] = None,
            geo_fencing: Optional[pulumi.Input[bool]] = None,
            geo_fencing_range: Optional[pulumi.Input[int]] = None,
            geo_fencing_range_variable: Optional[pulumi.Input[str]] = None,
            geo_fencing_sms: Optional[pulumi.Input[bool]] = None,
            geo_fencing_sms_phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs', 'CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgsDict']]]]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            hostname_variable: Optional[pulumi.Input[str]] = None,
            idle_timeout: Optional[pulumi.Input[int]] = None,
            idle_timeout_variable: Optional[pulumi.Input[str]] = None,
            latitude: Optional[pulumi.Input[float]] = None,
            latitude_variable: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            location_variable: Optional[pulumi.Input[str]] = None,
            longitude: Optional[pulumi.Input[float]] = None,
            longitude_variable: Optional[pulumi.Input[str]] = None,
            max_omp_sessions: Optional[pulumi.Input[int]] = None,
            max_omp_sessions_variable: Optional[pulumi.Input[str]] = None,
            migration_bgp_community: Optional[pulumi.Input[int]] = None,
            multi_tenant: Optional[pulumi.Input[bool]] = None,
            multi_tenant_variable: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            object_trackers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateObjectTrackerArgs', 'CiscoSystemFeatureTemplateObjectTrackerArgsDict']]]]] = None,
            on_demand_tunnel: Optional[pulumi.Input[bool]] = None,
            on_demand_tunnel_idle_timeout: Optional[pulumi.Input[int]] = None,
            on_demand_tunnel_idle_timeout_variable: Optional[pulumi.Input[str]] = None,
            on_demand_tunnel_variable: Optional[pulumi.Input[str]] = None,
            overlay_id: Optional[pulumi.Input[int]] = None,
            overlay_id_variable: Optional[pulumi.Input[str]] = None,
            port_hopping: Optional[pulumi.Input[bool]] = None,
            port_hopping_variable: Optional[pulumi.Input[str]] = None,
            port_offset: Optional[pulumi.Input[int]] = None,
            port_offset_variable: Optional[pulumi.Input[str]] = None,
            region_id: Optional[pulumi.Input[int]] = None,
            region_id_variable: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            role_variable: Optional[pulumi.Input[str]] = None,
            secondary_region_id: Optional[pulumi.Input[int]] = None,
            secondary_region_id_variable: Optional[pulumi.Input[str]] = None,
            site_id: Optional[pulumi.Input[int]] = None,
            site_id_variable: Optional[pulumi.Input[str]] = None,
            system_description: Optional[pulumi.Input[str]] = None,
            system_description_variable: Optional[pulumi.Input[str]] = None,
            system_ip: Optional[pulumi.Input[str]] = None,
            system_ip_variable: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            timezone_variable: Optional[pulumi.Input[str]] = None,
            track_default_gateway: Optional[pulumi.Input[bool]] = None,
            track_default_gateway_variable: Optional[pulumi.Input[str]] = None,
            track_interface_tag: Optional[pulumi.Input[int]] = None,
            track_interface_tag_variable: Optional[pulumi.Input[str]] = None,
            track_transport: Optional[pulumi.Input[bool]] = None,
            track_transport_variable: Optional[pulumi.Input[str]] = None,
            trackers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateTrackerArgs', 'CiscoSystemFeatureTemplateTrackerArgsDict']]]]] = None,
            transport_gateway: Optional[pulumi.Input[bool]] = None,
            transport_gateway_variable: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CiscoSystemFeatureTemplate':
        """
        Get an existing CiscoSystemFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_tech_on_failure: Collect admin-tech before reboot due to daemon failure - Default value: `true`
        :param pulumi.Input[str] admin_tech_on_failure_variable: Variable name
        :param pulumi.Input[int] affinity_group_number: Set the affinity group number for router - Range: `1`-`255`
        :param pulumi.Input[str] affinity_group_number_variable: Variable name
        :param pulumi.Input[str] affinity_group_preference_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] affinity_group_preferences: Set the affinity group preference
        :param pulumi.Input[str] console_baud_rate: Set the console baud rate - Choices: `1200`, `2400`, `4800`, `9600`, `19200`, `38400`, `57600`, `115200` - Default
               value: `9600`
        :param pulumi.Input[str] console_baud_rate_variable: Variable name
        :param pulumi.Input[int] control_session_pps: Set the policer rate for control sessions - Range: `1`-`65535` - Default value: `300`
        :param pulumi.Input[str] control_session_pps_variable: Variable name
        :param pulumi.Input[str] controller_group_list_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[int]]] controller_group_lists: Configure a list of comma-separated device groups
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_groups: Device groups (Use comma(,) for multiple groups)
        :param pulumi.Input[str] device_groups_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] enable_mrf_migration: Enable migration mode to Multi-Region Fabric - Choices: `enabled`, `enabled-from-bgp-core`
        :param pulumi.Input[bool] geo_fencing: Enable Geo fencing - Default value: `false`
        :param pulumi.Input[int] geo_fencing_range: Set the device’s geo fencing range - Range: `100`-`10000` - Default value: `100`
        :param pulumi.Input[str] geo_fencing_range_variable: Variable name
        :param pulumi.Input[bool] geo_fencing_sms: Enable Geo fencing - Default value: `false`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgs', 'CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumberArgsDict']]]] geo_fencing_sms_phone_numbers: Set device’s geo fencing SMS phone number
        :param pulumi.Input[str] hostname: Set the hostname
        :param pulumi.Input[str] hostname_variable: Variable name
        :param pulumi.Input[int] idle_timeout: Idle CLI timeout in minutes - Range: `0`-`300`
        :param pulumi.Input[str] idle_timeout_variable: Variable name
        :param pulumi.Input[float] latitude: Set the device’s physical latitude - Range: `-90`-`90`
        :param pulumi.Input[str] latitude_variable: Variable name
        :param pulumi.Input[str] location: Set the location of the device
        :param pulumi.Input[str] location_variable: Variable name
        :param pulumi.Input[float] longitude: Set the device’s physical longitude - Range: `-180`-`180`
        :param pulumi.Input[str] longitude_variable: Variable name
        :param pulumi.Input[int] max_omp_sessions: Set the maximum number of OMP sessions <1..100> the device can have - Range: `1`-`100`
        :param pulumi.Input[str] max_omp_sessions_variable: Variable name
        :param pulumi.Input[int] migration_bgp_community: Set BGP community during migration from BGP-core based network - Range: `1`-`4294967295`
        :param pulumi.Input[bool] multi_tenant: Device is multi-tenant - Default value: `false`
        :param pulumi.Input[str] multi_tenant_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateObjectTrackerArgs', 'CiscoSystemFeatureTemplateObjectTrackerArgsDict']]]] object_trackers: Object Track configuration
        :param pulumi.Input[bool] on_demand_tunnel: Enable or disable On-demand Tunnel - Default value: `false`
        :param pulumi.Input[int] on_demand_tunnel_idle_timeout: Idle CLI timeout in minutes - Range: `0`-`300`
        :param pulumi.Input[str] on_demand_tunnel_idle_timeout_variable: Variable name
        :param pulumi.Input[str] on_demand_tunnel_variable: Variable name
        :param pulumi.Input[int] overlay_id: Set the Overlay ID - Range: `1`-`4294967295` - Default value: `1`
        :param pulumi.Input[str] overlay_id_variable: Variable name
        :param pulumi.Input[bool] port_hopping: Enable port hopping - Default value: `true`
        :param pulumi.Input[str] port_hopping_variable: Variable name
        :param pulumi.Input[int] port_offset: Set the TLOC port offset when multiple devices are behind a NAT - Range: `0`-`19` - Default value: `0`
        :param pulumi.Input[str] port_offset_variable: Variable name
        :param pulumi.Input[int] region_id: Set region ID - Range: `1`-`63`
        :param pulumi.Input[str] region_id_variable: Variable name
        :param pulumi.Input[str] role: Set the role for router - Choices: `edge-router`, `border-router`
        :param pulumi.Input[str] role_variable: Variable name
        :param pulumi.Input[int] secondary_region_id: Set secondary region ID - Range: `1`-`63`
        :param pulumi.Input[str] secondary_region_id_variable: Variable name
        :param pulumi.Input[int] site_id: Set the site identifier - Range: `1`-`4294967295`
        :param pulumi.Input[str] site_id_variable: Variable name
        :param pulumi.Input[str] system_description: Set a text description of the device
        :param pulumi.Input[str] system_description_variable: Variable name
        :param pulumi.Input[str] system_ip: Set the system IP address
        :param pulumi.Input[str] system_ip_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[str] timezone: Set the timezone - Choices: `Europe/Andorra`, `Asia/Dubai`, `Asia/Kabul`, `America/Antigua`, `America/Anguilla`,
               `Europe/Tirane`, `Asia/Yerevan`, `Africa/Luanda`, `Antarctica/McMurdo`, `Antarctica/Rothera`, `Antarctica/Palmer`,
               `Antarctica/Mawson`, `Antarctica/Davis`, `Antarctica/Casey`, `Antarctica/Vostok`, `Antarctica/DumontDUrville`,
               `Antarctica/Syowa`, `America/Argentina/Buenos_Aires`, `America/Argentina/Cordoba`, `America/Argentina/Salta`,
               `America/Argentina/Jujuy`, `America/Argentina/Tucuman`, `America/Argentina/Catamarca`, `America/Argentina/La_Rioja`,
               `America/Argentina/San_Juan`, `America/Argentina/Mendoza`, `America/Argentina/San_Luis`,
               `America/Argentina/Rio_Gallegos`, `America/Argentina/Ushuaia`, `Pacific/Pago_Pago`, `Europe/Vienna`,
               `Australia/Lord_Howe`, `Antarctica/Macquarie`, `Australia/Hobart`, `Australia/Currie`, `Australia/Melbourne`,
               `Australia/Sydney`, `Australia/Broken_Hill`, `Australia/Brisbane`, `Australia/Lindeman`, `Australia/Adelaide`,
               `Australia/Darwin`, `Australia/Perth`, `Australia/Eucla`, `America/Aruba`, `Europe/Mariehamn`, `Asia/Baku`,
               `Europe/Sarajevo`, `America/Barbados`, `Asia/Dhaka`, `Europe/Brussels`, `Africa/Ouagadougou`, `Europe/Sofia`,
               `Asia/Bahrain`, `Africa/Bujumbura`, `Africa/Porto-Novo`, `America/St_Barthelemy`, `Atlantic/Bermuda`, `Asia/Brunei`,
               `America/La_Paz`, `America/Kralendijk`, `America/Noronha`, `America/Belem`, `America/Fortaleza`, `America/Recife`,
               `America/Araguaina`, `America/Maceio`, `America/Bahia`, `America/Sao_Paulo`, `America/Campo_Grande`, `America/Cuiaba`,
               `America/Santarem`, `America/Porto_Velho`, `America/Boa_Vista`, `America/Manaus`, `America/Eirunepe`,
               `America/Rio_Branco`, `America/Nassau`, `Asia/Thimphu`, `Africa/Gaborone`, `Europe/Minsk`, `America/Belize`,
               `America/St_Johns`, `America/Halifax`, `America/Glace_Bay`, `America/Moncton`, `America/Goose_Bay`,
               `America/Blanc-Sablon`, `America/Toronto`, `America/Nipigon`, `America/Thunder_Bay`, `America/Iqaluit`,
               `America/Pangnirtung`, `America/Resolute`, `America/Atikokan`, `America/Rankin_Inlet`, `America/Winnipeg`,
               `America/Rainy_River`, `America/Regina`, `America/Swift_Current`, `America/Edmonton`, `America/Cambridge_Bay`,
               `America/Yellowknife`, `America/Inuvik`, `America/Creston`, `America/Dawson_Creek`, `America/Vancouver`,
               `America/Whitehorse`, `America/Dawson`, `Indian/Cocos`, `Africa/Kinshasa`, `Africa/Lubumbashi`, `Africa/Bangui`,
               `Africa/Brazzaville`, `Europe/Zurich`, `Africa/Abidjan`, `Pacific/Rarotonga`, `America/Santiago`, `Pacific/Easter`,
               `Africa/Douala`, `Asia/Shanghai`, `Asia/Harbin`, `Asia/Chongqing`, `Asia/Urumqi`, `Asia/Kashgar`, `America/Bogota`,
               `America/Costa_Rica`, `America/Havana`, `Atlantic/Cape_Verde`, `America/Curacao`, `Indian/Christmas`, `Asia/Nicosia`,
               `Europe/Prague`, `Europe/Berlin`, `Europe/Busingen`, `Africa/Djibouti`, `Europe/Copenhagen`, `America/Dominica`,
               `America/Santo_Domingo`, `Africa/Algiers`, `America/Guayaquil`, `Pacific/Galapagos`, `Europe/Tallinn`, `Africa/Cairo`,
               `Africa/El_Aaiun`, `Africa/Asmara`, `Europe/Madrid`, `Africa/Ceuta`, `Atlantic/Canary`, `Africa/Addis_Ababa`,
               `Europe/Helsinki`, `Pacific/Fiji`, `Atlantic/Stanley`, `Pacific/Chuuk`, `Pacific/Pohnpei`, `Pacific/Kosrae`,
               `Atlantic/Faroe`, `Europe/Paris`, `Africa/Libreville`, `Europe/London`, `America/Grenada`, `Asia/Tbilisi`,
               `America/Cayenne`, `Europe/Guernsey`, `Africa/Accra`, `Europe/Gibraltar`, `America/Godthab`, `America/Danmarkshavn`,
               `America/Scoresbysund`, `America/Thule`, `Africa/Banjul`, `Africa/Conakry`, `America/Guadeloupe`, `Africa/Malabo`,
               `Europe/Athens`, `Atlantic/South_Georgia`, `America/Guatemala`, `Pacific/Guam`, `Africa/Bissau`, `America/Guyana`,
               `Asia/Hong_Kong`, `America/Tegucigalpa`, `Europe/Zagreb`, `America/Port-au-Prince`, `Europe/Budapest`, `Asia/Jakarta`,
               `Asia/Pontianak`, `Asia/Makassar`, `Asia/Jayapura`, `Europe/Dublin`, `Asia/Jerusalem`, `Europe/Isle_of_Man`,
               `Asia/Kolkata`, `Indian/Chagos`, `Asia/Baghdad`, `Asia/Tehran`, `Atlantic/Reykjavik`, `Europe/Rome`, `Europe/Jersey`,
               `America/Jamaica`, `Asia/Amman`, `Asia/Tokyo`, `Africa/Nairobi`, `Asia/Bishkek`, `Asia/Phnom_Penh`, `Pacific/Tarawa`,
               `Pacific/Enderbury`, `Pacific/Kiritimati`, `Indian/Comoro`, `America/St_Kitts`, `Asia/Pyongyang`, `Asia/Seoul`,
               `Asia/Kuwait`, `America/Cayman`, `Asia/Almaty`, `Asia/Qyzylorda`, `Asia/Aqtobe`, `Asia/Aqtau`, `Asia/Oral`,
               `Asia/Vientiane`, `Asia/Beirut`, `America/St_Lucia`, `Europe/Vaduz`, `Asia/Colombo`, `Africa/Monrovia`, `Africa/Maseru`,
               `Europe/Vilnius`, `Europe/Luxembourg`, `Europe/Riga`, `Africa/Tripoli`, `Africa/Casablanca`, `Europe/Monaco`,
               `Europe/Chisinau`, `Europe/Podgorica`, `America/Marigot`, `Indian/Antananarivo`, `Pacific/Majuro`, `Pacific/Kwajalein`,
               `Europe/Skopje`, `Africa/Bamako`, `Asia/Rangoon`, `Asia/Ulaanbaatar`, `Asia/Hovd`, `Asia/Choibalsan`, `Asia/Macau`,
               `Pacific/Saipan`, `America/Martinique`, `Africa/Nouakchott`, `America/Montserrat`, `Europe/Malta`, `Indian/Mauritius`,
               `Indian/Maldives`, `Africa/Blantyre`, `America/Mexico_City`, `America/Cancun`, `America/Merida`, `America/Monterrey`,
               `America/Matamoros`, `America/Mazatlan`, `America/Chihuahua`, `America/Ojinaga`, `America/Hermosillo`,
               `America/Tijuana`, `America/Santa_Isabel`, `America/Bahia_Banderas`, `Asia/Kuala_Lumpur`, `Asia/Kuching`,
               `Africa/Maputo`, `Africa/Windhoek`, `Pacific/Noumea`, `Africa/Niamey`, `Pacific/Norfolk`, `Africa/Lagos`,
               `America/Managua`, `Europe/Amsterdam`, `Europe/Oslo`, `Asia/Kathmandu`, `Pacific/Nauru`, `Pacific/Niue`,
               `Pacific/Auckland`, `Pacific/Chatham`, `Asia/Muscat`, `America/Panama`, `America/Lima`, `Pacific/Tahiti`,
               `Pacific/Marquesas`, `Pacific/Gambier`, `Pacific/Port_Moresby`, `Asia/Manila`, `Asia/Karachi`, `Europe/Warsaw`,
               `America/Miquelon`, `Pacific/Pitcairn`, `America/Puerto_Rico`, `Asia/Gaza`, `Asia/Hebron`, `Europe/Lisbon`,
               `Atlantic/Madeira`, `Atlantic/Azores`, `Pacific/Palau`, `America/Asuncion`, `Asia/Qatar`, `Indian/Reunion`,
               `Europe/Bucharest`, `Europe/Belgrade`, `Europe/Kaliningrad`, `Europe/Moscow`, `Europe/Volgograd`, `Europe/Samara`,
               `Asia/Yekaterinburg`, `Asia/Omsk`, `Asia/Novosibirsk`, `Asia/Novokuznetsk`, `Asia/Krasnoyarsk`, `Asia/Irkutsk`,
               `Asia/Yakutsk`, `Asia/Khandyga`, `Asia/Vladivostok`, `Asia/Sakhalin`, `Asia/Ust-Nera`, `Asia/Magadan`, `Asia/Kamchatka`,
               `Asia/Anadyr`, `Africa/Kigali`, `Asia/Riyadh`, `Pacific/Guadalcanal`, `Indian/Mahe`, `Africa/Khartoum`,
               `Europe/Stockholm`, `Asia/Singapore`, `Atlantic/St_Helena`, `Europe/Ljubljana`, `Arctic/Longyearbyen`,
               `Europe/Bratislava`, `Africa/Freetown`, `Europe/San_Marino`, `Africa/Dakar`, `Africa/Mogadishu`, `America/Paramaribo`,
               `Africa/Juba`, `Africa/Sao_Tome`, `America/El_Salvador`, `America/Lower_Princes`, `Asia/Damascus`, `Africa/Mbabane`,
               `America/Grand_Turk`, `Africa/Ndjamena`, `Indian/Kerguelen`, `Africa/Lome`, `Asia/Bangkok`, `Asia/Dushanbe`,
               `Pacific/Fakaofo`, `Asia/Dili`, `Asia/Ashgabat`, `Africa/Tunis`, `Pacific/Tongatapu`, `Europe/Istanbul`,
               `America/Port_of_Spain`, `Pacific/Funafuti`, `Asia/Taipei`, `Africa/Dar_es_Salaam`, `Europe/Kiev`, `Europe/Uzhgorod`,
               `Europe/Zaporozhye`, `Europe/Simferopol`, `Africa/Kampala`, `Pacific/Johnston`, `Pacific/Midway`, `Pacific/Wake`,
               `America/New_York`, `America/Detroit`, `America/Kentucky/Louisville`, `America/Kentucky/Monticello`,
               `America/Indiana/Indianapolis`, `America/Indiana/Vincennes`, `America/Indiana/Winamac`, `America/Indiana/Marengo`,
               `America/Indiana/Petersburg`, `America/Indiana/Vevay`, `America/Chicago`, `America/Indiana/Tell_City`,
               `America/Indiana/Knox`, `America/Menominee`, `America/North_Dakota/Center`, `America/North_Dakota/New_Salem`,
               `America/North_Dakota/Beulah`, `America/Denver`, `America/Boise`, `America/Phoenix`, `America/Los_Angeles`,
               `America/Anchorage`, `America/Juneau`, `America/Sitka`, `America/Yakutat`, `America/Nome`, `America/Adak`,
               `America/Metlakatla`, `Pacific/Honolulu`, `America/Montevideo`, `Asia/Samarkand`, `Asia/Tashkent`, `Europe/Vatican`,
               `America/St_Vincent`, `America/Caracas`, `America/Tortola`, `America/St_Thomas`, `Asia/Ho_Chi_Minh`, `Pacific/Efate`,
               `Pacific/Wallis`, `Pacific/Apia`, `Asia/Aden`, `Indian/Mayotte`, `Africa/Johannesburg`, `Africa/Lusaka`,
               `Africa/Harare`, `UTC` - Default value: `UTC`
        :param pulumi.Input[str] timezone_variable: Variable name
        :param pulumi.Input[bool] track_default_gateway: Enable or disable default gateway tracking - Default value: `true`
        :param pulumi.Input[str] track_default_gateway_variable: Variable name
        :param pulumi.Input[int] track_interface_tag: OMP Tag attached to routes based on interface tracking - Range: `1`-`4294967295`
        :param pulumi.Input[str] track_interface_tag_variable: Variable name
        :param pulumi.Input[bool] track_transport: Configure tracking of transport - Default value: `true`
        :param pulumi.Input[str] track_transport_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSystemFeatureTemplateTrackerArgs', 'CiscoSystemFeatureTemplateTrackerArgsDict']]]] trackers: Tracker configuration
        :param pulumi.Input[bool] transport_gateway: Enable transport gateway - Default value: `false`
        :param pulumi.Input[str] transport_gateway_variable: Variable name
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoSystemFeatureTemplateState.__new__(_CiscoSystemFeatureTemplateState)

        __props__.__dict__["admin_tech_on_failure"] = admin_tech_on_failure
        __props__.__dict__["admin_tech_on_failure_variable"] = admin_tech_on_failure_variable
        __props__.__dict__["affinity_group_number"] = affinity_group_number
        __props__.__dict__["affinity_group_number_variable"] = affinity_group_number_variable
        __props__.__dict__["affinity_group_preference_variable"] = affinity_group_preference_variable
        __props__.__dict__["affinity_group_preferences"] = affinity_group_preferences
        __props__.__dict__["console_baud_rate"] = console_baud_rate
        __props__.__dict__["console_baud_rate_variable"] = console_baud_rate_variable
        __props__.__dict__["control_session_pps"] = control_session_pps
        __props__.__dict__["control_session_pps_variable"] = control_session_pps_variable
        __props__.__dict__["controller_group_list_variable"] = controller_group_list_variable
        __props__.__dict__["controller_group_lists"] = controller_group_lists
        __props__.__dict__["description"] = description
        __props__.__dict__["device_groups"] = device_groups
        __props__.__dict__["device_groups_variable"] = device_groups_variable
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["enable_mrf_migration"] = enable_mrf_migration
        __props__.__dict__["geo_fencing"] = geo_fencing
        __props__.__dict__["geo_fencing_range"] = geo_fencing_range
        __props__.__dict__["geo_fencing_range_variable"] = geo_fencing_range_variable
        __props__.__dict__["geo_fencing_sms"] = geo_fencing_sms
        __props__.__dict__["geo_fencing_sms_phone_numbers"] = geo_fencing_sms_phone_numbers
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["hostname_variable"] = hostname_variable
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["idle_timeout_variable"] = idle_timeout_variable
        __props__.__dict__["latitude"] = latitude
        __props__.__dict__["latitude_variable"] = latitude_variable
        __props__.__dict__["location"] = location
        __props__.__dict__["location_variable"] = location_variable
        __props__.__dict__["longitude"] = longitude
        __props__.__dict__["longitude_variable"] = longitude_variable
        __props__.__dict__["max_omp_sessions"] = max_omp_sessions
        __props__.__dict__["max_omp_sessions_variable"] = max_omp_sessions_variable
        __props__.__dict__["migration_bgp_community"] = migration_bgp_community
        __props__.__dict__["multi_tenant"] = multi_tenant
        __props__.__dict__["multi_tenant_variable"] = multi_tenant_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["object_trackers"] = object_trackers
        __props__.__dict__["on_demand_tunnel"] = on_demand_tunnel
        __props__.__dict__["on_demand_tunnel_idle_timeout"] = on_demand_tunnel_idle_timeout
        __props__.__dict__["on_demand_tunnel_idle_timeout_variable"] = on_demand_tunnel_idle_timeout_variable
        __props__.__dict__["on_demand_tunnel_variable"] = on_demand_tunnel_variable
        __props__.__dict__["overlay_id"] = overlay_id
        __props__.__dict__["overlay_id_variable"] = overlay_id_variable
        __props__.__dict__["port_hopping"] = port_hopping
        __props__.__dict__["port_hopping_variable"] = port_hopping_variable
        __props__.__dict__["port_offset"] = port_offset
        __props__.__dict__["port_offset_variable"] = port_offset_variable
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["region_id_variable"] = region_id_variable
        __props__.__dict__["role"] = role
        __props__.__dict__["role_variable"] = role_variable
        __props__.__dict__["secondary_region_id"] = secondary_region_id
        __props__.__dict__["secondary_region_id_variable"] = secondary_region_id_variable
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_id_variable"] = site_id_variable
        __props__.__dict__["system_description"] = system_description
        __props__.__dict__["system_description_variable"] = system_description_variable
        __props__.__dict__["system_ip"] = system_ip
        __props__.__dict__["system_ip_variable"] = system_ip_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["timezone_variable"] = timezone_variable
        __props__.__dict__["track_default_gateway"] = track_default_gateway
        __props__.__dict__["track_default_gateway_variable"] = track_default_gateway_variable
        __props__.__dict__["track_interface_tag"] = track_interface_tag
        __props__.__dict__["track_interface_tag_variable"] = track_interface_tag_variable
        __props__.__dict__["track_transport"] = track_transport
        __props__.__dict__["track_transport_variable"] = track_transport_variable
        __props__.__dict__["trackers"] = trackers
        __props__.__dict__["transport_gateway"] = transport_gateway
        __props__.__dict__["transport_gateway_variable"] = transport_gateway_variable
        __props__.__dict__["version"] = version
        return CiscoSystemFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminTechOnFailure")
    def admin_tech_on_failure(self) -> pulumi.Output[Optional[bool]]:
        """
        Collect admin-tech before reboot due to daemon failure - Default value: `true`
        """
        return pulumi.get(self, "admin_tech_on_failure")

    @property
    @pulumi.getter(name="adminTechOnFailureVariable")
    def admin_tech_on_failure_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "admin_tech_on_failure_variable")

    @property
    @pulumi.getter(name="affinityGroupNumber")
    def affinity_group_number(self) -> pulumi.Output[Optional[int]]:
        """
        Set the affinity group number for router - Range: `1`-`255`
        """
        return pulumi.get(self, "affinity_group_number")

    @property
    @pulumi.getter(name="affinityGroupNumberVariable")
    def affinity_group_number_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "affinity_group_number_variable")

    @property
    @pulumi.getter(name="affinityGroupPreferenceVariable")
    def affinity_group_preference_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "affinity_group_preference_variable")

    @property
    @pulumi.getter(name="affinityGroupPreferences")
    def affinity_group_preferences(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        Set the affinity group preference
        """
        return pulumi.get(self, "affinity_group_preferences")

    @property
    @pulumi.getter(name="consoleBaudRate")
    def console_baud_rate(self) -> pulumi.Output[Optional[str]]:
        """
        Set the console baud rate - Choices: `1200`, `2400`, `4800`, `9600`, `19200`, `38400`, `57600`, `115200` - Default
        value: `9600`
        """
        return pulumi.get(self, "console_baud_rate")

    @property
    @pulumi.getter(name="consoleBaudRateVariable")
    def console_baud_rate_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "console_baud_rate_variable")

    @property
    @pulumi.getter(name="controlSessionPps")
    def control_session_pps(self) -> pulumi.Output[Optional[int]]:
        """
        Set the policer rate for control sessions - Range: `1`-`65535` - Default value: `300`
        """
        return pulumi.get(self, "control_session_pps")

    @property
    @pulumi.getter(name="controlSessionPpsVariable")
    def control_session_pps_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "control_session_pps_variable")

    @property
    @pulumi.getter(name="controllerGroupListVariable")
    def controller_group_list_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "controller_group_list_variable")

    @property
    @pulumi.getter(name="controllerGroupLists")
    def controller_group_lists(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        Configure a list of comma-separated device groups
        """
        return pulumi.get(self, "controller_group_lists")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceGroups")
    def device_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Device groups (Use comma(,) for multiple groups)
        """
        return pulumi.get(self, "device_groups")

    @property
    @pulumi.getter(name="deviceGroupsVariable")
    def device_groups_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "device_groups_variable")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="enableMrfMigration")
    def enable_mrf_migration(self) -> pulumi.Output[Optional[str]]:
        """
        Enable migration mode to Multi-Region Fabric - Choices: `enabled`, `enabled-from-bgp-core`
        """
        return pulumi.get(self, "enable_mrf_migration")

    @property
    @pulumi.getter(name="geoFencing")
    def geo_fencing(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Geo fencing - Default value: `false`
        """
        return pulumi.get(self, "geo_fencing")

    @property
    @pulumi.getter(name="geoFencingRange")
    def geo_fencing_range(self) -> pulumi.Output[Optional[int]]:
        """
        Set the device’s geo fencing range - Range: `100`-`10000` - Default value: `100`
        """
        return pulumi.get(self, "geo_fencing_range")

    @property
    @pulumi.getter(name="geoFencingRangeVariable")
    def geo_fencing_range_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "geo_fencing_range_variable")

    @property
    @pulumi.getter(name="geoFencingSms")
    def geo_fencing_sms(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Geo fencing - Default value: `false`
        """
        return pulumi.get(self, "geo_fencing_sms")

    @property
    @pulumi.getter(name="geoFencingSmsPhoneNumbers")
    def geo_fencing_sms_phone_numbers(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSystemFeatureTemplateGeoFencingSmsPhoneNumber']]]:
        """
        Set device’s geo fencing SMS phone number
        """
        return pulumi.get(self, "geo_fencing_sms_phone_numbers")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional[str]]:
        """
        Set the hostname
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="hostnameVariable")
    def hostname_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "hostname_variable")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Idle CLI timeout in minutes - Range: `0`-`300`
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="idleTimeoutVariable")
    def idle_timeout_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "idle_timeout_variable")

    @property
    @pulumi.getter
    def latitude(self) -> pulumi.Output[Optional[float]]:
        """
        Set the device’s physical latitude - Range: `-90`-`90`
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter(name="latitudeVariable")
    def latitude_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "latitude_variable")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        Set the location of the device
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationVariable")
    def location_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "location_variable")

    @property
    @pulumi.getter
    def longitude(self) -> pulumi.Output[Optional[float]]:
        """
        Set the device’s physical longitude - Range: `-180`-`180`
        """
        return pulumi.get(self, "longitude")

    @property
    @pulumi.getter(name="longitudeVariable")
    def longitude_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "longitude_variable")

    @property
    @pulumi.getter(name="maxOmpSessions")
    def max_omp_sessions(self) -> pulumi.Output[Optional[int]]:
        """
        Set the maximum number of OMP sessions <1..100> the device can have - Range: `1`-`100`
        """
        return pulumi.get(self, "max_omp_sessions")

    @property
    @pulumi.getter(name="maxOmpSessionsVariable")
    def max_omp_sessions_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "max_omp_sessions_variable")

    @property
    @pulumi.getter(name="migrationBgpCommunity")
    def migration_bgp_community(self) -> pulumi.Output[Optional[int]]:
        """
        Set BGP community during migration from BGP-core based network - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "migration_bgp_community")

    @property
    @pulumi.getter(name="multiTenant")
    def multi_tenant(self) -> pulumi.Output[Optional[bool]]:
        """
        Device is multi-tenant - Default value: `false`
        """
        return pulumi.get(self, "multi_tenant")

    @property
    @pulumi.getter(name="multiTenantVariable")
    def multi_tenant_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multi_tenant_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectTrackers")
    def object_trackers(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSystemFeatureTemplateObjectTracker']]]:
        """
        Object Track configuration
        """
        return pulumi.get(self, "object_trackers")

    @property
    @pulumi.getter(name="onDemandTunnel")
    def on_demand_tunnel(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable On-demand Tunnel - Default value: `false`
        """
        return pulumi.get(self, "on_demand_tunnel")

    @property
    @pulumi.getter(name="onDemandTunnelIdleTimeout")
    def on_demand_tunnel_idle_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Idle CLI timeout in minutes - Range: `0`-`300`
        """
        return pulumi.get(self, "on_demand_tunnel_idle_timeout")

    @property
    @pulumi.getter(name="onDemandTunnelIdleTimeoutVariable")
    def on_demand_tunnel_idle_timeout_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "on_demand_tunnel_idle_timeout_variable")

    @property
    @pulumi.getter(name="onDemandTunnelVariable")
    def on_demand_tunnel_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "on_demand_tunnel_variable")

    @property
    @pulumi.getter(name="overlayId")
    def overlay_id(self) -> pulumi.Output[Optional[int]]:
        """
        Set the Overlay ID - Range: `1`-`4294967295` - Default value: `1`
        """
        return pulumi.get(self, "overlay_id")

    @property
    @pulumi.getter(name="overlayIdVariable")
    def overlay_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "overlay_id_variable")

    @property
    @pulumi.getter(name="portHopping")
    def port_hopping(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable port hopping - Default value: `true`
        """
        return pulumi.get(self, "port_hopping")

    @property
    @pulumi.getter(name="portHoppingVariable")
    def port_hopping_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "port_hopping_variable")

    @property
    @pulumi.getter(name="portOffset")
    def port_offset(self) -> pulumi.Output[Optional[int]]:
        """
        Set the TLOC port offset when multiple devices are behind a NAT - Range: `0`-`19` - Default value: `0`
        """
        return pulumi.get(self, "port_offset")

    @property
    @pulumi.getter(name="portOffsetVariable")
    def port_offset_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "port_offset_variable")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[Optional[int]]:
        """
        Set region ID - Range: `1`-`63`
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="regionIdVariable")
    def region_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "region_id_variable")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        Set the role for router - Choices: `edge-router`, `border-router`
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="roleVariable")
    def role_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "role_variable")

    @property
    @pulumi.getter(name="secondaryRegionId")
    def secondary_region_id(self) -> pulumi.Output[Optional[int]]:
        """
        Set secondary region ID - Range: `1`-`63`
        """
        return pulumi.get(self, "secondary_region_id")

    @property
    @pulumi.getter(name="secondaryRegionIdVariable")
    def secondary_region_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "secondary_region_id_variable")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[Optional[int]]:
        """
        Set the site identifier - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteIdVariable")
    def site_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "site_id_variable")

    @property
    @pulumi.getter(name="systemDescription")
    def system_description(self) -> pulumi.Output[Optional[str]]:
        """
        Set a text description of the device
        """
        return pulumi.get(self, "system_description")

    @property
    @pulumi.getter(name="systemDescriptionVariable")
    def system_description_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "system_description_variable")

    @property
    @pulumi.getter(name="systemIp")
    def system_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Set the system IP address
        """
        return pulumi.get(self, "system_ip")

    @property
    @pulumi.getter(name="systemIpVariable")
    def system_ip_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "system_ip_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        """
        Set the timezone - Choices: `Europe/Andorra`, `Asia/Dubai`, `Asia/Kabul`, `America/Antigua`, `America/Anguilla`,
        `Europe/Tirane`, `Asia/Yerevan`, `Africa/Luanda`, `Antarctica/McMurdo`, `Antarctica/Rothera`, `Antarctica/Palmer`,
        `Antarctica/Mawson`, `Antarctica/Davis`, `Antarctica/Casey`, `Antarctica/Vostok`, `Antarctica/DumontDUrville`,
        `Antarctica/Syowa`, `America/Argentina/Buenos_Aires`, `America/Argentina/Cordoba`, `America/Argentina/Salta`,
        `America/Argentina/Jujuy`, `America/Argentina/Tucuman`, `America/Argentina/Catamarca`, `America/Argentina/La_Rioja`,
        `America/Argentina/San_Juan`, `America/Argentina/Mendoza`, `America/Argentina/San_Luis`,
        `America/Argentina/Rio_Gallegos`, `America/Argentina/Ushuaia`, `Pacific/Pago_Pago`, `Europe/Vienna`,
        `Australia/Lord_Howe`, `Antarctica/Macquarie`, `Australia/Hobart`, `Australia/Currie`, `Australia/Melbourne`,
        `Australia/Sydney`, `Australia/Broken_Hill`, `Australia/Brisbane`, `Australia/Lindeman`, `Australia/Adelaide`,
        `Australia/Darwin`, `Australia/Perth`, `Australia/Eucla`, `America/Aruba`, `Europe/Mariehamn`, `Asia/Baku`,
        `Europe/Sarajevo`, `America/Barbados`, `Asia/Dhaka`, `Europe/Brussels`, `Africa/Ouagadougou`, `Europe/Sofia`,
        `Asia/Bahrain`, `Africa/Bujumbura`, `Africa/Porto-Novo`, `America/St_Barthelemy`, `Atlantic/Bermuda`, `Asia/Brunei`,
        `America/La_Paz`, `America/Kralendijk`, `America/Noronha`, `America/Belem`, `America/Fortaleza`, `America/Recife`,
        `America/Araguaina`, `America/Maceio`, `America/Bahia`, `America/Sao_Paulo`, `America/Campo_Grande`, `America/Cuiaba`,
        `America/Santarem`, `America/Porto_Velho`, `America/Boa_Vista`, `America/Manaus`, `America/Eirunepe`,
        `America/Rio_Branco`, `America/Nassau`, `Asia/Thimphu`, `Africa/Gaborone`, `Europe/Minsk`, `America/Belize`,
        `America/St_Johns`, `America/Halifax`, `America/Glace_Bay`, `America/Moncton`, `America/Goose_Bay`,
        `America/Blanc-Sablon`, `America/Toronto`, `America/Nipigon`, `America/Thunder_Bay`, `America/Iqaluit`,
        `America/Pangnirtung`, `America/Resolute`, `America/Atikokan`, `America/Rankin_Inlet`, `America/Winnipeg`,
        `America/Rainy_River`, `America/Regina`, `America/Swift_Current`, `America/Edmonton`, `America/Cambridge_Bay`,
        `America/Yellowknife`, `America/Inuvik`, `America/Creston`, `America/Dawson_Creek`, `America/Vancouver`,
        `America/Whitehorse`, `America/Dawson`, `Indian/Cocos`, `Africa/Kinshasa`, `Africa/Lubumbashi`, `Africa/Bangui`,
        `Africa/Brazzaville`, `Europe/Zurich`, `Africa/Abidjan`, `Pacific/Rarotonga`, `America/Santiago`, `Pacific/Easter`,
        `Africa/Douala`, `Asia/Shanghai`, `Asia/Harbin`, `Asia/Chongqing`, `Asia/Urumqi`, `Asia/Kashgar`, `America/Bogota`,
        `America/Costa_Rica`, `America/Havana`, `Atlantic/Cape_Verde`, `America/Curacao`, `Indian/Christmas`, `Asia/Nicosia`,
        `Europe/Prague`, `Europe/Berlin`, `Europe/Busingen`, `Africa/Djibouti`, `Europe/Copenhagen`, `America/Dominica`,
        `America/Santo_Domingo`, `Africa/Algiers`, `America/Guayaquil`, `Pacific/Galapagos`, `Europe/Tallinn`, `Africa/Cairo`,
        `Africa/El_Aaiun`, `Africa/Asmara`, `Europe/Madrid`, `Africa/Ceuta`, `Atlantic/Canary`, `Africa/Addis_Ababa`,
        `Europe/Helsinki`, `Pacific/Fiji`, `Atlantic/Stanley`, `Pacific/Chuuk`, `Pacific/Pohnpei`, `Pacific/Kosrae`,
        `Atlantic/Faroe`, `Europe/Paris`, `Africa/Libreville`, `Europe/London`, `America/Grenada`, `Asia/Tbilisi`,
        `America/Cayenne`, `Europe/Guernsey`, `Africa/Accra`, `Europe/Gibraltar`, `America/Godthab`, `America/Danmarkshavn`,
        `America/Scoresbysund`, `America/Thule`, `Africa/Banjul`, `Africa/Conakry`, `America/Guadeloupe`, `Africa/Malabo`,
        `Europe/Athens`, `Atlantic/South_Georgia`, `America/Guatemala`, `Pacific/Guam`, `Africa/Bissau`, `America/Guyana`,
        `Asia/Hong_Kong`, `America/Tegucigalpa`, `Europe/Zagreb`, `America/Port-au-Prince`, `Europe/Budapest`, `Asia/Jakarta`,
        `Asia/Pontianak`, `Asia/Makassar`, `Asia/Jayapura`, `Europe/Dublin`, `Asia/Jerusalem`, `Europe/Isle_of_Man`,
        `Asia/Kolkata`, `Indian/Chagos`, `Asia/Baghdad`, `Asia/Tehran`, `Atlantic/Reykjavik`, `Europe/Rome`, `Europe/Jersey`,
        `America/Jamaica`, `Asia/Amman`, `Asia/Tokyo`, `Africa/Nairobi`, `Asia/Bishkek`, `Asia/Phnom_Penh`, `Pacific/Tarawa`,
        `Pacific/Enderbury`, `Pacific/Kiritimati`, `Indian/Comoro`, `America/St_Kitts`, `Asia/Pyongyang`, `Asia/Seoul`,
        `Asia/Kuwait`, `America/Cayman`, `Asia/Almaty`, `Asia/Qyzylorda`, `Asia/Aqtobe`, `Asia/Aqtau`, `Asia/Oral`,
        `Asia/Vientiane`, `Asia/Beirut`, `America/St_Lucia`, `Europe/Vaduz`, `Asia/Colombo`, `Africa/Monrovia`, `Africa/Maseru`,
        `Europe/Vilnius`, `Europe/Luxembourg`, `Europe/Riga`, `Africa/Tripoli`, `Africa/Casablanca`, `Europe/Monaco`,
        `Europe/Chisinau`, `Europe/Podgorica`, `America/Marigot`, `Indian/Antananarivo`, `Pacific/Majuro`, `Pacific/Kwajalein`,
        `Europe/Skopje`, `Africa/Bamako`, `Asia/Rangoon`, `Asia/Ulaanbaatar`, `Asia/Hovd`, `Asia/Choibalsan`, `Asia/Macau`,
        `Pacific/Saipan`, `America/Martinique`, `Africa/Nouakchott`, `America/Montserrat`, `Europe/Malta`, `Indian/Mauritius`,
        `Indian/Maldives`, `Africa/Blantyre`, `America/Mexico_City`, `America/Cancun`, `America/Merida`, `America/Monterrey`,
        `America/Matamoros`, `America/Mazatlan`, `America/Chihuahua`, `America/Ojinaga`, `America/Hermosillo`,
        `America/Tijuana`, `America/Santa_Isabel`, `America/Bahia_Banderas`, `Asia/Kuala_Lumpur`, `Asia/Kuching`,
        `Africa/Maputo`, `Africa/Windhoek`, `Pacific/Noumea`, `Africa/Niamey`, `Pacific/Norfolk`, `Africa/Lagos`,
        `America/Managua`, `Europe/Amsterdam`, `Europe/Oslo`, `Asia/Kathmandu`, `Pacific/Nauru`, `Pacific/Niue`,
        `Pacific/Auckland`, `Pacific/Chatham`, `Asia/Muscat`, `America/Panama`, `America/Lima`, `Pacific/Tahiti`,
        `Pacific/Marquesas`, `Pacific/Gambier`, `Pacific/Port_Moresby`, `Asia/Manila`, `Asia/Karachi`, `Europe/Warsaw`,
        `America/Miquelon`, `Pacific/Pitcairn`, `America/Puerto_Rico`, `Asia/Gaza`, `Asia/Hebron`, `Europe/Lisbon`,
        `Atlantic/Madeira`, `Atlantic/Azores`, `Pacific/Palau`, `America/Asuncion`, `Asia/Qatar`, `Indian/Reunion`,
        `Europe/Bucharest`, `Europe/Belgrade`, `Europe/Kaliningrad`, `Europe/Moscow`, `Europe/Volgograd`, `Europe/Samara`,
        `Asia/Yekaterinburg`, `Asia/Omsk`, `Asia/Novosibirsk`, `Asia/Novokuznetsk`, `Asia/Krasnoyarsk`, `Asia/Irkutsk`,
        `Asia/Yakutsk`, `Asia/Khandyga`, `Asia/Vladivostok`, `Asia/Sakhalin`, `Asia/Ust-Nera`, `Asia/Magadan`, `Asia/Kamchatka`,
        `Asia/Anadyr`, `Africa/Kigali`, `Asia/Riyadh`, `Pacific/Guadalcanal`, `Indian/Mahe`, `Africa/Khartoum`,
        `Europe/Stockholm`, `Asia/Singapore`, `Atlantic/St_Helena`, `Europe/Ljubljana`, `Arctic/Longyearbyen`,
        `Europe/Bratislava`, `Africa/Freetown`, `Europe/San_Marino`, `Africa/Dakar`, `Africa/Mogadishu`, `America/Paramaribo`,
        `Africa/Juba`, `Africa/Sao_Tome`, `America/El_Salvador`, `America/Lower_Princes`, `Asia/Damascus`, `Africa/Mbabane`,
        `America/Grand_Turk`, `Africa/Ndjamena`, `Indian/Kerguelen`, `Africa/Lome`, `Asia/Bangkok`, `Asia/Dushanbe`,
        `Pacific/Fakaofo`, `Asia/Dili`, `Asia/Ashgabat`, `Africa/Tunis`, `Pacific/Tongatapu`, `Europe/Istanbul`,
        `America/Port_of_Spain`, `Pacific/Funafuti`, `Asia/Taipei`, `Africa/Dar_es_Salaam`, `Europe/Kiev`, `Europe/Uzhgorod`,
        `Europe/Zaporozhye`, `Europe/Simferopol`, `Africa/Kampala`, `Pacific/Johnston`, `Pacific/Midway`, `Pacific/Wake`,
        `America/New_York`, `America/Detroit`, `America/Kentucky/Louisville`, `America/Kentucky/Monticello`,
        `America/Indiana/Indianapolis`, `America/Indiana/Vincennes`, `America/Indiana/Winamac`, `America/Indiana/Marengo`,
        `America/Indiana/Petersburg`, `America/Indiana/Vevay`, `America/Chicago`, `America/Indiana/Tell_City`,
        `America/Indiana/Knox`, `America/Menominee`, `America/North_Dakota/Center`, `America/North_Dakota/New_Salem`,
        `America/North_Dakota/Beulah`, `America/Denver`, `America/Boise`, `America/Phoenix`, `America/Los_Angeles`,
        `America/Anchorage`, `America/Juneau`, `America/Sitka`, `America/Yakutat`, `America/Nome`, `America/Adak`,
        `America/Metlakatla`, `Pacific/Honolulu`, `America/Montevideo`, `Asia/Samarkand`, `Asia/Tashkent`, `Europe/Vatican`,
        `America/St_Vincent`, `America/Caracas`, `America/Tortola`, `America/St_Thomas`, `Asia/Ho_Chi_Minh`, `Pacific/Efate`,
        `Pacific/Wallis`, `Pacific/Apia`, `Asia/Aden`, `Indian/Mayotte`, `Africa/Johannesburg`, `Africa/Lusaka`,
        `Africa/Harare`, `UTC` - Default value: `UTC`
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="timezoneVariable")
    def timezone_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "timezone_variable")

    @property
    @pulumi.getter(name="trackDefaultGateway")
    def track_default_gateway(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable default gateway tracking - Default value: `true`
        """
        return pulumi.get(self, "track_default_gateway")

    @property
    @pulumi.getter(name="trackDefaultGatewayVariable")
    def track_default_gateway_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "track_default_gateway_variable")

    @property
    @pulumi.getter(name="trackInterfaceTag")
    def track_interface_tag(self) -> pulumi.Output[Optional[int]]:
        """
        OMP Tag attached to routes based on interface tracking - Range: `1`-`4294967295`
        """
        return pulumi.get(self, "track_interface_tag")

    @property
    @pulumi.getter(name="trackInterfaceTagVariable")
    def track_interface_tag_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "track_interface_tag_variable")

    @property
    @pulumi.getter(name="trackTransport")
    def track_transport(self) -> pulumi.Output[Optional[bool]]:
        """
        Configure tracking of transport - Default value: `true`
        """
        return pulumi.get(self, "track_transport")

    @property
    @pulumi.getter(name="trackTransportVariable")
    def track_transport_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "track_transport_variable")

    @property
    @pulumi.getter
    def trackers(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSystemFeatureTemplateTracker']]]:
        """
        Tracker configuration
        """
        return pulumi.get(self, "trackers")

    @property
    @pulumi.getter(name="transportGateway")
    def transport_gateway(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable transport gateway - Default value: `false`
        """
        return pulumi.get(self, "transport_gateway")

    @property
    @pulumi.getter(name="transportGatewayVariable")
    def transport_gateway_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "transport_gateway_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

