# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetTransportRoutingOspfFeatureResult',
    'AwaitableGetTransportRoutingOspfFeatureResult',
    'get_transport_routing_ospf_feature',
    'get_transport_routing_ospf_feature_output',
]

@pulumi.output_type
class GetTransportRoutingOspfFeatureResult:
    """
    A collection of values returned by getTransportRoutingOspfFeature.
    """
    def __init__(__self__, areas=None, default_information_originate=None, default_information_originate_always=None, default_information_originate_always_variable=None, default_information_originate_metric=None, default_information_originate_metric_type=None, default_information_originate_metric_type_variable=None, default_information_originate_metric_variable=None, description=None, distance_external=None, distance_external_variable=None, distance_inter_area=None, distance_inter_area_variable=None, distance_intra_area=None, distance_intra_area_variable=None, feature_profile_id=None, id=None, name=None, redistributes=None, reference_bandwidth=None, reference_bandwidth_variable=None, rfc1583_compatible=None, rfc1583_compatible_variable=None, route_policy_id=None, router_id=None, router_id_variable=None, router_lsas=None, spf_calculation_delay=None, spf_calculation_delay_variable=None, spf_initial_hold_time=None, spf_initial_hold_time_variable=None, spf_maximum_hold_time=None, spf_maximum_hold_time_variable=None, version=None):
        if areas and not isinstance(areas, list):
            raise TypeError("Expected argument 'areas' to be a list")
        pulumi.set(__self__, "areas", areas)
        if default_information_originate and not isinstance(default_information_originate, bool):
            raise TypeError("Expected argument 'default_information_originate' to be a bool")
        pulumi.set(__self__, "default_information_originate", default_information_originate)
        if default_information_originate_always and not isinstance(default_information_originate_always, bool):
            raise TypeError("Expected argument 'default_information_originate_always' to be a bool")
        pulumi.set(__self__, "default_information_originate_always", default_information_originate_always)
        if default_information_originate_always_variable and not isinstance(default_information_originate_always_variable, str):
            raise TypeError("Expected argument 'default_information_originate_always_variable' to be a str")
        pulumi.set(__self__, "default_information_originate_always_variable", default_information_originate_always_variable)
        if default_information_originate_metric and not isinstance(default_information_originate_metric, int):
            raise TypeError("Expected argument 'default_information_originate_metric' to be a int")
        pulumi.set(__self__, "default_information_originate_metric", default_information_originate_metric)
        if default_information_originate_metric_type and not isinstance(default_information_originate_metric_type, str):
            raise TypeError("Expected argument 'default_information_originate_metric_type' to be a str")
        pulumi.set(__self__, "default_information_originate_metric_type", default_information_originate_metric_type)
        if default_information_originate_metric_type_variable and not isinstance(default_information_originate_metric_type_variable, str):
            raise TypeError("Expected argument 'default_information_originate_metric_type_variable' to be a str")
        pulumi.set(__self__, "default_information_originate_metric_type_variable", default_information_originate_metric_type_variable)
        if default_information_originate_metric_variable and not isinstance(default_information_originate_metric_variable, str):
            raise TypeError("Expected argument 'default_information_originate_metric_variable' to be a str")
        pulumi.set(__self__, "default_information_originate_metric_variable", default_information_originate_metric_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if distance_external and not isinstance(distance_external, int):
            raise TypeError("Expected argument 'distance_external' to be a int")
        pulumi.set(__self__, "distance_external", distance_external)
        if distance_external_variable and not isinstance(distance_external_variable, str):
            raise TypeError("Expected argument 'distance_external_variable' to be a str")
        pulumi.set(__self__, "distance_external_variable", distance_external_variable)
        if distance_inter_area and not isinstance(distance_inter_area, int):
            raise TypeError("Expected argument 'distance_inter_area' to be a int")
        pulumi.set(__self__, "distance_inter_area", distance_inter_area)
        if distance_inter_area_variable and not isinstance(distance_inter_area_variable, str):
            raise TypeError("Expected argument 'distance_inter_area_variable' to be a str")
        pulumi.set(__self__, "distance_inter_area_variable", distance_inter_area_variable)
        if distance_intra_area and not isinstance(distance_intra_area, int):
            raise TypeError("Expected argument 'distance_intra_area' to be a int")
        pulumi.set(__self__, "distance_intra_area", distance_intra_area)
        if distance_intra_area_variable and not isinstance(distance_intra_area_variable, str):
            raise TypeError("Expected argument 'distance_intra_area_variable' to be a str")
        pulumi.set(__self__, "distance_intra_area_variable", distance_intra_area_variable)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if redistributes and not isinstance(redistributes, list):
            raise TypeError("Expected argument 'redistributes' to be a list")
        pulumi.set(__self__, "redistributes", redistributes)
        if reference_bandwidth and not isinstance(reference_bandwidth, int):
            raise TypeError("Expected argument 'reference_bandwidth' to be a int")
        pulumi.set(__self__, "reference_bandwidth", reference_bandwidth)
        if reference_bandwidth_variable and not isinstance(reference_bandwidth_variable, str):
            raise TypeError("Expected argument 'reference_bandwidth_variable' to be a str")
        pulumi.set(__self__, "reference_bandwidth_variable", reference_bandwidth_variable)
        if rfc1583_compatible and not isinstance(rfc1583_compatible, bool):
            raise TypeError("Expected argument 'rfc1583_compatible' to be a bool")
        pulumi.set(__self__, "rfc1583_compatible", rfc1583_compatible)
        if rfc1583_compatible_variable and not isinstance(rfc1583_compatible_variable, str):
            raise TypeError("Expected argument 'rfc1583_compatible_variable' to be a str")
        pulumi.set(__self__, "rfc1583_compatible_variable", rfc1583_compatible_variable)
        if route_policy_id and not isinstance(route_policy_id, str):
            raise TypeError("Expected argument 'route_policy_id' to be a str")
        pulumi.set(__self__, "route_policy_id", route_policy_id)
        if router_id and not isinstance(router_id, str):
            raise TypeError("Expected argument 'router_id' to be a str")
        pulumi.set(__self__, "router_id", router_id)
        if router_id_variable and not isinstance(router_id_variable, str):
            raise TypeError("Expected argument 'router_id_variable' to be a str")
        pulumi.set(__self__, "router_id_variable", router_id_variable)
        if router_lsas and not isinstance(router_lsas, list):
            raise TypeError("Expected argument 'router_lsas' to be a list")
        pulumi.set(__self__, "router_lsas", router_lsas)
        if spf_calculation_delay and not isinstance(spf_calculation_delay, int):
            raise TypeError("Expected argument 'spf_calculation_delay' to be a int")
        pulumi.set(__self__, "spf_calculation_delay", spf_calculation_delay)
        if spf_calculation_delay_variable and not isinstance(spf_calculation_delay_variable, str):
            raise TypeError("Expected argument 'spf_calculation_delay_variable' to be a str")
        pulumi.set(__self__, "spf_calculation_delay_variable", spf_calculation_delay_variable)
        if spf_initial_hold_time and not isinstance(spf_initial_hold_time, int):
            raise TypeError("Expected argument 'spf_initial_hold_time' to be a int")
        pulumi.set(__self__, "spf_initial_hold_time", spf_initial_hold_time)
        if spf_initial_hold_time_variable and not isinstance(spf_initial_hold_time_variable, str):
            raise TypeError("Expected argument 'spf_initial_hold_time_variable' to be a str")
        pulumi.set(__self__, "spf_initial_hold_time_variable", spf_initial_hold_time_variable)
        if spf_maximum_hold_time and not isinstance(spf_maximum_hold_time, int):
            raise TypeError("Expected argument 'spf_maximum_hold_time' to be a int")
        pulumi.set(__self__, "spf_maximum_hold_time", spf_maximum_hold_time)
        if spf_maximum_hold_time_variable and not isinstance(spf_maximum_hold_time_variable, str):
            raise TypeError("Expected argument 'spf_maximum_hold_time_variable' to be a str")
        pulumi.set(__self__, "spf_maximum_hold_time_variable", spf_maximum_hold_time_variable)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def areas(self) -> Sequence['outputs.GetTransportRoutingOspfFeatureAreaResult']:
        """
        Configure OSPF area
        """
        return pulumi.get(self, "areas")

    @property
    @pulumi.getter(name="defaultInformationOriginate")
    def default_information_originate(self) -> bool:
        """
        Distribute default external route into OSPF
        """
        return pulumi.get(self, "default_information_originate")

    @property
    @pulumi.getter(name="defaultInformationOriginateAlways")
    def default_information_originate_always(self) -> bool:
        """
        Always advertise default route
        """
        return pulumi.get(self, "default_information_originate_always")

    @property
    @pulumi.getter(name="defaultInformationOriginateAlwaysVariable")
    def default_information_originate_always_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_always_variable")

    @property
    @pulumi.getter(name="defaultInformationOriginateMetric")
    def default_information_originate_metric(self) -> int:
        """
        Set metric used to generate default route \\n\\n
        """
        return pulumi.get(self, "default_information_originate_metric")

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricType")
    def default_information_originate_metric_type(self) -> str:
        """
        Set default route type
        """
        return pulumi.get(self, "default_information_originate_metric_type")

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricTypeVariable")
    def default_information_originate_metric_type_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_type_variable")

    @property
    @pulumi.getter(name="defaultInformationOriginateMetricVariable")
    def default_information_originate_metric_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "default_information_originate_metric_variable")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="distanceExternal")
    def distance_external(self) -> int:
        """
        Set distance for external routes
        """
        return pulumi.get(self, "distance_external")

    @property
    @pulumi.getter(name="distanceExternalVariable")
    def distance_external_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "distance_external_variable")

    @property
    @pulumi.getter(name="distanceInterArea")
    def distance_inter_area(self) -> int:
        """
        Set distance for inter-area routes
        """
        return pulumi.get(self, "distance_inter_area")

    @property
    @pulumi.getter(name="distanceInterAreaVariable")
    def distance_inter_area_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "distance_inter_area_variable")

    @property
    @pulumi.getter(name="distanceIntraArea")
    def distance_intra_area(self) -> int:
        """
        Set distance for intra-area routes
        """
        return pulumi.get(self, "distance_intra_area")

    @property
    @pulumi.getter(name="distanceIntraAreaVariable")
    def distance_intra_area_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "distance_intra_area_variable")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the Feature
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def redistributes(self) -> Sequence['outputs.GetTransportRoutingOspfFeatureRedistributeResult']:
        """
        Redistribute routes
        """
        return pulumi.get(self, "redistributes")

    @property
    @pulumi.getter(name="referenceBandwidth")
    def reference_bandwidth(self) -> int:
        """
        Set reference bandwidth method to assign OSPF cost
        """
        return pulumi.get(self, "reference_bandwidth")

    @property
    @pulumi.getter(name="referenceBandwidthVariable")
    def reference_bandwidth_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "reference_bandwidth_variable")

    @property
    @pulumi.getter(name="rfc1583Compatible")
    def rfc1583_compatible(self) -> bool:
        """
        Calculate summary route cost based on RFC 1583
        """
        return pulumi.get(self, "rfc1583_compatible")

    @property
    @pulumi.getter(name="rfc1583CompatibleVariable")
    def rfc1583_compatible_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "rfc1583_compatible_variable")

    @property
    @pulumi.getter(name="routePolicyId")
    def route_policy_id(self) -> str:
        return pulumi.get(self, "route_policy_id")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> str:
        """
        Set OSPF router ID to override system IP address
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter(name="routerIdVariable")
    def router_id_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "router_id_variable")

    @property
    @pulumi.getter(name="routerLsas")
    def router_lsas(self) -> Sequence['outputs.GetTransportRoutingOspfFeatureRouterLsaResult']:
        """
        Advertise own router LSA with infinite distance
        """
        return pulumi.get(self, "router_lsas")

    @property
    @pulumi.getter(name="spfCalculationDelay")
    def spf_calculation_delay(self) -> int:
        """
        Set delay from first change received until performing SPF calculation
        """
        return pulumi.get(self, "spf_calculation_delay")

    @property
    @pulumi.getter(name="spfCalculationDelayVariable")
    def spf_calculation_delay_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "spf_calculation_delay_variable")

    @property
    @pulumi.getter(name="spfInitialHoldTime")
    def spf_initial_hold_time(self) -> int:
        """
        Set initial hold time between consecutive SPF calculations
        """
        return pulumi.get(self, "spf_initial_hold_time")

    @property
    @pulumi.getter(name="spfInitialHoldTimeVariable")
    def spf_initial_hold_time_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "spf_initial_hold_time_variable")

    @property
    @pulumi.getter(name="spfMaximumHoldTime")
    def spf_maximum_hold_time(self) -> int:
        """
        Set maximum hold time between consecutive SPF calculations
        """
        return pulumi.get(self, "spf_maximum_hold_time")

    @property
    @pulumi.getter(name="spfMaximumHoldTimeVariable")
    def spf_maximum_hold_time_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "spf_maximum_hold_time_variable")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")


class AwaitableGetTransportRoutingOspfFeatureResult(GetTransportRoutingOspfFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransportRoutingOspfFeatureResult(
            areas=self.areas,
            default_information_originate=self.default_information_originate,
            default_information_originate_always=self.default_information_originate_always,
            default_information_originate_always_variable=self.default_information_originate_always_variable,
            default_information_originate_metric=self.default_information_originate_metric,
            default_information_originate_metric_type=self.default_information_originate_metric_type,
            default_information_originate_metric_type_variable=self.default_information_originate_metric_type_variable,
            default_information_originate_metric_variable=self.default_information_originate_metric_variable,
            description=self.description,
            distance_external=self.distance_external,
            distance_external_variable=self.distance_external_variable,
            distance_inter_area=self.distance_inter_area,
            distance_inter_area_variable=self.distance_inter_area_variable,
            distance_intra_area=self.distance_intra_area,
            distance_intra_area_variable=self.distance_intra_area_variable,
            feature_profile_id=self.feature_profile_id,
            id=self.id,
            name=self.name,
            redistributes=self.redistributes,
            reference_bandwidth=self.reference_bandwidth,
            reference_bandwidth_variable=self.reference_bandwidth_variable,
            rfc1583_compatible=self.rfc1583_compatible,
            rfc1583_compatible_variable=self.rfc1583_compatible_variable,
            route_policy_id=self.route_policy_id,
            router_id=self.router_id,
            router_id_variable=self.router_id_variable,
            router_lsas=self.router_lsas,
            spf_calculation_delay=self.spf_calculation_delay,
            spf_calculation_delay_variable=self.spf_calculation_delay_variable,
            spf_initial_hold_time=self.spf_initial_hold_time,
            spf_initial_hold_time_variable=self.spf_initial_hold_time_variable,
            spf_maximum_hold_time=self.spf_maximum_hold_time,
            spf_maximum_hold_time_variable=self.spf_maximum_hold_time_variable,
            version=self.version)


def get_transport_routing_ospf_feature(feature_profile_id: Optional[str] = None,
                                       id: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransportRoutingOspfFeatureResult:
    """
    This data source can read the Transport Routing OSPF Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_transport_routing_ospf_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param str feature_profile_id: Feature Profile ID
    :param str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getTransportRoutingOspfFeature:getTransportRoutingOspfFeature', __args__, opts=opts, typ=GetTransportRoutingOspfFeatureResult).value

    return AwaitableGetTransportRoutingOspfFeatureResult(
        areas=pulumi.get(__ret__, 'areas'),
        default_information_originate=pulumi.get(__ret__, 'default_information_originate'),
        default_information_originate_always=pulumi.get(__ret__, 'default_information_originate_always'),
        default_information_originate_always_variable=pulumi.get(__ret__, 'default_information_originate_always_variable'),
        default_information_originate_metric=pulumi.get(__ret__, 'default_information_originate_metric'),
        default_information_originate_metric_type=pulumi.get(__ret__, 'default_information_originate_metric_type'),
        default_information_originate_metric_type_variable=pulumi.get(__ret__, 'default_information_originate_metric_type_variable'),
        default_information_originate_metric_variable=pulumi.get(__ret__, 'default_information_originate_metric_variable'),
        description=pulumi.get(__ret__, 'description'),
        distance_external=pulumi.get(__ret__, 'distance_external'),
        distance_external_variable=pulumi.get(__ret__, 'distance_external_variable'),
        distance_inter_area=pulumi.get(__ret__, 'distance_inter_area'),
        distance_inter_area_variable=pulumi.get(__ret__, 'distance_inter_area_variable'),
        distance_intra_area=pulumi.get(__ret__, 'distance_intra_area'),
        distance_intra_area_variable=pulumi.get(__ret__, 'distance_intra_area_variable'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        redistributes=pulumi.get(__ret__, 'redistributes'),
        reference_bandwidth=pulumi.get(__ret__, 'reference_bandwidth'),
        reference_bandwidth_variable=pulumi.get(__ret__, 'reference_bandwidth_variable'),
        rfc1583_compatible=pulumi.get(__ret__, 'rfc1583_compatible'),
        rfc1583_compatible_variable=pulumi.get(__ret__, 'rfc1583_compatible_variable'),
        route_policy_id=pulumi.get(__ret__, 'route_policy_id'),
        router_id=pulumi.get(__ret__, 'router_id'),
        router_id_variable=pulumi.get(__ret__, 'router_id_variable'),
        router_lsas=pulumi.get(__ret__, 'router_lsas'),
        spf_calculation_delay=pulumi.get(__ret__, 'spf_calculation_delay'),
        spf_calculation_delay_variable=pulumi.get(__ret__, 'spf_calculation_delay_variable'),
        spf_initial_hold_time=pulumi.get(__ret__, 'spf_initial_hold_time'),
        spf_initial_hold_time_variable=pulumi.get(__ret__, 'spf_initial_hold_time_variable'),
        spf_maximum_hold_time=pulumi.get(__ret__, 'spf_maximum_hold_time'),
        spf_maximum_hold_time_variable=pulumi.get(__ret__, 'spf_maximum_hold_time_variable'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_transport_routing_ospf_feature)
def get_transport_routing_ospf_feature_output(feature_profile_id: Optional[pulumi.Input[str]] = None,
                                              id: Optional[pulumi.Input[str]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTransportRoutingOspfFeatureResult]:
    """
    This data source can read the Transport Routing OSPF Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_transport_routing_ospf_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param str feature_profile_id: Feature Profile ID
    :param str id: The id of the Feature
    """
    ...
