import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [cloudhsm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudhsm.html).
 *
 * @experimental
 */
export declare class Cloudhsm extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Adds or overwrites one or more tags for the specified AWS CloudHSM resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_AddTagsToResource.html
     *
     * @experimental
     */
    toAddTagsToResource(): this;
    /**
     * (experimental) Creates a copy of a backup in the specified region.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CopyBackupToRegion.html
     *
     * @experimental
     */
    toCopyBackupToRegion(): this;
    /**
     * (experimental) Creates a new AWS CloudHSM cluster.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateCluster.html
     *
     * @experimental
     */
    toCreateCluster(): this;
    /**
     * (experimental) Creates a high-availability partition group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_CreateHapg.html
     *
     * @experimental
     */
    toCreateHapg(): this;
    /**
     * (experimental) Creates a new hardware security module (HSM) in the specified AWS CloudHSM cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html
     *
     * @experimental
     */
    toCreateHsm(): this;
    /**
     * (experimental) Creates an HSM client.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_CreateLunaClient.html
     *
     * @experimental
     */
    toCreateLunaClient(): this;
    /**
     * (experimental) Deletes the specified CloudHSM backup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DeleteBackup.html
     *
     * @experimental
     */
    toDeleteBackup(): this;
    /**
     * (experimental) Deletes the specified AWS CloudHSM cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DeleteCluster.html
     *
     * @experimental
     */
    toDeleteCluster(): this;
    /**
     * (experimental) Deletes a high-availability partition group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_DeleteHapg.html
     *
     * @experimental
     */
    toDeleteHapg(): this;
    /**
     * (experimental) Deletes the specified HSM.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DeleteHsm.html
     *
     * @experimental
     */
    toDeleteHsm(): this;
    /**
     * (experimental) Deletes a client.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_DeleteLunaClient.html
     *
     * @experimental
     */
    toDeleteLunaClient(): this;
    /**
     * (experimental) Gets information about backups of AWS CloudHSM clusters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeBackups.html
     *
     * @experimental
     */
    toDescribeBackups(): this;
    /**
     * (experimental) Gets information about AWS CloudHSM clusters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html
     *
     * @experimental
     */
    toDescribeClusters(): this;
    /**
     * (experimental) Retrieves information about a high-availability partition group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_DescribeHapg.html
     *
     * @experimental
     */
    toDescribeHapg(): this;
    /**
     * (experimental) Retrieves information about an HSM. You can identify the HSM by its ARN or its serial number.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_DescribeHsm.html
     *
     * @experimental
     */
    toDescribeHsm(): this;
    /**
     * (experimental) Retrieves information about an HSM client.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_DescribeLunaClient.html
     *
     * @experimental
     */
    toDescribeLunaClient(): this;
    /**
     * (experimental) Gets the configuration files necessary to connect to all high availability partition groups the client is associated with.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_GetConfig.html
     *
     * @experimental
     */
    toGetConfig(): this;
    /**
     * (experimental) Claims an AWS CloudHSM cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_InitializeCluster.html
     *
     * @experimental
     */
    toInitializeCluster(): this;
    /**
     * (experimental) Lists the Availability Zones that have available AWS CloudHSM capacity.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_ListAvailableZones.html
     *
     * @experimental
     */
    toListAvailableZones(): this;
    /**
     * (experimental) Lists the high-availability partition groups for the account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_ListHapgs.html
     *
     * @experimental
     */
    toListHapgs(): this;
    /**
     * (experimental) Retrieves the identifiers of all of the HSMs provisioned for the current customer.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_ListHsms.html
     *
     * @experimental
     */
    toListHsms(): this;
    /**
     * (experimental) Lists all of the clients.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_ListLunaClients.html
     *
     * @experimental
     */
    toListLunaClients(): this;
    /**
     * (experimental) Gets a list of tags for the specified AWS CloudHSM cluster.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_ListTags.html
     *
     * @experimental
     */
    toListTags(): this;
    /**
     * (experimental) Returns a list of all tags for the specified AWS CloudHSM resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Modifies an existing high-availability partition group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_ModifyHapg.html
     *
     * @experimental
     */
    toModifyHapg(): this;
    /**
     * (experimental) Modifies an HSM.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_ModifyHsm.html
     *
     * @experimental
     */
    toModifyHsm(): this;
    /**
     * (experimental) Modifies the certificate used by the client.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_ModifyLunaClient.html
     *
     * @experimental
     */
    toModifyLunaClient(): this;
    /**
     * (experimental) Removes one or more tags from the specified AWS CloudHSM resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cloudhsm/classic/APIReference/API_RemoveTagsFromResource.html
     *
     * @experimental
     */
    toRemoveTagsFromResource(): this;
    /**
     * (experimental) Restores the specified CloudHSM backup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_RestoreBackup.html
     *
     * @experimental
     */
    toRestoreBackup(): this;
    /**
     * (experimental) Adds or overwrites one or more tags for the specified AWS CloudHSM cluster.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Removes the specified tag or tags from the specified AWS CloudHSM cluster.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type backup to the statement.
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/userguide/backups.html
     *
     * @param cloudHsmBackupInstanceName - Identifier for the cloudHsmBackupInstanceName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBackup(cloudHsmBackupInstanceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type cluster to the statement.
     *
     * https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html
     *
     * @param cloudHsmClusterInstanceName - Identifier for the cloudHsmClusterInstanceName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCluster(cloudHsmClusterInstanceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [cloudhsm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudhsm.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
