import { PolicyStatementWithActions } from './3-actions';
/**
 * @experimental
 */
export interface ResourceTypes {
    [key: string]: ResourceType;
}
export interface ResourceType {
    name: string;
    url: string;
    arn: string;
    conditionKeys: string[];
}
/**
 * (experimental) Adds "resource" functionality to the Policy Statement.
 *
 * @experimental
 */
export declare class PolicyStatementWithResources extends PolicyStatementWithActions {
    private useNotResources;
    /**
     * @experimental
     */
    protected resources: string[];
    /**
     * @experimental
     */
    protected skipAutoResource: boolean;
    private cdkResourcesApplied;
    /**
     * (experimental) Injects resources into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     *
     * @experimental
     */
    toJSON(): any;
    /**
     * (experimental) JSON-ify the policy statement.
     *
     * Used when JSON.stringify() is called
     *
     * @experimental
     */
    toStatementJson(): any;
    private cdkApplyResources;
    /**
     * (experimental) Switches the statement to use [`NotResource`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html).
     *
     * @experimental
     */
    notResources(): this;
    /**
     * (experimental) Checks weather any resource was applied to the policy.
     *
     * @experimental
     */
    hasResources(): boolean;
    /**
     * (experimental) Limit statement to specified resources.
     *
     * To allow all resources, pass `*`
     *
     * @experimental
     */
    on(...arns: string[]): this;
    /**
     * (experimental) Add all resources (`*`) to the statement.
     *
     * This is the default behavior, unless the statement has principals.
     *
     * @experimental
     */
    onAllResources(): this;
    private ensureResource;
    /**
     * (experimental) Dummy method. Will be overridden by 6-principal.ts.
     *
     * We just need it here so we can reference it in method `ensureResource`
     *
     * @experimental
     */
    hasPrincipals(): boolean;
}
