"""
Constants for the terminal parser and emulator.

This module contains constants used in the terminal parsing and emulation logic,
following standards like VT100, VT220, and xterm.
"""

# --- Parser States ---
GROUND = "GROUND"
ESCAPE = "ESCAPE"
CSI_ENTRY = "CSI_ENTRY"
CSI_PARAM = "CSI_PARAM"
CSI_INTERMEDIATE = "CSI_INTERMEDIATE"
OSC_STRING = "OSC_STRING"
OSC_ESC = "OSC_ESC"
DCS_STRING = "DCS_STRING"
DCS_ESC = "DCS_ESC"
CHARSET_G0 = "CHARSET_G0"
CHARSET_G1 = "CHARSET_G1"
CHARSET_G2 = "CHARSET_G2"
CHARSET_G3 = "CHARSET_G3"

# --- C0 Control Characters ---
BEL = "\x07"  # Bell
BS = "\x08"  # Backspace
HT = "\x09"  # Horizontal Tab
LF = "\x0a"  # Line Feed
CR = "\x0d"  # Carriage Return
SO = "\x0e"  # Shift Out (activate G1)
SI = "\x0f"  # Shift In (activate G0)
ESC = "\x1b"  # Escape
DEL = "\x7f"  # Delete

# --- Erase Modes (for ED and EL) ---
ERASE_FROM_CURSOR_TO_END = 0
ERASE_FROM_START_TO_CURSOR = 1
ERASE_ALL = 2

# --- Private Modes (DECSET/DECRST) ---
# Used with CSI ? ... h/l
DECCKM_CURSOR_KEYS_APPLICATION = 1
DECAWM_AUTOWRAP = 7
DECTCEM_SHOW_CURSOR = 25
ALT_SCREEN_BUFFER_OLDER = 47
ALT_SCREEN_BUFFER = 1049
MOUSE_TRACKING_BASIC = 1000
MOUSE_TRACKING_BUTTON_EVENT = 1002
MOUSE_TRACKING_ANY_EVENT = 1003
MOUSE_SGR_MODE = 1006
MOUSE_EXTENDED_MODE = 1015
BRACKETED_PASTE = 2004
DECBKM_BACKARROW_KEY = 67
DECSCLM_SCROLLING_MODE = 4
DECARM_AUTO_REPEAT = 8
DECNKM_NUMERIC_KEYPAD = 66
DECCOLM_COLUMN_MODE = 3
DECSCNM_SCREEN_MODE = 5
DECOM_ORIGIN_MODE = 6
DECARSM_AUTO_RESIZE = 2028
DECKBUM_KEYBOARD_USAGE = 69

# --- ANSI Modes (SM/RM) ---
# Used with CSI ... h/l
DECKPAM_APPLICATION_KEYPAD = 1
IRM_INSERT_REPLACE = 4
SRM_SEND_RECEIVE = 12

# --- SGR (Select Graphic Rendition) Parameters ---
SGR_RESET = 0
SGR_BOLD = 1
SGR_DIM = 2
SGR_ITALIC = 3
SGR_UNDERLINE = 4
SGR_BLINK = 5
SGR_REVERSE = 7
SGR_CONCEAL = 8
SGR_STRIKE = 9
SGR_NOT_BOLD_OR_DOUBLE_UNDERLINE = 21
SGR_NOT_BOLD_NOR_FAINT = 22
SGR_NOT_ITALIC = 23
SGR_NOT_UNDERLINED = 24
SGR_NOT_BLINKING = 25
SGR_NOT_REVERSED = 27
SGR_NOT_CONCEALED = 28
SGR_NOT_STRIKETHROUGH = 29
SGR_FG_BLACK = 30
SGR_FG_RED = 31
SGR_FG_GREEN = 32
SGR_FG_YELLOW = 33
SGR_FG_BLUE = 34
SGR_FG_MAGENTA = 35
SGR_FG_CYAN = 36
SGR_FG_WHITE = 37
SGR_EXTENDED_COLOR = 38
SGR_DEFAULT_FG = 39
SGR_BG_BLACK = 40
SGR_BG_RED = 41
SGR_BG_GREEN = 42
SGR_BG_YELLOW = 43
SGR_BG_BLUE = 44
SGR_BG_MAGENTA = 45
SGR_BG_CYAN = 46
SGR_BG_WHITE = 47
SGR_EXTENDED_BG_COLOR = 48
SGR_DEFAULT_BG = 49
SGR_BRIGHT_FG_BLACK = 90
SGR_BRIGHT_FG_RED = 91
SGR_BRIGHT_FG_GREEN = 92
SGR_BRIGHT_FG_YELLOW = 93
SGR_BRIGHT_FG_BLUE = 94
SGR_BRIGHT_FG_MAGENTA = 95
SGR_BRIGHT_FG_CYAN = 96
SGR_BRIGHT_FG_WHITE = 97
SGR_BRIGHT_BG_BLACK = 100
SGR_BRIGHT_BG_RED = 101
SGR_BRIGHT_BG_GREEN = 102
SGR_BRIGHT_BG_YELLOW = 103
SGR_BRIGHT_BG_BLUE = 104
SGR_BRIGHT_BG_MAGENTA = 105
SGR_BRIGHT_BG_CYAN = 106
SGR_BRIGHT_BG_WHITE = 107

# --- OSC (Operating System Command) Commands ---
OSC_SET_TITLE_AND_ICON = 0
OSC_SET_ICON_TITLE = 1
OSC_SET_TITLE = 2

# --- Mouse Button Modifiers ---
MOUSE_MOD_SHIFT = 4
MOUSE_MOD_META = 8
MOUSE_MOD_CTRL = 16

# --- Mouse Buttons ---
MOUSE_BUTTON_LEFT = 0
MOUSE_BUTTON_MIDDLE = 1
MOUSE_BUTTON_RIGHT = 2
MOUSE_BUTTON_WHEEL_UP = 64
MOUSE_BUTTON_WHEEL_DOWN = 65
MOUSE_BUTTON_MOVEMENT = 35

# --- Keyboard Modifier Codes (for CSI sequences) ---
KEY_MOD_NONE = 1
KEY_MOD_SHIFT = 2
KEY_MOD_ALT = 3
KEY_MOD_SHIFT_ALT = 4
KEY_MOD_CTRL = 5
KEY_MOD_SHIFT_CTRL = 6
KEY_MOD_ALT_CTRL = 7
KEY_MOD_SHIFT_ALT_CTRL = 8

# --- Cursor Key Mappings ---
CURSOR_KEYS = {"up": "A", "down": "B", "right": "C", "left": "D"}

# --- Navigation Key Mappings ---
NAV_KEYS = {"home": "H", "end": "F"}

# --- PTY and System Constants ---
DEFAULT_TERMINAL_WIDTH = 80
DEFAULT_TERMINAL_HEIGHT = 24
DEFAULT_PTY_BUFFER_SIZE = 4096
PTY_POLL_INTERVAL = 0.1
DEFAULT_EXIT_CODE = 0

# --- Error Numbers ---
EBADF = 9  # Bad file descriptor
EINVAL = 22  # Invalid argument
