/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import oracle.pgx.api.PropertyMetaData;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.IdType;

public abstract class EntityProviderMetaData
extends Self {
    protected IdType idType;
    protected final String name;
    protected final Set<String> labels;
    protected List<PropertyMetaData> properties;

    protected EntityProviderMetaData(String name, IdType idType, Set<String> labels, List<PropertyMetaData> properties) {
        this.idType = idType;
        this.name = name;
        this.labels = new HashSet<String>(labels);
        this.properties = new ArrayList<PropertyMetaData>(properties);
    }

    protected EntityProviderMetaData(EntityProviderMetaData other) {
        this.idType = other.idType;
        this.name = other.name;
        this.labels = new HashSet<String>(other.labels);
        this.properties = new ArrayList<PropertyMetaData>(other.properties);
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void setIdType(IdType idType) {
        this.idType = idType;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }

    public List<PropertyMetaData> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyMetaData> properties) {
        this.properties = properties;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.idType);
    }

    public String toString() {
        return "EntityTableMetaData [name=" + this.name + ", idType=" + this.getIdType() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EntityProviderMetaData other = (EntityProviderMetaData)((Object)obj);
        return this.name.equals(other.name) && this.idType == other.idType;
    }
}

