/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.concurrent.ExecutionException;
import oracle.pgx.api.Analyst;
import oracle.pgx.api.BipartiteGraph;
import oracle.pgx.api.Destroyable;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxVect;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.api.internal.ApiObject;
import oracle.pgx.common.ObjectHolder;
import oracle.pgx.common.types.PropertyType;

public class MatrixFactorizationModel<ID>
extends ApiObject {
    private final Analyst analyst;
    private final BipartiteGraph graph;
    private final VertexProperty<ID, PgxVect<Double>> features;
    private final double rmse;

    MatrixFactorizationModel(Analyst analyst, BipartiteGraph graph, VertexProperty<ID, PgxVect<Double>> features, double rmse) {
        this.analyst = analyst;
        this.graph = graph;
        this.features = features;
        this.rmse = rmse;
    }

    public VertexProperty<ID, PgxVect<Double>> getFeatures() {
        return this.features;
    }

    public double getRootMeanSquareError() {
        return this.rmse;
    }

    public PgxFuture<VertexProperty<ID, Double>> getEstimatedRatingsAsync(PgxVertex<ID> estimateRatingsFor) {
        PgxFuture promise = new PgxFuture();
        ObjectHolder ratingPropertyHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)this.graph.createVertexPropertyAsync(PropertyType.DOUBLE).thenCompose(rating -> {
            ratingPropertyHolder.set(rating);
            this.analyst.addTransientObject((Destroyable)rating);
            return this.analyst.getBuiltinAlgorithms().pgxBuiltinR2bMatrixFactorizationRecommendations(this.analyst.getSession().getSessionContext(), this.graph.getId(), estimateRatingsFor.getId(), this.graph.getIsLeftId(), this.features.getDimension(), this.features.getPropertyId(), rating.getPropertyId()).cancelOn(promise);
        })).thenApply(arg -> {
            VertexProperty rating = (VertexProperty)ratingPropertyHolder.get();
            assert (rating != null);
            return rating;
        })).thenComplete(promise);
    }

    public VertexProperty<ID, Double> getEstimatedRatings(PgxVertex<ID> estimateRatingsFor) throws InterruptedException, ExecutionException {
        return this.getEstimatedRatingsAsync(estimateRatingsFor).get();
    }

    public String toString() {
        return this.toString(MatrixFactorizationModel.entry("graph", this.graph.getName()));
    }
}

