/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import oracle.pgx.api.PgxEntity;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.Property;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.common.Pair;
import oracle.pgx.common.types.Direction;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;

public class PgxEdge
extends PgxEntity<Long> {
    static PgxEdge deserialize(PgxGraph graph, Object edgeResult) {
        if (edgeResult == null) {
            return null;
        }
        if (edgeResult instanceof Edge) {
            return new PgxEdge(graph, (Edge)edgeResult);
        }
        return new PgxEdge(graph, (Long)edgeResult);
    }

    PgxEdge(PgxGraph graph, Edge edge) {
        super(graph, (Entity)edge);
    }

    PgxEdge(PgxGraph graph, Long id) {
        super(graph, id, IdType.LONG, EntityType.EDGE);
    }

    @Override
    final EntityType getEntityType() {
        return EntityType.EDGE;
    }

    @Override
    protected <V> PgxFuture<? extends Property<Long, ?, V>> getPropAsync(String propertyName) {
        return this.getGraph().getEdgePropertyAsync(propertyName);
    }

    public PgxFuture<String> getLabelAsync() {
        return this.getCore().getEdgeLabel(this.getSessionContext(), this.getGraph().getId(), this.serialize()).thenApply(edgeLabel -> edgeLabel.getLabel());
    }

    public <ID> PgxFuture<PgxVertex<ID>> getSourceAsync() {
        return this.getVertexFromEdge(Direction.INCOMING);
    }

    public <ID> PgxFuture<PgxVertex<ID>> getDestinationAsync() {
        return this.getVertexFromEdge(Direction.OUTGOING);
    }

    public <ID> PgxFuture<Pair<PgxVertex<ID>, PgxVertex<ID>>> getVerticesAsync() {
        return this.getSourceAsync().thenCombine(this.getDestinationAsync(), Pair::new);
    }

    private <ID> PgxFuture<PgxVertex<ID>> getVertexFromEdge(Direction direction) {
        return this.getCore().getVertexFromEdge(this.getSessionContext(), this.getGraph().getId(), this.serialize(), direction).thenApply(vertex -> new PgxVertex<Vertex>(this.getGraph(), (Vertex)vertex));
    }

    public String getLabel() {
        return this.getLabelAsync().join();
    }

    public <ID> PgxVertex<ID> getSource() {
        return this.getSourceAsync().join();
    }

    public <ID> PgxVertex<ID> getDestination() {
        return this.getDestinationAsync().join();
    }

    public <ID> Pair<PgxVertex<ID>, PgxVertex<ID>> getVertices() {
        return this.getVerticesAsync().join();
    }
}

