/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.admin;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PoolType;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.common.MemoryUnit;
import oracle.pgx.common.VersionInfo;
import oracle.pgx.common.auth.PgxGenericPermission;
import oracle.pgx.common.pojo.admin.CacheStatistics;
import oracle.pgx.common.pojo.admin.GraphInfo;
import oracle.pgx.common.pojo.admin.MemoryInfo;
import oracle.pgx.common.pojo.admin.PoolInfo;
import oracle.pgx.common.pojo.admin.ResourceElasticityStatus;
import oracle.pgx.common.pojo.admin.SessionInfo;
import oracle.pgx.config.PgxConfig;
import oracle.pgx.config.PgxConfigBuilder;

public interface Control {
    public static final String PGX_CONFIG_FILE_SYSTEM_PROPERTY = "pgx_conf";
    public static final String SERVER_CONFIG_FILE_NAME = "pgx.conf";
    public static final String KEYSTORE_PATH_SYSTEM_PROPERTY = "pgx.keystore_path";
    public static final String KEYSTORE_SECRET_SYSTEM_PROPERTY = "pgx.keystore_password";
    public static final String FUTURE_MAP_KEY = "FUTURE_MAP";
    public static final String PROPERTY_PROXY_MAP_KEY = "PROPERTY_PROXY_MAP";
    public static final String ALL_PATHS_PROXY_MAP_KEY = "ALL_PATHS_PROXY_MAP";
    public static final String COLLECTION_PROXY_MAP_KEY = "COLLECTION_PROXY_MAP";
    public static final String COMPONENTS_PROXY_MAP_KEY = "COMPONENTS_PROXY_MAP";
    public static final String MAP_PROXY_MAP_KEY = "MAP_PROXY_MAP";
    public static final String PGQL_RESULTS_KEY = "PGQL_RESULTS_MAP";

    public PgxFuture<String> getVersion();

    public PgxFuture<VersionInfo> getExtendedVersion();

    public PgxFuture<Map<PgxConfig.Field, Object>> getPgxConfig();

    default public PgxFuture<PgxConfig> getPgxConfigObject() {
        return this.getPgxConfig().thenApply(values -> new PgxConfigBuilder(values).build());
    }

    public PgxFuture<Void> start();

    default public PgxFuture<Void> start(PgxConfig config) {
        return this.start(config.getValuesWithoutDefaults());
    }

    public PgxFuture<Void> start(Map<PgxConfig.Field, Object> var1);

    public PgxFuture<Void> start(InputStream var1);

    public PgxFuture<Void> start(String var1);

    public PgxFuture<Void> start(String var1, String var2, char[] var3);

    public PgxFuture<Boolean> isRunning();

    public PgxFuture<Boolean> isReady();

    public PgxFuture<Boolean> isGraphPreloadingDone();

    public PgxFuture<Void> shutdownNowIfRunning();

    public PgxFuture<Boolean> shutdown(long var1, TimeUnit var3);

    public PgxFuture<Void> shutdownNow();

    @Deprecated
    public PgxFuture<Collection<SessionInfo>> getSessionInfos();

    @Deprecated
    public PgxFuture<Collection<GraphInfo>> getGraphInfos();

    public PgxFuture<CacheStatistics> freeCachedMemory();

    public PgxFuture<CacheStatistics> freeCachedMemory(double var1);

    public PgxFuture<Void> unpinGraph(String var1);

    @Deprecated
    public PgxFuture<SessionInfo> getSessionInfo(String var1);

    @Deprecated
    default public PgxFuture<SessionInfo> getSessionInfo(SessionContext sessionContext) {
        return this.getSessionInfo(sessionContext.getSessionId());
    }

    @Deprecated
    public PgxFuture<GraphInfo> getGraphInfo(String var1);

    @Deprecated
    public PgxFuture<GraphInfo> getGraphInfo(String var1, String var2);

    @Deprecated
    public PgxFuture<MemoryInfo> getMemoryInfo();

    @Deprecated
    public PgxFuture<PoolInfo> getThreadPoolInfo(PoolType var1);

    @BetaApi
    public PgxFuture<JsonNode> getServerState();

    public PgxFuture<Void> killSession(String var1);

    public void addUserData(String var1, String var2, Object var3);

    public Object getUserData(SessionContext var1, String var2);

    public PgxFuture<JsonNode> joinMachine(String var1);

    public PgxFuture<JsonNode> leaveMachine(String var1);

    default public PgxFuture<Void> updatePgxConfig(PgxConfig config) {
        return this.updatePgxConfig(config.getValuesWithoutDefaults());
    }

    public PgxFuture<Void> updatePgxConfig(Map<PgxConfig.Field, Object> var1);

    public PgxFuture<Void> updatePgxConfig(InputStream var1);

    public PgxFuture<Void> updatePgxConfig(String var1);

    public PgxFuture<Void> setSessionMaxMemorySize(String var1, int var2, MemoryUnit var3);

    public PgxFuture<String> getUsername();

    public PgxFuture<Set<String>> getUserRoles();

    public PgxFuture<Set<PgxGenericPermission>> getSystemPermissions();

    public PgxFuture<ResourceElasticityStatus> getResourceElasticityStatus();
}

