/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.admin;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.api.admin.StartupLogEntryItem;
import oracle.pgx.common.MemoryUnit;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.VersionInfo;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.vfs.VirtualFile;
import oracle.pgx.vfs.VirtualFileManager;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupLogging {
    private static final Logger LOG = LoggerFactory.getLogger(StartupLogging.class);
    private static final String PRODUCT_VERSION_LOCATION = "classpath:/META-INF/product_version.properties";
    private static final String DISTRIBUTION_PROPERTY_KEY = "distribution";
    private static final String VERSION_PROPERTY_KEY = "version";
    private static final String STARTUP_LOG_ITEMS_KEY = "startup_log_items";

    public static String createVersionInfoString(Function<String, String> highlighter, String shellVersion, ServerInstance instance) throws IOException, ExecutionException, InterruptedException {
        StaticConfig.get().isEnablePluginVersionChecks();
        VirtualFileManager vfm = VirtualFileManagerFactory.getInstance();
        VirtualFile virtualFile = vfm.resolve(PRODUCT_VERSION_LOCATION, UserContext.SYSTEM_USER_CONTEXT);
        Properties properties = new Properties();
        Set<StartupLogEntryItem> displayLogItems = null;
        boolean missingData = false;
        if (virtualFile.exists()) {
            try (InputStream inputStream = virtualFile.getInputStream();){
                properties.load(inputStream);
                if (properties.containsKey(STARTUP_LOG_ITEMS_KEY)) {
                    displayLogItems = StartupLogging.readLogConfig(properties);
                }
                missingData = true;
            }
        } else {
            missingData = true;
        }
        StringBuilder displayedMessage = new StringBuilder();
        VersionInfo pgxVersionInfo = instance.getVersion();
        if (missingData || displayLogItems.contains((Object)StartupLogEntryItem.SHELL_VERSION)) {
            displayedMessage.append(highlighter.apply("PGX Shell ") + shellVersion);
        }
        if (missingData || displayLogItems.contains((Object)StartupLogEntryItem.SERVER_VERSION)) {
            displayedMessage.append(highlighter.apply("\nPGX server version: ") + pgxVersionInfo.getReleaseVersion() + highlighter.apply(" type: ") + pgxVersionInfo.getServerType().toUpperCase());
            if (instance.isEmbeddedInstance()) {
                displayedMessage.append(highlighter.apply(" running in embedded mode."));
            }
        }
        if (missingData || displayLogItems.contains((Object)StartupLogEntryItem.API_VERSION)) {
            displayedMessage.append(highlighter.apply("\nPGX server API version: ") + pgxVersionInfo.getApiVersion());
        }
        if (missingData || displayLogItems.contains((Object)StartupLogEntryItem.PGQL_VERSION)) {
            displayedMessage.append(highlighter.apply("\nPGQL version: ") + pgxVersionInfo.getPgqlVersion());
        }
        return displayedMessage.toString();
    }

    private static Set<StartupLogEntryItem> readLogConfig(Properties properties) {
        String chosenConfig = properties.getProperty(STARTUP_LOG_ITEMS_KEY);
        List itemsList = Splitter.on((char)',').trimResults().splitToList((CharSequence)chosenConfig);
        Set chosenConfigItems = itemsList.stream().map(StartupLogEntryItem::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(StartupLogEntryItem.class)));
        return chosenConfigItems;
    }

    public static void logPgxStartupInformation(String serverFlavor) throws IOException {
        StartupLogging.logPgxVersion(serverFlavor);
        StartupLogging.logProductVersion();
        if (serverFlavor.equals("sm")) {
            StartupLogging.logSystemInformation();
        }
        if (LOG.isInfoEnabled()) {
            StartupLogging.logVMSettings();
        }
    }

    private static void logPgxVersion(String serverFlavor) {
        VersionInfo versionInfo = VersionInfo.getInstance((String)serverFlavor);
        LOG.info(">>> PGX {} engine {}/ API {} running.", new Object[]{versionInfo.getServerType(), versionInfo.getReleaseVersion(), versionInfo.getApiVersion()});
        LOG.info(">>> PGQL version {}", (Object)versionInfo.getPgqlVersion());
        LOG.info(">>> Built from commit {}", (Object)versionInfo.getCommit());
        LOG.info(">>> Built at {}", (Object)versionInfo.getBuild());
    }

    private static void logProductVersion() throws IOException {
        StaticConfig.get().isEnablePluginVersionChecks();
        VirtualFileManager vfm = VirtualFileManagerFactory.getInstance();
        VirtualFile virtualFile = vfm.resolve(PRODUCT_VERSION_LOCATION, UserContext.SYSTEM_USER_CONTEXT);
        if (virtualFile.exists()) {
            Properties properties = new Properties();
            try (InputStream inputStream = virtualFile.getInputStream();){
                properties.load(inputStream);
            }
            String productDistribution = properties.getProperty(DISTRIBUTION_PROPERTY_KEY);
            String productVersion = properties.getProperty(VERSION_PROPERTY_KEY);
            if (productDistribution != null && productVersion != null) {
                LOG.info(">>> {} version {}", (Object)productDistribution, (Object)productVersion);
            } else {
                LOG.debug("incomplete product version info: {}/{}", (Object)productDistribution, (Object)productVersion);
            }
        }
    }

    private static void logSystemInformation() {
        Runtime runtime = Runtime.getRuntime();
        int availableProcessors = runtime.availableProcessors();
        String jdkVersion = StartupLogging.getJdkVersion();
        String operatingSystemName = System.getProperty("os.name");
        LOG.info(">>> JDK version: {}", (Object)jdkVersion);
        LOG.info(">>> Operating system: {}", (Object)operatingSystemName);
        LOG.info(">>> Number of processors: {}", (Object)availableProcessors);
        ConfigParser.getTotalPhysicalMemorySize().ifPresent(memoryByte -> {
            long memoryMb = MemoryUnit.BYTE.toMegabytes(memoryByte);
            LOG.info(">>> Total system memory: {} MB", (Object)memoryMb);
        });
    }

    private static void logVMSettings() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> listOfArguments = runtimeMxBean.getInputArguments();
        for (String argument : listOfArguments) {
            LOG.info(">>> JVM argument: {}", (Object)argument);
        }
    }

    private static String getJdkVersion() {
        String jdkVersion = Runtime.class.getPackage().getImplementationVersion();
        if (jdkVersion != null) {
            return jdkVersion;
        }
        return System.getProperty("java.runtime.version");
    }
}

