/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.internal.dispatchers.spatial;

import java.util.function.Function;
import oracle.pgx.api.frames.schema.datatypes.spatial.Point2dType;
import oracle.pgx.api.frames.schema.datatypes.spatial.SpatialType;
import oracle.pgx.api.frames.schema.internal.dispatchers.DataTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.spatial.Point2dTypeDispatcher;

@FunctionalInterface
public interface SpatialTypeDispatcher<R>
extends Function<SpatialType, R> {
    public static <R> SpatialTypeDispatcher<R> dispatcher(final Point2dTypeDispatcher<R> point2dTypeDispatcher) {
        return new DefaultSpatialTypeDispatcher<R>(){

            @Override
            public R applyPoint2dType(Point2dType type) {
                return DataTypeDispatcher.applyType(point2dTypeDispatcher, type);
            }
        };
    }

    public static <R> R dispatch(Point2dTypeDispatcher<R> point2dTypeDispatcher, SpatialType dataType) {
        return SpatialTypeDispatcher.dispatcher(point2dTypeDispatcher).apply(dataType);
    }

    public static interface DefaultSpatialTypeDispatcher<R>
    extends SpatialTypeDispatcher<R> {
        @Override
        default public R apply(SpatialType dataType) {
            if (dataType instanceof Point2dType) {
                return (R)DataTypeDispatcher.applyType(this::applyPoint2dType, (Point2dType)dataType);
            }
            return (R)DataTypeDispatcher.throwNoDispatcherForType(dataType);
        }

        default public R applyPoint2dType(Point2dType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }
    }
}

