/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import oracle.pgx.api.Namespace;
import oracle.pgx.api.internal.Property;
import oracle.pgx.common.GenericMutable;
import oracle.pgx.common.Mutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CollectByNamespace
implements Collector<Property, Mutable<Property>, Optional<Property>> {
    private static final Logger LOG = LoggerFactory.getLogger(CollectByNamespace.class);
    private final Namespace namespace;

    public static CollectByNamespace collectByNamespace(Namespace namespace) {
        return new CollectByNamespace(namespace);
    }

    private CollectByNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public Supplier<Mutable<Property>> supplier() {
        return () -> new GenericMutable(null);
    }

    @Override
    public BiConsumer<Mutable<Property>, Property> accumulator() {
        if (this.namespace == null) {
            return this::combineNullNamespaceSemantics;
        }
        return this::filterByNamespace;
    }

    @Override
    public BinaryOperator<Mutable<Property>> combiner() {
        return (propertyMutable, propertyMutable2) -> {
            Property otherProperty = (Property)((Object)((Object)propertyMutable2.GET()));
            if (otherProperty != null) {
                this.accumulator().accept((Mutable<Property>)propertyMutable, otherProperty);
            }
            return propertyMutable;
        };
    }

    @Override
    public Function<Mutable<Property>, Optional<Property>> finisher() {
        return propertyMutable -> Optional.ofNullable(propertyMutable.GET());
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED);
    }

    private void filterByNamespace(Mutable<Property> propertyMutable, Property property) {
        Property currentProperty = (Property)((Object)propertyMutable.GET());
        if (currentProperty != null) {
            this.checkNameEquality(property, currentProperty);
        }
        if (property.getNamespace().equals(this.namespace)) {
            propertyMutable.SET((Object)property);
        }
    }

    private void combineNullNamespaceSemantics(Mutable<Property> propertyMutable, Property property) {
        Property currentProperty = (Property)((Object)propertyMutable.GET());
        if (currentProperty == null) {
            propertyMutable.SET((Object)property);
            return;
        }
        this.checkNameEquality(property, currentProperty);
        if (property.getNamespace().equals(Namespace.PRIVATE)) {
            propertyMutable.SET((Object)property);
        }
    }

    private void checkNameEquality(Property property, Property currentProperty) {
        if (!currentProperty.getName().equals(property.getName())) {
            throw new IllegalArgumentException("trying to collect properties with incompatible names");
        }
    }
}

