/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pgx.api.EntityProviderMetaData;
import oracle.pgx.api.internal.Property;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.PrettyPrint;

public abstract class EntityTable<EntityTableMetaDataType extends EntityProviderMetaData> {
    private EntityType entityType;
    private String name;
    private EntityTableMetaDataType metaData;
    @JsonProperty(value="transient")
    private boolean transientFlag;
    private Set<String> providerLabels = Collections.emptySet();
    private LinkedHashMap<PgxId, Property> props = new LinkedHashMap();
    private Property label;
    private String keyPropertyName;
    private IdType entityKeyType;
    private boolean isIdentityKeyMapping;

    public EntityTable(EntityType entityType) {
        this.entityType = entityType;
    }

    public EntityTable(EntityType entityType, String name) {
        this.entityType = entityType;
        this.name = name;
    }

    public EntityTable(EntityType entityType, String name, boolean transientFlag, String keyPropertyName, IdType entityKeyType, boolean isIdentityKeyMapping) {
        this.entityType = entityType;
        this.name = name;
        this.transientFlag = transientFlag;
        this.keyPropertyName = keyPropertyName;
        this.entityKeyType = entityKeyType;
        this.isIdentityKeyMapping = isIdentityKeyMapping;
    }

    @JsonIgnore
    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getKeyPropertyName() {
        return this.keyPropertyName;
    }

    public IdType getEntityKeyType() {
        return this.entityKeyType;
    }

    public boolean getIsIdentityKeyMapping() {
        return this.isIdentityKeyMapping;
    }

    public String getName() {
        return this.name;
    }

    public EntityTableMetaDataType getMetaData() {
        return this.metaData;
    }

    public void setMetaData(EntityTableMetaDataType metaData) {
        this.metaData = metaData;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setEntityKeyType(IdType entityKeyType) {
        this.entityKeyType = entityKeyType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public Set<String> getProviderLabels() {
        return this.providerLabels;
    }

    public void setProviderLabels(Set<String> providerLabels) {
        this.providerLabels = providerLabels;
    }

    @JsonIgnore
    public void setLabel(Property property) {
        assert (property == null || property.getEntityType() == this.entityType);
        this.label = property;
    }

    @JsonIgnore
    public Property getLabel() {
        return this.label;
    }

    @JsonIgnore
    public LinkedHashMap<PgxId, Property> getProperties() {
        return this.props;
    }

    @JsonIgnore
    public void setProperties(LinkedHashMap<PgxId, Property> props) {
        this.props = new LinkedHashMap<PgxId, Property>(props);
    }

    @JsonIgnore
    public void addProperty(PgxId id, Property property) {
        assert (property.getEntityType() == this.entityType);
        this.props.put(id, property);
    }

    @JsonIgnore
    public Set<String> getPropertyNames() {
        return this.props.values().stream().map(Property::getName).collect(Collectors.toSet());
    }

    public String toString() {
        return PrettyPrint.prettify(this);
    }
}

