/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.api.PgxVect;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.api.internal.ScalarValue;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.internal.PropertyTypeUtils;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.internal.EntityDeserializationHelper;
import oracle.pgx.config.LinkTemplate;

public class PropertyValue<V>
extends ScalarValue<V> {
    private Object key;
    private Boolean isKeyWrapped;
    private final PgxId graphId;
    private final PgxId propId;

    public PropertyValue() {
        this.graphId = null;
        this.propId = null;
    }

    public PropertyValue(V value) {
        this();
        this.setValue(value);
    }

    public PropertyValue(V value, PropertyType valueType) {
        this(value);
        this.setValueType(valueType);
    }

    public PropertyValue(V value, Object key, PropertyType valueType, boolean isVector) {
        this(value, valueType);
        this.setKey(key);
        this.setVector(isVector);
    }

    public PropertyValue(V value, Object key, IdType nodeEdgeValueType, PropertyType valueType, PgxId graphId, PgxId propId, boolean isVector) {
        this.setValue(value);
        this.setValueType(valueType);
        this.setId(key.toString());
        this.setVector(isVector);
        this.setNodeEdgeValueType(nodeEdgeValueType);
        this.setKey(key);
        this.graphId = graphId;
        this.propId = propId;
        this.injectLinks();
    }

    public Object getKey() {
        return this.key;
    }

    @JsonIgnore
    public Object getParsedKey() throws IOException {
        if (this.key == null) {
            return null;
        }
        String json = JsonUtil.sanitize((String)JsonUtil.toJson((Object)this.key));
        if (Boolean.TRUE.equals(this.isKeyWrapped)) {
            return EntityDeserializationHelper.deserializeEntityOrKey((JsonNode)JsonUtil.readTopLevelJsonToTree((String)json)).getLeft().get();
        }
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
        this.isKeyWrapped = key instanceof Entity;
    }

    public void setKeyWrapped(Boolean value) {
        this.isKeyWrapped = value;
    }

    public Boolean isKeyWrapped() {
        return this.isKeyWrapped;
    }

    @Override
    public void injectLinks() {
        Link selfLink = new Link(LinkRel.SELF, LinkTemplate.PROPERTY_VALUE_SELF.generateLink(new Object[0]));
        this.addLinks(new Link[]{selfLink});
    }

    public static <V> PropertyValue wrap(Object key, V value) {
        PropertyType type;
        boolean isVector = false;
        if (value != null) {
            if (value instanceof PgxVect) {
                type = ((PgxVect)value).getType();
                isVector = true;
            } else {
                type = PropertyTypeUtils.getElementPropertyType(value);
            }
        } else {
            type = null;
        }
        return new PropertyValue<V>(value, key, type, isVector);
    }
}

