/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;
import oracle.pgx.api.internal.PgxRealmClient;
import oracle.pgx.common.util.AuthCertUtils;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.realm.client.RealmClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RealmClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RealmClientFactory.class);
    private static final RealmClient EMBEDDED_REALM_CLIENT = new SingleTokenRealmClient(null);
    private final boolean isEmbedded;
    private final ClientConfig config;

    public RealmClientFactory(boolean isEmbedded, ClientConfig config) {
        this.isEmbedded = isEmbedded;
        this.config = config;
    }

    public RealmClient provide() {
        if (this.isEmbedded) {
            LOG.debug("creating embedded realm client");
            return EMBEDDED_REALM_CLIENT;
        }
        if (this.config.getAccessToken() != null) {
            LOG.debug("creating single token provider");
            return new SingleTokenRealmClient(this.config.getAccessToken());
        }
        ServiceLoader<RealmClient> realmClients = ServiceLoader.load(RealmClient.class);
        Iterator<RealmClient> iterator = realmClients.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"REALM_CLIENT_NOT_FOUND", (Object[])new Object[0]));
        }
        RealmClient realmClient = iterator.next();
        Objects.requireNonNull(realmClient);
        LOG.debug("found {}", realmClient.getClass());
        if (iterator.hasNext()) {
            LOG.warn("more than one RealmClient found, will use {}", (Object)realmClient.getClass().getSimpleName());
        }
        realmClient.configure(this.config, AuthCertUtils.getSystemConsole());
        return realmClient;
    }

    private static final class SingleTokenRealmClient
    extends PgxRealmClient {
        SingleTokenRealmClient(String token) {
            this.token = token;
        }
    }
}

