/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.algorithm.arguments;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ArgumentAbbreviationSupport {
    private final Set<String> supportedTokens;

    ArgumentAbbreviationSupport(Set<String> availableCommands) {
        this.supportedTokens = availableCommands;
    }

    private String generateRegexFor(String source) {
        Pattern basePattern = Pattern.compile("(\\p{javaLowerCase}+)|(\\p{javaUpperCase}\\p{javaLowerCase}*)");
        Matcher finder = basePattern.matcher(source);
        StringBuilder result = new StringBuilder();
        while (finder.find()) {
            result.append(Pattern.quote(finder.group()));
            result.append("[\\p{javaLowerCase}]*");
        }
        result.append(Pattern.quote(""));
        return result.toString();
    }

    public Optional<Set<String>> getTokensFor(String source) {
        if (source.isEmpty()) {
            return Optional.empty();
        }
        HashSet<String> result = new HashSet<String>();
        if (this.supportedTokens.contains(source)) {
            result.add(source);
            return Optional.of(result);
        }
        String regexText = this.generateRegexFor(source);
        Pattern simplePattern = Pattern.compile(regexText);
        Pattern ignoringPattern = Pattern.compile(regexText, 2);
        result.addAll(this.supportedTokens.stream().filter(s -> simplePattern.matcher((CharSequence)s).matches() || ignoringPattern.matcher((CharSequence)s).lookingAt()).collect(Collectors.toList()));
        if (result.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(result);
    }
}

