/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.mllib.Model;
import oracle.pgx.api.mllib.ModelStorer;
import oracle.pgx.config.mllib.DbModelStoringConfiguration;
import oracle.pgx.config.mllib.ModelStoringConfiguration;

public class DbModelStorer<ModelType extends Model<ModelType>>
extends ModelStorer<ModelType, DbModelStorer<ModelType>> {
    private final DbModelStoringConfiguration storingConfiguration;

    public DbModelStorer(PgxSession session, Core core, ModelType model, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        super(session, core, model, keystorePathSupplier, keystorePasswordSupplier);
        this.storingConfiguration = new DbModelStoringConfiguration(((Model)model).getModelKind());
    }

    @Override
    protected DbModelStorer<ModelType> getThis() {
        return this;
    }

    public DbModelStorer<ModelType> jdbcUrl(String jdbcUrl) {
        this.storingConfiguration.setJdbcUrl(jdbcUrl);
        return this.getThis();
    }

    public DbModelStorer<ModelType> dataSourceId(String dataSourceId) {
        this.storingConfiguration.setDataSourceId(dataSourceId);
        return this.getThis();
    }

    public DbModelStorer<ModelType> username(String username) {
        this.storingConfiguration.setUsername(username);
        return this.getThis();
    }

    public DbModelStorer<ModelType> schema(String schema) {
        this.storingConfiguration.setOwner(schema);
        return this.getThis();
    }

    public DbModelStorer<ModelType> owner(String owner) {
        return this.schema(owner);
    }

    public DbModelStorer<ModelType> password(String password) {
        this.storingConfiguration.setPassword(password);
        return this.getThis();
    }

    public DbModelStorer<ModelType> keystoreAlias(String keystore) {
        this.storingConfiguration.setKeystoreAlias(keystore);
        return this.getThis();
    }

    public DbModelStorer<ModelType> modelstore(String modelStoreName) {
        this.storingConfiguration.setModelstore(modelStoreName);
        return this.getThis();
    }

    public DbModelStorer<ModelType> modelname(String modelName) {
        this.storingConfiguration.setModelname(modelName);
        return this.getThis();
    }

    public DbModelStorer<ModelType> description(String desc) {
        this.storingConfiguration.setDescription(desc);
        return this.getThis();
    }

    @Override
    public PgxFuture<Void> storeAsync() {
        return this.triggerStoreAsync((ModelStoringConfiguration)this.storingConfiguration);
    }
}

