/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.mllib.DeepWalkModelMetadata;
import oracle.pgx.api.mllib.DeepWalkModel;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.DeepWalkModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepWalkModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DeepWalkModelBuilder.class);
    private final PgxSession session;
    private final Core core;
    private final Supplier<String> keystorePathSupplier;
    private final Supplier<char[]> keystorePasswordSupplier;
    private final DeepWalkModelConfig deepWalkModelConfig;

    public DeepWalkModelBuilder(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.deepWalkModelConfig = new DeepWalkModelConfig();
    }

    public DeepWalkModelBuilder setMinWordFrequency(int minWordFrequency) {
        this.deepWalkModelConfig.setMinWordFrequency(minWordFrequency);
        return this;
    }

    public DeepWalkModelBuilder setShuffle(boolean shuffle) {
        this.deepWalkModelConfig.setShuffle(shuffle);
        return this;
    }

    public boolean isShuffle() {
        return this.deepWalkModelConfig.isShuffle();
    }

    public int getMinWordFrequency() {
        return this.deepWalkModelConfig.getMinWordFrequency();
    }

    public DeepWalkModelBuilder setSeed(Long seed) {
        this.deepWalkModelConfig.setSeed(seed);
        return this;
    }

    public Long getSeed() {
        return this.deepWalkModelConfig.getSeed();
    }

    public DeepWalkModelBuilder setBatchSize(int batchSize) {
        this.deepWalkModelConfig.setBatchSize(batchSize);
        return this;
    }

    public int getBatchSize() {
        return this.deepWalkModelConfig.getBatchSize();
    }

    public DeepWalkModelBuilder setNumEpochs(int numEpochs) {
        this.deepWalkModelConfig.setNumEpochs(numEpochs);
        return this;
    }

    public int getNumEpochs() {
        return this.deepWalkModelConfig.getNumEpochs();
    }

    public DeepWalkModelBuilder setLayerSize(int layerSize) {
        this.deepWalkModelConfig.setLayerSize(layerSize);
        return this;
    }

    public int getLayerSize() {
        return this.deepWalkModelConfig.getLayerSize();
    }

    public DeepWalkModelBuilder setLearningRate(double lr) {
        this.deepWalkModelConfig.setLearningRate(lr);
        return this;
    }

    public double getLearningRate() {
        return this.deepWalkModelConfig.getLearningRate();
    }

    public DeepWalkModelBuilder setMinLearningRate(double minLr) {
        this.deepWalkModelConfig.setMinLearningRate(minLr);
        return this;
    }

    public double getMinLearningRate() {
        return this.deepWalkModelConfig.getMinLearningRate();
    }

    public DeepWalkModelBuilder setWindowSize(int windowSize) {
        this.deepWalkModelConfig.setWindowSize(windowSize);
        return this;
    }

    public int getWindowSize() {
        return this.deepWalkModelConfig.getWindowSize();
    }

    public DeepWalkModelBuilder setWalkLength(int walkLength) {
        this.deepWalkModelConfig.setWalkLength(walkLength);
        return this;
    }

    public int getWalkLength() {
        return this.deepWalkModelConfig.getWalkLength();
    }

    public DeepWalkModelBuilder setWalksPerVertex(int walksPerVertex) {
        this.deepWalkModelConfig.setWalksPerVertex(walksPerVertex);
        return this;
    }

    public int getWalksPerVertex() {
        return this.deepWalkModelConfig.getWalksPerVertex();
    }

    public DeepWalkModelBuilder setSampleRate(double sampleRate) {
        this.deepWalkModelConfig.setSampleRate(sampleRate);
        return this;
    }

    public double getSampleRate() {
        return this.deepWalkModelConfig.getSampleRate();
    }

    public DeepWalkModelBuilder setNegativeSample(int negativeSample) {
        this.deepWalkModelConfig.setNegativeSample(negativeSample);
        return this;
    }

    public int getNegativeSample() {
        return this.deepWalkModelConfig.getNegativeSample();
    }

    @Deprecated
    public DeepWalkModelBuilder setValidationFraction(double validationFraction) {
        this.deepWalkModelConfig.setValidationFraction(validationFraction);
        return this;
    }

    @Deprecated
    public double getValidationFraction() {
        return this.deepWalkModelConfig.getValidationFraction();
    }

    public DeepWalkModelBuilder setIgnoreIsolated(boolean ignoreIsolated) {
        this.deepWalkModelConfig.setIgnoreIsolated(ignoreIsolated);
        return this;
    }

    public boolean isIgnoreIsolated() {
        return this.deepWalkModelConfig.isIgnoreIsolated();
    }

    public DeepWalkModel build() throws InterruptedException, ExecutionException {
        LOG.debug("Building Model...");
        this.validateAll();
        return (DeepWalkModel)((PgxFuture)this.core.createDeepWalkModel(this.session.getSessionContext(), new DeepWalkModelMetadata(null, this.deepWalkModelConfig)).thenApply(metaData -> new DeepWalkModel(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier, (DeepWalkModelMetadata)((Object)metaData)))).get();
    }

    private void validateAll() {
        if (this.deepWalkModelConfig.getNumEpochs() <= 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_NUM_EPOCHS", (Object[])new Object[]{this.deepWalkModelConfig.getNumEpochs()}));
        }
        if (this.deepWalkModelConfig.getBatchSize() <= 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_BATCH_SIZE", (Object[])new Object[]{this.deepWalkModelConfig.getBatchSize()}));
        }
        if (this.deepWalkModelConfig.getNegativeSample() <= 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_NEGATIVE_SAMPLE", (Object[])new Object[]{this.deepWalkModelConfig.getNegativeSample()}));
        }
    }
}

