/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.api.mllib.Model;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.mllib.ModelKind;
import oracle.pgx.config.mllib.ModelLoadingConfiguration;

public abstract class ModelLoader<LoadedModelType extends Model<?>, ModelLoaderType extends ModelLoader<LoadedModelType, ?>> {
    protected final PgxSession session;
    protected final Core core;
    protected final Supplier<String> keystorePathSupplier;
    protected final Supplier<char[]> keystorePasswordSupplier;
    protected final ModelKind modelKind;
    protected final ModelConstructor<LoadedModelType> modelConstructor;

    public ModelLoader(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, ModelKind modelKind, ModelConstructor<LoadedModelType> modelConstructor) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.modelKind = modelKind;
        this.modelConstructor = modelConstructor;
    }

    protected abstract ModelLoaderType getThis();

    public abstract PgxFuture<LoadedModelType> loadAsync();

    public LoadedModelType load() throws InterruptedException, ExecutionException {
        return (LoadedModelType)((Model)this.loadAsync().get());
    }

    protected final PgxFuture<LoadedModelType> triggerLoadAsync(ModelLoadingConfiguration config) {
        try {
            if (this.keystorePathSupplier != null && this.keystorePasswordSupplier != null) {
                ConfigUtils.modifyModelLoadingConfigWithCredentials((String)this.keystorePathSupplier.get(), (char[])this.keystorePasswordSupplier.get(), (ModelLoadingConfiguration)config);
            }
        }
        catch (Exception e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
        return this.core.loadModel(this.session.getSessionContext(), config).thenApply(modelMetadata -> (Model)this.modelConstructor.construct(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier, (ModelMetadata)((Object)modelMetadata)));
    }

    @FunctionalInterface
    public static interface ModelConstructor<LoadedModelType> {
        public LoadedModelType construct(PgxSession var1, Core var2, Supplier<String> var3, Supplier<char[]> var4, ModelMetadata var5);
    }
}

