/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.internal.PgxFrameImpl;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.api.internal.mllib.Pg2vecModelMetadata;
import oracle.pgx.api.mllib.FileModelStorer;
import oracle.pgx.api.mllib.Model;
import oracle.pgx.common.ObjectHolder;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.ModelKind;

public class Pg2vecModel
extends Model<Pg2vecModel> {
    private final Pg2vecModelMetadata modelMetadata;

    public Pg2vecModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, Pg2vecModelMetadata modelMetadata) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier);
        this.modelMetadata = modelMetadata;
    }

    public Pg2vecModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, ModelMetadata modelMetadata) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier);
        if (!(modelMetadata instanceof Pg2vecModelMetadata)) {
            throw new IllegalArgumentException("expected Pg2vecModelMetadata");
        }
        this.modelMetadata = (Pg2vecModelMetadata)modelMetadata;
    }

    @Override
    protected Pg2vecModel getThis() {
        return this;
    }

    @Override
    protected ModelKind getModelKind() {
        return ModelKind.PG2VEC;
    }

    @Override
    String getModelName() {
        return this.modelMetadata.getModelName();
    }

    public PgxFuture<Void> fitAsync(PgxGraph graph) {
        ObjectHolder graphletIdPropertyTypeHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)((PgxFuture)graph.getVertexPropertyAsync(this.modelMetadata.getGraphLetIdPropertyName()).thenApply(graphletIdProperty -> {
            if (graphletIdProperty == null) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPHLET_ID_NOT_FOUND", (Object[])new Object[]{this.modelMetadata.getGraphLetIdPropertyName()}));
            }
            graphletIdPropertyTypeHolder.set((Object)graphletIdProperty.getType().toString());
            return null;
        })).thenCompose(n -> graph.getVertexPropertyAsync(this.modelMetadata.getGraphletSizePropertyName()))).thenCompose(property -> {
            if (property != null) {
                return PgxFuture.exceptionallyCompletedFuture(new IllegalStateException(ErrorMessages.getMessage((String)"PROPERTY_EXISTS", (Object[])new Object[]{this.modelMetadata.getGraphletSizePropertyName()})));
            }
            return graph.createVertexPropertyAsync(PropertyType.LONG, this.modelMetadata.getGraphletSizePropertyName());
        })).thenCompose(ignore -> this.core.fitPg2vecModel(this.session.getSessionContext(), this.modelMetadata.getModelName(), graph.getId(), (String)graphletIdPropertyTypeHolder.get()).thenApply(trainingLoss -> {
            this.modelMetadata.setLoss((Double)trainingLoss);
            return null;
        }));
    }

    public void fit(PgxGraph graph) throws ExecutionException, InterruptedException {
        this.fitAsync(graph).get();
    }

    public PgxFuture<PgxFrame> computeSimilarsAsync(Object graphletIdObject, int k) {
        String graphletId = String.valueOf(graphletIdObject);
        return this.core.computeSimilarsPg2vecModel(this.session.getSessionContext(), this.modelMetadata.getModelName(), graphletId, k).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame computeSimilars(Object graphletId, int k) throws ExecutionException, InterruptedException {
        return this.computeSimilarsAsync(graphletId, k).get();
    }

    public PgxFuture<PgxFrame> computeSimilarsAsync(List<Object> graphletIdObjects, int k) {
        List graphletIds = Lists.transform(graphletIdObjects, (Function)Functions.toStringFunction());
        return this.core.computeSimilarsBatchedPg2vecModel(this.session.getSessionContext(), this.modelMetadata.getModelName(), graphletIds, k).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame computeSimilars(List<Object> graphletIds, int k) throws ExecutionException, InterruptedException {
        return this.computeSimilarsAsync(graphletIds, k).get();
    }

    public PgxFuture<PgxFrame> inferGraphletVectorAsync(PgxGraph graph) {
        graph.createVertexProperty(PropertyType.LONG, this.modelMetadata.getGraphletSizePropertyName());
        String graphletIdPropertyType = graph.getVertexProperty(this.modelMetadata.getGraphLetIdPropertyName()).getType().toString();
        return this.core.inferGraphletVectorPg2vecModel(this.session.getSessionContext(), this.modelMetadata.getModelName(), graph.getId(), graphletIdPropertyType).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame inferGraphletVector(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.inferGraphletVectorAsync(graph).get();
    }

    public PgxFuture<PgxFrame> inferGraphletVectorBatchedAsync(PgxGraph graph) {
        graph.createVertexProperty(PropertyType.LONG, this.modelMetadata.getGraphletSizePropertyName());
        String graphletIdPropertyType = graph.getVertexProperty(this.modelMetadata.getGraphLetIdPropertyName()).getType().toString();
        return this.core.inferGraphletVectorBatchedPg2vecModel(this.session.getSessionContext(), this.modelMetadata.getModelName(), graph.getId(), graphletIdPropertyType).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame inferGraphletVectorBatched(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.inferGraphletVectorBatchedAsync(graph).get();
    }

    public PgxFuture<PgxFrame> getTrainedGraphletVectorsAsync() {
        return this.core.getTrainedGraphletVectorsPg2vecModel(this.session.getSessionContext(), this.modelMetadata.getModelName()).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame getTrainedGraphletVectors() throws ExecutionException, InterruptedException {
        return this.getTrainedGraphletVectorsAsync().get();
    }

    public PgxFuture<Void> storeAsync(String path, String key) {
        return this.export().file().path(path).key(key).storeAsync();
    }

    public PgxFuture<Void> storeAsync(String path, String key, boolean overwrite) {
        return ((FileModelStorer)this.export().file().path(path).key(key).overwrite(overwrite)).storeAsync();
    }

    public void store(String path, String key) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key).get();
    }

    public void store(String path, String key, boolean overwrite) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key, overwrite).get();
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyMlModel(this.session.getSessionContext(), this.modelMetadata.getModelName());
    }

    public void destroy() throws ExecutionException, InterruptedException {
        this.destroyAsync().get();
    }

    public String getGraphLetIdPropertyName() {
        return this.modelMetadata.getGraphLetIdPropertyName();
    }

    public Collection<String> getVertexPropertyNames() {
        return this.modelMetadata.getVertexPropertyNames();
    }

    public int getMinWordFrequency() {
        return this.modelMetadata.getMinWordFrequency();
    }

    public Boolean getUseGraphletSize() {
        return this.modelMetadata.getUseGraphletSize();
    }

    public int getBatchSize() {
        return this.modelMetadata.getBatchSize();
    }

    public int getNumEpochs() {
        return this.modelMetadata.getNumEpochs();
    }

    public int getLayerSize() {
        return this.modelMetadata.getLayerSize();
    }

    public double getLearningRate() {
        return this.modelMetadata.getLearningRate();
    }

    public double getMinLearningRate() {
        return this.modelMetadata.getMinLearningRate();
    }

    public int getWindowSize() {
        return this.modelMetadata.getWindowSize();
    }

    public int getWalkLength() {
        return this.modelMetadata.getWalkLength();
    }

    public int getWalksPerVertex() {
        return this.modelMetadata.getWalksPerVertex();
    }

    public String getGraphletSizePropertyName() {
        return this.modelMetadata.getGraphletSizePropertyName();
    }

    @Deprecated
    public double getValidationFraction() {
        return this.modelMetadata.getValidationFraction();
    }

    public double getLoss() {
        return this.modelMetadata.getLoss();
    }

    public double getSeed() {
        return this.modelMetadata.getSeed().longValue();
    }
}

