/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.internal.mllib.SupervisedGnnExplainerConfig;
import oracle.pgx.api.mllib.GnnExplainer;
import oracle.pgx.api.mllib.SupervisedGnnExplanation;
import oracle.pgx.api.mllib.SupervisedGraphWiseModel;

public class SupervisedGnnExplainer
extends GnnExplainer {
    private SupervisedGraphWiseModel model;

    SupervisedGnnExplainer(SupervisedGraphWiseModel model) {
        this.model = model;
        this.gnnExplainerConfig = new SupervisedGnnExplainerConfig();
    }

    public <ID> PgxFuture<SupervisedGnnExplanation<ID>> inferAndExplainAsync(PgxGraph graph, PgxVertex<ID> vertex) {
        return this.inferAndExplainAsync(graph, vertex, 0.0f);
    }

    public <ID> PgxFuture<SupervisedGnnExplanation<ID>> inferAndExplainAsync(PgxGraph graph, PgxVertex<ID> vertex, float threshold) {
        return this.model.inferAndExplainWithConfigAsync(graph, vertex, (SupervisedGnnExplainerConfig)this.gnnExplainerConfig, threshold);
    }

    public <ID> SupervisedGnnExplanation<ID> inferAndExplain(PgxGraph graph, PgxVertex<ID> vertex) {
        return this.inferAndExplain(graph, vertex, 0.0f);
    }

    public <ID> SupervisedGnnExplanation<ID> inferAndExplain(PgxGraph graph, PgxVertex<ID> vertex, float threshold) {
        return this.inferAndExplainAsync(graph, vertex, threshold).join();
    }

    public SupervisedGnnExplainer numOptimizationSteps(int numOptimizationSteps) {
        this.gnnExplainerConfig.setNumOptimizationSteps(numOptimizationSteps);
        return this;
    }

    public SupervisedGnnExplainer learningRate(double learningRate) {
        this.gnnExplainerConfig.setLearningRate(learningRate);
        return this;
    }

    public SupervisedGnnExplainer marginalize(boolean marginalize) {
        this.gnnExplainerConfig.setMarginalize(marginalize);
        return this;
    }
}

