/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.redaction;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.pgx.api.redaction.GraphRedactionCacheClearer;
import oracle.pgx.api.redaction.RedactionRuleHandler;
import oracle.pgx.common.auth.PgxUser;
import oracle.pgx.common.types.AuthorizationType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.Versions;
import oracle.pgx.config.AbstractPartitionedGraphConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.PgxRedactionRuleConfig;

public class DefaultRedactionRuleHandler
implements RedactionRuleHandler {
    @Override
    public RedactionRuleHandler getNewInstance() {
        return new DefaultRedactionRuleHandler();
    }

    @Override
    public void addRedactionRule(GraphRedactionCacheClearer cacheClearer, PgxRedactionRuleConfig ruleConfig, AuthorizationType type, List<String> vertexProperties, List<String> edgeProperties, String ... names) {
        throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"REDACTION_DISABLED", (Object[])new Object[0]));
    }

    @Override
    public void addRedactionRulesFromConfig(GraphConfig graphconfig, List<String> vertexProperties, List<String> edgeProperties) {
        this.checkRedactionFreeConfig(graphconfig);
    }

    @Override
    public void addRedactionRulesFromConfig(GraphRedactionCacheClearer cacheClearer, GraphConfig graphconfig, List<String> vertexProperties, List<String> edgeProperties) {
        this.checkRedactionFreeConfig(graphconfig);
    }

    private void checkRedactionFreeConfig(GraphConfig graphconfig) {
        if (!(graphconfig instanceof AbstractPartitionedGraphConfig)) {
            return;
        }
        AbstractPartitionedGraphConfig config = (AbstractPartitionedGraphConfig)graphconfig;
        if (!config.getRedactionRules().isEmpty() || !config.getRulesMapping().isEmpty()) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"REDACTION_DISABLED", (Object[])new Object[0]));
        }
    }

    @Override
    public void removeRedactionRule(GraphRedactionCacheClearer cacheClearer, PgxRedactionRuleConfig ruleConfig, AuthorizationType type, String ... names) {
        throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"REDACTION_DISABLED", (Object[])new Object[0]));
    }

    @Override
    public List<PgxRedactionRuleConfig> getRedactionRules(AuthorizationType type, String name) {
        return Collections.emptyList();
    }

    @Override
    public Set<PgxRedactionRuleConfig> getRedactionRules(PgxUser user) {
        return Collections.emptySet();
    }

    @Override
    public boolean hasRedactionRules(PgxUser user) {
        return false;
    }

    @Override
    public boolean hasEntityRedactionRules(EntityType entityType, PgxUser user) {
        return false;
    }

    @Override
    public boolean hasRedactionRulesForProperty(EntityType entityType, String propName, PgxUser user) {
        return false;
    }

    @Override
    public void copyRedactionRules(RedactionRuleHandler previousRedactionRules) {
    }

    @Override
    public void clear() {
    }

    public String getVersion() {
        return Versions.getVersionOf(this.getClass());
    }
}

