/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.subgraph;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import oracle.pgx.api.subgraph.internal.PreparedQueryBuilder;
import oracle.pgx.common.types.QueryArgumentType;

public interface PreparedPgqlQueryBuilder<B extends PreparedPgqlQueryBuilder<B>>
extends PreparedQueryBuilder<B> {
    default public B withBooleanArg(int position, boolean value) {
        return this.withArg(position, QueryArgumentType.BOOLEAN, value);
    }

    default public B withDoubleArg(int position, double value) {
        return this.withArg(position, QueryArgumentType.DOUBLE, value);
    }

    default public B withFloatArg(int position, float value) {
        return this.withArg(position, QueryArgumentType.FLOAT, Float.valueOf(value));
    }

    default public B withIntegerArg(int position, int value) {
        return this.withArg(position, QueryArgumentType.INTEGER, value);
    }

    default public B withLongArg(int position, long value) {
        return this.withArg(position, QueryArgumentType.LONG, value);
    }

    default public B withStringArg(int position, String value) {
        return this.withArg(position, QueryArgumentType.STRING, value);
    }

    default public B withDateArg(int position, LocalDate value) {
        return this.withArg(position, QueryArgumentType.LOCAL_DATE, value);
    }

    default public B withTimeArg(int position, LocalTime value) {
        return this.withArg(position, QueryArgumentType.TIME, value);
    }

    default public B withTimeWithTimezoneArg(int position, OffsetTime value) {
        return this.withArg(position, QueryArgumentType.TIME_WITH_TIMEZONE, value);
    }

    default public B withTimestampArg(int position, LocalDateTime value) {
        return this.withArg(position, QueryArgumentType.TIMESTAMP, value);
    }

    default public B withTimestampWithTimezoneArg(int position, OffsetDateTime value) {
        return this.withArg(position, QueryArgumentType.TIMESTAMP_WITH_TIMEZONE, value);
    }
}

