/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.api.internal.mllib.DeepWalkModelMetadata;
import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.api.internal.mllib.Pg2vecModelMetadata;
import oracle.pgx.api.internal.mllib.SupervisedEdgeWiseModelMetadata;
import oracle.pgx.api.internal.mllib.SupervisedGraphWiseModelMetadata;
import oracle.pgx.api.internal.mllib.UnsupervisedEdgeWiseModelMetadata;
import oracle.pgx.api.internal.mllib.UnsupervisedGraphWiseModelMetadata;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.mllib.ModelKind;

public class ModelMetadataMarshaler
implements Marshaler<ModelMetadata> {
    @Override
    public ModelMetadata unmarshal(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        String sanitizedJson = JsonUtil.sanitize((String)jsonString);
        JsonNode node = JsonUtil.readTopLevelJsonToTree((String)sanitizedJson);
        ModelKind modelKind = (ModelKind)JsonUtil.fromJsonNode((JsonNode)node.get("modelKind"), ModelKind.class);
        switch (modelKind) {
            case DEEPWALK: {
                return (ModelMetadata)((Object)JsonUtil.readValue((String)sanitizedJson, DeepWalkModelMetadata.class));
            }
            case PG2VEC: {
                return (ModelMetadata)((Object)JsonUtil.readValue((String)sanitizedJson, Pg2vecModelMetadata.class));
            }
            case SUPERVISED_GRAPHWISE: {
                return (ModelMetadata)((Object)JsonUtil.readValue((String)sanitizedJson, SupervisedGraphWiseModelMetadata.class));
            }
            case SUPERVISED_EDGEWISE: {
                return (ModelMetadata)((Object)JsonUtil.readValue((String)sanitizedJson, SupervisedEdgeWiseModelMetadata.class));
            }
            case UNSUPERVISED_EDGEWISE: {
                return (ModelMetadata)((Object)JsonUtil.readValue((String)sanitizedJson, UnsupervisedEdgeWiseModelMetadata.class));
            }
            case UNSUPERVISED_GRAPHWISE: {
                return (ModelMetadata)((Object)JsonUtil.readValue((String)sanitizedJson, UnsupervisedGraphWiseModelMetadata.class));
            }
        }
        throw new IllegalEnumConstantException((Enum)modelKind);
    }

    @Override
    public String marshal(ModelMetadata object) throws JsonGenerationException, JsonMappingException, IOException {
        return JsonUtil.toJsonNullable((Object)((Object)object));
    }
}

