/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.pojo.BindValueImpl;
import oracle.pgx.common.types.internal.ValueType;
import oracle.pgx.common.util.ErrorMessages;

public class BindValueSerializer
extends JsonSerializer<BindValueImpl> {
    private static final Map<String, ValueType> CLASS_TO_VALUE_MAP = BindValueSerializer.initClassToValueTypeMap();

    public void serialize(BindValueImpl bindValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("type");
        jsonGenerator.writeString(bindValue.getType().toString());
        if (bindValue.getType() == ValueType.ARRAY) {
            List list = (List)bindValue.getValue();
            jsonGenerator.writeFieldName("valueType");
            jsonGenerator.writeString(BindValueSerializer.getListElementsValueType(list));
            jsonGenerator.writeFieldName("value");
            jsonGenerator.writeStartArray();
            for (Object x : list) {
                jsonGenerator.writeObject(x);
            }
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeFieldName("value");
            jsonGenerator.writeObject(bindValue.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    private static String getListElementsValueType(List list) {
        if (list.size() > 0) {
            return BindValueSerializer.fromClassName(list.get(0).getClass().getName()).toString();
        }
        return "EMPTY";
    }

    private static Map<String, ValueType> initClassToValueTypeMap() {
        HashMap<String, ValueType> classValueTypeMap = new HashMap<String, ValueType>();
        classValueTypeMap.put(Integer.class.getName(), ValueType.INTEGER);
        classValueTypeMap.put(Long.class.getName(), ValueType.LONG);
        classValueTypeMap.put(Float.class.getName(), ValueType.FLOAT);
        classValueTypeMap.put(Double.class.getName(), ValueType.DOUBLE);
        classValueTypeMap.put(Boolean.class.getName(), ValueType.BOOLEAN);
        classValueTypeMap.put(String.class.getName(), ValueType.STRING);
        classValueTypeMap.put(LocalDate.class.getName(), ValueType.LOCAL_DATE);
        classValueTypeMap.put(LocalTime.class.getName(), ValueType.TIME);
        classValueTypeMap.put(LocalDateTime.class.getName(), ValueType.TIMESTAMP);
        classValueTypeMap.put(OffsetTime.class.getName(), ValueType.TIME_WITH_TIMEZONE);
        classValueTypeMap.put(OffsetDateTime.class.getName(), ValueType.TIMESTAMP_WITH_TIMEZONE);
        classValueTypeMap.put(OffsetDateTime.class.getName(), ValueType.TIMESTAMP_WITH_TIMEZONE);
        return classValueTypeMap;
    }

    private static ValueType fromClassName(String className) {
        if (CLASS_TO_VALUE_MAP.containsKey(className)) {
            return CLASS_TO_VALUE_MAP.get(className);
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARRAY_BIND_VARIABLE_TYPE_NOT_SUPPORTED", (Object[])new Object[]{className}));
    }
}

