/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SerializedException {
    public final String type = "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.1";
    @JsonProperty(value="title")
    public ErrorCode code;
    @JsonProperty(value="detail")
    public String message;
    public int status;
    @JsonProperty(value="o:errorCode")
    public String errorCode;

    public SerializedException() {
    }

    public SerializedException(ErrorCode code, String message, String errorCode) {
        this.code = code;
        this.message = message;
        this.status = code.status;
        this.errorCode = errorCode;
    }

    public SerializedException(ErrorCode code, String message) {
        this.code = code;
        this.message = message;
        this.status = code.status;
    }

    public static enum ErrorCode {
        REJECTED(405),
        BAD_REQUEST(400),
        UNSUPPORTED(501),
        INVALID_RESULT(400),
        INTERNAL_ENGINE_EXCEPTION(500),
        CANCELLED(200),
        COMPILATION_ERROR(400),
        MALFORMED_PROGRAM(400),
        MALFORMED_QUERY(400),
        PGQL_TO_SQL_PROCESSING_ERROR(400),
        ILLEGAL_STATE(500),
        NOT_FOUND(404),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        CHANGE_TRACKING_EXCEPTION(500);

        private final int status;

        private ErrorCode(int status) {
            this.status = status;
        }

        @JsonCreator
        public static ErrorCode parse(String str) {
            if (str == null) {
                return null;
            }
            return ErrorCode.valueOf(str.toUpperCase());
        }

        public int getStatus() {
            return this.status;
        }

        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

