/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractClientConfig;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.InteractionMode;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;

public class ClientConfig
extends AbstractClientConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static ClientConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return ClientConfig.parse(ConfigParser.parseRaw((InputStream)is), strict, parentPath);
    }

    static ClientConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return ClientConfig.parse(ConfigParser.parseRaw((InputStream)is), strict, parentPath, parseHiddenValues);
    }

    public static ClientConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new ClientConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static ClientConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new ClientConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static ClientConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new ClientConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected ClientConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains((Object)field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove((Object)field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson((Object)configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Override
    public String getBaseUrl() {
        return (String)this.values.get((Object)Field.BASE_URL);
    }

    public Integer getPrefetchSize() {
        return (Integer)this.values.get((Object)Field.PREFETCH_SIZE);
    }

    public Integer getUploadBatchSize() {
        return (Integer)this.values.get((Object)Field.UPLOAD_BATCH_SIZE);
    }

    public Integer getRemoteFutureTimeout() {
        return (Integer)this.values.get((Object)Field.REMOTE_FUTURE_TIMEOUT);
    }

    public Integer getRemoteFuturePendingRetryInterval() {
        return (Integer)this.values.get((Object)Field.REMOTE_FUTURE_PENDING_RETRY_INTERVAL);
    }

    public Boolean isEnableCctrace() {
        return (Boolean)this.values.get((Object)Field.ENABLE_CCTRACE);
    }

    public String getCctraceOut() {
        return (String)this.values.get((Object)Field.CCTRACE_OUT);
    }

    public Boolean isCctracePrintStacktraces() {
        return (Boolean)this.values.get((Object)Field.CCTRACE_PRINT_STACKTRACES);
    }

    public String getKeystore() {
        return (String)this.values.get((Object)Field.KEYSTORE);
    }

    public String getTruststore() {
        return (String)this.values.get((Object)Field.TRUSTSTORE);
    }

    public String getAccessToken() {
        return (String)this.values.get((Object)Field.ACCESS_TOKEN);
    }

    public Integer getMaxClientHttpConnections() {
        return (Integer)this.values.get((Object)Field.MAX_CLIENT_HTTP_CONNECTIONS);
    }

    public InteractionMode getClientServerInteractionMode() {
        return (InteractionMode)this.values.get((Object)Field.CLIENT_SERVER_INTERACTION_MODE);
    }

    public String getTlsVersion() {
        return (String)this.values.get((Object)Field.TLS_VERSION);
    }

    public Map getRealmClientConfig() {
        return (Map)this.values.get((Object)Field.REALM_CLIENT_CONFIG);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ClientConfig other = (ClientConfig)((Object)obj);
        if (!Objects.equals(this.getBaseUrl(), other.getBaseUrl())) {
            return false;
        }
        if (!Objects.equals(this.getPrefetchSize(), other.getPrefetchSize())) {
            return false;
        }
        if (!Objects.equals(this.getUploadBatchSize(), other.getUploadBatchSize())) {
            return false;
        }
        if (!Objects.equals(this.getRemoteFutureTimeout(), other.getRemoteFutureTimeout())) {
            return false;
        }
        if (!Objects.equals(this.getRemoteFuturePendingRetryInterval(), other.getRemoteFuturePendingRetryInterval())) {
            return false;
        }
        if (!Objects.equals(this.isEnableCctrace(), other.isEnableCctrace())) {
            return false;
        }
        if (!Objects.equals(this.getCctraceOut(), other.getCctraceOut())) {
            return false;
        }
        if (!Objects.equals(this.isCctracePrintStacktraces(), other.isCctracePrintStacktraces())) {
            return false;
        }
        if (!Objects.equals(this.getKeystore(), other.getKeystore())) {
            return false;
        }
        if (!Objects.equals(this.getTruststore(), other.getTruststore())) {
            return false;
        }
        if (!Objects.equals(this.getAccessToken(), other.getAccessToken())) {
            return false;
        }
        if (!Objects.equals(this.getMaxClientHttpConnections(), other.getMaxClientHttpConnections())) {
            return false;
        }
        if (!Objects.equals(this.getClientServerInteractionMode(), other.getClientServerInteractionMode())) {
            return false;
        }
        if (!Objects.equals(this.getTlsVersion(), other.getTlsVersion())) {
            return false;
        }
        return Objects.equals(this.getRealmClientConfig(), other.getRealmClientConfig());
    }

    public static enum Field implements ConfigField
    {
        BASE_URL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        PREFETCH_SIZE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 2048, false, false, false, false),
        UPLOAD_BATCH_SIZE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 65536, false, false, false, false),
        REMOTE_FUTURE_TIMEOUT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 300000, false, false, false, false),
        REMOTE_FUTURE_PENDING_RETRY_INTERVAL(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 500, false, false, false, false),
        ENABLE_CCTRACE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        CCTRACE_OUT(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        CCTRACE_PRINT_STACKTRACES(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        KEYSTORE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        TRUSTSTORE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        ACCESS_TOKEN(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_CLIENT_HTTP_CONNECTIONS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 2, false, false, false, false),
        CLIENT_SERVER_INTERACTION_MODE(Collections.emptyList(), Collections.emptyList(), InteractionMode.class, false, InteractionMode.ASYNC_POLLING, false, false, false, false),
        TLS_VERSION(Collections.emptyList(), Collections.emptyList(), String.class, false, "TLSv1.2", false, false, false, false),
        REALM_CLIENT_CONFIG(Collections.emptyList(), Collections.emptyList(), Map.class, false, Collections.emptyMap(), false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault((String)"client.json", (ConfigField)this, (Object)factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        public List<String> getKeyAliases() {
            return this.aliases;
        }

        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isArray() {
            return this.array;
        }

        public boolean isPath() {
            return this.path;
        }

        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        public boolean isSensitive() {
            return this.sensitive;
        }

        public boolean isHidden() {
            return this.hidden;
        }
    }
}

